/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl;

import com.sun.net.ssl.X509KeyManager;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;

final class X509KeyManagerJavaxWrapper
implements javax.net.ssl.X509KeyManager {
    private X509KeyManager theX509KeyManager;

    X509KeyManagerJavaxWrapper(X509KeyManager x509KeyManager) {
        this.theX509KeyManager = x509KeyManager;
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.theX509KeyManager.getClientAliases(string, principalArray);
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.theX509KeyManager.chooseClientAlias(stringArray[i], principalArray);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.theX509KeyManager.chooseClientAlias(stringArray[i], principalArray);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.theX509KeyManager.getServerAliases(string, principalArray);
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        if (string == null) {
            return null;
        }
        return this.theX509KeyManager.chooseServerAlias(string, principalArray);
    }

    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        if (string == null) {
            return null;
        }
        return this.theX509KeyManager.chooseServerAlias(string, principalArray);
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        return this.theX509KeyManager.getCertificateChain(string);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        return this.theX509KeyManager.getPrivateKey(string);
    }
}

