/*
 * Copyright 2014 - Present Rafael Winterhalter
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.api.tasks;

/**
 * A placeholder representation of Gradle's {@code org.gradle.api.tasks.PathSensitivity} type.
 */
public enum PathSensitivity {

    /**
     * A placeholder representation of Gradle's {@code org.gradle.api.tasks.PathSensitivity#ABSOLUTE} constant.
     */
    ABSOLUTE,

    /**
     * A placeholder representation of Gradle's {@code org.gradle.api.tasks.PathSensitivity#NAME_ONLY} constant.
     */
    NAME_ONLY,

    /**
     * A placeholder representation of Gradle's {@code org.gradle.api.tasks.PathSensitivity#NONE} constant.
     */
    NONE,

    /**
     * A placeholder representation of Gradle's {@code org.gradle.api.tasks.PathSensitivity#RELATIVE} constant.
     */
    RELATIVE
}
