/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.mpp.time;

import ai.grazie.utils.mpp.time.Duration$;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 52\u00020\u0001:\u000256B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B#\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0007H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u000e\u0010!\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0000J\u000e\u0010\"\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0000J\u000e\u0010$\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0000J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010)\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\u0007H\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001J%\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0001\u00a2\u0006\u0002\b4R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u001b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012\u00a8\u00067"}, d2={"Lai/grazie/utils/mpp/time/Duration;", "", "millis", "", "<init>", "(J)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IJLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getMillis", "()J", "isZero", "", "()Z", "seconds", "getSeconds", "()I", "secondsWithFraction", "", "getSecondsWithFraction", "()D", "minutes", "getMinutes", "hours", "getHours", "days", "getDays", "times", "multiplier", "compareTo", "other", "less", "lessOrEqual", "greater", "greaterOrEqual", "minus", "plus", "component1", "copy", "equals", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$utils_common", "Companion", "$serializer", "utils-common"})
public final class Duration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long millis;
    @NotNull
    private static final Duration ZERO = new Duration(0L);

    public Duration(long millis) {
        this.millis = millis;
    }

    public final long getMillis() {
        return this.millis;
    }

    public final boolean isZero() {
        return this.millis == 0L;
    }

    public final int getSeconds() {
        return MathKt.roundToInt((double)this.getSecondsWithFraction());
    }

    public final double getSecondsWithFraction() {
        return (double)this.millis / (double)1000;
    }

    public final int getMinutes() {
        return MathKt.roundToInt((double)((double)this.getSeconds() / (double)60));
    }

    public final int getHours() {
        return MathKt.roundToInt((double)((double)this.getMinutes() / (double)60));
    }

    public final int getDays() {
        return MathKt.roundToInt((double)((double)this.getHours() / (double)24));
    }

    @NotNull
    public final Duration times(int multiplier) {
        return new Duration(this.millis * (long)multiplier);
    }

    public final int compareTo(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.millis, (long)other.millis);
    }

    public final boolean less(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) < 0;
    }

    public final boolean lessOrEqual(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) <= 0;
    }

    public final boolean greater(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) > 0;
    }

    public final boolean greaterOrEqual(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) >= 0;
    }

    @NotNull
    public final Duration minus(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Duration(Math.abs(this.millis - other.millis));
    }

    @NotNull
    public final Duration plus(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Duration(this.millis + other.millis);
    }

    public final long component1() {
        return this.millis;
    }

    @NotNull
    public final Duration copy(long millis) {
        return new Duration(millis);
    }

    public static /* synthetic */ Duration copy$default(Duration duration, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = duration.millis;
        }
        return duration.copy(l);
    }

    @NotNull
    public String toString() {
        return "Duration(millis=" + this.millis + ")";
    }

    public int hashCode() {
        return Long.hashCode(this.millis);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Duration)) {
            return false;
        }
        Duration duration = (Duration)other;
        return this.millis == duration.millis;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$utils_common(Duration self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeLongElement(serialDesc, 0, self.millis);
    }

    public /* synthetic */ Duration(int seen0, long millis, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.millis = millis;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lai/grazie/utils/mpp/time/Duration$Companion;", "", "<init>", "()V", "ZERO", "Lai/grazie/utils/mpp/time/Duration;", "getZERO", "()Lai/grazie/utils/mpp/time/Duration;", "millis", "", "seconds", "minutes", "hours", "days", "weeks", "serializer", "Lkotlinx/serialization/KSerializer;", "utils-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getZERO() {
            return ZERO;
        }

        @NotNull
        public final Duration millis(int millis) {
            return new Duration(millis);
        }

        @NotNull
        public final Duration seconds(int seconds) {
            return new Duration((long)seconds * (long)1000);
        }

        @NotNull
        public final Duration minutes(int minutes) {
            return this.seconds(minutes * 60);
        }

        @NotNull
        public final Duration hours(int hours) {
            return this.minutes(hours * 60);
        }

        @NotNull
        public final Duration days(int days) {
            return this.hours(days * 24);
        }

        @NotNull
        public final Duration weeks(int weeks) {
            return this.days(weeks * 7);
        }

        @NotNull
        public final KSerializer<Duration> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

