/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesProvider;
import com.intellij.openapi.vcs.changes.shelf.DiffShelvedChangesActionProvider;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapperDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ShelvedWrapper
extends ChangeViewDiffRequestProcessor.Wrapper
implements SavedPatchesProvider.ChangeObject {
    @Nullable
    private final ShelvedChange myShelvedChange;
    @Nullable
    private final ShelvedBinaryFile myBinaryFile;
    @NotNull
    private final ShelvedChangeList myChangeList;

    public ShelvedWrapper(@Nullable ShelvedChange shelvedChange, @Nullable ShelvedBinaryFile binaryFile, @NotNull ShelvedChangeList changeList) {
        if (changeList == null) {
            ShelvedWrapper.$$$reportNull$$$0(0);
        }
        this.myShelvedChange = shelvedChange;
        this.myBinaryFile = binaryFile;
        this.myChangeList = changeList;
    }

    public ShelvedWrapper(@NotNull ShelvedChange shelvedChange, @NotNull ShelvedChangeList changeList) {
        if (shelvedChange == null) {
            ShelvedWrapper.$$$reportNull$$$0(1);
        }
        if (changeList == null) {
            ShelvedWrapper.$$$reportNull$$$0(2);
        }
        this(shelvedChange, null, changeList);
    }

    public ShelvedWrapper(@NotNull ShelvedBinaryFile binaryFile, @NotNull ShelvedChangeList changeList) {
        if (binaryFile == null) {
            ShelvedWrapper.$$$reportNull$$$0(3);
        }
        if (changeList == null) {
            ShelvedWrapper.$$$reportNull$$$0(4);
        }
        this(null, binaryFile, changeList);
    }

    @NotNull
    public ShelvedChangeList getChangeList() {
        ShelvedChangeList shelvedChangeList = this.myChangeList;
        if (shelvedChangeList == null) {
            ShelvedWrapper.$$$reportNull$$$0(5);
        }
        return shelvedChangeList;
    }

    @Override
    @NotNull
    public Object getUserObject() {
        Object object = this.myShelvedChange != null ? this.myShelvedChange : Objects.requireNonNull(this.myBinaryFile);
        if (object == null) {
            ShelvedWrapper.$$$reportNull$$$0(6);
        }
        return object;
    }

    @Override
    @Nullable
    public ChangesBrowserNode.Tag getTag() {
        return new ShelvedListTag(this.myChangeList);
    }

    @Nullable
    public ShelvedChange getShelvedChange() {
        return this.myShelvedChange;
    }

    @Nullable
    public ShelvedBinaryFile getBinaryFile() {
        return this.myBinaryFile;
    }

    @NotNull
    public String getPath() {
        String string = (String)ObjectUtils.chooseNotNull((Object)this.getAfterPath(), (Object)this.getBeforePath());
        if (string == null) {
            ShelvedWrapper.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @Nullable
    public FilePath getOriginalFilePath() {
        ContentRevision beforeRevision;
        ContentRevision contentRevision = beforeRevision = this.myShelvedChange != null ? this.myShelvedChange.getChange().getBeforeRevision() : null;
        if (beforeRevision != null) {
            return beforeRevision.getFile();
        }
        String beforePath = this.getBeforePath();
        if (beforePath == null) {
            return null;
        }
        return VcsUtil.getFilePath((String)beforePath, (boolean)false);
    }

    @NlsSafe
    public String getRequestName() {
        return FileUtil.toSystemDependentName((String)this.getPath());
    }

    @Override
    @NotNull
    @Nls
    public String getPresentableName() {
        if (this.myShelvedChange == null) {
            String string = this.getRequestName();
            if (string == null) {
                ShelvedWrapper.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = ChangesUtil.getFilePath((Change)this.myShelvedChange.getChange()).getName();
        if (string == null) {
            ShelvedWrapper.$$$reportNull$$$0(9);
        }
        return string;
    }

    public String getBeforePath() {
        return this.myShelvedChange != null ? this.myShelvedChange.getBeforePath() : Objects.requireNonNull(this.myBinaryFile).BEFORE_PATH;
    }

    String getAfterPath() {
        return this.myShelvedChange != null ? this.myShelvedChange.getAfterPath() : Objects.requireNonNull(this.myBinaryFile).AFTER_PATH;
    }

    @Override
    @NotNull
    public FilePath getFilePath() {
        Change change = this.myShelvedChange != null ? this.myShelvedChange.getChange() : null;
        FilePath filePath = change != null ? ChangesUtil.getFilePath((Change)change) : VcsUtil.getFilePath((String)this.getPath(), (boolean)false);
        if (filePath == null) {
            ShelvedWrapper.$$$reportNull$$$0(10);
        }
        return filePath;
    }

    @Override
    @NotNull
    public FileStatus getFileStatus() {
        FileStatus fileStatus = this.myShelvedChange != null ? this.myShelvedChange.getFileStatus() : Objects.requireNonNull(this.myBinaryFile).getFileStatus();
        if (fileStatus == null) {
            ShelvedWrapper.$$$reportNull$$$0(11);
        }
        return fileStatus;
    }

    @ApiStatus.Internal
    public Change getChangeWithLocal(@NotNull Project project) {
        if (project == null) {
            ShelvedWrapper.$$$reportNull$$$0(12);
        }
        return this.myShelvedChange != null ? this.myShelvedChange.getChange() : Objects.requireNonNull(this.myBinaryFile).createChange(project);
    }

    @Nullable
    public VirtualFile getBeforeVFUnderProject(@NotNull Project project) {
        if (project == null) {
            ShelvedWrapper.$$$reportNull$$$0(13);
        }
        if (this.getBeforePath() == null || project.getBasePath() == null) {
            return null;
        }
        File baseDir = new File(project.getBasePath());
        File file = new File(baseDir, this.getBeforePath());
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    @Override
    @Nullable
    public ChangeDiffRequestChain.Producer createProducer(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        return new ShelvedWrapperDiffRequestProducer(project, this);
    }

    @Override
    @Nullable
    public ChangeDiffRequestChain.Producer createDiffRequestProducer(@Nullable Project project) {
        return this.createProducer(project);
    }

    @Override
    @Nullable
    public ChangeDiffRequestChain.Producer createDiffWithLocalRequestProducer(@Nullable Project project, boolean useBeforeVersion) {
        if (useBeforeVersion || project == null) {
            return null;
        }
        return DiffShelvedChangesActionProvider.createDiffProducer(project, this, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedWrapper";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedWrapper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserObject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getChangeWithLocal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getBeforeVFUnderProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static class ShelvedListTag
    extends ChangesBrowserNode.ValueTag<ShelvedChangeList> {
        public ShelvedListTag(@NotNull ShelvedChangeList value) {
            if (value == null) {
                ShelvedListTag.$$$reportNull$$$0(0);
            }
            super(value);
        }

        @Override
        @Nls
        public String toString() {
            return ((ShelvedChangeList)this.value).getDescription();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/shelf/ShelvedWrapper$ShelvedListTag", "<init>"));
        }
    }
}

