/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.remote.ui;

import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0013B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/ui/JupyterRfsCopyAskDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "originalName", "", "originalPath", "targetDirectory", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getOriginalPath", "()Ljava/lang/String;", "getTargetDirectory", "model", "Lcom/intellij/jupyter/core/jupyter/remote/ui/JupyterRfsCopyAskDialog$Model;", "getModel", "()Lcom/intellij/jupyter/core/jupyter/remote/ui/JupyterRfsCopyAskDialog$Model;", "createCenterPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "Model", "intellij.jupyter.core"})
public final class JupyterRfsCopyAskDialog
extends DialogWrapper {
    @NotNull
    private final String originalPath;
    @NotNull
    private final String targetDirectory;
    @NotNull
    private final Model model;

    public JupyterRfsCopyAskDialog(@NotNull Project project, @NlsSafe @NotNull String originalName, @NlsSafe @NotNull String originalPath, @NlsSafe @NotNull String targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
        Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        super(project, false);
        this.originalPath = originalPath;
        this.targetDirectory = targetDirectory;
        this.model = new Model(originalName);
        this.setTitle(RefactoringBundle.message((String)"copy.files.copy.title"));
        this.init();
    }

    @NotNull
    public final String getOriginalPath() {
        return this.originalPath;
    }

    @NotNull
    public final String getTargetDirectory() {
        return this.targetDirectory;
    }

    @NotNull
    public final Model getModel() {
        return this.model;
    }

    @NotNull
    protected DialogPanel createCenterPanel() {
        return BuilderKt.panel(arg_0 -> JupyterRfsCopyAskDialog.createCenterPanel$lambda$5(this, arg_0));
    }

    private static final Unit createCenterPanel$lambda$5$lambda$0(JupyterRfsCopyAskDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Object[] objectArray = new Object[]{this$0.originalPath};
        String string = RefactoringBundle.message((String)"copy.files.copy.file.0", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).bold();
        return Unit.INSTANCE;
    }

    private static final ValidationInfo createCenterPanel$lambda$5$lambda$3$lambda$2(ValidationInfoBuilder $this$validationOnInput, JBTextField field) {
        ValidationInfo validationInfo;
        Intrinsics.checkNotNullParameter((Object)$this$validationOnInput, (String)"$this$validationOnInput");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (!JupyterRemoteFileSystem.Companion.getInstance().isValidName(field.getText())) {
            String string = RefactoringBundle.message((String)"name.is.not.a.valid.file.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            validationInfo = $this$validationOnInput.error(string);
        } else {
            validationInfo = null;
        }
        return validationInfo;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$3(String $leftCol, String $rightCol, JupyterRfsCopyAskDialog this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = RefactoringBundle.message((String)"copy.files.new.name.label");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).widthGroup($leftCol);
        Cell $this$createCenterPanel_u24lambda_u245_u24lambda_u243_u24lambda_u241 = cell = $this$row.textField().focused();
        boolean bl = false;
        JBTextField jBTextField = (JBTextField)$this$createCenterPanel_u24lambda_u245_u24lambda_u243_u24lambda_u241.getComponent();
        String string2 = ((JBTextField)$this$createCenterPanel_u24lambda_u245_u24lambda_u243_u24lambda_u241.getComponent()).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        jBTextField.select(0, StringsKt.substringBeforeLast$default((String)string2, (String)".", null, (int)2, null).length());
        TextFieldKt.bindText((Cell)cell.resizableColumn().validationOnInput(JupyterRfsCopyAskDialog::createCenterPanel$lambda$5$lambda$3$lambda$2).widthGroup($rightCol), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.model){

            public Object get() {
                return ((Model)this.receiver).getNewName();
            }

            public void set(Object value) {
                ((Model)this.receiver).setNewName((String)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$4(String $leftCol, JupyterRfsCopyAskDialog this$0, String $rightCol, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = RefactoringBundle.message((String)"copy.files.to.directory.label");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).widthGroup($leftCol);
        $this$row.label(this$0.targetDirectory).widthGroup($rightCol);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5(JupyterRfsCopyAskDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String leftCol = "leftCol";
        String rightCol = "rightCol";
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterRfsCopyAskDialog.createCenterPanel$lambda$5$lambda$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterRfsCopyAskDialog.createCenterPanel$lambda$5$lambda$3(leftCol, rightCol, this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JupyterRfsCopyAskDialog.createCenterPanel$lambda$5$lambda$4(leftCol, this$0, rightCol, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/ui/JupyterRfsCopyAskDialog$Model;", "", "newName", "", "<init>", "(Ljava/lang/String;)V", "getNewName", "()Ljava/lang/String;", "setNewName", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.jupyter.core"})
    public static final class Model {
        @NotNull
        private String newName;

        public Model(@NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            this.newName = newName;
        }

        @NotNull
        public final String getNewName() {
            return this.newName;
        }

        public final void setNewName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.newName = string;
        }

        @NotNull
        public final String component1() {
            return this.newName;
        }

        @NotNull
        public final Model copy(@NotNull String newName) {
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            return new Model(newName);
        }

        public static /* synthetic */ Model copy$default(Model model, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = model.newName;
            }
            return model.copy(string);
        }

        @NotNull
        public String toString() {
            return "Model(newName=" + this.newName + ")";
        }

        public int hashCode() {
            return this.newName.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Model)) {
                return false;
            }
            Model model = (Model)other;
            return Intrinsics.areEqual((Object)this.newName, (Object)model.newName);
        }
    }
}

