/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.MultiplatformKt;
import org.jetbrains.plugins.textmate.language.TextMateInterner;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxIncludeRawNode;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRawNode;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRawNodeImpl;
import org.jetbrains.plugins.textmate.language.syntax.TextMateRawCapture;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTableCore;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J)\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\"\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableBuilder;", "", "interner", "Lorg/jetbrains/plugins/textmate/language/TextMateInterner;", "<init>", "(Lorg/jetbrains/plugins/textmate/language/TextMateInterner;)V", "currentRuleId", "Lkotlin/concurrent/atomics/AtomicInt;", "Ljava/util/concurrent/atomic/AtomicInteger;", "syntaxNodes", "Lkotlin/concurrent/atomics/AtomicReference;", "Lkotlinx/collections/immutable/PersistentMap;", "", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxRawNode;", "Ljava/util/concurrent/atomic/AtomicReference;", "addSyntax", "plist", "Lorg/jetbrains/plugins/textmate/plist/Plist;", "build", "Lorg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableCore;", "loadRealNode", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxRawNodeImpl;", "parentBuilder", "loadNestedSyntax", "loadCaptures", "", "Lorg/jetbrains/plugins/textmate/language/syntax/TextMateRawCapture;", "captures", "parent", "(Lorg/jetbrains/plugins/textmate/plist/Plist;Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxRawNode;)[Lorg/jetbrains/plugins/textmate/language/syntax/TextMateRawCapture;", "intellij.textmate.core"})
@SourceDebugExtension(value={"SMAP\nTextMateSyntaxTableBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateSyntaxTableBuilder.kt\norg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n216#2,2:330\n1869#3,2:332\n1869#3,2:334\n1869#3,2:336\n1869#3,2:338\n1869#3,2:340\n1869#3,2:342\n*S KotlinDebug\n*F\n+ 1 TextMateSyntaxTableBuilder.kt\norg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableBuilder\n*L\n45#1:330,2\n54#1:332,2\n89#1:334,2\n94#1:336,2\n99#1:338,2\n122#1:340,2\n139#1:342,2\n*E\n"})
public final class TextMateSyntaxTableBuilder {
    @NotNull
    private final TextMateInterner interner;
    @NotNull
    private final AtomicInteger currentRuleId;
    @NotNull
    private final AtomicReference<PersistentMap<CharSequence, SyntaxRawNode>> syntaxNodes;

    public TextMateSyntaxTableBuilder(@NotNull TextMateInterner interner) {
        Intrinsics.checkNotNullParameter((Object)interner, (String)"interner");
        this.interner = interner;
        this.currentRuleId = new AtomicInteger(0);
        this.syntaxNodes = new AtomicReference<PersistentMap>(ExtensionsKt.persistentMapOf());
    }

    @Nullable
    public final CharSequence addSyntax(@NotNull Plist plist) {
        Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
        SyntaxRawNodeImpl topLevelNode = this.loadRealNode(plist, null);
        CharSequence scopeName = topLevelNode.getScopeName();
        if (scopeName != null) {
            MultiplatformKt.update(this.syntaxNodes, arg_0 -> TextMateSyntaxTableBuilder.addSyntax$lambda$0(scopeName, topLevelNode, arg_0));
        }
        return scopeName;
    }

    @NotNull
    public final TextMateSyntaxTableCore build() {
        Map ruleIdToReferenceRuleId = new LinkedHashMap();
        Map compiledRules = new LinkedHashMap();
        Map rules = new LinkedHashMap();
        TextMateSyntaxTableCore syntaxTable = new TextMateSyntaxTableCore(rules);
        PersistentMap<CharSequence, SyntaxRawNode> syntaxNodes = this.syntaxNodes.get();
        Map $this$forEach$iv = (Map)syntaxNodes;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            CharSequence scopeName = (CharSequence)entry.getKey();
            SyntaxRawNode nodeBuilder = (SyntaxRawNode)entry.getValue();
            SyntaxNodeDescriptor syntaxNodeDescriptor = nodeBuilder.compile((Map)syntaxNodes, compiledRules, ruleIdToReferenceRuleId, syntaxTable);
            if (syntaxNodeDescriptor == null) continue;
            SyntaxNodeDescriptor compiledNode = syntaxNodeDescriptor;
            boolean bl2 = false;
            rules.put(scopeName, compiledNode);
        }
        SyntaxNodeDescriptor[] rulesRepository = new SyntaxNodeDescriptor[ruleIdToReferenceRuleId.size()];
        Iterable $this$forEach$iv2 = ruleIdToReferenceRuleId.entrySet();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            rulesRepository[((Number)it.getValue()).intValue()] = compiledRules.get(it.getKey());
        }
        syntaxTable.setRulesRepository$intellij_textmate_core(rulesRepository);
        return syntaxTable;
    }

    private final SyntaxRawNodeImpl loadRealNode(Plist plist, SyntaxRawNode parentBuilder) {
        PListValue scopeNamePlistValue;
        PListValue pListValue = scopeNamePlistValue = plist.getPlistValue(Constants.StringKey.SCOPE_NAME.getValue());
        String scopeNameValue = pListValue != null ? pListValue.getString() : null;
        CharSequence scopeName = scopeNameValue != null ? (CharSequence)this.interner.intern(scopeNameValue) : null;
        int ruleId = AtomicsKt.fetchAndIncrement((AtomicInteger)this.currentRuleId);
        SyntaxRawNodeImpl result = new SyntaxRawNodeImpl(ruleId, parentBuilder, scopeName);
        for (Map.Entry<String, PListValue> entry : plist.entries()) {
            PListValue value;
            String key;
            Map.Entry entry2;
            Iterable $this$forEach$iv;
            PListValue pListValue2 = entry.getValue();
            if (pListValue2 == null) continue;
            String key2 = entry.getKey();
            Constants.StringKey stringKey = Constants.StringKey.Companion.fromName(key2);
            if (stringKey != null) {
                if (pListValue2.getString() != null) {
                    String stringValue;
                    boolean bl = false;
                    result.setStringAttribute(stringKey, this.interner.intern(stringValue));
                }
                continue;
            }
            Constants.CaptureKey captureKey = Constants.CaptureKey.Companion.fromName(key2);
            if (captureKey != null) {
                if (this.loadCaptures(pListValue2.getPlist(), result) != null) {
                    TextMateRawCapture[] captures;
                    boolean bl = false;
                    result.setCaptures(captureKey, captures);
                }
                continue;
            }
            if (StringsKt.equals((String)"repository", (String)key2, (boolean)true)) {
                $this$forEach$iv = pListValue2.getPlist().entries();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    entry2 = (Map.Entry)element$iv;
                    boolean bl = false;
                    key = (String)entry2.getKey();
                    value = (PListValue)entry2.getValue();
                    result.appendRepository(key, this.loadNestedSyntax(value.getPlist(), result));
                }
                continue;
            }
            if (StringsKt.equals((String)"patterns", (String)key2, (boolean)true)) {
                $this$forEach$iv = pListValue2.getArray();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PListValue value2 = (PListValue)element$iv;
                    boolean bl = false;
                    result.addChild(this.loadNestedSyntax(value2.getPlist(), result));
                }
                continue;
            }
            if (!StringsKt.equals((String)"injections", (String)key2, (boolean)true)) continue;
            $this$forEach$iv = pListValue2.getPlist().entries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                entry2 = (Map.Entry)element$iv;
                boolean bl = false;
                key = (String)entry2.getKey();
                value = (PListValue)entry2.getValue();
                result.addInjection(key, this.loadRealNode(value.getPlist(), result));
            }
        }
        return result;
    }

    private final SyntaxRawNode loadNestedSyntax(Plist plist, SyntaxRawNodeImpl parentBuilder) {
        PListValue pListValue = plist.getPlistValue("include");
        String include = pListValue != null ? pListValue.getString() : null;
        return include != null ? (SyntaxRawNode)new SyntaxIncludeRawNode(AtomicsKt.fetchAndIncrement((AtomicInteger)this.currentRuleId), parentBuilder, include) : (SyntaxRawNode)this.loadRealNode(plist, parentBuilder);
    }

    private final TextMateRawCapture[] loadCaptures(Plist captures, SyntaxRawNode parent) {
        Map map = new LinkedHashMap();
        int maxGroupIndex = 0;
        maxGroupIndex = -1;
        Iterable $this$forEach$iv = captures.entries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            PListValue value = (PListValue)entry.getValue();
            Integer n = StringsKt.toIntOrNull((String)key);
            if (n == null) continue;
            int index = ((Number)n).intValue();
            boolean bl2 = false;
            Plist captureDict = value.getPlist();
            PListValue captureName = captureDict.getPlistValue("name");
            if (captureName != null) {
                Integer n2 = index;
                String string = captureName.getString();
                if (string == null) {
                    string = "";
                }
                map.put(n2, new TextMateRawCapture.Name(this.interner.intern(string)));
            } else {
                map.put(index, new TextMateRawCapture.Rule(this.loadRealNode(captureDict, parent)));
            }
            maxGroupIndex = Math.max(maxGroupIndex, index);
        }
        if (maxGroupIndex < 0 || map.isEmpty()) {
            return null;
        }
        TextMateRawCapture[] result = new TextMateRawCapture[maxGroupIndex + 1];
        Iterable $this$forEach$iv2 = map.entrySet();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Map.Entry e = (Map.Entry)element$iv;
            boolean bl = false;
            result[((Number)e.getKey()).intValue()] = e.getValue();
        }
        return result;
    }

    private static final PersistentMap addSyntax$lambda$0(CharSequence $scopeName, SyntaxRawNodeImpl $topLevelNode, PersistentMap it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.put((Object)$scopeName, (Object)$topLevelNode);
    }
}

