// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id: 553b2f634177cbbdc05c8685f7af2d6d9fac399e $
//
// Copyright (C) 2006-2026 by The Odamex Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// DESCRIPTION:
//  std::string utility functions
//
//-----------------------------------------------------------------------------

#include "str_utils.h"

#include <algorithm>

using namespace std;

string stdstr_toupper(const string& s)
{
	string upper(s);

	transform(upper.begin(), upper.end(), upper.begin(), ::toupper);

	return s;
}

// These can be removed for wx 2.9/3
string wxstr_tostdstr(const wxString& s)
{
	return string(s.mb_str());
}

wxString stdstr_towxstr(const string& s)
{
	return wxString(s.c_str(), wxConvUTF8);
}
