//
// MongoDBTest.h
//
// Definition of the MongoDBTest class.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// SPDX-License-Identifier:	BSL-1.0
//


#ifndef MongoDBTest_INCLUDED
#define MongoDBTest_INCLUDED


#include "Poco/MongoDB/Connection.h"
#include "CppUnit/TestCase.h"


class MongoDBTest: public CppUnit::TestCase
{
public:
	MongoDBTest(const std::string& name);

	virtual ~MongoDBTest();
	
	void setUp();
	void tearDown();

	void testObjectID();
	void testBuildInfo();
	void testHello();
	void testConnectURI();

	// OP_MSG wire protocol
	void testOpCmdHello();
	void testOpCmdWriteRead();
	void testOpCmdInsert();
	void testOpCmdFind();
	void testOpCmdCursor();
	void testOpCmdCursorAggregate();
	void testOpCmdCursorEmptyFirstBatch();
	void testOpCmdKillCursor();
	void testOpCmdCount();
	void testOpCmdDelete();
	void testOpCmdUnaknowledgedInsert();
	void testOpCmdConnectionPool();
	void testOpCmdDropDatabase();
	void testDBCount();

	static CppUnit::Test* suite();

private:
	static Poco::MongoDB::Connection::Ptr	_mongo;
	static Poco::Int64						_wireVersion;
};


#endif // MongoDBTest_INCLUDED
