/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.TextStringBuilder;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.apache.commons.text.matcher.StringMatcher;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class StringSubstitutorTest {
    private static final String ACTUAL_ANIMAL = "quick brown fox";
    private static final String ACTUAL_TARGET = "lazy dog";
    private static final String CLASSIC_RESULT = "The quick brown fox jumps over the lazy dog.";
    private static final String CLASSIC_TEMPLATE = "The ${animal} jumps over the ${target}.";
    private static final String EMPTY_EXPR = "${}";
    protected Map<String, String> values;

    private void assertEqualsCharSeq(CharSequence expected, CharSequence actual) {
        Assertions.assertEquals((Object)expected, (Object)actual, () -> String.format("expected.length()=%,d, actual.length()=%,d", StringUtils.length((CharSequence)expected), StringUtils.length((CharSequence)actual)));
    }

    protected void doNotReplace(String replaceTemplate) throws IOException {
        this.doTestNoReplace(new StringSubstitutor(this.values), replaceTemplate);
    }

    protected void doReplace(String expectedResult, String replaceTemplate, boolean substring) throws IOException {
        this.doTestReplace(new StringSubstitutor(this.values), expectedResult, replaceTemplate, substring);
    }

    protected void doTestNoReplace(StringSubstitutor substitutor, String replaceTemplate) throws IOException {
        if (replaceTemplate == null) {
            Assertions.assertNull((Object)this.replace(substitutor, null));
            Assertions.assertNull((Object)substitutor.replace((String)null, 0, 100));
            Assertions.assertNull((Object)substitutor.replace((char[])null));
            Assertions.assertNull((Object)substitutor.replace((char[])null, 0, 100));
            Assertions.assertNull((Object)substitutor.replace((StringBuffer)null));
            Assertions.assertNull((Object)substitutor.replace((StringBuffer)null, 0, 100));
            Assertions.assertNull((Object)substitutor.replace((TextStringBuilder)null));
            Assertions.assertNull((Object)substitutor.replace((TextStringBuilder)null, 0, 100));
            Assertions.assertNull((Object)substitutor.replace(null));
            Assertions.assertFalse((boolean)substitutor.replaceIn((StringBuffer)null));
            Assertions.assertFalse((boolean)substitutor.replaceIn((StringBuffer)null, 0, 100));
            Assertions.assertFalse((boolean)substitutor.replaceIn((TextStringBuilder)null));
            Assertions.assertFalse((boolean)substitutor.replaceIn((TextStringBuilder)null, 0, 100));
        } else {
            Assertions.assertEquals((Object)replaceTemplate, (Object)this.replace(substitutor, replaceTemplate));
            TextStringBuilder builder = new TextStringBuilder(replaceTemplate);
            Assertions.assertFalse((boolean)substitutor.replaceIn(builder));
            Assertions.assertEquals((Object)replaceTemplate, (Object)builder.toString());
        }
    }

    protected void doTestReplace(StringSubstitutor sub, String expectedResult, String replaceTemplate, boolean substring) throws IOException {
        String expectedShortResult = substring ? expectedResult.substring(1, expectedResult.length() - 1) : expectedResult;
        String actual = this.replace(sub, replaceTemplate);
        Assertions.assertEquals((Object)expectedResult, (Object)actual, () -> String.format("Index of difference: %,d", StringUtils.indexOfDifference((CharSequence)expectedResult, (CharSequence)actual)));
        if (substring) {
            Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace(replaceTemplate, 1, replaceTemplate.length() - 2));
        }
        char[] chars = replaceTemplate.toCharArray();
        Assertions.assertEquals((Object)expectedResult, (Object)sub.replace(chars));
        if (substring) {
            Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace(chars, 1, chars.length - 2));
        }
        StringBuffer buf = new StringBuffer(replaceTemplate);
        Assertions.assertEquals((Object)expectedResult, (Object)sub.replace(buf));
        if (substring) {
            Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace(buf, 1, buf.length() - 2));
        }
        StringBuilder builder = new StringBuilder(replaceTemplate);
        Assertions.assertEquals((Object)expectedResult, (Object)sub.replace((CharSequence)builder));
        if (substring) {
            Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace((CharSequence)builder, 1, builder.length() - 2));
        }
        TextStringBuilder bld = new TextStringBuilder(replaceTemplate);
        Assertions.assertEquals((Object)expectedResult, (Object)sub.replace(bld));
        if (substring) {
            Assertions.assertEquals((Object)expectedShortResult, (Object)sub.replace(bld, 1, bld.length() - 2));
        }
        MutableObject obj = new MutableObject((Object)replaceTemplate);
        Assertions.assertEquals((Object)expectedResult, (Object)sub.replace((Object)obj));
        buf = new StringBuffer(replaceTemplate);
        Assertions.assertTrue((boolean)sub.replaceIn(buf), (String)replaceTemplate);
        Assertions.assertEquals((Object)expectedResult, (Object)buf.toString());
        if (substring) {
            buf = new StringBuffer(replaceTemplate);
            Assertions.assertTrue((boolean)sub.replaceIn(buf, 1, buf.length() - 2));
            Assertions.assertEquals((Object)expectedResult, (Object)buf.toString());
        }
        builder = new StringBuilder(replaceTemplate);
        Assertions.assertTrue((boolean)sub.replaceIn(builder));
        Assertions.assertEquals((Object)expectedResult, (Object)builder.toString());
        if (substring) {
            builder = new StringBuilder(replaceTemplate);
            Assertions.assertTrue((boolean)sub.replaceIn(builder, 1, builder.length() - 2));
            Assertions.assertEquals((Object)expectedResult, (Object)builder.toString());
        }
        bld = new TextStringBuilder(replaceTemplate);
        Assertions.assertTrue((boolean)sub.replaceIn(bld));
        Assertions.assertEquals((Object)expectedResult, (Object)bld.toString());
        if (substring) {
            bld = new TextStringBuilder(replaceTemplate);
            Assertions.assertTrue((boolean)sub.replaceIn(bld, 1, bld.length() - 2));
            Assertions.assertEquals((Object)expectedResult, (Object)bld.toString());
        }
    }

    protected String replace(StringSubstitutor stringSubstitutor, String template) throws IOException {
        return stringSubstitutor.replace(template);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.values = new HashMap<String, String>();
        this.values.put("a", "1");
        this.values.put("aa", "11");
        this.values.put("aaa", "111");
        this.values.put("b", "2");
        this.values.put("bb", "22");
        this.values.put("bbb", "222");
        this.values.put("a2b", "b");
        this.values.put("animal", ACTUAL_ANIMAL);
        this.values.put("target", ACTUAL_TARGET);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.values = null;
    }

    @Test
    public void testConstructorNullMap() {
        Map parameters = null;
        StringSubstitutor s = new StringSubstitutor(parameters, "prefix", "suffix");
        Assertions.assertNull((Object)s.getStringLookup().lookup("X"));
    }

    @Test
    public void testConstructorStringSubstitutor() {
        StringSubstitutor source = new StringSubstitutor();
        source.setDisableSubstitutionInValues(true);
        source.setEnableSubstitutionInVariables(true);
        source.setEnableUndefinedVariableException(true);
        source.setEscapeChar('e');
        source.setValueDelimiter('d');
        source.setVariablePrefix('p');
        source.setVariableResolver(StringLookupFactory.INSTANCE.nullStringLookup());
        source.setVariableSuffix('s');
        StringSubstitutor target = new StringSubstitutor(source);
        Assertions.assertTrue((boolean)target.isDisableSubstitutionInValues());
        Assertions.assertTrue((boolean)target.isEnableSubstitutionInVariables());
        Assertions.assertTrue((boolean)target.isEnableUndefinedVariableException());
        Assertions.assertEquals((char)'e', (char)target.getEscapeChar());
        Assertions.assertTrue((boolean)target.getValueDelimiterMatcher().toString().endsWith("['d']"), (String)target.getValueDelimiterMatcher().toString());
        Assertions.assertTrue((boolean)target.getVariablePrefixMatcher().toString().endsWith("['p']"), (String)target.getValueDelimiterMatcher().toString());
        Assertions.assertTrue((boolean)target.getVariableSuffixMatcher().toString().endsWith("['s']"), (String)target.getValueDelimiterMatcher().toString());
    }

    @Test
    public void testGetSetEscape() {
        StringSubstitutor sub = new StringSubstitutor();
        Assertions.assertEquals((char)'$', (char)sub.getEscapeChar());
        sub.setEscapeChar('<');
        Assertions.assertEquals((char)'<', (char)sub.getEscapeChar());
    }

    @Test
    public void testLANG1055() {
        System.setProperty("test_key", "test_value");
        String expected = StringSubstitutor.replace((Object)"test_key=${test_key}", (Properties)System.getProperties());
        String actual = StringSubstitutor.replaceSystemProperties((Object)"test_key=${test_key}");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testReplace_JiraText178_WeirdPatterns1() throws IOException {
        this.doNotReplace("$${");
        this.doNotReplace("$${a");
        this.doNotReplace("$$${");
        this.doNotReplace("$$${a");
        this.doNotReplace("$${${a");
        this.doNotReplace("${${a}");
        this.doNotReplace("${$${a}");
    }

    @Test
    public void testReplace_JiraText178_WeirdPatterns2() throws IOException {
        this.doReplace("${1}", "$${${a}}", false);
    }

    @Test
    @Disabled
    public void testReplace_JiraText178_WeirdPatterns3() throws IOException {
        this.doReplace("${${a}", "$${${a}", false);
    }

    @Test
    public void testReplaceAdjacentAtEnd() throws IOException {
        this.values.put("code", "GBP");
        this.values.put("amount", "12.50");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        this.assertEqualsCharSeq("Amount is GBP12.50", this.replace(sub, "Amount is ${code}${amount}"));
    }

    @Test
    public void testReplaceAdjacentAtStart() throws IOException {
        this.values.put("code", "GBP");
        this.values.put("amount", "12.50");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        this.assertEqualsCharSeq("GBP12.50 charged", this.replace(sub, "${code}${amount} charged"));
    }

    @Test
    public void testReplaceChangedMap() throws IOException {
        StringSubstitutor sub = new StringSubstitutor(this.values);
        String template = CLASSIC_TEMPLATE;
        this.assertEqualsCharSeq(CLASSIC_RESULT, this.replace(sub, CLASSIC_TEMPLATE));
        this.values.put("target", "moon");
        this.assertEqualsCharSeq("The quick brown fox jumps over the moon.", this.replace(sub, CLASSIC_TEMPLATE));
    }

    @Test
    public void testReplaceComplexEscaping() throws IOException {
        this.doReplace("${1}", "$${${a}}", false);
        this.doReplace("${11}", "$${${aa}}", false);
        this.doReplace("${111}", "$${${aaa}}", false);
        this.doReplace("${quick brown fox}", "$${${animal}}", false);
        this.doReplace("The ${quick brown fox} jumps over the lazy dog.", "The $${${animal}} jumps over the ${target}.", true);
        this.doReplace("${${a}}", "$${$${a}}", false);
        this.doReplace("${${aa}}", "$${$${aa}}", false);
        this.doReplace("${${aaa}}", "$${$${aaa}}", false);
        this.doReplace("${${animal}}", "$${$${animal}}", false);
        this.doReplace(".${${animal}}", ".$${$${animal}}", false);
        this.doReplace("${${animal}}.", "$${$${animal}}.", false);
        this.doReplace(".${${animal}}.", ".$${$${animal}}.", false);
        this.doReplace("The ${${animal}} jumps over the lazy dog.", "The $${$${animal}} jumps over the ${target}.", true);
        this.doReplace("The ${quick brown fox} jumps over the lazy dog. ${1234567890}.", "The $${${animal}} jumps over the ${target}. $${${undefined.number:-1234567890}}.", true);
    }

    @Test
    public void testReplaceEmptyKey() throws IOException {
        this.doReplace("The ${} jumps over the lazy dog.", "The ${} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceEmptyKeyExtraFirst() throws IOException {
        this.assertEqualsCharSeq(".${}", this.replace(new StringSubstitutor(this.values), ".${}"));
    }

    @Test
    public void testReplaceEmptyKeyExtraLast() throws IOException {
        this.assertEqualsCharSeq("${}.", this.replace(new StringSubstitutor(this.values), "${}."));
    }

    @Test
    public void testReplaceEmptyKeyOnly() throws IOException {
        Assertions.assertEquals((Object)EMPTY_EXPR, (Object)this.replace(new StringSubstitutor(this.values), EMPTY_EXPR));
    }

    @Test
    public void testReplaceEmptyKeyShortest() throws IOException {
        this.doNotReplace(EMPTY_EXPR);
    }

    @Test
    public void testReplaceEmptyKeyWithDefault() throws IOException {
        this.doReplace("The animal jumps over the lazy dog.", "The ${:-animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceEmptyKeyWithDefaultOnly() throws IOException {
        this.doReplace("animal", "${:-animal}", false);
    }

    @Test
    public void testReplaceEmptyKeyWithDefaultOnlyEmpty() throws IOException {
        this.doReplace("", "${:-}", false);
    }

    @Test
    public void testReplaceEmptyKeyWithDefaultOnlyShortest() throws IOException {
        this.doReplace("a", "${:-a}", false);
    }

    @Test
    public void testReplaceEmptyString() throws IOException {
        this.doNotReplace("");
    }

    @Test
    public void testReplaceEscaping() throws IOException {
        this.doReplace("The ${animal} jumps over the lazy dog.", "The $${animal} jumps over the ${target}.", true);
        this.doReplace("${a}", "$${a}", false);
        this.doReplace("${a${a}}", "$${a$${a}}", false);
        this.doReplace("${a${a${a}}}", "$${a$${a$${a}}}", false);
    }

    @Test
    public void testReplaceFailOnUndefinedVariable() throws IOException {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        sub.setEnableUndefinedVariableException(true);
        Assertions.assertEquals((Object)"Cannot resolve variable 'animal.${species' (enableSubstitutionInVariables=false).", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.replace(sub, "The ${animal.${species}} jumps over the ${target}."))).getMessage());
        Assertions.assertEquals((Object)"Cannot resolve variable 'animal.${species:-1' (enableSubstitutionInVariables=false).", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.replace(sub, "The ${animal.${species:-1}} jumps over the ${target}."))).getMessage());
        Assertions.assertEquals((Object)"Cannot resolve variable 'unknown' (enableSubstitutionInVariables=false).", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.replace(sub, "The ${test:-statement} is a sample for missing ${unknown}."))).getMessage());
        this.assertEqualsCharSeq("The statement is a sample for missing variable.", this.replace(sub, "The ${test:-statement} is a sample for missing ${unknown:-variable}."));
        this.assertEqualsCharSeq("The fox jumps over the lazy dog.", this.replace(sub, "The ${animal.1} jumps over the ${target}."));
    }

    @Test
    public void testReplaceFailOnUndefinedVariableWithReplaceInVariable() throws IOException {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        this.values.put("statement.1", "2");
        this.values.put("recursive", "1");
        this.values.put("word", "variable");
        this.values.put("testok.2", "statement");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        sub.setEnableUndefinedVariableException(true);
        sub.setEnableSubstitutionInVariables(true);
        this.assertEqualsCharSeq("The mouse jumps over the lazy dog.", this.replace(sub, "The ${animal.${species}} jumps over the ${target}."));
        this.values.put("species", "1");
        this.assertEqualsCharSeq("The fox jumps over the lazy dog.", this.replace(sub, "The ${animal.${species}} jumps over the ${target}."));
        Assertions.assertEquals((Object)"Cannot resolve variable 'statement' (enableSubstitutionInVariables=true).", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.replace(sub, "The ${test.${statement}} is a sample for missing ${word}."))).getMessage());
        Assertions.assertEquals((Object)"Cannot resolve variable 'test.2' (enableSubstitutionInVariables=true).", (Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.replace(sub, "The ${test.${statement.${recursive}}} is a sample for missing ${word}."))).getMessage());
        this.assertEqualsCharSeq("statement", this.replace(sub, "${testok.${statement.${recursive}}}"));
        this.assertEqualsCharSeq("${testok.2}", this.replace(sub, "$${testok.${statement.${recursive}}}"));
        this.assertEqualsCharSeq("The statement is a sample for missing variable.", this.replace(sub, "The ${testok.${statement.${recursive}}} is a sample for missing ${word}."));
    }

    @Test
    public void testReplaceIncompletePrefix() throws IOException {
        this.doReplace("The {animal} jumps over the lazy dog.", "The {animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceInTakingStringBufferWithNonNull() {
        StringSubstitutor strSubstitutor = new StringSubstitutor(new HashMap(), "WV@i#y?N*[", "WV@i#y?N*[", '*');
        Assertions.assertFalse((boolean)strSubstitutor.isPreserveEscapes());
        Assertions.assertFalse((boolean)strSubstitutor.replaceIn(new StringBuffer("WV@i#y?N*[")));
        Assertions.assertEquals((char)'*', (char)strSubstitutor.getEscapeChar());
    }

    @Test
    public void testReplaceInTakingStringBuilderWithNonNull() {
        StringLookup strLookup = StringLookupFactory.INSTANCE.systemPropertyStringLookup();
        StringSubstitutor strSubstitutor = new StringSubstitutor(strLookup, "b<H", "b<H", '\'');
        StringBuilder stringBuilder = new StringBuilder((CharSequence)"b<H");
        Assertions.assertEquals((char)'\'', (char)strSubstitutor.getEscapeChar());
        Assertions.assertFalse((boolean)strSubstitutor.replaceIn(stringBuilder));
    }

    @Test
    public void testReplaceInTakingStringBuilderWithNull() {
        HashMap map = new HashMap();
        StringSubstitutor strSubstitutor = new StringSubstitutor(map, "", "", 'T', "K+<'f");
        Assertions.assertFalse((boolean)strSubstitutor.replaceIn((StringBuilder)null));
    }

    @Test
    public void testReplaceInTakingTwoAndThreeIntsReturningFalse() {
        HashMap hashMap = new HashMap();
        StringLookup mapStringLookup = StringLookupFactory.INSTANCE.mapStringLookup(hashMap);
        StringMatcher strMatcher = StringMatcherFactory.INSTANCE.tabMatcher();
        StringSubstitutor strSubstitutor = new StringSubstitutor(mapStringLookup, strMatcher, strMatcher, 'b', strMatcher);
        Assertions.assertFalse((boolean)strSubstitutor.replaceIn((StringBuilder)null, 1315, -1369));
        Assertions.assertEquals((char)'b', (char)strSubstitutor.getEscapeChar());
        Assertions.assertFalse((boolean)strSubstitutor.isPreserveEscapes());
    }

    @Test
    public void testReplaceInVariable() throws IOException {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        sub.setEnableSubstitutionInVariables(true);
        this.assertEqualsCharSeq("The mouse jumps over the lazy dog.", this.replace(sub, "The ${animal.${species}} jumps over the ${target}."));
        this.values.put("species", "1");
        this.assertEqualsCharSeq("The fox jumps over the lazy dog.", this.replace(sub, "The ${animal.${species}} jumps over the ${target}."));
        this.assertEqualsCharSeq("The fox jumps over the lazy dog.", this.replace(sub, "The ${unknown.animal.${unknown.species:-1}:-fox} jumps over the ${unknow.target:-lazy dog}."));
    }

    @Test
    public void testReplaceInVariableDisabled() throws IOException {
        this.values.put("animal.1", "fox");
        this.values.put("animal.2", "mouse");
        this.values.put("species", "2");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        this.assertEqualsCharSeq("The ${animal.${species}} jumps over the lazy dog.", this.replace(sub, "The ${animal.${species}} jumps over the ${target}."));
        this.assertEqualsCharSeq("The ${animal.${species:-1}} jumps over the lazy dog.", this.replace(sub, "The ${animal.${species:-1}} jumps over the ${target}."));
    }

    @Test
    public void testReplaceInVariableRecursive() throws IOException {
        this.values.put("animal.2", "brown fox");
        this.values.put("animal.1", "white mouse");
        this.values.put("color", "white");
        this.values.put("species.white", "1");
        this.values.put("species.brown", "2");
        StringSubstitutor sub = new StringSubstitutor(this.values);
        sub.setEnableSubstitutionInVariables(true);
        this.assertEqualsCharSeq("white mouse", this.replace(sub, "${animal.${species.${color}}}"));
        this.assertEqualsCharSeq("The white mouse jumps over the lazy dog.", this.replace(sub, "The ${animal.${species.${color}}} jumps over the ${target}."));
        this.assertEqualsCharSeq("The brown fox jumps over the lazy dog.", this.replace(sub, "The ${animal.${species.${unknownColor:-brown}}} jumps over the ${target}."));
    }

    @Test
    public void testReplaceKeyStartChars() throws IOException {
        String substring = "${a";
        this.assertEqualsCharSeq("${a", this.replace(new StringSubstitutor(this.values), "${a"));
    }

    @Test
    public void testReplaceKeyStartChars1Only() throws IOException {
        String substring = "${".substring(0, 1);
        this.assertEqualsCharSeq(substring, this.replace(new StringSubstitutor(this.values), substring));
    }

    @Test
    public void testReplaceKeyStartChars2Only() throws IOException {
        String substring = "${".substring(0, 2);
        this.assertEqualsCharSeq(substring, this.replace(new StringSubstitutor(this.values), substring));
    }

    @Test
    public void testReplaceNoPrefixNoSuffix() throws IOException {
        this.doReplace("The animal jumps over the lazy dog.", "The animal jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceNoPrefixSuffix() throws IOException {
        this.doReplace("The animal} jumps over the lazy dog.", "The animal} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceNoVariables() throws IOException {
        this.doNotReplace("The balloon arrived.");
    }

    @Test
    public void testReplaceNull() throws IOException {
        this.doNotReplace(null);
    }

    @Test
    public void testReplacePartialString_noReplace() {
        StringSubstitutor sub = new StringSubstitutor();
        this.assertEqualsCharSeq("${animal} jumps", sub.replace(CLASSIC_TEMPLATE, 4, 15));
    }

    @Test
    public void testReplacePrefixNoSuffix() throws IOException {
        this.doReplace("The ${animal jumps over the ${target} lazy dog.", "The ${animal jumps over the ${target} ${target}.", true);
    }

    @Test
    public void testReplaceRecursive() throws IOException {
        this.values.put("animal", "${critter}");
        this.values.put("target", "${pet}");
        this.values.put("pet", "${petCharacteristic} dog");
        this.values.put("petCharacteristic", "lazy");
        this.values.put("critter", "${critterSpeed} ${critterColor} ${critterType}");
        this.values.put("critterSpeed", "quick");
        this.values.put("critterColor", "brown");
        this.values.put("critterType", "fox");
        this.doReplace(CLASSIC_RESULT, CLASSIC_TEMPLATE, true);
        this.values.put("pet", "${petCharacteristicUnknown:-lazy} dog");
        this.doReplace(CLASSIC_RESULT, CLASSIC_TEMPLATE, true);
    }

    @Test
    public void testReplaceSimple() throws IOException {
        this.doReplace(CLASSIC_RESULT, CLASSIC_TEMPLATE, true);
    }

    @Test
    public void testReplaceSimpleKeySize1() throws IOException {
        this.doReplace("1", "${a}", false);
    }

    @Test
    public void testReplaceSimpleKeySize2() throws IOException {
        this.doReplace("11", "${aa}", false);
    }

    @Test
    public void testReplaceSimpleKeySize3() throws IOException {
        this.doReplace("111", "${aaa}", false);
    }

    @Test
    public void testReplaceTakingCharSequenceReturningNull() {
        StringSubstitutor strSubstitutor = new StringSubstitutor((StringLookup)null);
        Assertions.assertNull((Object)strSubstitutor.replace((CharSequence)null));
        Assertions.assertFalse((boolean)strSubstitutor.isPreserveEscapes());
        Assertions.assertEquals((char)'$', (char)strSubstitutor.getEscapeChar());
    }

    @Test
    public void testReplaceTakingThreeArgumentsThrowsNullPointerException() {
        Assertions.assertThrows(NullPointerException.class, () -> StringSubstitutor.replace(null, (Properties)null));
    }

    @Test
    public void testReplaceThrowsStringIndexOutOfBoundsException() {
        StringSubstitutor sub = new StringSubstitutor();
        char[] emptyCharArray = new char[]{};
        Assertions.assertThrows(StringIndexOutOfBoundsException.class, () -> sub.replace(emptyCharArray, 0, 1));
        Assertions.assertThrows(StringIndexOutOfBoundsException.class, () -> sub.replace(emptyCharArray, 1, 0));
        Assertions.assertThrows(StringIndexOutOfBoundsException.class, () -> sub.replace("", 1, 1));
        Assertions.assertThrows(StringIndexOutOfBoundsException.class, () -> sub.replace("", 0, 1));
    }

    @Test
    public void testReplaceToIdentical() throws IOException {
        this.values.put("animal", "$${${thing}}");
        this.values.put("thing", "animal");
        this.doReplace("The ${animal} jumps.", "The ${animal} jumps.", true);
    }

    @Test
    public void testReplaceUnknownKey() throws IOException {
        this.doReplace("The ${person} jumps over the lazy dog.", "The ${person} jumps over the ${target}.", true);
    }

    @Test
    public void testReplaceUnknownKeyDefaultValue() throws IOException {
        this.doReplace("The ${person} jumps over the lazy dog. 1234567890.", "The ${person} jumps over the ${target}. ${undefined.number:-1234567890}.", true);
    }

    @Test
    public void testReplaceUnknownKeyOnly() throws IOException {
        String expected = "${person}";
        this.assertEqualsCharSeq("${person}", this.replace(new StringSubstitutor(this.values), "${person}"));
    }

    @Test
    public void testReplaceUnknownKeyOnlyExtraFirst() throws IOException {
        String expected = ".${person}";
        this.assertEqualsCharSeq(".${person}", this.replace(new StringSubstitutor(this.values), ".${person}"));
    }

    @Test
    public void testReplaceUnknownKeyOnlyExtraLast() throws IOException {
        String expected = "${person}.";
        this.assertEqualsCharSeq("${person}.", this.replace(new StringSubstitutor(this.values), "${person}."));
    }

    @Test
    public void testReplaceUnknownShortestKeyOnly() throws IOException {
        String expected = "${U}";
        this.assertEqualsCharSeq("${U}", this.replace(new StringSubstitutor(this.values), "${U}"));
    }

    @Test
    public void testReplaceUnknownShortestKeyOnlyExtraFirst() throws IOException {
        String expected = ".${U}";
        this.assertEqualsCharSeq(".${U}", this.replace(new StringSubstitutor(this.values), ".${U}"));
    }

    @Test
    public void testReplaceUnknownShortestKeyOnlyExtraLast() throws IOException {
        String expected = "${U}.";
        this.assertEqualsCharSeq("${U}.", this.replace(new StringSubstitutor(this.values), "${U}."));
    }

    @Test
    public void testReplaceVariablesCount1() throws IOException {
        this.doReplace(ACTUAL_ANIMAL, "${animal}", false);
    }

    @Test
    public void testReplaceVariablesCount1Escaping2To1() throws IOException {
        this.doReplace("${a}", "$${a}", false);
        this.doReplace("${animal}", "$${animal}", false);
    }

    @Test
    public void testReplaceVariablesCount1Escaping3To2() throws IOException {
        this.doReplace("$${a}", "$$${a}", false);
        this.doReplace("$${animal}", "$$${animal}", false);
    }

    @Test
    public void testReplaceVariablesCount1Escaping4To3() throws IOException {
        this.doReplace("$$${a}", "$$$${a}", false);
        this.doReplace("$$${animal}", "$$$${animal}", false);
    }

    @Test
    public void testReplaceVariablesCount1Escaping5To4() throws IOException {
        this.doReplace("$$$${a}", "$$$$${a}", false);
        this.doReplace("$$$${animal}", "$$$$${animal}", false);
    }

    @Test
    public void testReplaceVariablesCount1Escaping6To4() throws IOException {
        this.doReplace("$$$$${a}", "$$$$$${a}", false);
        this.doReplace("$$$$${animal}", "$$$$$${animal}", false);
    }

    @Test
    public void testReplaceVariablesCount2() throws IOException {
        this.doReplace("1122", "${aa}${bb}", false);
        this.doReplace("quick brown foxquick brown fox", "${animal}${animal}", false);
        this.doReplace("lazy doglazy dog", "${target}${target}", false);
        this.doReplace("quick brown foxlazy dog", "${animal}${target}", false);
    }

    @Test
    public void testReplaceVariablesCount2NonAdjacent() throws IOException {
        this.doReplace("1 2", "${a} ${b}", false);
        this.doReplace("11 22", "${aa} ${bb}", false);
        this.doReplace("quick brown fox quick brown fox", "${animal} ${animal}", false);
        this.doReplace("quick brown fox quick brown fox", "${animal} ${animal}", false);
        this.doReplace("quick brown fox quick brown fox", "${animal} ${animal}", false);
    }

    @Test
    public void testReplaceVariablesCount3() throws IOException {
        this.doReplace("121", "${a}${b}${a}", false);
        this.doReplace("112211", "${aa}${bb}${aa}", false);
        this.doReplace("quick brown foxquick brown foxquick brown fox", "${animal}${animal}${animal}", false);
        this.doReplace("lazy doglazy doglazy dog", "${target}${target}${target}", false);
    }

    @Test
    public void testReplaceVariablesCount3NonAdjacent() throws IOException {
        this.doReplace("1 2 1", "${a} ${b} ${a}", false);
        this.doReplace("11 22 11", "${aa} ${bb} ${aa}", false);
        this.doReplace("quick brown fox quick brown fox quick brown fox", "${animal} ${animal} ${animal}", false);
        this.doReplace("lazy dog lazy dog lazy dog", "${target} ${target} ${target}", false);
    }

    @Test
    public void testReplaceWeirdPattens() throws IOException {
        this.doNotReplace("");
        this.doNotReplace(EMPTY_EXPR);
        this.doNotReplace("${ }");
        this.doNotReplace("${\t}");
        this.doNotReplace("${\n}");
        this.doNotReplace("${\b}");
        this.doNotReplace("${");
        this.doNotReplace("$}");
        this.doNotReplace("$$}");
        this.doNotReplace("}");
        this.doNotReplace("${}$");
        this.doNotReplace("${}$$");
        this.doNotReplace("${${");
        this.doNotReplace("${${}}");
        this.doNotReplace("${$${}}");
        this.doNotReplace("${$$${}}");
        this.doNotReplace("${$$${$}}");
        this.doNotReplace("${${}}");
        this.doNotReplace("${${ }}");
        this.doNotReplace("${$${a}}");
        this.doNotReplace("${$$${a}}");
        this.doNotReplace("${${a}}");
        this.doNotReplace("${${${a}");
        this.doNotReplace("${ ${a}");
        this.doNotReplace("${ ${ ${a}");
        this.doReplace("${1}", "$${${a}}", false);
        this.doReplace("${ 1}", "$${ ${a}}", false);
        this.doReplace("${12}", "$${${a}${b}}", false);
        this.doReplace("${ 1 2 }", "$${ ${a} ${b} }", false);
        this.doReplace("${${${a}2", "${${${a}${b}", false);
    }

    @Test
    public void testResolveVariable() {
        final TextStringBuilder builder = new TextStringBuilder("Hi ${name}!");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        StringSubstitutor sub = new StringSubstitutor(map){

            protected String resolveVariable(String variableName, TextStringBuilder buf, int startPos, int endPos) {
                Assertions.assertEquals((Object)"name", (Object)variableName);
                Assertions.assertSame((Object)builder, (Object)buf);
                Assertions.assertEquals((int)3, (int)startPos);
                Assertions.assertEquals((int)10, (int)endPos);
                return "jakarta";
            }
        };
        sub.replaceIn(builder);
        this.assertEqualsCharSeq("Hi jakarta!", builder.toString());
    }

    @Test
    public void testSamePrefixAndSuffix() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("greeting", "Hello");
        map.put(" there ", "XXX");
        map.put("name", "commons");
        this.assertEqualsCharSeq("Hi commons!", StringSubstitutor.replace((Object)"Hi @name@!", map, (String)"@", (String)"@"));
        this.assertEqualsCharSeq("Hello there commons!", StringSubstitutor.replace((Object)"@greeting@ there @name@!", map, (String)"@", (String)"@"));
    }

    @Test
    public void testStaticReplace() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        this.assertEqualsCharSeq("Hi commons!", StringSubstitutor.replace((Object)"Hi ${name}!", map));
    }

    @Test
    public void testStaticReplacePrefixSuffix() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "commons");
        this.assertEqualsCharSeq("Hi commons!", StringSubstitutor.replace((Object)"Hi <name>!", map, (String)"<", (String)">"));
    }

    @Test
    public void testStaticReplaceSystemProperties() {
        TextStringBuilder buf = new TextStringBuilder();
        buf.append("Hi ").append(SystemProperties.getUserName());
        buf.append(", you are working with ");
        buf.append(SystemProperties.getOsName());
        buf.append(", your home directory is ");
        buf.append(SystemProperties.getUserHome()).append('.');
        this.assertEqualsCharSeq(buf.toString(), StringSubstitutor.replaceSystemProperties((Object)"Hi ${user.name}, you are working with ${os.name}, your home directory is ${user.home}."));
    }

    @Test
    public void testStaticReplaceSystemPropertiesWithUpdate() {
        System.setProperty("foo", "bar1");
        try {
            this.assertEqualsCharSeq("bar1", StringSubstitutor.replaceSystemProperties((Object)"${foo}"));
            System.setProperty("foo", "bar2");
            this.assertEqualsCharSeq("bar2", StringSubstitutor.replaceSystemProperties((Object)"${foo}"));
        }
        finally {
            System.getProperties().remove("foo");
        }
    }

    @Test
    public void testSubstituteDefaultProperties() {
        String org = "${doesnotwork}";
        System.setProperty("doesnotwork", "It works!");
        Properties props = new Properties(System.getProperties());
        this.assertEqualsCharSeq("It works!", StringSubstitutor.replace((Object)"${doesnotwork}", (Properties)props));
    }

    @Test
    public void testSubstitutePreserveEscape() throws IOException {
        String org = "${not-escaped} $${escaped}";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("not-escaped", "value");
        StringSubstitutor sub = new StringSubstitutor(map, "${", "}", '$');
        Assertions.assertFalse((boolean)sub.isPreserveEscapes());
        this.assertEqualsCharSeq("value ${escaped}", this.replace(sub, "${not-escaped} $${escaped}"));
        sub.setPreserveEscapes(true);
        Assertions.assertTrue((boolean)sub.isPreserveEscapes());
        this.assertEqualsCharSeq("value $${escaped}", this.replace(sub, "${not-escaped} $${escaped}"));
    }
}

