/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import org.apache.commons.text.translate.JavaUnicodeEscaper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JavaUnicodeEscaperTest {
    @Test
    public void testAbove() {
        JavaUnicodeEscaper jue = JavaUnicodeEscaper.above((int)70);
        String input = "ADFGZ";
        String result = jue.translate((CharSequence)"ADFGZ");
        Assertions.assertEquals((Object)"ADF\\u0047\\u005A", (Object)result, (String)"Failed to escape Unicode characters via the above method");
    }

    @Test
    public void testBelow() {
        JavaUnicodeEscaper jue = JavaUnicodeEscaper.below((int)70);
        String input = "ADFGZ";
        String result = jue.translate((CharSequence)"ADFGZ");
        Assertions.assertEquals((Object)"\\u0041\\u0044FGZ", (Object)result, (String)"Failed to escape Unicode characters via the below method");
    }

    @Test
    public void testBetween() {
        JavaUnicodeEscaper jue = JavaUnicodeEscaper.between((int)70, (int)76);
        String input = "ADFGZ";
        String result = jue.translate((CharSequence)"ADFGZ");
        Assertions.assertEquals((Object)"AD\\u0046\\u0047Z", (Object)result, (String)"Failed to escape Unicode characters via the between method");
    }

    @Test
    public void testToUtf16Escape() {
        JavaUnicodeEscaper jue = JavaUnicodeEscaper.below((int)70);
        String encoding = jue.toUtf16Escape(Integer.parseInt("024B62", 16));
        Assertions.assertEquals((Object)"\\uD852\\uDF62", (Object)encoding);
    }
}

