# Inline Assistant

## Usage Overview

Use {#kb assistant::InlineAssist} to open the Inline Assistant nearly anywhere you can enter text: editors, text threads, the rules library, channel notes, and even within the terminal panel.

The Inline Assistant allows you to send the current selection (or the current line) to a language model and modify the selection with the language model's response.

## Getting Started

If you're using the Inline Assistant for the first time, you need to have at least one LLM provider or external agent configured.
You can do that by:

1. [subscribing to our Pro plan](https://zed.dev/pricing), so you have access to our hosted models
2. [using your own API keys](./llm-providers.md#use-your-own-keys), either from model providers like Anthropic or model gateways like OpenRouter.

If you have already set up an LLM provider to interact with [the Agent Panel](./agent-panel.md#getting-started), then that will also work for the Inline Assistant.

> Unlike the Agent Panel, though, the only exception at the moment is [external agents](./external-agents.md).
> They currently can't be used for generating changes with the Inline Assistant.

## Adding Context

You can add context in the Inline Assistant the same way you can in [the Agent Panel](./agent-panel.md#adding-context):

- @-mention files, directories, past threads, rules, and symbols
- paste images that are copied on your clipboard

Additionally, a useful pattern is to create a thread in the Agent Panel, and then mention it with `@thread` in the Inline Assistant to include it as context.
That often serves as a way to more quickly iterate over a specific part of a change that happened in the context of a larger thread.

## Parallel Generations

There are two ways in which you can generate multiple changes at once with the Inline Assistant:

### Multiple Cursors

If you have a multiple cursor selection and hit {#kb assistant::InlineAssist}, you can shoot the same prompt for all cursor positions and get a change in all of them.

This is particularly useful when working on excerpts in [a multibuffer context](../multibuffers.md).

### Multiple Models

You can use the Inline Assistant to send the same prompt to multiple models at once.

Here's how you can customize your `settings.json` to add this functionality:

```json [settings]
{
  "agent": {
    "default_model": {
      "provider": "zed.dev",
      "model": "claude-sonnet-4"
    },
    "inline_alternatives": [
      {
        "provider": "zed.dev",
        "model": "gpt-4-mini"
      }
    ]
  }
}
```

When multiple models are configured, you'll see in the Inline Assistant UI buttons that allow you to cycle between outputs generated by each model.

The models you specify here are always used in _addition_ to your [default model](#default-model).

For example, the following configuration will generate three outputs for every assist.
One with Claude Sonnet 4 (the default model), another with GPT-5-mini, and another one with Gemini 2.5 Flash.

```json [settings]
{
  "agent": {
    "default_model": {
      "provider": "zed.dev",
      "model": "claude-sonnet-4"
    },
    "inline_alternatives": [
      {
        "provider": "zed.dev",
        "model": "gpt-4-mini"
      },
      {
        "provider": "zed.dev",
        "model": "gemini-2.5-flash"
      }
    ]
  }
}
```

## Inline Assistant vs. Edit Prediction

Users often ask what's the difference between these two AI-powered features in Zed, particularly because both of them involve getting inline LLM code completions.

Here's how they are different:

- The Inline Assistant is more similar to the Agent Panel as in you're still writing a prompt yourself and crafting context. It works from within the buffer and is mostly centered around your selections.
- [Edit Predictions](./edit-prediction.md) is an AI-powered completion mechanism that intelligently suggests what you likely want to add next, based on context automatically gathered from your previous edits, recently visited files, and more.

In summary, the key difference is that in the Inline Assistant, you're still manually prompting, whereas Edit Prediction will _automatically suggest_ edits to you.

## Prefilling Prompts

To create a custom keybinding that prefills a prompt, you can add the following format in your keymap:

```json [keymap]
[
  {
    "context": "Editor && mode == full",
    "bindings": {
      "ctrl-shift-enter": [
        "assistant::InlineAssist",
        { "prompt": "Build a snake game" }
      ]
    }
  }
]
```
