//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `warn!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn warn() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::warn!(ident = 3); // DEBUG:warn,-,-,-,-,"ident","3"
    tracing::warn!(foo = true, ident = 3); // DEBUG:warn,-,-,p,-,"ident","3"
    tracing::warn!(ident = 3, qux = 3); // DEBUG:warn,-,-,f,-,"ident","3"
    tracing::warn!(foo = true, ident = 3, qux = 3); // DEBUG:warn,-,-,pf,-,"ident","3"
    tracing::warn!(ident = 3, "msg without args"); // DEBUG:warn,-,-,-,m,"ident","3"
    tracing::warn!(foo = true, ident = 3, "msg without args"); // DEBUG:warn,-,-,p,m,"ident","3"
    tracing::warn!(ident = 3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"ident","3"
    tracing::warn!(foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"ident","3"
    tracing::warn!({ ident = 3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"ident","3"
    tracing::warn!({ foo = true, ident = 3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"ident","3"
    tracing::warn!({ ident = 3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"ident","3"
    tracing::warn!({ foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"ident","3"
    tracing::warn!(ident = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"ident","3"
    tracing::warn!(foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"ident","3"
    tracing::warn!(ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"ident","3"
    tracing::warn!(foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"ident","3"
    tracing::warn!({ ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"ident","3"
    tracing::warn!({ foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"ident","3"
    tracing::warn!({ ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"ident","3"
    tracing::warn!({ foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"ident","3"
    tracing::warn!(ident = false); // DEBUG:warn,-,-,-,-,"ident","false"
    tracing::warn!(foo = true, ident = false); // DEBUG:warn,-,-,p,-,"ident","false"
    tracing::warn!(ident = false, qux = 3); // DEBUG:warn,-,-,f,-,"ident","false"
    tracing::warn!(foo = true, ident = false, qux = 3); // DEBUG:warn,-,-,pf,-,"ident","false"
    tracing::warn!(ident = false, "msg without args"); // DEBUG:warn,-,-,-,m,"ident","false"
    tracing::warn!(foo = true, ident = false, "msg without args"); // DEBUG:warn,-,-,p,m,"ident","false"
    tracing::warn!(ident = false, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"ident","false"
    tracing::warn!(foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"ident","false"
    tracing::warn!({ ident = false }, "msg without args"); // DEBUG:warn,-,{},-,m,"ident","false"
    tracing::warn!({ foo = true, ident = false }, "msg without args"); // DEBUG:warn,-,{},p,m,"ident","false"
    tracing::warn!({ ident = false, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"ident","false"
    tracing::warn!({ foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"ident","false"
    tracing::warn!(ident = false, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"ident","false"
    tracing::warn!(foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"ident","false"
    tracing::warn!(ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"ident","false"
    tracing::warn!(foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"ident","false"
    tracing::warn!({ ident = false }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"ident","false"
    tracing::warn!({ foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"ident","false"
    tracing::warn!({ ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"ident","false"
    tracing::warn!({ foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"ident","false"
    tracing::warn!(ident = ?3); // DEBUG:warn,-,-,-,-,"ident","?3"
    tracing::warn!(foo = true, ident = ?3); // DEBUG:warn,-,-,p,-,"ident","?3"
    tracing::warn!(ident = ?3, qux = 3); // DEBUG:warn,-,-,f,-,"ident","?3"
    tracing::warn!(foo = true, ident = ?3, qux = 3); // DEBUG:warn,-,-,pf,-,"ident","?3"
    tracing::warn!(ident = ?3, "msg without args"); // DEBUG:warn,-,-,-,m,"ident","?3"
    tracing::warn!(foo = true, ident = ?3, "msg without args"); // DEBUG:warn,-,-,p,m,"ident","?3"
    tracing::warn!(ident = ?3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"ident","?3"
    tracing::warn!(foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"ident","?3"
    tracing::warn!({ ident = ?3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"ident","?3"
    tracing::warn!({ foo = true, ident = ?3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"ident","?3"
    tracing::warn!({ ident = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"ident","?3"
    tracing::warn!({ foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"ident","?3"
    tracing::warn!(ident = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"ident","?3"
    tracing::warn!(foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"ident","?3"
    tracing::warn!(ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"ident","?3"
    tracing::warn!(foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"ident","?3"
    tracing::warn!({ ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"ident","?3"
    tracing::warn!({ foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"ident","?3"
    tracing::warn!({ ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"ident","?3"
    tracing::warn!({ foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"ident","?3"
    tracing::warn!(ident = %3); // DEBUG:warn,-,-,-,-,"ident","%3"
    tracing::warn!(foo = true, ident = %3); // DEBUG:warn,-,-,p,-,"ident","%3"
    tracing::warn!(ident = %3, qux = 3); // DEBUG:warn,-,-,f,-,"ident","%3"
    tracing::warn!(foo = true, ident = %3, qux = 3); // DEBUG:warn,-,-,pf,-,"ident","%3"
    tracing::warn!(ident = %3, "msg without args"); // DEBUG:warn,-,-,-,m,"ident","%3"
    tracing::warn!(foo = true, ident = %3, "msg without args"); // DEBUG:warn,-,-,p,m,"ident","%3"
    tracing::warn!(ident = %3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"ident","%3"
    tracing::warn!(foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"ident","%3"
    tracing::warn!({ ident = %3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"ident","%3"
    tracing::warn!({ foo = true, ident = %3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"ident","%3"
    tracing::warn!({ ident = %3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"ident","%3"
    tracing::warn!({ foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"ident","%3"
    tracing::warn!(ident = %3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"ident","%3"
    tracing::warn!(foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"ident","%3"
    tracing::warn!(ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"ident","%3"
    tracing::warn!(foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"ident","%3"
    tracing::warn!({ ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"ident","%3"
    tracing::warn!({ foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"ident","%3"
    tracing::warn!({ ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"ident","%3"
    tracing::warn!({ foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"ident","%3"
    tracing::warn!(ident = ?deb); // DEBUG:warn,-,-,-,-,"ident","?deb"
    tracing::warn!(foo = true, ident = ?deb); // DEBUG:warn,-,-,p,-,"ident","?deb"
    tracing::warn!(ident = ?deb, qux = 3); // DEBUG:warn,-,-,f,-,"ident","?deb"
    tracing::warn!(foo = true, ident = ?deb, qux = 3); // DEBUG:warn,-,-,pf,-,"ident","?deb"
    tracing::warn!(ident = ?deb, "msg without args"); // DEBUG:warn,-,-,-,m,"ident","?deb"
    tracing::warn!(foo = true, ident = ?deb, "msg without args"); // DEBUG:warn,-,-,p,m,"ident","?deb"
    tracing::warn!(ident = ?deb, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"ident","?deb"
    tracing::warn!(foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"ident","?deb"
    tracing::warn!({ ident = ?deb }, "msg without args"); // DEBUG:warn,-,{},-,m,"ident","?deb"
    tracing::warn!({ foo = true, ident = ?deb }, "msg without args"); // DEBUG:warn,-,{},p,m,"ident","?deb"
    tracing::warn!({ ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"ident","?deb"
    tracing::warn!({ foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"ident","?deb"
    tracing::warn!(ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"ident","?deb"
    tracing::warn!(foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"ident","?deb"
    tracing::warn!(ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"ident","?deb"
    tracing::warn!(foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"ident","?deb"
    tracing::warn!({ ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"ident","?deb"
    tracing::warn!({ foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"ident","?deb"
    tracing::warn!({ ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"ident","?deb"
    tracing::warn!({ foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"ident","?deb"
    tracing::warn!(ident = %disp); // DEBUG:warn,-,-,-,-,"ident","%disp"
    tracing::warn!(foo = true, ident = %disp); // DEBUG:warn,-,-,p,-,"ident","%disp"
    tracing::warn!(ident = %disp, qux = 3); // DEBUG:warn,-,-,f,-,"ident","%disp"
    tracing::warn!(foo = true, ident = %disp, qux = 3); // DEBUG:warn,-,-,pf,-,"ident","%disp"
    tracing::warn!(ident = %disp, "msg without args"); // DEBUG:warn,-,-,-,m,"ident","%disp"
    tracing::warn!(foo = true, ident = %disp, "msg without args"); // DEBUG:warn,-,-,p,m,"ident","%disp"
    tracing::warn!(ident = %disp, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"ident","%disp"
    tracing::warn!(foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"ident","%disp"
    tracing::warn!({ ident = %disp }, "msg without args"); // DEBUG:warn,-,{},-,m,"ident","%disp"
    tracing::warn!({ foo = true, ident = %disp }, "msg without args"); // DEBUG:warn,-,{},p,m,"ident","%disp"
    tracing::warn!({ ident = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"ident","%disp"
    tracing::warn!({ foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"ident","%disp"
    tracing::warn!(ident = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"ident","%disp"
    tracing::warn!(foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"ident","%disp"
    tracing::warn!(ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"ident","%disp"
    tracing::warn!(foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"ident","%disp"
    tracing::warn!({ ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"ident","%disp"
    tracing::warn!({ foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"ident","%disp"
    tracing::warn!({ ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"ident","%disp"
    tracing::warn!({ foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"ident","%disp"
    tracing::warn!(ident = ?sub.field); // DEBUG:warn,-,-,-,-,"ident","?sub.field"
    tracing::warn!(foo = true, ident = ?sub.field); // DEBUG:warn,-,-,p,-,"ident","?sub.field"
    tracing::warn!(ident = ?sub.field, qux = 3); // DEBUG:warn,-,-,f,-,"ident","?sub.field"
    tracing::warn!(foo = true, ident = ?sub.field, qux = 3); // DEBUG:warn,-,-,pf,-,"ident","?sub.field"
    tracing::warn!(ident = ?sub.field, "msg without args"); // DEBUG:warn,-,-,-,m,"ident","?sub.field"
    tracing::warn!(foo = true, ident = ?sub.field, "msg without args"); // DEBUG:warn,-,-,p,m,"ident","?sub.field"
    tracing::warn!(ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"ident","?sub.field"
    tracing::warn!(foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"ident","?sub.field"
    tracing::warn!({ ident = ?sub.field }, "msg without args"); // DEBUG:warn,-,{},-,m,"ident","?sub.field"
    tracing::warn!({ foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:warn,-,{},p,m,"ident","?sub.field"
    tracing::warn!({ ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"ident","?sub.field"
    tracing::warn!({ foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"ident","?sub.field"
    tracing::warn!(ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"ident","?sub.field"
    tracing::warn!(foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"ident","?sub.field"
    tracing::warn!(ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"ident","?sub.field"
    tracing::warn!(foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"ident","?sub.field"
    tracing::warn!({ ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"ident","?sub.field"
    tracing::warn!({ foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"ident","?sub.field"
    tracing::warn!({ ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"ident","?sub.field"
    tracing::warn!({ foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"ident","?sub.field"
    tracing::warn!(ident = %sub.field); // DEBUG:warn,-,-,-,-,"ident","%sub.field"
    tracing::warn!(foo = true, ident = %sub.field); // DEBUG:warn,-,-,p,-,"ident","%sub.field"
    tracing::warn!(ident = %sub.field, qux = 3); // DEBUG:warn,-,-,f,-,"ident","%sub.field"
    tracing::warn!(foo = true, ident = %sub.field, qux = 3); // DEBUG:warn,-,-,pf,-,"ident","%sub.field"
    tracing::warn!(ident = %sub.field, "msg without args"); // DEBUG:warn,-,-,-,m,"ident","%sub.field"
    tracing::warn!(foo = true, ident = %sub.field, "msg without args"); // DEBUG:warn,-,-,p,m,"ident","%sub.field"
    tracing::warn!(ident = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"ident","%sub.field"
    tracing::warn!(foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"ident","%sub.field"
    tracing::warn!({ ident = %sub.field }, "msg without args"); // DEBUG:warn,-,{},-,m,"ident","%sub.field"
    tracing::warn!({ foo = true, ident = %sub.field }, "msg without args"); // DEBUG:warn,-,{},p,m,"ident","%sub.field"
    tracing::warn!({ ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"ident","%sub.field"
    tracing::warn!({ foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"ident","%sub.field"
    tracing::warn!(ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"ident","%sub.field"
    tracing::warn!(foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"ident","%sub.field"
    tracing::warn!(ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"ident","%sub.field"
    tracing::warn!(foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"ident","%sub.field"
    tracing::warn!({ ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"ident","%sub.field"
    tracing::warn!({ foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"ident","%sub.field"
    tracing::warn!({ ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"ident","%sub.field"
    tracing::warn!({ foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"ident","%sub.field"
    tracing::warn!(ident = debug(&deb)); // DEBUG:warn,-,-,-,-,"ident","debug(&deb)"
    tracing::warn!(foo = true, ident = debug(&deb)); // DEBUG:warn,-,-,p,-,"ident","debug(&deb)"
    tracing::warn!(ident = debug(&deb), qux = 3); // DEBUG:warn,-,-,f,-,"ident","debug(&deb)"
    tracing::warn!(foo = true, ident = debug(&deb), qux = 3); // DEBUG:warn,-,-,pf,-,"ident","debug(&deb)"
    tracing::warn!(ident = debug(&deb), "msg without args"); // DEBUG:warn,-,-,-,m,"ident","debug(&deb)"
    tracing::warn!(foo = true, ident = debug(&deb), "msg without args"); // DEBUG:warn,-,-,p,m,"ident","debug(&deb)"
    tracing::warn!(ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"ident","debug(&deb)"
    tracing::warn!(foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"ident","debug(&deb)"
    tracing::warn!({ ident = debug(&deb) }, "msg without args"); // DEBUG:warn,-,{},-,m,"ident","debug(&deb)"
    tracing::warn!({ foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:warn,-,{},p,m,"ident","debug(&deb)"
    tracing::warn!({ ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"ident","debug(&deb)"
    tracing::warn!({ foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"ident","debug(&deb)"
    tracing::warn!(ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"ident","debug(&deb)"
    tracing::warn!(foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"ident","debug(&deb)"
    tracing::warn!(ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"ident","debug(&deb)"
    tracing::warn!(foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"ident","debug(&deb)"
    tracing::warn!({ ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"ident","debug(&deb)"
    tracing::warn!({ foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"ident","debug(&deb)"
    tracing::warn!({ ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"ident","debug(&deb)"
    tracing::warn!({ foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"ident","debug(&deb)"
    tracing::warn!(ident = display(&disp)); // DEBUG:warn,-,-,-,-,"ident","display(&disp)"
    tracing::warn!(foo = true, ident = display(&disp)); // DEBUG:warn,-,-,p,-,"ident","display(&disp)"
    tracing::warn!(ident = display(&disp), qux = 3); // DEBUG:warn,-,-,f,-,"ident","display(&disp)"
    tracing::warn!(foo = true, ident = display(&disp), qux = 3); // DEBUG:warn,-,-,pf,-,"ident","display(&disp)"
    tracing::warn!(ident = display(&disp), "msg without args"); // DEBUG:warn,-,-,-,m,"ident","display(&disp)"
    tracing::warn!(foo = true, ident = display(&disp), "msg without args"); // DEBUG:warn,-,-,p,m,"ident","display(&disp)"
    tracing::warn!(ident = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"ident","display(&disp)"
    tracing::warn!(foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"ident","display(&disp)"
    tracing::warn!({ ident = display(&disp) }, "msg without args"); // DEBUG:warn,-,{},-,m,"ident","display(&disp)"
    tracing::warn!({ foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:warn,-,{},p,m,"ident","display(&disp)"
    tracing::warn!({ ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"ident","display(&disp)"
    tracing::warn!({ foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"ident","display(&disp)"
    tracing::warn!(ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"ident","display(&disp)"
    tracing::warn!(foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"ident","display(&disp)"
    tracing::warn!(ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"ident","display(&disp)"
    tracing::warn!(foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"ident","display(&disp)"
    tracing::warn!({ ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"ident","display(&disp)"
    tracing::warn!({ foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"ident","display(&disp)"
    tracing::warn!({ ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"ident","display(&disp)"
    tracing::warn!({ foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"ident","display(&disp)"
    tracing::warn!(ident = tracing::field::Empty); // DEBUG:warn,-,-,-,-,"ident","tracing::field::Empty"
    tracing::warn!(foo = true, ident = tracing::field::Empty); // DEBUG:warn,-,-,p,-,"ident","tracing::field::Empty"
    tracing::warn!(ident = tracing::field::Empty, qux = 3); // DEBUG:warn,-,-,f,-,"ident","tracing::field::Empty"
    tracing::warn!(foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:warn,-,-,pf,-,"ident","tracing::field::Empty"
    tracing::warn!(ident = tracing::field::Empty, "msg without args"); // DEBUG:warn,-,-,-,m,"ident","tracing::field::Empty"
    tracing::warn!(foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:warn,-,-,p,m,"ident","tracing::field::Empty"
    tracing::warn!(ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"ident","tracing::field::Empty"
    tracing::warn!(foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"ident","tracing::field::Empty"
    tracing::warn!({ ident = tracing::field::Empty }, "msg without args"); // DEBUG:warn,-,{},-,m,"ident","tracing::field::Empty"
    tracing::warn!({ foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:warn,-,{},p,m,"ident","tracing::field::Empty"
    tracing::warn!({ ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"ident","tracing::field::Empty"
    tracing::warn!({ foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"ident","tracing::field::Empty"
    tracing::warn!(ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"ident","tracing::field::Empty"
    tracing::warn!(foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"ident","tracing::field::Empty"
    tracing::warn!(ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"ident","tracing::field::Empty"
    tracing::warn!(foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"ident","tracing::field::Empty"
    tracing::warn!({ ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"ident","tracing::field::Empty"
    tracing::warn!({ foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"ident","tracing::field::Empty"
    tracing::warn!({ ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"ident","tracing::field::Empty"
    tracing::warn!({ foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"ident","tracing::field::Empty"
    tracing::warn!(dotted.ident = 3); // DEBUG:warn,-,-,-,-,"dotted.ident","3"
    tracing::warn!(foo = true, dotted.ident = 3); // DEBUG:warn,-,-,p,-,"dotted.ident","3"
    tracing::warn!(dotted.ident = 3, qux = 3); // DEBUG:warn,-,-,f,-,"dotted.ident","3"
    tracing::warn!(foo = true, dotted.ident = 3, qux = 3); // DEBUG:warn,-,-,pf,-,"dotted.ident","3"
    tracing::warn!(dotted.ident = 3, "msg without args"); // DEBUG:warn,-,-,-,m,"dotted.ident","3"
    tracing::warn!(foo = true, dotted.ident = 3, "msg without args"); // DEBUG:warn,-,-,p,m,"dotted.ident","3"
    tracing::warn!(dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"dotted.ident","3"
    tracing::warn!(foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"dotted.ident","3"
    tracing::warn!({ dotted.ident = 3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"dotted.ident","3"
    tracing::warn!({ foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"dotted.ident","3"
    tracing::warn!({ dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"dotted.ident","3"
    tracing::warn!({ foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"dotted.ident","3"
    tracing::warn!(dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"dotted.ident","3"
    tracing::warn!(foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"dotted.ident","3"
    tracing::warn!(dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"dotted.ident","3"
    tracing::warn!(foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"dotted.ident","3"
    tracing::warn!({ dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"dotted.ident","3"
    tracing::warn!({ foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"dotted.ident","3"
    tracing::warn!({ dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"dotted.ident","3"
    tracing::warn!({ foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"dotted.ident","3"
    tracing::warn!(dotted.ident = false); // DEBUG:warn,-,-,-,-,"dotted.ident","false"
    tracing::warn!(foo = true, dotted.ident = false); // DEBUG:warn,-,-,p,-,"dotted.ident","false"
    tracing::warn!(dotted.ident = false, qux = 3); // DEBUG:warn,-,-,f,-,"dotted.ident","false"
    tracing::warn!(foo = true, dotted.ident = false, qux = 3); // DEBUG:warn,-,-,pf,-,"dotted.ident","false"
    tracing::warn!(dotted.ident = false, "msg without args"); // DEBUG:warn,-,-,-,m,"dotted.ident","false"
    tracing::warn!(foo = true, dotted.ident = false, "msg without args"); // DEBUG:warn,-,-,p,m,"dotted.ident","false"
    tracing::warn!(dotted.ident = false, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"dotted.ident","false"
    tracing::warn!(foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"dotted.ident","false"
    tracing::warn!({ dotted.ident = false }, "msg without args"); // DEBUG:warn,-,{},-,m,"dotted.ident","false"
    tracing::warn!({ foo = true, dotted.ident = false }, "msg without args"); // DEBUG:warn,-,{},p,m,"dotted.ident","false"
    tracing::warn!({ dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"dotted.ident","false"
    tracing::warn!({ foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"dotted.ident","false"
    tracing::warn!(dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"dotted.ident","false"
    tracing::warn!(foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"dotted.ident","false"
    tracing::warn!(dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"dotted.ident","false"
    tracing::warn!(foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"dotted.ident","false"
    tracing::warn!({ dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"dotted.ident","false"
    tracing::warn!({ foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"dotted.ident","false"
    tracing::warn!({ dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"dotted.ident","false"
    tracing::warn!({ foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"dotted.ident","false"
    tracing::warn!(dotted.ident = ?3); // DEBUG:warn,-,-,-,-,"dotted.ident","?3"
    tracing::warn!(foo = true, dotted.ident = ?3); // DEBUG:warn,-,-,p,-,"dotted.ident","?3"
    tracing::warn!(dotted.ident = ?3, qux = 3); // DEBUG:warn,-,-,f,-,"dotted.ident","?3"
    tracing::warn!(foo = true, dotted.ident = ?3, qux = 3); // DEBUG:warn,-,-,pf,-,"dotted.ident","?3"
    tracing::warn!(dotted.ident = ?3, "msg without args"); // DEBUG:warn,-,-,-,m,"dotted.ident","?3"
    tracing::warn!(foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:warn,-,-,p,m,"dotted.ident","?3"
    tracing::warn!(dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"dotted.ident","?3"
    tracing::warn!(foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"dotted.ident","?3"
    tracing::warn!({ dotted.ident = ?3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"dotted.ident","?3"
    tracing::warn!({ foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"dotted.ident","?3"
    tracing::warn!({ dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"dotted.ident","?3"
    tracing::warn!({ foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"dotted.ident","?3"
    tracing::warn!(dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"dotted.ident","?3"
    tracing::warn!(foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"dotted.ident","?3"
    tracing::warn!(dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"dotted.ident","?3"
    tracing::warn!(foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"dotted.ident","?3"
    tracing::warn!({ dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"dotted.ident","?3"
    tracing::warn!({ foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"dotted.ident","?3"
    tracing::warn!({ dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"dotted.ident","?3"
    tracing::warn!({ foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"dotted.ident","?3"
    tracing::warn!(dotted.ident = %3); // DEBUG:warn,-,-,-,-,"dotted.ident","%3"
    tracing::warn!(foo = true, dotted.ident = %3); // DEBUG:warn,-,-,p,-,"dotted.ident","%3"
    tracing::warn!(dotted.ident = %3, qux = 3); // DEBUG:warn,-,-,f,-,"dotted.ident","%3"
    tracing::warn!(foo = true, dotted.ident = %3, qux = 3); // DEBUG:warn,-,-,pf,-,"dotted.ident","%3"
    tracing::warn!(dotted.ident = %3, "msg without args"); // DEBUG:warn,-,-,-,m,"dotted.ident","%3"
    tracing::warn!(foo = true, dotted.ident = %3, "msg without args"); // DEBUG:warn,-,-,p,m,"dotted.ident","%3"
    tracing::warn!(dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"dotted.ident","%3"
    tracing::warn!(foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"dotted.ident","%3"
    tracing::warn!({ dotted.ident = %3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"dotted.ident","%3"
    tracing::warn!({ foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"dotted.ident","%3"
    tracing::warn!({ dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"dotted.ident","%3"
    tracing::warn!({ foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"dotted.ident","%3"
    tracing::warn!(dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"dotted.ident","%3"
    tracing::warn!(foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"dotted.ident","%3"
    tracing::warn!(dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"dotted.ident","%3"
    tracing::warn!(foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"dotted.ident","%3"
    tracing::warn!({ dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"dotted.ident","%3"
    tracing::warn!({ foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"dotted.ident","%3"
    tracing::warn!({ dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"dotted.ident","%3"
    tracing::warn!({ foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"dotted.ident","%3"
    tracing::warn!(dotted.ident = ?deb); // DEBUG:warn,-,-,-,-,"dotted.ident","?deb"
    tracing::warn!(foo = true, dotted.ident = ?deb); // DEBUG:warn,-,-,p,-,"dotted.ident","?deb"
    tracing::warn!(dotted.ident = ?deb, qux = 3); // DEBUG:warn,-,-,f,-,"dotted.ident","?deb"
    tracing::warn!(foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:warn,-,-,pf,-,"dotted.ident","?deb"
    tracing::warn!(dotted.ident = ?deb, "msg without args"); // DEBUG:warn,-,-,-,m,"dotted.ident","?deb"
    tracing::warn!(foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:warn,-,-,p,m,"dotted.ident","?deb"
    tracing::warn!(dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"dotted.ident","?deb"
    tracing::warn!(foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"dotted.ident","?deb"
    tracing::warn!({ dotted.ident = ?deb }, "msg without args"); // DEBUG:warn,-,{},-,m,"dotted.ident","?deb"
    tracing::warn!({ foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:warn,-,{},p,m,"dotted.ident","?deb"
    tracing::warn!({ dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"dotted.ident","?deb"
    tracing::warn!({ foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"dotted.ident","?deb"
    tracing::warn!(dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"dotted.ident","?deb"
    tracing::warn!(foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"dotted.ident","?deb"
    tracing::warn!(dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"dotted.ident","?deb"
    tracing::warn!(foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"dotted.ident","?deb"
    tracing::warn!({ dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"dotted.ident","?deb"
    tracing::warn!({ foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"dotted.ident","?deb"
    tracing::warn!({ dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"dotted.ident","?deb"
    tracing::warn!({ foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"dotted.ident","?deb"
    tracing::warn!(dotted.ident = %disp); // DEBUG:warn,-,-,-,-,"dotted.ident","%disp"
    tracing::warn!(foo = true, dotted.ident = %disp); // DEBUG:warn,-,-,p,-,"dotted.ident","%disp"
    tracing::warn!(dotted.ident = %disp, qux = 3); // DEBUG:warn,-,-,f,-,"dotted.ident","%disp"
    tracing::warn!(foo = true, dotted.ident = %disp, qux = 3); // DEBUG:warn,-,-,pf,-,"dotted.ident","%disp"
    tracing::warn!(dotted.ident = %disp, "msg without args"); // DEBUG:warn,-,-,-,m,"dotted.ident","%disp"
    tracing::warn!(foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:warn,-,-,p,m,"dotted.ident","%disp"
    tracing::warn!(dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"dotted.ident","%disp"
    tracing::warn!(foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"dotted.ident","%disp"
    tracing::warn!({ dotted.ident = %disp }, "msg without args"); // DEBUG:warn,-,{},-,m,"dotted.ident","%disp"
    tracing::warn!({ foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:warn,-,{},p,m,"dotted.ident","%disp"
    tracing::warn!({ dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"dotted.ident","%disp"
    tracing::warn!({ foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"dotted.ident","%disp"
    tracing::warn!(dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"dotted.ident","%disp"
    tracing::warn!(foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"dotted.ident","%disp"
    tracing::warn!(dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"dotted.ident","%disp"
    tracing::warn!(foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"dotted.ident","%disp"
    tracing::warn!({ dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"dotted.ident","%disp"
    tracing::warn!({ foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"dotted.ident","%disp"
    tracing::warn!({ dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"dotted.ident","%disp"
    tracing::warn!({ foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"dotted.ident","%disp"
    tracing::warn!(dotted.ident = ?sub.field); // DEBUG:warn,-,-,-,-,"dotted.ident","?sub.field"
    tracing::warn!(foo = true, dotted.ident = ?sub.field); // DEBUG:warn,-,-,p,-,"dotted.ident","?sub.field"
    tracing::warn!(dotted.ident = ?sub.field, qux = 3); // DEBUG:warn,-,-,f,-,"dotted.ident","?sub.field"
    tracing::warn!(foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:warn,-,-,pf,-,"dotted.ident","?sub.field"
    tracing::warn!(dotted.ident = ?sub.field, "msg without args"); // DEBUG:warn,-,-,-,m,"dotted.ident","?sub.field"
    tracing::warn!(foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:warn,-,-,p,m,"dotted.ident","?sub.field"
    tracing::warn!(dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"dotted.ident","?sub.field"
    tracing::warn!(foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"dotted.ident","?sub.field"
    tracing::warn!({ dotted.ident = ?sub.field }, "msg without args"); // DEBUG:warn,-,{},-,m,"dotted.ident","?sub.field"
    tracing::warn!({ foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:warn,-,{},p,m,"dotted.ident","?sub.field"
    tracing::warn!({ dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"dotted.ident","?sub.field"
    tracing::warn!({ foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"dotted.ident","?sub.field"
    tracing::warn!(dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"dotted.ident","?sub.field"
    tracing::warn!(foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"dotted.ident","?sub.field"
    tracing::warn!(dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"dotted.ident","?sub.field"
    tracing::warn!(foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"dotted.ident","?sub.field"
    tracing::warn!({ dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"dotted.ident","?sub.field"
    tracing::warn!({ foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"dotted.ident","?sub.field"
    tracing::warn!({ dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"dotted.ident","?sub.field"
    tracing::warn!({ foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"dotted.ident","?sub.field"
    tracing::warn!(dotted.ident = %sub.field); // DEBUG:warn,-,-,-,-,"dotted.ident","%sub.field"
    tracing::warn!(foo = true, dotted.ident = %sub.field); // DEBUG:warn,-,-,p,-,"dotted.ident","%sub.field"
    tracing::warn!(dotted.ident = %sub.field, qux = 3); // DEBUG:warn,-,-,f,-,"dotted.ident","%sub.field"
    tracing::warn!(foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:warn,-,-,pf,-,"dotted.ident","%sub.field"
    tracing::warn!(dotted.ident = %sub.field, "msg without args"); // DEBUG:warn,-,-,-,m,"dotted.ident","%sub.field"
    tracing::warn!(foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:warn,-,-,p,m,"dotted.ident","%sub.field"
    tracing::warn!(dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"dotted.ident","%sub.field"
    tracing::warn!(foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"dotted.ident","%sub.field"
    tracing::warn!({ dotted.ident = %sub.field }, "msg without args"); // DEBUG:warn,-,{},-,m,"dotted.ident","%sub.field"
    tracing::warn!({ foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:warn,-,{},p,m,"dotted.ident","%sub.field"
    tracing::warn!({ dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"dotted.ident","%sub.field"
    tracing::warn!({ foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"dotted.ident","%sub.field"
    tracing::warn!(dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"dotted.ident","%sub.field"
    tracing::warn!(foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"dotted.ident","%sub.field"
    tracing::warn!(dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"dotted.ident","%sub.field"
    tracing::warn!(foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"dotted.ident","%sub.field"
    tracing::warn!({ dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"dotted.ident","%sub.field"
    tracing::warn!({ foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"dotted.ident","%sub.field"
    tracing::warn!({ dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"dotted.ident","%sub.field"
    tracing::warn!({ foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"dotted.ident","%sub.field"
    tracing::warn!(dotted.ident = debug(&deb)); // DEBUG:warn,-,-,-,-,"dotted.ident","debug(&deb)"
    tracing::warn!(foo = true, dotted.ident = debug(&deb)); // DEBUG:warn,-,-,p,-,"dotted.ident","debug(&deb)"
    tracing::warn!(dotted.ident = debug(&deb), qux = 3); // DEBUG:warn,-,-,f,-,"dotted.ident","debug(&deb)"
    tracing::warn!(foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:warn,-,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::warn!(dotted.ident = debug(&deb), "msg without args"); // DEBUG:warn,-,-,-,m,"dotted.ident","debug(&deb)"
    tracing::warn!(foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:warn,-,-,p,m,"dotted.ident","debug(&deb)"
    tracing::warn!(dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"dotted.ident","debug(&deb)"
    tracing::warn!(foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::warn!({ dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:warn,-,{},-,m,"dotted.ident","debug(&deb)"
    tracing::warn!({ foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:warn,-,{},p,m,"dotted.ident","debug(&deb)"
    tracing::warn!({ dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"dotted.ident","debug(&deb)"
    tracing::warn!({ foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::warn!(dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::warn!({ dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::warn!({ foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::warn!({ dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::warn!({ foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::warn!(dotted.ident = display(&disp)); // DEBUG:warn,-,-,-,-,"dotted.ident","display(&disp)"
    tracing::warn!(foo = true, dotted.ident = display(&disp)); // DEBUG:warn,-,-,p,-,"dotted.ident","display(&disp)"
    tracing::warn!(dotted.ident = display(&disp), qux = 3); // DEBUG:warn,-,-,f,-,"dotted.ident","display(&disp)"
    tracing::warn!(foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:warn,-,-,pf,-,"dotted.ident","display(&disp)"
    tracing::warn!(dotted.ident = display(&disp), "msg without args"); // DEBUG:warn,-,-,-,m,"dotted.ident","display(&disp)"
    tracing::warn!(foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:warn,-,-,p,m,"dotted.ident","display(&disp)"
    tracing::warn!(dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"dotted.ident","display(&disp)"
    tracing::warn!(foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"dotted.ident","display(&disp)"
    tracing::warn!({ dotted.ident = display(&disp) }, "msg without args"); // DEBUG:warn,-,{},-,m,"dotted.ident","display(&disp)"
    tracing::warn!({ foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:warn,-,{},p,m,"dotted.ident","display(&disp)"
    tracing::warn!({ dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"dotted.ident","display(&disp)"
    tracing::warn!({ foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"dotted.ident","display(&disp)"
    tracing::warn!(dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"dotted.ident","display(&disp)"
    tracing::warn!(foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"dotted.ident","display(&disp)"
    tracing::warn!(dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"dotted.ident","display(&disp)"
    tracing::warn!(foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::warn!({ dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"dotted.ident","display(&disp)"
    tracing::warn!({ foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"dotted.ident","display(&disp)"
    tracing::warn!({ dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"dotted.ident","display(&disp)"
    tracing::warn!({ foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::warn!(dotted.ident = tracing::field::Empty); // DEBUG:warn,-,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::warn!(foo = true, dotted.ident = tracing::field::Empty); // DEBUG:warn,-,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::warn!(dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:warn,-,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::warn!(foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:warn,-,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::warn!(dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:warn,-,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:warn,-,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!({ dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:warn,-,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!({ foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:warn,-,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!({ dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!({ foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::warn!(dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!(foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!({ dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!({ foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!({ dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!({ foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::warn!("literal" = 3); // DEBUG:warn,-,-,-,-,"\"literal\"","3"
    tracing::warn!(foo = true, "literal" = 3); // DEBUG:warn,-,-,p,-,"\"literal\"","3"
    tracing::warn!("literal" = 3, qux = 3); // DEBUG:warn,-,-,f,-,"\"literal\"","3"
    tracing::warn!(foo = true, "literal" = 3, qux = 3); // DEBUG:warn,-,-,pf,-,"\"literal\"","3"
    tracing::warn!("literal" = 3, "msg without args"); // DEBUG:warn,-,-,-,m,"\"literal\"","3"
    tracing::warn!(foo = true, "literal" = 3, "msg without args"); // DEBUG:warn,-,-,p,m,"\"literal\"","3"
    tracing::warn!("literal" = 3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"\"literal\"","3"
    tracing::warn!(foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"\"literal\"","3"
    tracing::warn!({ "literal" = 3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"\"literal\"","3"
    tracing::warn!({ foo = true, "literal" = 3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"\"literal\"","3"
    tracing::warn!({ "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"\"literal\"","3"
    tracing::warn!({ foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"\"literal\"","3"
    tracing::warn!("literal" = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"\"literal\"","3"
    tracing::warn!(foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"\"literal\"","3"
    tracing::warn!("literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"\"literal\"","3"
    tracing::warn!(foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"\"literal\"","3"
    tracing::warn!({ "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"\"literal\"","3"
    tracing::warn!({ foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"\"literal\"","3"
    tracing::warn!({ "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"\"literal\"","3"
    tracing::warn!({ foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"\"literal\"","3"
    tracing::warn!("literal" = false); // DEBUG:warn,-,-,-,-,"\"literal\"","false"
    tracing::warn!(foo = true, "literal" = false); // DEBUG:warn,-,-,p,-,"\"literal\"","false"
    tracing::warn!("literal" = false, qux = 3); // DEBUG:warn,-,-,f,-,"\"literal\"","false"
    tracing::warn!(foo = true, "literal" = false, qux = 3); // DEBUG:warn,-,-,pf,-,"\"literal\"","false"
    tracing::warn!("literal" = false, "msg without args"); // DEBUG:warn,-,-,-,m,"\"literal\"","false"
    tracing::warn!(foo = true, "literal" = false, "msg without args"); // DEBUG:warn,-,-,p,m,"\"literal\"","false"
    tracing::warn!("literal" = false, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"\"literal\"","false"
    tracing::warn!(foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"\"literal\"","false"
    tracing::warn!({ "literal" = false }, "msg without args"); // DEBUG:warn,-,{},-,m,"\"literal\"","false"
    tracing::warn!({ foo = true, "literal" = false }, "msg without args"); // DEBUG:warn,-,{},p,m,"\"literal\"","false"
    tracing::warn!({ "literal" = false, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"\"literal\"","false"
    tracing::warn!({ foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"\"literal\"","false"
    tracing::warn!("literal" = false, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"\"literal\"","false"
    tracing::warn!(foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"\"literal\"","false"
    tracing::warn!("literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"\"literal\"","false"
    tracing::warn!(foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"\"literal\"","false"
    tracing::warn!({ "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"\"literal\"","false"
    tracing::warn!({ foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"\"literal\"","false"
    tracing::warn!({ "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"\"literal\"","false"
    tracing::warn!({ foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"\"literal\"","false"
    tracing::warn!("literal" = ?3); // DEBUG:warn,-,-,-,-,"\"literal\"","?3"
    tracing::warn!(foo = true, "literal" = ?3); // DEBUG:warn,-,-,p,-,"\"literal\"","?3"
    tracing::warn!("literal" = ?3, qux = 3); // DEBUG:warn,-,-,f,-,"\"literal\"","?3"
    tracing::warn!(foo = true, "literal" = ?3, qux = 3); // DEBUG:warn,-,-,pf,-,"\"literal\"","?3"
    tracing::warn!("literal" = ?3, "msg without args"); // DEBUG:warn,-,-,-,m,"\"literal\"","?3"
    tracing::warn!(foo = true, "literal" = ?3, "msg without args"); // DEBUG:warn,-,-,p,m,"\"literal\"","?3"
    tracing::warn!("literal" = ?3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"\"literal\"","?3"
    tracing::warn!(foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"\"literal\"","?3"
    tracing::warn!({ "literal" = ?3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"\"literal\"","?3"
    tracing::warn!({ foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"\"literal\"","?3"
    tracing::warn!({ "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"\"literal\"","?3"
    tracing::warn!({ foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"\"literal\"","?3"
    tracing::warn!("literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"\"literal\"","?3"
    tracing::warn!(foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"\"literal\"","?3"
    tracing::warn!("literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"\"literal\"","?3"
    tracing::warn!(foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"\"literal\"","?3"
    tracing::warn!({ "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"\"literal\"","?3"
    tracing::warn!({ foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"\"literal\"","?3"
    tracing::warn!({ "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"\"literal\"","?3"
    tracing::warn!({ foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"\"literal\"","?3"
    tracing::warn!("literal" = %3); // DEBUG:warn,-,-,-,-,"\"literal\"","%3"
    tracing::warn!(foo = true, "literal" = %3); // DEBUG:warn,-,-,p,-,"\"literal\"","%3"
    tracing::warn!("literal" = %3, qux = 3); // DEBUG:warn,-,-,f,-,"\"literal\"","%3"
    tracing::warn!(foo = true, "literal" = %3, qux = 3); // DEBUG:warn,-,-,pf,-,"\"literal\"","%3"
    tracing::warn!("literal" = %3, "msg without args"); // DEBUG:warn,-,-,-,m,"\"literal\"","%3"
    tracing::warn!(foo = true, "literal" = %3, "msg without args"); // DEBUG:warn,-,-,p,m,"\"literal\"","%3"
    tracing::warn!("literal" = %3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"\"literal\"","%3"
    tracing::warn!(foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"\"literal\"","%3"
    tracing::warn!({ "literal" = %3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"\"literal\"","%3"
    tracing::warn!({ foo = true, "literal" = %3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"\"literal\"","%3"
    tracing::warn!({ "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"\"literal\"","%3"
    tracing::warn!({ foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"\"literal\"","%3"
    tracing::warn!("literal" = %3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"\"literal\"","%3"
    tracing::warn!(foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"\"literal\"","%3"
    tracing::warn!("literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"\"literal\"","%3"
    tracing::warn!(foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"\"literal\"","%3"
    tracing::warn!({ "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"\"literal\"","%3"
    tracing::warn!({ foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"\"literal\"","%3"
    tracing::warn!({ "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"\"literal\"","%3"
    tracing::warn!({ foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"\"literal\"","%3"
    tracing::warn!("literal" = ?deb); // DEBUG:warn,-,-,-,-,"\"literal\"","?deb"
    tracing::warn!(foo = true, "literal" = ?deb); // DEBUG:warn,-,-,p,-,"\"literal\"","?deb"
    tracing::warn!("literal" = ?deb, qux = 3); // DEBUG:warn,-,-,f,-,"\"literal\"","?deb"
    tracing::warn!(foo = true, "literal" = ?deb, qux = 3); // DEBUG:warn,-,-,pf,-,"\"literal\"","?deb"
    tracing::warn!("literal" = ?deb, "msg without args"); // DEBUG:warn,-,-,-,m,"\"literal\"","?deb"
    tracing::warn!(foo = true, "literal" = ?deb, "msg without args"); // DEBUG:warn,-,-,p,m,"\"literal\"","?deb"
    tracing::warn!("literal" = ?deb, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"\"literal\"","?deb"
    tracing::warn!(foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"\"literal\"","?deb"
    tracing::warn!({ "literal" = ?deb }, "msg without args"); // DEBUG:warn,-,{},-,m,"\"literal\"","?deb"
    tracing::warn!({ foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:warn,-,{},p,m,"\"literal\"","?deb"
    tracing::warn!({ "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"\"literal\"","?deb"
    tracing::warn!({ foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"\"literal\"","?deb"
    tracing::warn!("literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"\"literal\"","?deb"
    tracing::warn!(foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"\"literal\"","?deb"
    tracing::warn!("literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"\"literal\"","?deb"
    tracing::warn!(foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"\"literal\"","?deb"
    tracing::warn!({ "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"\"literal\"","?deb"
    tracing::warn!({ foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"\"literal\"","?deb"
    tracing::warn!({ "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"\"literal\"","?deb"
    tracing::warn!({ foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"\"literal\"","?deb"
    tracing::warn!("literal" = %disp); // DEBUG:warn,-,-,-,-,"\"literal\"","%disp"
    tracing::warn!(foo = true, "literal" = %disp); // DEBUG:warn,-,-,p,-,"\"literal\"","%disp"
    tracing::warn!("literal" = %disp, qux = 3); // DEBUG:warn,-,-,f,-,"\"literal\"","%disp"
    tracing::warn!(foo = true, "literal" = %disp, qux = 3); // DEBUG:warn,-,-,pf,-,"\"literal\"","%disp"
    tracing::warn!("literal" = %disp, "msg without args"); // DEBUG:warn,-,-,-,m,"\"literal\"","%disp"
    tracing::warn!(foo = true, "literal" = %disp, "msg without args"); // DEBUG:warn,-,-,p,m,"\"literal\"","%disp"
    tracing::warn!("literal" = %disp, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"\"literal\"","%disp"
    tracing::warn!(foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"\"literal\"","%disp"
    tracing::warn!({ "literal" = %disp }, "msg without args"); // DEBUG:warn,-,{},-,m,"\"literal\"","%disp"
    tracing::warn!({ foo = true, "literal" = %disp }, "msg without args"); // DEBUG:warn,-,{},p,m,"\"literal\"","%disp"
    tracing::warn!({ "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"\"literal\"","%disp"
    tracing::warn!({ foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"\"literal\"","%disp"
    tracing::warn!("literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"\"literal\"","%disp"
    tracing::warn!(foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"\"literal\"","%disp"
    tracing::warn!("literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"\"literal\"","%disp"
    tracing::warn!(foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"\"literal\"","%disp"
    tracing::warn!({ "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"\"literal\"","%disp"
    tracing::warn!({ foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"\"literal\"","%disp"
    tracing::warn!({ "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"\"literal\"","%disp"
    tracing::warn!({ foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"\"literal\"","%disp"
    tracing::warn!("literal" = ?sub.field); // DEBUG:warn,-,-,-,-,"\"literal\"","?sub.field"
    tracing::warn!(foo = true, "literal" = ?sub.field); // DEBUG:warn,-,-,p,-,"\"literal\"","?sub.field"
    tracing::warn!("literal" = ?sub.field, qux = 3); // DEBUG:warn,-,-,f,-,"\"literal\"","?sub.field"
    tracing::warn!(foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:warn,-,-,pf,-,"\"literal\"","?sub.field"
    tracing::warn!("literal" = ?sub.field, "msg without args"); // DEBUG:warn,-,-,-,m,"\"literal\"","?sub.field"
    tracing::warn!(foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:warn,-,-,p,m,"\"literal\"","?sub.field"
    tracing::warn!("literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"\"literal\"","?sub.field"
    tracing::warn!(foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"\"literal\"","?sub.field"
    tracing::warn!({ "literal" = ?sub.field }, "msg without args"); // DEBUG:warn,-,{},-,m,"\"literal\"","?sub.field"
    tracing::warn!({ foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:warn,-,{},p,m,"\"literal\"","?sub.field"
    tracing::warn!({ "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"\"literal\"","?sub.field"
    tracing::warn!({ foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"\"literal\"","?sub.field"
    tracing::warn!("literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"\"literal\"","?sub.field"
    tracing::warn!(foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"\"literal\"","?sub.field"
    tracing::warn!("literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"\"literal\"","?sub.field"
    tracing::warn!(foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"\"literal\"","?sub.field"
    tracing::warn!({ "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"\"literal\"","?sub.field"
    tracing::warn!({ foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"\"literal\"","?sub.field"
    tracing::warn!({ "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"\"literal\"","?sub.field"
    tracing::warn!({ foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"\"literal\"","?sub.field"
    tracing::warn!("literal" = %sub.field); // DEBUG:warn,-,-,-,-,"\"literal\"","%sub.field"
    tracing::warn!(foo = true, "literal" = %sub.field); // DEBUG:warn,-,-,p,-,"\"literal\"","%sub.field"
    tracing::warn!("literal" = %sub.field, qux = 3); // DEBUG:warn,-,-,f,-,"\"literal\"","%sub.field"
    tracing::warn!(foo = true, "literal" = %sub.field, qux = 3); // DEBUG:warn,-,-,pf,-,"\"literal\"","%sub.field"
    tracing::warn!("literal" = %sub.field, "msg without args"); // DEBUG:warn,-,-,-,m,"\"literal\"","%sub.field"
    tracing::warn!(foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:warn,-,-,p,m,"\"literal\"","%sub.field"
    tracing::warn!("literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"\"literal\"","%sub.field"
    tracing::warn!(foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"\"literal\"","%sub.field"
    tracing::warn!({ "literal" = %sub.field }, "msg without args"); // DEBUG:warn,-,{},-,m,"\"literal\"","%sub.field"
    tracing::warn!({ foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:warn,-,{},p,m,"\"literal\"","%sub.field"
    tracing::warn!({ "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"\"literal\"","%sub.field"
    tracing::warn!({ foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"\"literal\"","%sub.field"
    tracing::warn!("literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"\"literal\"","%sub.field"
    tracing::warn!(foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"\"literal\"","%sub.field"
    tracing::warn!("literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"\"literal\"","%sub.field"
    tracing::warn!(foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"\"literal\"","%sub.field"
    tracing::warn!({ "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"\"literal\"","%sub.field"
    tracing::warn!({ foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"\"literal\"","%sub.field"
    tracing::warn!({ "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"\"literal\"","%sub.field"
    tracing::warn!({ foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"\"literal\"","%sub.field"
    tracing::warn!("literal" = debug(&deb)); // DEBUG:warn,-,-,-,-,"\"literal\"","debug(&deb)"
    tracing::warn!(foo = true, "literal" = debug(&deb)); // DEBUG:warn,-,-,p,-,"\"literal\"","debug(&deb)"
    tracing::warn!("literal" = debug(&deb), qux = 3); // DEBUG:warn,-,-,f,-,"\"literal\"","debug(&deb)"
    tracing::warn!(foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:warn,-,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::warn!("literal" = debug(&deb), "msg without args"); // DEBUG:warn,-,-,-,m,"\"literal\"","debug(&deb)"
    tracing::warn!(foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:warn,-,-,p,m,"\"literal\"","debug(&deb)"
    tracing::warn!("literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"\"literal\"","debug(&deb)"
    tracing::warn!(foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::warn!({ "literal" = debug(&deb) }, "msg without args"); // DEBUG:warn,-,{},-,m,"\"literal\"","debug(&deb)"
    tracing::warn!({ foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:warn,-,{},p,m,"\"literal\"","debug(&deb)"
    tracing::warn!({ "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"\"literal\"","debug(&deb)"
    tracing::warn!({ foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::warn!("literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::warn!("literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::warn!(foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::warn!({ "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::warn!({ foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::warn!({ "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::warn!({ foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::warn!("literal" = display(&disp)); // DEBUG:warn,-,-,-,-,"\"literal\"","display(&disp)"
    tracing::warn!(foo = true, "literal" = display(&disp)); // DEBUG:warn,-,-,p,-,"\"literal\"","display(&disp)"
    tracing::warn!("literal" = display(&disp), qux = 3); // DEBUG:warn,-,-,f,-,"\"literal\"","display(&disp)"
    tracing::warn!(foo = true, "literal" = display(&disp), qux = 3); // DEBUG:warn,-,-,pf,-,"\"literal\"","display(&disp)"
    tracing::warn!("literal" = display(&disp), "msg without args"); // DEBUG:warn,-,-,-,m,"\"literal\"","display(&disp)"
    tracing::warn!(foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:warn,-,-,p,m,"\"literal\"","display(&disp)"
    tracing::warn!("literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"\"literal\"","display(&disp)"
    tracing::warn!(foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"\"literal\"","display(&disp)"
    tracing::warn!({ "literal" = display(&disp) }, "msg without args"); // DEBUG:warn,-,{},-,m,"\"literal\"","display(&disp)"
    tracing::warn!({ foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:warn,-,{},p,m,"\"literal\"","display(&disp)"
    tracing::warn!({ "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"\"literal\"","display(&disp)"
    tracing::warn!({ foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"\"literal\"","display(&disp)"
    tracing::warn!("literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"\"literal\"","display(&disp)"
    tracing::warn!(foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"\"literal\"","display(&disp)"
    tracing::warn!("literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"\"literal\"","display(&disp)"
    tracing::warn!(foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::warn!({ "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"\"literal\"","display(&disp)"
    tracing::warn!({ foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"\"literal\"","display(&disp)"
    tracing::warn!({ "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"\"literal\"","display(&disp)"
    tracing::warn!({ foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::warn!("literal" = tracing::field::Empty); // DEBUG:warn,-,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::warn!(foo = true, "literal" = tracing::field::Empty); // DEBUG:warn,-,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::warn!("literal" = tracing::field::Empty, qux = 3); // DEBUG:warn,-,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::warn!(foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:warn,-,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::warn!("literal" = tracing::field::Empty, "msg without args"); // DEBUG:warn,-,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:warn,-,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!("literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!(foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!({ "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:warn,-,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!({ foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:warn,-,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!({ "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!({ foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::warn!("literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!("literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!(foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!({ "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!({ foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!({ "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!({ foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::warn!({ CONST_VAR } = 3); // DEBUG:warn,-,-,-,-,"{ CONST_VAR }","3"
    tracing::warn!(foo = true, { CONST_VAR } = 3); // DEBUG:warn,-,-,p,-,"{ CONST_VAR }","3"
    tracing::warn!({ CONST_VAR } = 3, qux = 3); // DEBUG:warn,-,-,f,-,"{ CONST_VAR }","3"
    tracing::warn!(foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:warn,-,-,pf,-,"{ CONST_VAR }","3"
    tracing::warn!({ CONST_VAR } = 3, "msg without args"); // DEBUG:warn,-,-,-,m,"{ CONST_VAR }","3"
    tracing::warn!(foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:warn,-,-,p,m,"{ CONST_VAR }","3"
    tracing::warn!({ CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"{ CONST_VAR }","3"
    tracing::warn!(foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"{ CONST_VAR }","3"
    tracing::warn!({ { CONST_VAR } = 3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"{ CONST_VAR }","3"
    tracing::warn!({ foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"{ CONST_VAR }","3"
    tracing::warn!({ { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"{ CONST_VAR }","3"
    tracing::warn!({ foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"{ CONST_VAR }","3"
    tracing::warn!({ CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"{ CONST_VAR }","3"
    tracing::warn!(foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"{ CONST_VAR }","3"
    tracing::warn!({ CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"{ CONST_VAR }","3"
    tracing::warn!(foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"{ CONST_VAR }","3"
    tracing::warn!({ { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"{ CONST_VAR }","3"
    tracing::warn!({ foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"{ CONST_VAR }","3"
    tracing::warn!({ { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"{ CONST_VAR }","3"
    tracing::warn!({ foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"{ CONST_VAR }","3"
    tracing::warn!({ CONST_VAR } = false); // DEBUG:warn,-,-,-,-,"{ CONST_VAR }","false"
    tracing::warn!(foo = true, { CONST_VAR } = false); // DEBUG:warn,-,-,p,-,"{ CONST_VAR }","false"
    tracing::warn!({ CONST_VAR } = false, qux = 3); // DEBUG:warn,-,-,f,-,"{ CONST_VAR }","false"
    tracing::warn!(foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:warn,-,-,pf,-,"{ CONST_VAR }","false"
    tracing::warn!({ CONST_VAR } = false, "msg without args"); // DEBUG:warn,-,-,-,m,"{ CONST_VAR }","false"
    tracing::warn!(foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:warn,-,-,p,m,"{ CONST_VAR }","false"
    tracing::warn!({ CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"{ CONST_VAR }","false"
    tracing::warn!(foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"{ CONST_VAR }","false"
    tracing::warn!({ { CONST_VAR } = false }, "msg without args"); // DEBUG:warn,-,{},-,m,"{ CONST_VAR }","false"
    tracing::warn!({ foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:warn,-,{},p,m,"{ CONST_VAR }","false"
    tracing::warn!({ { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"{ CONST_VAR }","false"
    tracing::warn!({ foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"{ CONST_VAR }","false"
    tracing::warn!({ CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"{ CONST_VAR }","false"
    tracing::warn!(foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"{ CONST_VAR }","false"
    tracing::warn!({ CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"{ CONST_VAR }","false"
    tracing::warn!(foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"{ CONST_VAR }","false"
    tracing::warn!({ { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"{ CONST_VAR }","false"
    tracing::warn!({ foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"{ CONST_VAR }","false"
    tracing::warn!({ { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"{ CONST_VAR }","false"
    tracing::warn!({ foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"{ CONST_VAR }","false"
    tracing::warn!({ CONST_VAR } = ?3); // DEBUG:warn,-,-,-,-,"{ CONST_VAR }","?3"
    tracing::warn!(foo = true, { CONST_VAR } = ?3); // DEBUG:warn,-,-,p,-,"{ CONST_VAR }","?3"
    tracing::warn!({ CONST_VAR } = ?3, qux = 3); // DEBUG:warn,-,-,f,-,"{ CONST_VAR }","?3"
    tracing::warn!(foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:warn,-,-,pf,-,"{ CONST_VAR }","?3"
    tracing::warn!({ CONST_VAR } = ?3, "msg without args"); // DEBUG:warn,-,-,-,m,"{ CONST_VAR }","?3"
    tracing::warn!(foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:warn,-,-,p,m,"{ CONST_VAR }","?3"
    tracing::warn!({ CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"{ CONST_VAR }","?3"
    tracing::warn!(foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"{ CONST_VAR }","?3"
    tracing::warn!({ { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"{ CONST_VAR }","?3"
    tracing::warn!({ foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"{ CONST_VAR }","?3"
    tracing::warn!({ { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"{ CONST_VAR }","?3"
    tracing::warn!({ foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"{ CONST_VAR }","?3"
    tracing::warn!({ CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"{ CONST_VAR }","?3"
    tracing::warn!(foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"{ CONST_VAR }","?3"
    tracing::warn!({ CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"{ CONST_VAR }","?3"
    tracing::warn!(foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::warn!({ { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"{ CONST_VAR }","?3"
    tracing::warn!({ foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"{ CONST_VAR }","?3"
    tracing::warn!({ { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"{ CONST_VAR }","?3"
    tracing::warn!({ foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::warn!({ CONST_VAR } = %3); // DEBUG:warn,-,-,-,-,"{ CONST_VAR }","%3"
    tracing::warn!(foo = true, { CONST_VAR } = %3); // DEBUG:warn,-,-,p,-,"{ CONST_VAR }","%3"
    tracing::warn!({ CONST_VAR } = %3, qux = 3); // DEBUG:warn,-,-,f,-,"{ CONST_VAR }","%3"
    tracing::warn!(foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:warn,-,-,pf,-,"{ CONST_VAR }","%3"
    tracing::warn!({ CONST_VAR } = %3, "msg without args"); // DEBUG:warn,-,-,-,m,"{ CONST_VAR }","%3"
    tracing::warn!(foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:warn,-,-,p,m,"{ CONST_VAR }","%3"
    tracing::warn!({ CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"{ CONST_VAR }","%3"
    tracing::warn!(foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"{ CONST_VAR }","%3"
    tracing::warn!({ { CONST_VAR } = %3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"{ CONST_VAR }","%3"
    tracing::warn!({ foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"{ CONST_VAR }","%3"
    tracing::warn!({ { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"{ CONST_VAR }","%3"
    tracing::warn!({ foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"{ CONST_VAR }","%3"
    tracing::warn!({ CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"{ CONST_VAR }","%3"
    tracing::warn!(foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"{ CONST_VAR }","%3"
    tracing::warn!({ CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"{ CONST_VAR }","%3"
    tracing::warn!(foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::warn!({ { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"{ CONST_VAR }","%3"
    tracing::warn!({ foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"{ CONST_VAR }","%3"
    tracing::warn!({ { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"{ CONST_VAR }","%3"
    tracing::warn!({ foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::warn!({ CONST_VAR } = ?deb); // DEBUG:warn,-,-,-,-,"{ CONST_VAR }","?deb"
    tracing::warn!(foo = true, { CONST_VAR } = ?deb); // DEBUG:warn,-,-,p,-,"{ CONST_VAR }","?deb"
    tracing::warn!({ CONST_VAR } = ?deb, qux = 3); // DEBUG:warn,-,-,f,-,"{ CONST_VAR }","?deb"
    tracing::warn!(foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:warn,-,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::warn!({ CONST_VAR } = ?deb, "msg without args"); // DEBUG:warn,-,-,-,m,"{ CONST_VAR }","?deb"
    tracing::warn!(foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:warn,-,-,p,m,"{ CONST_VAR }","?deb"
    tracing::warn!({ CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"{ CONST_VAR }","?deb"
    tracing::warn!(foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::warn!({ { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:warn,-,{},-,m,"{ CONST_VAR }","?deb"
    tracing::warn!({ foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:warn,-,{},p,m,"{ CONST_VAR }","?deb"
    tracing::warn!({ { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"{ CONST_VAR }","?deb"
    tracing::warn!({ foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::warn!({ CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::warn!({ CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::warn!(foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::warn!({ { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::warn!({ foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::warn!({ { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::warn!({ foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::warn!({ CONST_VAR } = %disp); // DEBUG:warn,-,-,-,-,"{ CONST_VAR }","%disp"
    tracing::warn!(foo = true, { CONST_VAR } = %disp); // DEBUG:warn,-,-,p,-,"{ CONST_VAR }","%disp"
    tracing::warn!({ CONST_VAR } = %disp, qux = 3); // DEBUG:warn,-,-,f,-,"{ CONST_VAR }","%disp"
    tracing::warn!(foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:warn,-,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::warn!({ CONST_VAR } = %disp, "msg without args"); // DEBUG:warn,-,-,-,m,"{ CONST_VAR }","%disp"
    tracing::warn!(foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:warn,-,-,p,m,"{ CONST_VAR }","%disp"
    tracing::warn!({ CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"{ CONST_VAR }","%disp"
    tracing::warn!(foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::warn!({ { CONST_VAR } = %disp }, "msg without args"); // DEBUG:warn,-,{},-,m,"{ CONST_VAR }","%disp"
    tracing::warn!({ foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:warn,-,{},p,m,"{ CONST_VAR }","%disp"
    tracing::warn!({ { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"{ CONST_VAR }","%disp"
    tracing::warn!({ foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::warn!({ CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::warn!({ CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::warn!(foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::warn!({ { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::warn!({ foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::warn!({ { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::warn!({ foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::warn!({ CONST_VAR } = ?sub.field); // DEBUG:warn,-,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::warn!(foo = true, { CONST_VAR } = ?sub.field); // DEBUG:warn,-,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ CONST_VAR } = ?sub.field, qux = 3); // DEBUG:warn,-,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::warn!(foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:warn,-,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:warn,-,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:warn,-,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!(foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:warn,-,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:warn,-,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!(foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::warn!({ CONST_VAR } = %sub.field); // DEBUG:warn,-,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::warn!(foo = true, { CONST_VAR } = %sub.field); // DEBUG:warn,-,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ CONST_VAR } = %sub.field, qux = 3); // DEBUG:warn,-,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::warn!(foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:warn,-,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ CONST_VAR } = %sub.field, "msg without args"); // DEBUG:warn,-,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:warn,-,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!(foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:warn,-,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:warn,-,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!(foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::warn!({ CONST_VAR } = debug(&deb)); // DEBUG:warn,-,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:warn,-,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ CONST_VAR } = debug(&deb), qux = 3); // DEBUG:warn,-,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:warn,-,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:warn,-,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:warn,-,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:warn,-,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:warn,-,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!(foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::warn!({ CONST_VAR } = display(&disp)); // DEBUG:warn,-,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(foo = true, { CONST_VAR } = display(&disp)); // DEBUG:warn,-,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ CONST_VAR } = display(&disp), qux = 3); // DEBUG:warn,-,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:warn,-,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ CONST_VAR } = display(&disp), "msg without args"); // DEBUG:warn,-,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:warn,-,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:warn,-,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:warn,-,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!(foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::warn!({ CONST_VAR } = tracing::field::Empty); // DEBUG:warn,-,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:warn,-,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!({ CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:warn,-,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:warn,-,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!({ CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:warn,-,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:warn,-,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!({ CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!({ { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:warn,-,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!({ foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:warn,-,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!({ { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!({ foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!({ CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!({ CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!({ { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!({ foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!({ { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!({ foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::warn!(r#type = 3); // DEBUG:warn,-,-,-,-,"r#type","3"
    tracing::warn!(foo = true, r#type = 3); // DEBUG:warn,-,-,p,-,"r#type","3"
    tracing::warn!(r#type = 3, qux = 3); // DEBUG:warn,-,-,f,-,"r#type","3"
    tracing::warn!(foo = true, r#type = 3, qux = 3); // DEBUG:warn,-,-,pf,-,"r#type","3"
    tracing::warn!(r#type = 3, "msg without args"); // DEBUG:warn,-,-,-,m,"r#type","3"
    tracing::warn!(foo = true, r#type = 3, "msg without args"); // DEBUG:warn,-,-,p,m,"r#type","3"
    tracing::warn!(r#type = 3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"r#type","3"
    tracing::warn!(foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"r#type","3"
    tracing::warn!({ r#type = 3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"r#type","3"
    tracing::warn!({ foo = true, r#type = 3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"r#type","3"
    tracing::warn!({ r#type = 3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"r#type","3"
    tracing::warn!({ foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"r#type","3"
    tracing::warn!(r#type = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"r#type","3"
    tracing::warn!(foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"r#type","3"
    tracing::warn!(r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"r#type","3"
    tracing::warn!(foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"r#type","3"
    tracing::warn!({ r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"r#type","3"
    tracing::warn!({ foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"r#type","3"
    tracing::warn!({ r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"r#type","3"
    tracing::warn!({ foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"r#type","3"
    tracing::warn!(r#type = false); // DEBUG:warn,-,-,-,-,"r#type","false"
    tracing::warn!(foo = true, r#type = false); // DEBUG:warn,-,-,p,-,"r#type","false"
    tracing::warn!(r#type = false, qux = 3); // DEBUG:warn,-,-,f,-,"r#type","false"
    tracing::warn!(foo = true, r#type = false, qux = 3); // DEBUG:warn,-,-,pf,-,"r#type","false"
    tracing::warn!(r#type = false, "msg without args"); // DEBUG:warn,-,-,-,m,"r#type","false"
    tracing::warn!(foo = true, r#type = false, "msg without args"); // DEBUG:warn,-,-,p,m,"r#type","false"
    tracing::warn!(r#type = false, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"r#type","false"
    tracing::warn!(foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"r#type","false"
    tracing::warn!({ r#type = false }, "msg without args"); // DEBUG:warn,-,{},-,m,"r#type","false"
    tracing::warn!({ foo = true, r#type = false }, "msg without args"); // DEBUG:warn,-,{},p,m,"r#type","false"
    tracing::warn!({ r#type = false, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"r#type","false"
    tracing::warn!({ foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"r#type","false"
    tracing::warn!(r#type = false, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"r#type","false"
    tracing::warn!(foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"r#type","false"
    tracing::warn!(r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"r#type","false"
    tracing::warn!(foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"r#type","false"
    tracing::warn!({ r#type = false }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"r#type","false"
    tracing::warn!({ foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"r#type","false"
    tracing::warn!({ r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"r#type","false"
    tracing::warn!({ foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"r#type","false"
    tracing::warn!(r#type = ?3); // DEBUG:warn,-,-,-,-,"r#type","?3"
    tracing::warn!(foo = true, r#type = ?3); // DEBUG:warn,-,-,p,-,"r#type","?3"
    tracing::warn!(r#type = ?3, qux = 3); // DEBUG:warn,-,-,f,-,"r#type","?3"
    tracing::warn!(foo = true, r#type = ?3, qux = 3); // DEBUG:warn,-,-,pf,-,"r#type","?3"
    tracing::warn!(r#type = ?3, "msg without args"); // DEBUG:warn,-,-,-,m,"r#type","?3"
    tracing::warn!(foo = true, r#type = ?3, "msg without args"); // DEBUG:warn,-,-,p,m,"r#type","?3"
    tracing::warn!(r#type = ?3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"r#type","?3"
    tracing::warn!(foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"r#type","?3"
    tracing::warn!({ r#type = ?3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"r#type","?3"
    tracing::warn!({ foo = true, r#type = ?3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"r#type","?3"
    tracing::warn!({ r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"r#type","?3"
    tracing::warn!({ foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"r#type","?3"
    tracing::warn!(r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"r#type","?3"
    tracing::warn!(foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"r#type","?3"
    tracing::warn!(r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"r#type","?3"
    tracing::warn!(foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"r#type","?3"
    tracing::warn!({ r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"r#type","?3"
    tracing::warn!({ foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"r#type","?3"
    tracing::warn!({ r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"r#type","?3"
    tracing::warn!({ foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"r#type","?3"
    tracing::warn!(r#type = %3); // DEBUG:warn,-,-,-,-,"r#type","%3"
    tracing::warn!(foo = true, r#type = %3); // DEBUG:warn,-,-,p,-,"r#type","%3"
    tracing::warn!(r#type = %3, qux = 3); // DEBUG:warn,-,-,f,-,"r#type","%3"
    tracing::warn!(foo = true, r#type = %3, qux = 3); // DEBUG:warn,-,-,pf,-,"r#type","%3"
    tracing::warn!(r#type = %3, "msg without args"); // DEBUG:warn,-,-,-,m,"r#type","%3"
    tracing::warn!(foo = true, r#type = %3, "msg without args"); // DEBUG:warn,-,-,p,m,"r#type","%3"
    tracing::warn!(r#type = %3, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"r#type","%3"
    tracing::warn!(foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"r#type","%3"
    tracing::warn!({ r#type = %3 }, "msg without args"); // DEBUG:warn,-,{},-,m,"r#type","%3"
    tracing::warn!({ foo = true, r#type = %3 }, "msg without args"); // DEBUG:warn,-,{},p,m,"r#type","%3"
    tracing::warn!({ r#type = %3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"r#type","%3"
    tracing::warn!({ foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"r#type","%3"
    tracing::warn!(r#type = %3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"r#type","%3"
    tracing::warn!(foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"r#type","%3"
    tracing::warn!(r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"r#type","%3"
    tracing::warn!(foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"r#type","%3"
    tracing::warn!({ r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"r#type","%3"
    tracing::warn!({ foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"r#type","%3"
    tracing::warn!({ r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"r#type","%3"
    tracing::warn!({ foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"r#type","%3"
    tracing::warn!(r#type = ?deb); // DEBUG:warn,-,-,-,-,"r#type","?deb"
    tracing::warn!(foo = true, r#type = ?deb); // DEBUG:warn,-,-,p,-,"r#type","?deb"
    tracing::warn!(r#type = ?deb, qux = 3); // DEBUG:warn,-,-,f,-,"r#type","?deb"
    tracing::warn!(foo = true, r#type = ?deb, qux = 3); // DEBUG:warn,-,-,pf,-,"r#type","?deb"
    tracing::warn!(r#type = ?deb, "msg without args"); // DEBUG:warn,-,-,-,m,"r#type","?deb"
    tracing::warn!(foo = true, r#type = ?deb, "msg without args"); // DEBUG:warn,-,-,p,m,"r#type","?deb"
    tracing::warn!(r#type = ?deb, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"r#type","?deb"
    tracing::warn!(foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"r#type","?deb"
    tracing::warn!({ r#type = ?deb }, "msg without args"); // DEBUG:warn,-,{},-,m,"r#type","?deb"
    tracing::warn!({ foo = true, r#type = ?deb }, "msg without args"); // DEBUG:warn,-,{},p,m,"r#type","?deb"
    tracing::warn!({ r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"r#type","?deb"
    tracing::warn!({ foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"r#type","?deb"
    tracing::warn!(r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"r#type","?deb"
    tracing::warn!(foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"r#type","?deb"
    tracing::warn!(r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"r#type","?deb"
    tracing::warn!(foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"r#type","?deb"
    tracing::warn!({ r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"r#type","?deb"
    tracing::warn!({ foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"r#type","?deb"
    tracing::warn!({ r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"r#type","?deb"
    tracing::warn!({ foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"r#type","?deb"
    tracing::warn!(r#type = %disp); // DEBUG:warn,-,-,-,-,"r#type","%disp"
    tracing::warn!(foo = true, r#type = %disp); // DEBUG:warn,-,-,p,-,"r#type","%disp"
    tracing::warn!(r#type = %disp, qux = 3); // DEBUG:warn,-,-,f,-,"r#type","%disp"
    tracing::warn!(foo = true, r#type = %disp, qux = 3); // DEBUG:warn,-,-,pf,-,"r#type","%disp"
    tracing::warn!(r#type = %disp, "msg without args"); // DEBUG:warn,-,-,-,m,"r#type","%disp"
    tracing::warn!(foo = true, r#type = %disp, "msg without args"); // DEBUG:warn,-,-,p,m,"r#type","%disp"
    tracing::warn!(r#type = %disp, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"r#type","%disp"
    tracing::warn!(foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"r#type","%disp"
    tracing::warn!({ r#type = %disp }, "msg without args"); // DEBUG:warn,-,{},-,m,"r#type","%disp"
    tracing::warn!({ foo = true, r#type = %disp }, "msg without args"); // DEBUG:warn,-,{},p,m,"r#type","%disp"
    tracing::warn!({ r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"r#type","%disp"
    tracing::warn!({ foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"r#type","%disp"
    tracing::warn!(r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"r#type","%disp"
    tracing::warn!(foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"r#type","%disp"
    tracing::warn!(r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"r#type","%disp"
    tracing::warn!(foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"r#type","%disp"
    tracing::warn!({ r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"r#type","%disp"
    tracing::warn!({ foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"r#type","%disp"
    tracing::warn!({ r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"r#type","%disp"
    tracing::warn!({ foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"r#type","%disp"
    tracing::warn!(r#type = ?sub.field); // DEBUG:warn,-,-,-,-,"r#type","?sub.field"
    tracing::warn!(foo = true, r#type = ?sub.field); // DEBUG:warn,-,-,p,-,"r#type","?sub.field"
    tracing::warn!(r#type = ?sub.field, qux = 3); // DEBUG:warn,-,-,f,-,"r#type","?sub.field"
    tracing::warn!(foo = true, r#type = ?sub.field, qux = 3); // DEBUG:warn,-,-,pf,-,"r#type","?sub.field"
    tracing::warn!(r#type = ?sub.field, "msg without args"); // DEBUG:warn,-,-,-,m,"r#type","?sub.field"
    tracing::warn!(foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:warn,-,-,p,m,"r#type","?sub.field"
    tracing::warn!(r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"r#type","?sub.field"
    tracing::warn!(foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"r#type","?sub.field"
    tracing::warn!({ r#type = ?sub.field }, "msg without args"); // DEBUG:warn,-,{},-,m,"r#type","?sub.field"
    tracing::warn!({ foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:warn,-,{},p,m,"r#type","?sub.field"
    tracing::warn!({ r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"r#type","?sub.field"
    tracing::warn!({ foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"r#type","?sub.field"
    tracing::warn!(r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"r#type","?sub.field"
    tracing::warn!(foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"r#type","?sub.field"
    tracing::warn!(r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"r#type","?sub.field"
    tracing::warn!(foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"r#type","?sub.field"
    tracing::warn!({ r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"r#type","?sub.field"
    tracing::warn!({ foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"r#type","?sub.field"
    tracing::warn!({ r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"r#type","?sub.field"
    tracing::warn!({ foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"r#type","?sub.field"
    tracing::warn!(r#type = %sub.field); // DEBUG:warn,-,-,-,-,"r#type","%sub.field"
    tracing::warn!(foo = true, r#type = %sub.field); // DEBUG:warn,-,-,p,-,"r#type","%sub.field"
    tracing::warn!(r#type = %sub.field, qux = 3); // DEBUG:warn,-,-,f,-,"r#type","%sub.field"
    tracing::warn!(foo = true, r#type = %sub.field, qux = 3); // DEBUG:warn,-,-,pf,-,"r#type","%sub.field"
    tracing::warn!(r#type = %sub.field, "msg without args"); // DEBUG:warn,-,-,-,m,"r#type","%sub.field"
    tracing::warn!(foo = true, r#type = %sub.field, "msg without args"); // DEBUG:warn,-,-,p,m,"r#type","%sub.field"
    tracing::warn!(r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"r#type","%sub.field"
    tracing::warn!(foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"r#type","%sub.field"
    tracing::warn!({ r#type = %sub.field }, "msg without args"); // DEBUG:warn,-,{},-,m,"r#type","%sub.field"
    tracing::warn!({ foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:warn,-,{},p,m,"r#type","%sub.field"
    tracing::warn!({ r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"r#type","%sub.field"
    tracing::warn!({ foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"r#type","%sub.field"
    tracing::warn!(r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"r#type","%sub.field"
    tracing::warn!(foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"r#type","%sub.field"
    tracing::warn!(r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"r#type","%sub.field"
    tracing::warn!(foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"r#type","%sub.field"
    tracing::warn!({ r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"r#type","%sub.field"
    tracing::warn!({ foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"r#type","%sub.field"
    tracing::warn!({ r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"r#type","%sub.field"
    tracing::warn!({ foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"r#type","%sub.field"
    tracing::warn!(r#type = debug(&deb)); // DEBUG:warn,-,-,-,-,"r#type","debug(&deb)"
    tracing::warn!(foo = true, r#type = debug(&deb)); // DEBUG:warn,-,-,p,-,"r#type","debug(&deb)"
    tracing::warn!(r#type = debug(&deb), qux = 3); // DEBUG:warn,-,-,f,-,"r#type","debug(&deb)"
    tracing::warn!(foo = true, r#type = debug(&deb), qux = 3); // DEBUG:warn,-,-,pf,-,"r#type","debug(&deb)"
    tracing::warn!(r#type = debug(&deb), "msg without args"); // DEBUG:warn,-,-,-,m,"r#type","debug(&deb)"
    tracing::warn!(foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:warn,-,-,p,m,"r#type","debug(&deb)"
    tracing::warn!(r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"r#type","debug(&deb)"
    tracing::warn!(foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"r#type","debug(&deb)"
    tracing::warn!({ r#type = debug(&deb) }, "msg without args"); // DEBUG:warn,-,{},-,m,"r#type","debug(&deb)"
    tracing::warn!({ foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:warn,-,{},p,m,"r#type","debug(&deb)"
    tracing::warn!({ r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"r#type","debug(&deb)"
    tracing::warn!({ foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"r#type","debug(&deb)"
    tracing::warn!(r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"r#type","debug(&deb)"
    tracing::warn!(foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"r#type","debug(&deb)"
    tracing::warn!(r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"r#type","debug(&deb)"
    tracing::warn!(foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"r#type","debug(&deb)"
    tracing::warn!({ r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"r#type","debug(&deb)"
    tracing::warn!({ foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"r#type","debug(&deb)"
    tracing::warn!({ r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"r#type","debug(&deb)"
    tracing::warn!({ foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"r#type","debug(&deb)"
    tracing::warn!(r#type = display(&disp)); // DEBUG:warn,-,-,-,-,"r#type","display(&disp)"
    tracing::warn!(foo = true, r#type = display(&disp)); // DEBUG:warn,-,-,p,-,"r#type","display(&disp)"
    tracing::warn!(r#type = display(&disp), qux = 3); // DEBUG:warn,-,-,f,-,"r#type","display(&disp)"
    tracing::warn!(foo = true, r#type = display(&disp), qux = 3); // DEBUG:warn,-,-,pf,-,"r#type","display(&disp)"
    tracing::warn!(r#type = display(&disp), "msg without args"); // DEBUG:warn,-,-,-,m,"r#type","display(&disp)"
    tracing::warn!(foo = true, r#type = display(&disp), "msg without args"); // DEBUG:warn,-,-,p,m,"r#type","display(&disp)"
    tracing::warn!(r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"r#type","display(&disp)"
    tracing::warn!(foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"r#type","display(&disp)"
    tracing::warn!({ r#type = display(&disp) }, "msg without args"); // DEBUG:warn,-,{},-,m,"r#type","display(&disp)"
    tracing::warn!({ foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:warn,-,{},p,m,"r#type","display(&disp)"
    tracing::warn!({ r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"r#type","display(&disp)"
    tracing::warn!({ foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"r#type","display(&disp)"
    tracing::warn!(r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"r#type","display(&disp)"
    tracing::warn!(foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"r#type","display(&disp)"
    tracing::warn!(r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"r#type","display(&disp)"
    tracing::warn!(foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"r#type","display(&disp)"
    tracing::warn!({ r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"r#type","display(&disp)"
    tracing::warn!({ foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"r#type","display(&disp)"
    tracing::warn!({ r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"r#type","display(&disp)"
    tracing::warn!({ foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"r#type","display(&disp)"
    tracing::warn!(r#type = tracing::field::Empty); // DEBUG:warn,-,-,-,-,"r#type","tracing::field::Empty"
    tracing::warn!(foo = true, r#type = tracing::field::Empty); // DEBUG:warn,-,-,p,-,"r#type","tracing::field::Empty"
    tracing::warn!(r#type = tracing::field::Empty, qux = 3); // DEBUG:warn,-,-,f,-,"r#type","tracing::field::Empty"
    tracing::warn!(foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:warn,-,-,pf,-,"r#type","tracing::field::Empty"
    tracing::warn!(r#type = tracing::field::Empty, "msg without args"); // DEBUG:warn,-,-,-,m,"r#type","tracing::field::Empty"
    tracing::warn!(foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:warn,-,-,p,m,"r#type","tracing::field::Empty"
    tracing::warn!(r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,"r#type","tracing::field::Empty"
    tracing::warn!(foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,"r#type","tracing::field::Empty"
    tracing::warn!({ r#type = tracing::field::Empty }, "msg without args"); // DEBUG:warn,-,{},-,m,"r#type","tracing::field::Empty"
    tracing::warn!({ foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:warn,-,{},p,m,"r#type","tracing::field::Empty"
    tracing::warn!({ r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,"r#type","tracing::field::Empty"
    tracing::warn!({ foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,"r#type","tracing::field::Empty"
    tracing::warn!(r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,"r#type","tracing::field::Empty"
    tracing::warn!(foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,"r#type","tracing::field::Empty"
    tracing::warn!(r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,"r#type","tracing::field::Empty"
    tracing::warn!(foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::warn!({ r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,"r#type","tracing::field::Empty"
    tracing::warn!({ foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,"r#type","tracing::field::Empty"
    tracing::warn!({ r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,"r#type","tracing::field::Empty"
    tracing::warn!({ foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::warn!(var); // DEBUG:warn,-,-,-,-,-,"var"
    tracing::warn!(foo = true, var); // DEBUG:warn,-,-,p,-,-,"var"
    tracing::warn!(var, qux = 3); // DEBUG:warn,-,-,f,-,-,"var"
    tracing::warn!(foo = true, var, qux = 3); // DEBUG:warn,-,-,pf,-,-,"var"
    tracing::warn!(var, "msg without args"); // DEBUG:warn,-,-,-,m,-,"var"
    tracing::warn!(foo = true, var, "msg without args"); // DEBUG:warn,-,-,p,m,-,"var"
    tracing::warn!(var, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,-,"var"
    tracing::warn!(foo = true, var, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,-,"var"
    tracing::warn!({ var }, "msg without args"); // DEBUG:warn,-,{},-,m,-,"var"
    tracing::warn!({ foo = true, var }, "msg without args"); // DEBUG:warn,-,{},p,m,-,"var"
    tracing::warn!({ var, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,-,"var"
    tracing::warn!({ foo = true, var, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,-,"var"
    tracing::warn!(var, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,-,"var"
    tracing::warn!(foo = true, var, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,-,"var"
    tracing::warn!(var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,-,"var"
    tracing::warn!(foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,-,"var"
    tracing::warn!({ var }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,-,"var"
    tracing::warn!({ foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,-,"var"
    tracing::warn!({ var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,-,"var"
    tracing::warn!({ foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,-,"var"
    tracing::warn!(sub.field); // DEBUG:warn,-,-,-,-,-,"sub.field"
    tracing::warn!(foo = true, sub.field); // DEBUG:warn,-,-,p,-,-,"sub.field"
    tracing::warn!(sub.field, qux = 3); // DEBUG:warn,-,-,f,-,-,"sub.field"
    tracing::warn!(foo = true, sub.field, qux = 3); // DEBUG:warn,-,-,pf,-,-,"sub.field"
    tracing::warn!(sub.field, "msg without args"); // DEBUG:warn,-,-,-,m,-,"sub.field"
    tracing::warn!(foo = true, sub.field, "msg without args"); // DEBUG:warn,-,-,p,m,-,"sub.field"
    tracing::warn!(sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,-,"sub.field"
    tracing::warn!(foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,-,"sub.field"
    tracing::warn!({ sub.field }, "msg without args"); // DEBUG:warn,-,{},-,m,-,"sub.field"
    tracing::warn!({ foo = true, sub.field }, "msg without args"); // DEBUG:warn,-,{},p,m,-,"sub.field"
    tracing::warn!({ sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,-,"sub.field"
    tracing::warn!({ foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,-,"sub.field"
    tracing::warn!(sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,-,"sub.field"
    tracing::warn!(foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,-,"sub.field"
    tracing::warn!(sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,-,"sub.field"
    tracing::warn!(foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,-,"sub.field"
    tracing::warn!({ sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,-,"sub.field"
    tracing::warn!({ foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,-,"sub.field"
    tracing::warn!({ sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,-,"sub.field"
    tracing::warn!({ foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,-,"sub.field"
    tracing::warn!(%disp); // DEBUG:warn,-,-,-,-,-,"%disp"
    tracing::warn!(foo = true, %disp); // DEBUG:warn,-,-,p,-,-,"%disp"
    tracing::warn!(%disp, qux = 3); // DEBUG:warn,-,-,f,-,-,"%disp"
    tracing::warn!(foo = true, %disp, qux = 3); // DEBUG:warn,-,-,pf,-,-,"%disp"
    tracing::warn!(%disp, "msg without args"); // DEBUG:warn,-,-,-,m,-,"%disp"
    tracing::warn!(foo = true, %disp, "msg without args"); // DEBUG:warn,-,-,p,m,-,"%disp"
    tracing::warn!(%disp, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,-,"%disp"
    tracing::warn!(foo = true, %disp, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,-,"%disp"
    tracing::warn!({ %disp }, "msg without args"); // DEBUG:warn,-,{},-,m,-,"%disp"
    tracing::warn!({ foo = true, %disp }, "msg without args"); // DEBUG:warn,-,{},p,m,-,"%disp"
    tracing::warn!({ %disp, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,-,"%disp"
    tracing::warn!({ foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,-,"%disp"
    tracing::warn!(%disp, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,-,"%disp"
    tracing::warn!(foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,-,"%disp"
    tracing::warn!(%disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,-,"%disp"
    tracing::warn!(foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,-,"%disp"
    tracing::warn!({ %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,-,"%disp"
    tracing::warn!({ foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,-,"%disp"
    tracing::warn!({ %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,-,"%disp"
    tracing::warn!({ foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,-,"%disp"
    tracing::warn!(?deb); // DEBUG:warn,-,-,-,-,-,"?deb"
    tracing::warn!(foo = true, ?deb); // DEBUG:warn,-,-,p,-,-,"?deb"
    tracing::warn!(?deb, qux = 3); // DEBUG:warn,-,-,f,-,-,"?deb"
    tracing::warn!(foo = true, ?deb, qux = 3); // DEBUG:warn,-,-,pf,-,-,"?deb"
    tracing::warn!(?deb, "msg without args"); // DEBUG:warn,-,-,-,m,-,"?deb"
    tracing::warn!(foo = true, ?deb, "msg without args"); // DEBUG:warn,-,-,p,m,-,"?deb"
    tracing::warn!(?deb, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,-,"?deb"
    tracing::warn!(foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,-,"?deb"
    tracing::warn!({ ?deb }, "msg without args"); // DEBUG:warn,-,{},-,m,-,"?deb"
    tracing::warn!({ foo = true, ?deb }, "msg without args"); // DEBUG:warn,-,{},p,m,-,"?deb"
    tracing::warn!({ ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,-,"?deb"
    tracing::warn!({ foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,-,"?deb"
    tracing::warn!(?deb, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,-,"?deb"
    tracing::warn!(foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,-,"?deb"
    tracing::warn!(?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,-,"?deb"
    tracing::warn!(foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,-,"?deb"
    tracing::warn!({ ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,-,"?deb"
    tracing::warn!({ foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,-,"?deb"
    tracing::warn!({ ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,-,"?deb"
    tracing::warn!({ foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,-,"?deb"
    tracing::warn!(%sub.field); // DEBUG:warn,-,-,-,-,-,"%sub.field"
    tracing::warn!(foo = true, %sub.field); // DEBUG:warn,-,-,p,-,-,"%sub.field"
    tracing::warn!(%sub.field, qux = 3); // DEBUG:warn,-,-,f,-,-,"%sub.field"
    tracing::warn!(foo = true, %sub.field, qux = 3); // DEBUG:warn,-,-,pf,-,-,"%sub.field"
    tracing::warn!(%sub.field, "msg without args"); // DEBUG:warn,-,-,-,m,-,"%sub.field"
    tracing::warn!(foo = true, %sub.field, "msg without args"); // DEBUG:warn,-,-,p,m,-,"%sub.field"
    tracing::warn!(%sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,-,"%sub.field"
    tracing::warn!(foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,-,"%sub.field"
    tracing::warn!({ %sub.field }, "msg without args"); // DEBUG:warn,-,{},-,m,-,"%sub.field"
    tracing::warn!({ foo = true, %sub.field }, "msg without args"); // DEBUG:warn,-,{},p,m,-,"%sub.field"
    tracing::warn!({ %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,-,"%sub.field"
    tracing::warn!({ foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,-,"%sub.field"
    tracing::warn!(%sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,-,"%sub.field"
    tracing::warn!(foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,-,"%sub.field"
    tracing::warn!(%sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,-,"%sub.field"
    tracing::warn!(foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,-,"%sub.field"
    tracing::warn!({ %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,-,"%sub.field"
    tracing::warn!({ foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,-,"%sub.field"
    tracing::warn!({ %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,-,"%sub.field"
    tracing::warn!({ foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,-,"%sub.field"
    tracing::warn!(?sub.field); // DEBUG:warn,-,-,-,-,-,"?sub.field"
    tracing::warn!(foo = true, ?sub.field); // DEBUG:warn,-,-,p,-,-,"?sub.field"
    tracing::warn!(?sub.field, qux = 3); // DEBUG:warn,-,-,f,-,-,"?sub.field"
    tracing::warn!(foo = true, ?sub.field, qux = 3); // DEBUG:warn,-,-,pf,-,-,"?sub.field"
    tracing::warn!(?sub.field, "msg without args"); // DEBUG:warn,-,-,-,m,-,"?sub.field"
    tracing::warn!(foo = true, ?sub.field, "msg without args"); // DEBUG:warn,-,-,p,m,-,"?sub.field"
    tracing::warn!(?sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,f,m,-,"?sub.field"
    tracing::warn!(foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:warn,-,-,pf,m,-,"?sub.field"
    tracing::warn!({ ?sub.field }, "msg without args"); // DEBUG:warn,-,{},-,m,-,"?sub.field"
    tracing::warn!({ foo = true, ?sub.field }, "msg without args"); // DEBUG:warn,-,{},p,m,-,"?sub.field"
    tracing::warn!({ ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},f,m,-,"?sub.field"
    tracing::warn!({ foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:warn,-,{},pf,m,-,"?sub.field"
    tracing::warn!(?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,-,ma,-,"?sub.field"
    tracing::warn!(foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,p,ma,-,"?sub.field"
    tracing::warn!(?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,f,ma,-,"?sub.field"
    tracing::warn!(foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:warn,-,-,pf,ma,-,"?sub.field"
    tracing::warn!({ ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},-,ma,-,"?sub.field"
    tracing::warn!({ foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},p,ma,-,"?sub.field"
    tracing::warn!({ ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},f,ma,-,"?sub.field"
    tracing::warn!({ foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:warn,-,{},pf,ma,-,"?sub.field"
}
