/**
* Created on Apr 17, 2007
* Created by Alan Snyder
* Copyright (C) Azureus Software, Inc, All Rights Reserved.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
*/

package com.biglybt.core.networkmanager.admin;


public interface NetworkAdminSpeedTesterListener
{

    /**
     * When a test completes.
     * @param tester - test ran
     * @param result - String with the result
     */
    public void complete(NetworkAdminSpeedTester tester, NetworkAdminSpeedTesterResult result);

    /**
     * Informs listener when the test is at a new stage.
     * @param tester - test running.
     * @param step - String with stage.
     */
    public void stage(NetworkAdminSpeedTester tester, String step);

}
