MODULE CSC_TABLE
    USE ISO_C_BINDING
    IMPLICIT NONE

    INTEGER, PARAMETER :: CSC_TABLE_INTEGER = 0
    INTEGER, PARAMETER :: CSC_TABLE_FLOAT   = 1
    INTEGER, PARAMETER :: CSC_TABLE_STRING  = 2

    INTEGER, PARAMETER :: CSC_TABLE_CENTER = 0
    INTEGER, PARAMETER :: CSC_TABLE_LEFT   = 1
    INTEGER, PARAMETER :: CSC_TABLE_RIGHT  = 2


    INTERFACE
        FUNCTION CSC_TABLE_NEW_C( CONTINOUS_PRINT ) BIND(C,name="csc_table_new")
            IMPORT
            INTEGER(KIND=C_INT), VALUE, INTENT(IN) :: CONTINOUS_PRINT
            TYPE(C_PTR) ::  CSC_TABLE_NEW_C
        END FUNCTION CSC_TABLE_NEW_C

        FUNCTION CSC_TABLE_NEW_FROM_TABLE( TAB ) BIND(C,name="csc_table_new_from_table")
            IMPORT
            TYPE(C_PTR), VALUE ::  TAB
            TYPE(C_PTR) ::  CSC_TABLE_NEW_FROM_TABLE
        END FUNCTION CSC_TABLE_NEW_FROM_TABLE

        SUBROUTINE CSC_TABLE_DESTROY( TAB) BIND(C,name="csc_table_destroy")
            IMPORT
            TYPE(C_PTR), VALUE, INTENT(IN) :: TAB
        END SUBROUTINE CSC_TABLE_DESTROY

        SUBROUTINE CSC_TABLE_CLEAR( TAB ) BIND(C,name="csc_table_clear")
            IMPORT
            TYPE(C_PTR), VALUE, INTENT(IN) :: TAB
        END SUBROUTINE CSC_TABLE_CLEAR

        SUBROUTINE CSC_TABLE_PRINT_C(TAB, COLSEP) BIND(C,name="csc_table_print_fortran")
            IMPORT
            TYPE(C_PTR),VALUE     :: TAB
            CHARACTER(KIND=C_CHAR) :: COLSEP
        END SUBROUTINE CSC_TABLE_PRINT_C

        FUNCTION CSC_TABLE_SAVE_ASCII_C(FILENAME, TAB, COLSEP) BIND(C,name="csc_table_save_ascii")
            IMPORT
            TYPE(C_PTR),VALUE     :: TAB
            CHARACTER(KIND=C_CHAR) :: FILENAME, COLSEP
            INTEGER(KIND = C_INT ) :: CSC_TABLE_SAVE_ASCII_C
        END FUNCTION CSC_TABLE_SAVE_ASCII_C

        FUNCTION CSC_TABLE_SAVE_LATEX_C(FILENAME, TAB, STANDALONE) BIND(C,name="csc_table_save_latex")
            IMPORT
            INTEGER(KIND=C_INT), VALUE :: STANDALONE
            TYPE(C_PTR),VALUE     :: TAB
            CHARACTER(KIND=C_CHAR) :: FILENAME
            INTEGER(KIND = C_INT ) :: CSC_TABLE_SAVE_LATEX_C
        END FUNCTION CSC_TABLE_SAVE_LATEX_C

        FUNCTION CSC_TABLE_ADD_COLUMN_C( TAB, CNAME, CTYPE, CALIGN) BIND(C, name="csc_table_add_column")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
            CHARACTER(KIND=C_CHAR) :: CNAME
            INTEGER(KIND = C_INT), VALUE :: CTYPE, CALIGN
            INTEGER(KIND = C_INT) :: CSC_TABLE_ADD_COLUMN_C
        END FUNCTION CSC_TABLE_ADD_COLUMN_C

        FUNCTION CSC_TABLE_NEW_ROW_C(TAB) BIND(C, name = "csc_table_new_row")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
            INTEGER(KIND = C_INT) :: CSC_TABLE_NEW_ROW_C
        END FUNCTION CSC_TABLE_NEW_ROW_C

        SUBROUTINE CSC_TABLE_SET_ENTRY_INTEGER_C(TAB, COL, VAL) BIND(C, name = "csc_table_set_entry_integer")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
            INTEGER(KIND = C_INT), VALUE :: COL, VAL
        END SUBROUTINE

        SUBROUTINE CSC_TABLE_SET_ENTRY_FLOAT_C( TAB, COL, VAL) BIND(C, name = "csc_table_set_entry_float")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
            INTEGER(KIND = C_INT), VALUE ::  COL
            REAL(KIND = C_DOUBLE), VALUE :: VAL
        END SUBROUTINE CSC_TABLE_SET_ENTRY_FLOAT_C

        SUBROUTINE CSC_TABLE_SET_ENTRY_STRING_C(TAB, COL, STRING) BIND(C, name = "csc_table_set_entry_string")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
            INTEGER(KIND = C_INT), VALUE  :: COL
            CHARACTER(KIND = C_CHAR) :: STRING
        END SUBROUTINE CSC_TABLE_SET_ENTRY_STRING_C

        FUNCTION CSC_TABLE_COLUMN_SET_FORMAT_C(TAB, COL, FRM) BIND(C, name = "csc_table_column_set_format")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
            INTEGER(KIND = C_INT), VALUE :: COL
            CHARACTER(KIND=C_CHAR) :: FRM
            INTEGER(KIND = C_INT) :: CSC_TABLE_COLUMN_SET_FORMAT_C
        END FUNCTION CSC_TABLE_COLUMN_SET_FORMAT_C

        FUNCTION CSC_TABLE_APPEND_ROW_C(TAB1, TAB2, ROW) BIND(C, name = "csc_table_append_row")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB1, TAB2
            INTEGER(KIND = C_INT), VALUE :: ROW
            INTEGER(KIND = C_INT) :: CSC_TABLE_APPEND_ROW_C
        END FUNCTION CSC_TABLE_APPEND_ROW_C

        FUNCTION CSC_TABLE_COMMENT_SIGN_C(TAB, CS) BIND(C, name = "csc_table_comment_sign")
            IMPORT
            TYPE(C_PTR),VALUE :: TAB
            CHARACTER(KIND = C_CHAR) :: CS
            INTEGER(KIND = C_INT) :: CSC_TABLE_COMMENT_SIGN_C
        END FUNCTION CSC_TABLE_COMMENT_SIGN_C

        FUNCTION CSC_TABLE_COMMENT_TEXT_C(TAB, CS) BIND(C, name = "csc_table_comment_text")
            IMPORT
            TYPE(C_PTR),VALUE :: TAB
            CHARACTER(KIND = C_CHAR) :: CS
            INTEGER(KIND = C_INT) :: CSC_TABLE_COMMENT_TEXT_C
        END FUNCTION CSC_TABLE_COMMENT_TEXT_C

        SUBROUTINE CSC_TABLE_COMMENT_DATE(TAB) BIND(C, name = "csc_table_comment_date")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
        END SUBROUTINE CSC_TABLE_COMMENT_DATE

        SUBROUTINE CSC_TABLE_COMMENT_SYSINFO(TAB) BIND(C, name = "csc_table_comment_sysinfo")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
        END SUBROUTINE CSC_TABLE_COMMENT_SYSINFO

        SUBROUTINE CSC_TABLE_COMMENT_CMAKE(TAB) BIND(C, name = "csc_table_comment_cmake")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
        END SUBROUTINE CSC_TABLE_COMMENT_CMAKE

        SUBROUTINE CSC_TABLE_COMMENT_OPENMP_INFO(TAB) BIND(C, name = "csc_table_comment_openmp_info")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
        END SUBROUTINE CSC_TABLE_COMMENT_OPENMP_INFO

        SUBROUTINE CSC_TABLE_COMMENT_COMPILERFLAGS(TAB) BIND(C, name = "csc_table_comment_compilerflags")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
        END SUBROUTINE CSC_TABLE_COMMENT_COMPILERFLAGS

        SUBROUTINE CSC_TABLE_COMMENT_ALLINFO(TAB) BIND(C, name = "csc_table_comment_allinfo")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
        END SUBROUTINE CSC_TABLE_COMMENT_ALLINFO


        FUNCTION CSC_TABLE_MAX_ROW_C(TAB, COL) BIND(C, name = "csc_table_max_row")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
            INTEGER(KIND = C_INT),VALUE :: COL
            INTEGER(KIND = C_INT) :: CSC_TABLE_MAX_ROW_C
        END FUNCTION CSC_TABLE_MAX_ROW_C

        FUNCTION CSC_TABLE_MIN_ROW_C(TAB, COL) BIND(C, name = "csc_table_min_row")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
            INTEGER(KIND = C_INT),VALUE :: COL
            INTEGER(KIND = C_INT) :: CSC_TABLE_MIN_ROW_C
        END FUNCTION CSC_TABLE_MIN_ROW_C

        FUNCTION CSC_TABLE_MIN_ROW_THRES_C(TAB, COL, TH) BIND(C, name = "csc_table_min_row_thres")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
            INTEGER(KIND = C_INT),VALUE :: COL
            REAL(KIND = C_DOUBLE),VALUE :: TH
            INTEGER(KIND = C_INT) :: CSC_TABLE_MIN_ROW_THRES_C
        END FUNCTION CSC_TABLE_MIN_ROW_THRES_C

        FUNCTION CSC_TABLE_COLUMN_MINWIDTH_C(TAB, COL, WIDTH) BIND(C, name = "csc_table_column_minwidth")
            IMPORT
            TYPE(C_PTR), VALUE :: TAB
            INTEGER(KIND = C_INT),VALUE :: COL
            INTEGER(KIND = C_INT),VALUE :: WIDTH
            INTEGER(KIND = C_INT) :: CSC_TABLE_COLUMN_MINWIDTH_C
        END FUNCTION CSC_TABLE_COLUMN_MINWIDTH_C

    END INTERFACE

CONTAINS

    FUNCTION CSC_TABLE_NEW( CONTINOUS_PRINT )
        INTEGER, INTENT(IN) :: CONTINOUS_PRINT
        TYPE(C_PTR) ::  CSC_TABLE_NEW

        INTEGER(KIND=C_INT) :: CP
        TYPE(C_PTR) :: RET

        CP = INT(CONTINOUS_PRINT, KIND=C_INT)
        RET = CSC_TABLE_NEW_C(CP)
        CSC_TABLE_NEW = RET
    END FUNCTION CSC_TABLE_NEW


    SUBROUTINE CSC_TABLE_PRINT(TAB, COLSEP)
        TYPE(C_PTR), INTENT(IN)      :: TAB
        CHARACTER(LEN=*), INTENT(IN) :: COLSEP


        CALL CSC_TABLE_PRINT_C(TAB, COLSEP // C_NULL_CHAR)
        RETURN
    END SUBROUTINE CSC_TABLE_PRINT

    SUBROUTINE CSC_TABLE_SAVE_ASCII(FILENAME, TAB, COLSEP)
        TYPE(C_PTR), INTENT(IN)      :: TAB
        CHARACTER(LEN=*), INTENT(IN) :: FILENAME, COLSEP
        INTEGER(KIND=C_INT) :: RET


        RET = CSC_TABLE_SAVE_ASCII_C(TRIM(FILENAME) // C_NULL_CHAR, TAB, COLSEP // C_NULL_CHAR)
        RETURN
    END SUBROUTINE CSC_TABLE_SAVE_ASCII

    SUBROUTINE CSC_TABLE_SAVE_LATEX(FILENAME, TAB, STANDALONE)
        TYPE(C_PTR), INTENT(IN)      :: TAB
        CHARACTER(LEN=*), INTENT(IN) :: FILENAME
        INTEGER :: STANDALONE
        INTEGER(KIND=C_INT) :: RET
        INTEGER(KIND=C_INT) :: PASS_STANDALONE


        PASS_STANDALONE = INT(STANDALONE, KIND = C_INT)
        RET = CSC_TABLE_SAVE_LATEX_C(TRIM(FILENAME) // C_NULL_CHAR, TAB, PASS_STANDALONE )
        RETURN
    END SUBROUTINE CSC_TABLE_SAVE_LATEX

    INTEGER FUNCTION CSC_TABLE_ADD_COLUMN( TAB, CNAME, CTYPE, CALIGN)
        TYPE(C_PTR) :: TAB
        CHARACTER(LEN=*) :: CNAME
        INTEGER :: CTYPE, CALIGN

        INTEGER(KIND = C_INT) :: PTYPE, PALIGN, RET

        PTYPE  = INT ( CTYPE,  KIND = C_INT)
        PALIGN = INT ( CALIGN, KIND = C_INT)

        RET = CSC_TABLE_ADD_COLUMN_C(TAB, CNAME // C_NULL_CHAR, PTYPE, PALIGN)

        CSC_TABLE_ADD_COLUMN = INT(RET, KIND = C_INT)

        RETURN
    END FUNCTION CSC_TABLE_ADD_COLUMN

    SUBROUTINE CSC_TABLE_NEW_ROW(TAB)
        TYPE(C_PTR) :: TAB
        INTEGER(KIND = C_INT) :: RET

        RET = CSC_TABLE_NEW_ROW_C(TAB)

        IF ( RET .NE. 0 ) THEN
            WRITE(*,*) "Failed to add row to table"
        END IF

        RETURN
    END SUBROUTINE CSC_TABLE_NEW_ROW

    SUBROUTINE CSC_TABLE_SET_ENTRY_INTEGER(TAB, COL, VAL)
        TYPE(C_PTR) :: TAB
        INTEGER :: COL, VAL
        INTEGER(KIND = C_INT) :: CCOL, CVAL

        CCOL = INT( COL, KIND = C_INT)
        CVAL = INT( VAL, KIND = C_INT)
        CALL CSC_TABLE_SET_ENTRY_INTEGER_C(TAB, CCOL, CVAL)
        RETURN
    END SUBROUTINE

    SUBROUTINE CSC_TABLE_SET_ENTRY_FLOAT( TAB, COL, VAL)
        TYPE(C_PTR) :: TAB
        INTEGER ::  COL
        DOUBLE PRECISION :: VAL
        INTEGER(KIND = C_INT) :: CCOL

        CCOL = INT(COL, KIND = C_INT)
        CALL CSC_TABLE_SET_ENTRY_FLOAT_C(TAB, CCOL, VAL)
    END SUBROUTINE CSC_TABLE_SET_ENTRY_FLOAT

    SUBROUTINE CSC_TABLE_SET_ENTRY_STRING(TAB, COL, STRING)
        TYPE(C_PTR) :: TAB
        INTEGER :: COL
        INTEGER(KIND = C_INT) :: CCOL
        CHARACTER(LEN=*) :: STRING

        CCOL = INT(COL, KIND = C_INT)
        CALL CSC_TABLE_SET_ENTRY_STRING_C(TAB, CCOL, STRING // C_NULL_CHAR)
    END SUBROUTINE CSC_TABLE_SET_ENTRY_STRING

    SUBROUTINE CSC_TABLE_COLUMN_SET_FORMAT(TAB, COL, FRM)
        TYPE(C_PTR) :: TAB
        INTEGER :: COL
        CHARACTER(LEN = *) :: FRM
        INTEGER(KIND = C_INT) :: CCOL, RET


        CCOL = INT(COL, KIND = C_INT)
        RET = CSC_TABLE_COLUMN_SET_FORMAT_C(TAB, CCOL, FRM // C_NULL_CHAR)
        IF ( RET .NE. 0 ) THEN
            WRITE(*,*) "Failed to set column format"
        END IF

        RETURN
    END SUBROUTINE CSC_TABLE_COLUMN_SET_FORMAT

    SUBROUTINE CSC_TABLE_APPEND_ROW(TAB1, TAB2, ROW)
        TYPE(C_PTR) :: TAB1, TAB2
        INTEGER :: ROW
        INTEGER(KIND = C_INT) :: CROW
        INTEGER(KIND = C_INT) :: RET

        CROW = INT(ROW, KIND = C_INT)
        RET = CSC_TABLE_APPEND_ROW_C(TAB1, TAB2, CROW)
        IF ( RET .NE. 0 ) THEN
            WRITE(*,*) "Failed to append row from a second table"
        END IF

        RETURN
    END SUBROUTINE CSC_TABLE_APPEND_ROW

    SUBROUTINE CSC_TABLE_COMMENT_SIGN( TAB, CS)
        TYPE(C_PTR) :: TAB
        CHARACTER(LEN=*):: CS
        INTEGER(KIND = C_INT) :: RET

        RET = CSC_TABLE_COMMENT_SIGN_C( TAB, CS // C_NULL_CHAR )
        IF ( RET .NE. 0 ) THEN
            WRITE(*,*) "Failed to append row from a second table"
        END IF

        RETURN
    END SUBROUTINE CSC_TABLE_COMMENT_SIGN

    SUBROUTINE CSC_TABLE_COMMENT_TEXT( TAB, CS)
        TYPE(C_PTR) :: TAB
        CHARACTER(LEN=*):: CS
        INTEGER(KIND = C_INT) :: RET

        RET = CSC_TABLE_COMMENT_TEXT_C( TAB, CS // C_NULL_CHAR )
        IF ( RET .NE. 0 ) THEN
            WRITE(*,*) "Failed to append row from a second table"
        END IF

        RETURN
    END SUBROUTINE CSC_TABLE_COMMENT_TEXT

    SUBROUTINE CSC_TABLE_COMMENT_CMD(TAB)
        TYPE(C_PTR) :: TAB
        CHARACTER(LEN=32768) :: CMD

        CALL GET_COMMAND(CMD)
        CALL CSC_TABLE_COMMENT_TEXT(TAB, "Command line: " // TRIM(CMD))


    END SUBROUTINE CSC_TABLE_COMMENT_CMD

    FUNCTION CSC_TABLE_MAX_ROW(TAB, COL)
        TYPE(C_PTR) :: TAB
        INTEGER :: COL
        INTEGER :: CSC_TABLE_MAX_ROW
        INTEGER(KIND = C_INT) :: RET, COLI

        COLI = INT(COL, KIND=C_INT)
        RET = CSC_TABLE_MAX_ROW_C(TAB, COLI)
        CSC_TABLE_MAX_ROW = INT(RET)
        RETURN
    END FUNCTION

    FUNCTION CSC_TABLE_MIN_ROW(TAB, COL)
        TYPE(C_PTR) :: TAB
        INTEGER :: COL
        INTEGER :: CSC_TABLE_MIN_ROW
        INTEGER(KIND = C_INT) :: RET, COLI

        COLI = INT(COL, KIND=C_INT)
        RET = CSC_TABLE_MIN_ROW_C(TAB, COLI)
        CSC_TABLE_MIN_ROW = INT(RET)
        RETURN
    END FUNCTION

    FUNCTION CSC_TABLE_MIN_ROW_THRES(TAB, COL, TH)
        TYPE(C_PTR) :: TAB
        INTEGER :: COL
        INTEGER :: CSC_TABLE_MIN_ROW_THRES
        DOUBLE PRECISION :: TH
        INTEGER(KIND = C_INT) :: RET, COLI

        COLI = INT(COL, KIND=C_INT)
        RET = CSC_TABLE_MIN_ROW_THRES_C(TAB, COLI, TH)
        CSC_TABLE_MIN_ROW_THRES = INT(RET)
        RETURN
    END FUNCTION

    SUBROUTINE CSC_TABLE_COLUMN_MINWIDTH( TAB, COL, WIDTH)
        TYPE(C_PTR) :: TAB
        INTEGER :: COL
        INTEGER :: WIDTH
        INTEGER(KIND = C_INT) :: COLI, WIDTHI, RET

        COLI = INT(COL, KIND=C_INT)
        WIDTHI = INT( WIDTH, KIND=C_INT)

        RET = CSC_TABLE_COLUMN_MINWIDTH_C(TAB, COLI, WIDTHI)
        RETURN
    END SUBROUTINE CSC_TABLE_COLUMN_MINWIDTH

END MODULE CSC_TABLE
