/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    int major = 0;
    int minor = 0;
    int revision = 0;

    public Version(String versionString) {
        Pattern pattern = Pattern.compile("((?:\\d)+)\\.((?:\\d)+)\\.((?:\\d)+)");
        Matcher m = pattern.matcher(versionString);
        if (!m.matches()) {
            throw new IllegalArgumentException("Not a valid version number");
        }
        this.major = Integer.parseInt(m.group(1));
        this.minor = Integer.parseInt(m.group(2));
        this.revision = Integer.parseInt(m.group(3));
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int major) {
        this.minor = major;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int minor) {
        this.revision = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int version) {
        this.major = version;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.revision;
    }

    @Override
    public int compareTo(Version other) {
        int otherVersion;
        int thisVersion = this.getMajor() * 10000 + this.getMinor() * 100 + this.getRevision();
        if (thisVersion > (otherVersion = other.getMajor() * 10000 + other.getMinor() * 100 + other.getRevision())) {
            return 1;
        }
        if (thisVersion < otherVersion) {
            return -1;
        }
        return 0;
    }
}

