/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.hampelratte.svdrp.parsers.ChannelLineParser;
import org.hampelratte.svdrp.responses.highlevel.Channel;
import org.hampelratte.svdrp.responses.highlevel.DVBChannel;

public class DVBChannelLineParser
extends ChannelLineParser {
    private DVBChannel channel;

    @Override
    public Channel parse(String chanConfLine) {
        this.channel = new DVBChannel();
        String line = chanConfLine;
        this.channel.setChannelNumber(Integer.parseInt(line.substring(0, line.indexOf(32))));
        line = line.substring(line.indexOf(32) + 1);
        StringTokenizer st = new StringTokenizer(line, ":");
        this.channel.setName(st.nextToken().replace("|", ":"));
        this.channel.setFrequency(Integer.parseInt(st.nextToken()));
        this.parseParameters(st.nextToken());
        this.channel.setSource(st.nextToken());
        this.channel.setSymbolRate(Integer.parseInt(st.nextToken()));
        this.channel.setVPID(st.nextToken());
        this.channel.setAPID(st.nextToken());
        this.channel.setTPID(st.nextToken());
        this.channel.setConditionalAccess(this.parseConditionalAccess(st.nextToken()));
        this.channel.setSID(Integer.parseInt(st.nextToken()));
        this.channel.setNID(Integer.parseInt(st.nextToken()));
        this.channel.setTID(Integer.parseInt(st.nextToken()));
        this.channel.setRID(Integer.parseInt(st.nextToken()));
        return this.channel;
    }

    protected List<Integer> parseConditionalAccess(String ca) {
        ArrayList<Integer> caList = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(ca, ",");
        while (st.hasMoreElements()) {
            caList.add(Integer.parseInt(st.nextToken(), 16));
        }
        return caList;
    }

    protected void parseParameters(String string) {
        block14: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case 'B': {
                    this.channel.setBandwidth(DVBChannelLineParser.parseNumberParam(string, i));
                    continue block14;
                }
                case 'C': {
                    this.channel.setCodeRateHP(DVBChannelLineParser.parseNumberParam(string, i));
                    continue block14;
                }
                case 'D': {
                    this.channel.setCodeRateLP(DVBChannelLineParser.parseNumberParam(string, i));
                    continue block14;
                }
                case 'G': {
                    this.channel.setGuardInterval(DVBChannelLineParser.parseNumberParam(string, i));
                    continue block14;
                }
                case 'H': 
                case 'h': {
                    this.channel.setHorizontalPolarization(true);
                    continue block14;
                }
                case 'I': {
                    this.channel.setInversion(DVBChannelLineParser.parseNumberParam(string, i));
                    continue block14;
                }
                case 'L': {
                    this.channel.setLeftCircularPolarization(true);
                    continue block14;
                }
                case 'M': {
                    this.channel.setModulation(DVBChannelLineParser.parseNumberParam(string, i));
                    continue block14;
                }
                case 'R': {
                    this.channel.setRightCircularPolarization(true);
                    continue block14;
                }
                case 'T': {
                    this.channel.setTransmissionMode(DVBChannelLineParser.parseNumberParam(string, i));
                    continue block14;
                }
                case 'V': 
                case 'v': {
                    this.channel.setVerticalPolarization(true);
                    continue block14;
                }
                case 'Y': {
                    this.channel.setHierarchy(DVBChannelLineParser.parseNumberParam(string, i));
                    continue block14;
                }
            }
        }
    }
}

