# Oxc AST Visit

Visitor pattern implementations for traversing and mutating AST nodes.

## Overview

This crate provides visitor traits and implementations for systematically traversing AST nodes. It supports both immutable visitation (`Visit`) and mutable transformation (`VisitMut`).

## Key Features

- **`Visit` trait**: Immutable AST traversal for analysis
- **`VisitMut` trait**: Mutable AST traversal for transformations
- **Generated implementations**: Most visitor code is auto-generated for consistency
- **UTF-8 to UTF-16 conversion**: Special visitors for span conversion

## Architecture

The visitor pattern is designed for:

- **Analysis**: Static analysis, linting, and code inspection
- **Transformation**: Code modification and transpilation
- **Consistency**: Systematic traversal of all AST nodes
- **Performance**: Efficient traversal with minimal overhead

Most visitor implementations are generated by `oxc_ast_tools` to ensure all AST nodes are covered and traversal is consistent.
