// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package fisiface provides an interface to enable mocking the AWS Fault Injection Simulator service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package fisiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/fis"
)

// FISAPI provides an interface to enable mocking the
// fis.FIS service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Fault Injection Simulator.
//	func myFunc(svc fisiface.FISAPI) bool {
//	    // Make svc.CreateExperimentTemplate request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := fis.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockFISClient struct {
//	    fisiface.FISAPI
//	}
//	func (m *mockFISClient) CreateExperimentTemplate(input *fis.CreateExperimentTemplateInput) (*fis.CreateExperimentTemplateOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockFISClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type FISAPI interface {
	CreateExperimentTemplate(*fis.CreateExperimentTemplateInput) (*fis.CreateExperimentTemplateOutput, error)
	CreateExperimentTemplateWithContext(aws.Context, *fis.CreateExperimentTemplateInput, ...request.Option) (*fis.CreateExperimentTemplateOutput, error)
	CreateExperimentTemplateRequest(*fis.CreateExperimentTemplateInput) (*request.Request, *fis.CreateExperimentTemplateOutput)

	DeleteExperimentTemplate(*fis.DeleteExperimentTemplateInput) (*fis.DeleteExperimentTemplateOutput, error)
	DeleteExperimentTemplateWithContext(aws.Context, *fis.DeleteExperimentTemplateInput, ...request.Option) (*fis.DeleteExperimentTemplateOutput, error)
	DeleteExperimentTemplateRequest(*fis.DeleteExperimentTemplateInput) (*request.Request, *fis.DeleteExperimentTemplateOutput)

	GetAction(*fis.GetActionInput) (*fis.GetActionOutput, error)
	GetActionWithContext(aws.Context, *fis.GetActionInput, ...request.Option) (*fis.GetActionOutput, error)
	GetActionRequest(*fis.GetActionInput) (*request.Request, *fis.GetActionOutput)

	GetExperiment(*fis.GetExperimentInput) (*fis.GetExperimentOutput, error)
	GetExperimentWithContext(aws.Context, *fis.GetExperimentInput, ...request.Option) (*fis.GetExperimentOutput, error)
	GetExperimentRequest(*fis.GetExperimentInput) (*request.Request, *fis.GetExperimentOutput)

	GetExperimentTemplate(*fis.GetExperimentTemplateInput) (*fis.GetExperimentTemplateOutput, error)
	GetExperimentTemplateWithContext(aws.Context, *fis.GetExperimentTemplateInput, ...request.Option) (*fis.GetExperimentTemplateOutput, error)
	GetExperimentTemplateRequest(*fis.GetExperimentTemplateInput) (*request.Request, *fis.GetExperimentTemplateOutput)

	GetTargetResourceType(*fis.GetTargetResourceTypeInput) (*fis.GetTargetResourceTypeOutput, error)
	GetTargetResourceTypeWithContext(aws.Context, *fis.GetTargetResourceTypeInput, ...request.Option) (*fis.GetTargetResourceTypeOutput, error)
	GetTargetResourceTypeRequest(*fis.GetTargetResourceTypeInput) (*request.Request, *fis.GetTargetResourceTypeOutput)

	ListActions(*fis.ListActionsInput) (*fis.ListActionsOutput, error)
	ListActionsWithContext(aws.Context, *fis.ListActionsInput, ...request.Option) (*fis.ListActionsOutput, error)
	ListActionsRequest(*fis.ListActionsInput) (*request.Request, *fis.ListActionsOutput)

	ListActionsPages(*fis.ListActionsInput, func(*fis.ListActionsOutput, bool) bool) error
	ListActionsPagesWithContext(aws.Context, *fis.ListActionsInput, func(*fis.ListActionsOutput, bool) bool, ...request.Option) error

	ListExperimentTemplates(*fis.ListExperimentTemplatesInput) (*fis.ListExperimentTemplatesOutput, error)
	ListExperimentTemplatesWithContext(aws.Context, *fis.ListExperimentTemplatesInput, ...request.Option) (*fis.ListExperimentTemplatesOutput, error)
	ListExperimentTemplatesRequest(*fis.ListExperimentTemplatesInput) (*request.Request, *fis.ListExperimentTemplatesOutput)

	ListExperimentTemplatesPages(*fis.ListExperimentTemplatesInput, func(*fis.ListExperimentTemplatesOutput, bool) bool) error
	ListExperimentTemplatesPagesWithContext(aws.Context, *fis.ListExperimentTemplatesInput, func(*fis.ListExperimentTemplatesOutput, bool) bool, ...request.Option) error

	ListExperiments(*fis.ListExperimentsInput) (*fis.ListExperimentsOutput, error)
	ListExperimentsWithContext(aws.Context, *fis.ListExperimentsInput, ...request.Option) (*fis.ListExperimentsOutput, error)
	ListExperimentsRequest(*fis.ListExperimentsInput) (*request.Request, *fis.ListExperimentsOutput)

	ListExperimentsPages(*fis.ListExperimentsInput, func(*fis.ListExperimentsOutput, bool) bool) error
	ListExperimentsPagesWithContext(aws.Context, *fis.ListExperimentsInput, func(*fis.ListExperimentsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*fis.ListTagsForResourceInput) (*fis.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *fis.ListTagsForResourceInput, ...request.Option) (*fis.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*fis.ListTagsForResourceInput) (*request.Request, *fis.ListTagsForResourceOutput)

	ListTargetResourceTypes(*fis.ListTargetResourceTypesInput) (*fis.ListTargetResourceTypesOutput, error)
	ListTargetResourceTypesWithContext(aws.Context, *fis.ListTargetResourceTypesInput, ...request.Option) (*fis.ListTargetResourceTypesOutput, error)
	ListTargetResourceTypesRequest(*fis.ListTargetResourceTypesInput) (*request.Request, *fis.ListTargetResourceTypesOutput)

	ListTargetResourceTypesPages(*fis.ListTargetResourceTypesInput, func(*fis.ListTargetResourceTypesOutput, bool) bool) error
	ListTargetResourceTypesPagesWithContext(aws.Context, *fis.ListTargetResourceTypesInput, func(*fis.ListTargetResourceTypesOutput, bool) bool, ...request.Option) error

	StartExperiment(*fis.StartExperimentInput) (*fis.StartExperimentOutput, error)
	StartExperimentWithContext(aws.Context, *fis.StartExperimentInput, ...request.Option) (*fis.StartExperimentOutput, error)
	StartExperimentRequest(*fis.StartExperimentInput) (*request.Request, *fis.StartExperimentOutput)

	StopExperiment(*fis.StopExperimentInput) (*fis.StopExperimentOutput, error)
	StopExperimentWithContext(aws.Context, *fis.StopExperimentInput, ...request.Option) (*fis.StopExperimentOutput, error)
	StopExperimentRequest(*fis.StopExperimentInput) (*request.Request, *fis.StopExperimentOutput)

	TagResource(*fis.TagResourceInput) (*fis.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *fis.TagResourceInput, ...request.Option) (*fis.TagResourceOutput, error)
	TagResourceRequest(*fis.TagResourceInput) (*request.Request, *fis.TagResourceOutput)

	UntagResource(*fis.UntagResourceInput) (*fis.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *fis.UntagResourceInput, ...request.Option) (*fis.UntagResourceOutput, error)
	UntagResourceRequest(*fis.UntagResourceInput) (*request.Request, *fis.UntagResourceOutput)

	UpdateExperimentTemplate(*fis.UpdateExperimentTemplateInput) (*fis.UpdateExperimentTemplateOutput, error)
	UpdateExperimentTemplateWithContext(aws.Context, *fis.UpdateExperimentTemplateInput, ...request.Option) (*fis.UpdateExperimentTemplateOutput, error)
	UpdateExperimentTemplateRequest(*fis.UpdateExperimentTemplateInput) (*request.Request, *fis.UpdateExperimentTemplateOutput)
}

var _ FISAPI = (*fis.FIS)(nil)
