// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LogService20210330LogEntry LogEntry represents a single log entry that is stored in the Log System.
//
// swagger:model log_service_20210330LogEntry
type LogService20210330LogEntry struct {

	// control_plane_event includes details about an action that happened on the
	// HCP control-plane.
	ControlPlaneEvent *LogService20210330ControlPlaneEvent `json:"control_plane_event,omitempty"`

	// id is the unique identifier of this log entry.
	ID string `json:"id,omitempty"`

	// resource identifies the resource related to the log entry if one exists.
	Resource *LocationLink `json:"resource,omitempty"`

	// service_log_event includes details about an action that happened on the
	// HCP data-plane.
	ServiceLogEvent *LogService20210330ServiceLogEvent `json:"service_log_event,omitempty"`

	// stream identifies the log stream this log entry is part of.
	Stream *LogService20210330LogStream `json:"stream,omitempty"`

	// Subject will replace resource and identifies the resources/users/organizations/etc
	// associated with the log entry
	Subject *LogService20210330Subject `json:"subject,omitempty"`

	// timestamp is the time this log entry was stored.
	// Format: date-time
	Timestamp strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this log service 20210330 log entry
func (m *LogService20210330LogEntry) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControlPlaneEvent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServiceLogEvent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStream(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubject(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330LogEntry) validateControlPlaneEvent(formats strfmt.Registry) error {
	if swag.IsZero(m.ControlPlaneEvent) { // not required
		return nil
	}

	if m.ControlPlaneEvent != nil {
		if err := m.ControlPlaneEvent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("control_plane_event")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("control_plane_event")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330LogEntry) validateResource(formats strfmt.Registry) error {
	if swag.IsZero(m.Resource) { // not required
		return nil
	}

	if m.Resource != nil {
		if err := m.Resource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330LogEntry) validateServiceLogEvent(formats strfmt.Registry) error {
	if swag.IsZero(m.ServiceLogEvent) { // not required
		return nil
	}

	if m.ServiceLogEvent != nil {
		if err := m.ServiceLogEvent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_log_event")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("service_log_event")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330LogEntry) validateStream(formats strfmt.Registry) error {
	if swag.IsZero(m.Stream) { // not required
		return nil
	}

	if m.Stream != nil {
		if err := m.Stream.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stream")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stream")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330LogEntry) validateSubject(formats strfmt.Registry) error {
	if swag.IsZero(m.Subject) { // not required
		return nil
	}

	if m.Subject != nil {
		if err := m.Subject.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subject")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("subject")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330LogEntry) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this log service 20210330 log entry based on the context it is used
func (m *LogService20210330LogEntry) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateControlPlaneEvent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServiceLogEvent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStream(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubject(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330LogEntry) contextValidateControlPlaneEvent(ctx context.Context, formats strfmt.Registry) error {

	if m.ControlPlaneEvent != nil {

		if swag.IsZero(m.ControlPlaneEvent) { // not required
			return nil
		}

		if err := m.ControlPlaneEvent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("control_plane_event")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("control_plane_event")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330LogEntry) contextValidateResource(ctx context.Context, formats strfmt.Registry) error {

	if m.Resource != nil {

		if swag.IsZero(m.Resource) { // not required
			return nil
		}

		if err := m.Resource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330LogEntry) contextValidateServiceLogEvent(ctx context.Context, formats strfmt.Registry) error {

	if m.ServiceLogEvent != nil {

		if swag.IsZero(m.ServiceLogEvent) { // not required
			return nil
		}

		if err := m.ServiceLogEvent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_log_event")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("service_log_event")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330LogEntry) contextValidateStream(ctx context.Context, formats strfmt.Registry) error {

	if m.Stream != nil {

		if swag.IsZero(m.Stream) { // not required
			return nil
		}

		if err := m.Stream.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stream")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stream")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330LogEntry) contextValidateSubject(ctx context.Context, formats strfmt.Registry) error {

	if m.Subject != nil {

		if swag.IsZero(m.Subject) { // not required
			return nil
		}

		if err := m.Subject.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subject")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("subject")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogService20210330LogEntry) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogService20210330LogEntry) UnmarshalBinary(b []byte) error {
	var res LogService20210330LogEntry
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
