// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// CreateGcpSmSyncIntegrationReader is a Reader for the CreateGcpSmSyncIntegration structure.
type CreateGcpSmSyncIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateGcpSmSyncIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateGcpSmSyncIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateGcpSmSyncIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateGcpSmSyncIntegrationOK creates a CreateGcpSmSyncIntegrationOK with default headers values
func NewCreateGcpSmSyncIntegrationOK() *CreateGcpSmSyncIntegrationOK {
	return &CreateGcpSmSyncIntegrationOK{}
}

/*
CreateGcpSmSyncIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateGcpSmSyncIntegrationOK struct {
	Payload *models.Secrets20230613CreateSyncIntegrationResponse
}

// IsSuccess returns true when this create gcp sm sync integration o k response has a 2xx status code
func (o *CreateGcpSmSyncIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create gcp sm sync integration o k response has a 3xx status code
func (o *CreateGcpSmSyncIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create gcp sm sync integration o k response has a 4xx status code
func (o *CreateGcpSmSyncIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create gcp sm sync integration o k response has a 5xx status code
func (o *CreateGcpSmSyncIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create gcp sm sync integration o k response a status code equal to that given
func (o *CreateGcpSmSyncIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create gcp sm sync integration o k response
func (o *CreateGcpSmSyncIntegrationOK) Code() int {
	return 200
}

func (o *CreateGcpSmSyncIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gcp-sm][%d] createGcpSmSyncIntegrationOK %s", 200, payload)
}

func (o *CreateGcpSmSyncIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gcp-sm][%d] createGcpSmSyncIntegrationOK %s", 200, payload)
}

func (o *CreateGcpSmSyncIntegrationOK) GetPayload() *models.Secrets20230613CreateSyncIntegrationResponse {
	return o.Payload
}

func (o *CreateGcpSmSyncIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20230613CreateSyncIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateGcpSmSyncIntegrationDefault creates a CreateGcpSmSyncIntegrationDefault with default headers values
func NewCreateGcpSmSyncIntegrationDefault(code int) *CreateGcpSmSyncIntegrationDefault {
	return &CreateGcpSmSyncIntegrationDefault{
		_statusCode: code,
	}
}

/*
CreateGcpSmSyncIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateGcpSmSyncIntegrationDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this create gcp sm sync integration default response has a 2xx status code
func (o *CreateGcpSmSyncIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create gcp sm sync integration default response has a 3xx status code
func (o *CreateGcpSmSyncIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create gcp sm sync integration default response has a 4xx status code
func (o *CreateGcpSmSyncIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create gcp sm sync integration default response has a 5xx status code
func (o *CreateGcpSmSyncIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create gcp sm sync integration default response a status code equal to that given
func (o *CreateGcpSmSyncIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create gcp sm sync integration default response
func (o *CreateGcpSmSyncIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *CreateGcpSmSyncIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gcp-sm][%d] CreateGcpSmSyncIntegration default %s", o._statusCode, payload)
}

func (o *CreateGcpSmSyncIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gcp-sm][%d] CreateGcpSmSyncIntegration default %s", o._statusCode, payload)
}

func (o *CreateGcpSmSyncIntegrationDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *CreateGcpSmSyncIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CreateGcpSmSyncIntegrationBody create gcp sm sync integration body
swagger:model CreateGcpSmSyncIntegrationBody
*/
type CreateGcpSmSyncIntegrationBody struct {

	// gcp sm connection details
	GcpSmConnectionDetails *models.Secrets20230613GcpSmConnectionDetailsRequest `json:"gcp_sm_connection_details,omitempty"`

	// location
	Location *CreateGcpSmSyncIntegrationParamsBodyLocation `json:"location,omitempty"`

	// name
	Name string `json:"name,omitempty"`
}

// Validate validates this create gcp sm sync integration body
func (o *CreateGcpSmSyncIntegrationBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGcpSmConnectionDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateGcpSmSyncIntegrationBody) validateGcpSmConnectionDetails(formats strfmt.Registry) error {
	if swag.IsZero(o.GcpSmConnectionDetails) { // not required
		return nil
	}

	if o.GcpSmConnectionDetails != nil {
		if err := o.GcpSmConnectionDetails.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "gcp_sm_connection_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "gcp_sm_connection_details")
			}
			return err
		}
	}

	return nil
}

func (o *CreateGcpSmSyncIntegrationBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create gcp sm sync integration body based on the context it is used
func (o *CreateGcpSmSyncIntegrationBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGcpSmConnectionDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateGcpSmSyncIntegrationBody) contextValidateGcpSmConnectionDetails(ctx context.Context, formats strfmt.Registry) error {

	if o.GcpSmConnectionDetails != nil {

		if swag.IsZero(o.GcpSmConnectionDetails) { // not required
			return nil
		}

		if err := o.GcpSmConnectionDetails.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "gcp_sm_connection_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "gcp_sm_connection_details")
			}
			return err
		}
	}

	return nil
}

func (o *CreateGcpSmSyncIntegrationBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateGcpSmSyncIntegrationBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateGcpSmSyncIntegrationBody) UnmarshalBinary(b []byte) error {
	var res CreateGcpSmSyncIntegrationBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CreateGcpSmSyncIntegrationParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model CreateGcpSmSyncIntegrationParamsBodyLocation
*/
type CreateGcpSmSyncIntegrationParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this create gcp sm sync integration params body location
func (o *CreateGcpSmSyncIntegrationParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateGcpSmSyncIntegrationParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create gcp sm sync integration params body location based on the context it is used
func (o *CreateGcpSmSyncIntegrationParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateGcpSmSyncIntegrationParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateGcpSmSyncIntegrationParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateGcpSmSyncIntegrationParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res CreateGcpSmSyncIntegrationParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
