// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// GetAppDynamicSecretReader is a Reader for the GetAppDynamicSecret structure.
type GetAppDynamicSecretReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAppDynamicSecretReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAppDynamicSecretOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetAppDynamicSecretDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetAppDynamicSecretOK creates a GetAppDynamicSecretOK with default headers values
func NewGetAppDynamicSecretOK() *GetAppDynamicSecretOK {
	return &GetAppDynamicSecretOK{}
}

/*
GetAppDynamicSecretOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetAppDynamicSecretOK struct {
	Payload *models.Secrets20231128GetAppDynamicSecretResponse
}

// IsSuccess returns true when this get app dynamic secret o k response has a 2xx status code
func (o *GetAppDynamicSecretOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get app dynamic secret o k response has a 3xx status code
func (o *GetAppDynamicSecretOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get app dynamic secret o k response has a 4xx status code
func (o *GetAppDynamicSecretOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get app dynamic secret o k response has a 5xx status code
func (o *GetAppDynamicSecretOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get app dynamic secret o k response a status code equal to that given
func (o *GetAppDynamicSecretOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get app dynamic secret o k response
func (o *GetAppDynamicSecretOK) Code() int {
	return 200
}

func (o *GetAppDynamicSecretOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic/{name}][%d] getAppDynamicSecretOK %s", 200, payload)
}

func (o *GetAppDynamicSecretOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic/{name}][%d] getAppDynamicSecretOK %s", 200, payload)
}

func (o *GetAppDynamicSecretOK) GetPayload() *models.Secrets20231128GetAppDynamicSecretResponse {
	return o.Payload
}

func (o *GetAppDynamicSecretOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128GetAppDynamicSecretResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAppDynamicSecretDefault creates a GetAppDynamicSecretDefault with default headers values
func NewGetAppDynamicSecretDefault(code int) *GetAppDynamicSecretDefault {
	return &GetAppDynamicSecretDefault{
		_statusCode: code,
	}
}

/*
GetAppDynamicSecretDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetAppDynamicSecretDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this get app dynamic secret default response has a 2xx status code
func (o *GetAppDynamicSecretDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get app dynamic secret default response has a 3xx status code
func (o *GetAppDynamicSecretDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get app dynamic secret default response has a 4xx status code
func (o *GetAppDynamicSecretDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get app dynamic secret default response has a 5xx status code
func (o *GetAppDynamicSecretDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get app dynamic secret default response a status code equal to that given
func (o *GetAppDynamicSecretDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get app dynamic secret default response
func (o *GetAppDynamicSecretDefault) Code() int {
	return o._statusCode
}

func (o *GetAppDynamicSecretDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic/{name}][%d] GetAppDynamicSecret default %s", o._statusCode, payload)
}

func (o *GetAppDynamicSecretDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic/{name}][%d] GetAppDynamicSecret default %s", o._statusCode, payload)
}

func (o *GetAppDynamicSecretDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *GetAppDynamicSecretDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
