// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceUpdateAddOnDefinitionReader is a Reader for the WaypointServiceUpdateAddOnDefinition structure.
type WaypointServiceUpdateAddOnDefinitionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceUpdateAddOnDefinitionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceUpdateAddOnDefinitionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceUpdateAddOnDefinitionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceUpdateAddOnDefinitionOK creates a WaypointServiceUpdateAddOnDefinitionOK with default headers values
func NewWaypointServiceUpdateAddOnDefinitionOK() *WaypointServiceUpdateAddOnDefinitionOK {
	return &WaypointServiceUpdateAddOnDefinitionOK{}
}

/*
WaypointServiceUpdateAddOnDefinitionOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceUpdateAddOnDefinitionOK struct {
	Payload *models.HashicorpCloudWaypointUpdateAddOnDefinitionResponse
}

// IsSuccess returns true when this waypoint service update add on definition o k response has a 2xx status code
func (o *WaypointServiceUpdateAddOnDefinitionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service update add on definition o k response has a 3xx status code
func (o *WaypointServiceUpdateAddOnDefinitionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service update add on definition o k response has a 4xx status code
func (o *WaypointServiceUpdateAddOnDefinitionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service update add on definition o k response has a 5xx status code
func (o *WaypointServiceUpdateAddOnDefinitionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service update add on definition o k response a status code equal to that given
func (o *WaypointServiceUpdateAddOnDefinitionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service update add on definition o k response
func (o *WaypointServiceUpdateAddOnDefinitionOK) Code() int {
	return 200
}

func (o *WaypointServiceUpdateAddOnDefinitionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/{existing_add_on_definition.id}][%d] waypointServiceUpdateAddOnDefinitionOK %s", 200, payload)
}

func (o *WaypointServiceUpdateAddOnDefinitionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/{existing_add_on_definition.id}][%d] waypointServiceUpdateAddOnDefinitionOK %s", 200, payload)
}

func (o *WaypointServiceUpdateAddOnDefinitionOK) GetPayload() *models.HashicorpCloudWaypointUpdateAddOnDefinitionResponse {
	return o.Payload
}

func (o *WaypointServiceUpdateAddOnDefinitionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointUpdateAddOnDefinitionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceUpdateAddOnDefinitionDefault creates a WaypointServiceUpdateAddOnDefinitionDefault with default headers values
func NewWaypointServiceUpdateAddOnDefinitionDefault(code int) *WaypointServiceUpdateAddOnDefinitionDefault {
	return &WaypointServiceUpdateAddOnDefinitionDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceUpdateAddOnDefinitionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceUpdateAddOnDefinitionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service update add on definition default response has a 2xx status code
func (o *WaypointServiceUpdateAddOnDefinitionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service update add on definition default response has a 3xx status code
func (o *WaypointServiceUpdateAddOnDefinitionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service update add on definition default response has a 4xx status code
func (o *WaypointServiceUpdateAddOnDefinitionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service update add on definition default response has a 5xx status code
func (o *WaypointServiceUpdateAddOnDefinitionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service update add on definition default response a status code equal to that given
func (o *WaypointServiceUpdateAddOnDefinitionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service update add on definition default response
func (o *WaypointServiceUpdateAddOnDefinitionDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceUpdateAddOnDefinitionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/{existing_add_on_definition.id}][%d] WaypointService_UpdateAddOnDefinition default %s", o._statusCode, payload)
}

func (o *WaypointServiceUpdateAddOnDefinitionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /waypoint/2023-08-18/namespace/{namespace.id}/add-on-definition/{existing_add_on_definition.id}][%d] WaypointService_UpdateAddOnDefinition default %s", o._statusCode, payload)
}

func (o *WaypointServiceUpdateAddOnDefinitionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceUpdateAddOnDefinitionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
