// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContractFlexDetails Flex contains all information related to the flex consumption contract.
//
// swagger:model ContractFlexDetails
type ContractFlexDetails struct {

	// discounts represents all discounts under a contract.
	Discounts []*Billing20201105ContractDiscount `json:"discounts"`

	// initial_amount is the initial amount on the consumption pool in USD.
	InitialAmount string `json:"initial_amount,omitempty"`

	// recognized_balance is the official remaining balance of the flex consumption pool in USD
	// as of the last recognition event.
	RecognizedBalance string `json:"recognized_balance,omitempty"`

	// roll_in_percentage is the percentage of a remaining balance an account is allowed to rolled in to
	// this renewal consumption pool. This percentage will be set in the renewal sales order, the actual balance
	// will be calculated at the start date of this consumption pool.
	// In case of new or add-on sales order it will be empty.
	// Must be between 0 and 100.
	RollInPercentage string `json:"roll_in_percentage,omitempty"`

	// running_total is a running usage estimate since the last recognition event.
	// This number will be increased after each new running transaction and
	// zeroed after a recognition event (if recognition event covered all available running
	// transactions).
	RunningTotal string `json:"running_total,omitempty"`

	// support_level applied at the level of the flex contract.
	SupportLevel string `json:"support_level,omitempty"`

	// support_levels applied at the product level.
	SupportLevels []*ContractProductSupportLevel `json:"support_levels"`
}

// Validate validates this contract flex details
func (m *ContractFlexDetails) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDiscounts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSupportLevels(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContractFlexDetails) validateDiscounts(formats strfmt.Registry) error {
	if swag.IsZero(m.Discounts) { // not required
		return nil
	}

	for i := 0; i < len(m.Discounts); i++ {
		if swag.IsZero(m.Discounts[i]) { // not required
			continue
		}

		if m.Discounts[i] != nil {
			if err := m.Discounts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("discounts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("discounts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContractFlexDetails) validateSupportLevels(formats strfmt.Registry) error {
	if swag.IsZero(m.SupportLevels) { // not required
		return nil
	}

	for i := 0; i < len(m.SupportLevels); i++ {
		if swag.IsZero(m.SupportLevels[i]) { // not required
			continue
		}

		if m.SupportLevels[i] != nil {
			if err := m.SupportLevels[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("support_levels" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("support_levels" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this contract flex details based on the context it is used
func (m *ContractFlexDetails) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDiscounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSupportLevels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContractFlexDetails) contextValidateDiscounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Discounts); i++ {

		if m.Discounts[i] != nil {

			if swag.IsZero(m.Discounts[i]) { // not required
				return nil
			}

			if err := m.Discounts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("discounts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("discounts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContractFlexDetails) contextValidateSupportLevels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SupportLevels); i++ {

		if m.SupportLevels[i] != nil {

			if swag.IsZero(m.SupportLevels[i]) { // not required
				return nil
			}

			if err := m.SupportLevels[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("support_levels" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("support_levels" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContractFlexDetails) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContractFlexDetails) UnmarshalBinary(b []byte) error {
	var res ContractFlexDetails
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
