// Code generated by go-swagger; DO NOT EDIT.

package streaming_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// StreamingServiceListDestinationsReader is a Reader for the StreamingServiceListDestinations structure.
type StreamingServiceListDestinationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StreamingServiceListDestinationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStreamingServiceListDestinationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewStreamingServiceListDestinationsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewStreamingServiceListDestinationsOK creates a StreamingServiceListDestinationsOK with default headers values
func NewStreamingServiceListDestinationsOK() *StreamingServiceListDestinationsOK {
	return &StreamingServiceListDestinationsOK{}
}

/*
StreamingServiceListDestinationsOK describes a response with status code 200, with default header values.

A successful response.
*/
type StreamingServiceListDestinationsOK struct {
	Payload *models.LogService20210330ListDestinationsResponse
}

// IsSuccess returns true when this streaming service list destinations o k response has a 2xx status code
func (o *StreamingServiceListDestinationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this streaming service list destinations o k response has a 3xx status code
func (o *StreamingServiceListDestinationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this streaming service list destinations o k response has a 4xx status code
func (o *StreamingServiceListDestinationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this streaming service list destinations o k response has a 5xx status code
func (o *StreamingServiceListDestinationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this streaming service list destinations o k response a status code equal to that given
func (o *StreamingServiceListDestinationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the streaming service list destinations o k response
func (o *StreamingServiceListDestinationsOK) Code() int {
	return 200
}

func (o *StreamingServiceListDestinationsOK) Error() string {
	return fmt.Sprintf("[GET /logs/2021-03-30/organizations/{organization_id}/destinations][%d] streamingServiceListDestinationsOK  %+v", 200, o.Payload)
}

func (o *StreamingServiceListDestinationsOK) String() string {
	return fmt.Sprintf("[GET /logs/2021-03-30/organizations/{organization_id}/destinations][%d] streamingServiceListDestinationsOK  %+v", 200, o.Payload)
}

func (o *StreamingServiceListDestinationsOK) GetPayload() *models.LogService20210330ListDestinationsResponse {
	return o.Payload
}

func (o *StreamingServiceListDestinationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LogService20210330ListDestinationsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStreamingServiceListDestinationsDefault creates a StreamingServiceListDestinationsDefault with default headers values
func NewStreamingServiceListDestinationsDefault(code int) *StreamingServiceListDestinationsDefault {
	return &StreamingServiceListDestinationsDefault{
		_statusCode: code,
	}
}

/*
StreamingServiceListDestinationsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type StreamingServiceListDestinationsDefault struct {
	_statusCode int

	Payload *models.RuntimeError
}

// IsSuccess returns true when this streaming service list destinations default response has a 2xx status code
func (o *StreamingServiceListDestinationsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this streaming service list destinations default response has a 3xx status code
func (o *StreamingServiceListDestinationsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this streaming service list destinations default response has a 4xx status code
func (o *StreamingServiceListDestinationsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this streaming service list destinations default response has a 5xx status code
func (o *StreamingServiceListDestinationsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this streaming service list destinations default response a status code equal to that given
func (o *StreamingServiceListDestinationsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the streaming service list destinations default response
func (o *StreamingServiceListDestinationsDefault) Code() int {
	return o._statusCode
}

func (o *StreamingServiceListDestinationsDefault) Error() string {
	return fmt.Sprintf("[GET /logs/2021-03-30/organizations/{organization_id}/destinations][%d] StreamingService_ListDestinations default  %+v", o._statusCode, o.Payload)
}

func (o *StreamingServiceListDestinationsDefault) String() string {
	return fmt.Sprintf("[GET /logs/2021-03-30/organizations/{organization_id}/destinations][%d] StreamingService_ListDestinations default  %+v", o._statusCode, o.Payload)
}

func (o *StreamingServiceListDestinationsDefault) GetPayload() *models.RuntimeError {
	return o.Payload
}

func (o *StreamingServiceListDestinationsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
