// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// UpdateArchitectureReader is a Reader for the UpdateArchitecture structure.
type UpdateArchitectureReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateArchitectureReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateArchitectureOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUpdateArchitectureDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateArchitectureOK creates a UpdateArchitectureOK with default headers values
func NewUpdateArchitectureOK() *UpdateArchitectureOK {
	return &UpdateArchitectureOK{}
}

/*
UpdateArchitectureOK describes a response with status code 200, with default header values.

A successful response.
*/
type UpdateArchitectureOK struct {
	Payload *models.HashicorpCloudVagrant20220930UpdateArchitectureResponse
}

// IsSuccess returns true when this update architecture o k response has a 2xx status code
func (o *UpdateArchitectureOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update architecture o k response has a 3xx status code
func (o *UpdateArchitectureOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update architecture o k response has a 4xx status code
func (o *UpdateArchitectureOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update architecture o k response has a 5xx status code
func (o *UpdateArchitectureOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update architecture o k response a status code equal to that given
func (o *UpdateArchitectureOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update architecture o k response
func (o *UpdateArchitectureOK) Code() int {
	return 200
}

func (o *UpdateArchitectureOK) Error() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}][%d] updateArchitectureOK  %+v", 200, o.Payload)
}

func (o *UpdateArchitectureOK) String() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}][%d] updateArchitectureOK  %+v", 200, o.Payload)
}

func (o *UpdateArchitectureOK) GetPayload() *models.HashicorpCloudVagrant20220930UpdateArchitectureResponse {
	return o.Payload
}

func (o *UpdateArchitectureOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVagrant20220930UpdateArchitectureResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateArchitectureDefault creates a UpdateArchitectureDefault with default headers values
func NewUpdateArchitectureDefault(code int) *UpdateArchitectureDefault {
	return &UpdateArchitectureDefault{
		_statusCode: code,
	}
}

/*
UpdateArchitectureDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UpdateArchitectureDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this update architecture default response has a 2xx status code
func (o *UpdateArchitectureDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this update architecture default response has a 3xx status code
func (o *UpdateArchitectureDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this update architecture default response has a 4xx status code
func (o *UpdateArchitectureDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this update architecture default response has a 5xx status code
func (o *UpdateArchitectureDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this update architecture default response a status code equal to that given
func (o *UpdateArchitectureDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the update architecture default response
func (o *UpdateArchitectureDefault) Code() int {
	return o._statusCode
}

func (o *UpdateArchitectureDefault) Error() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}][%d] UpdateArchitecture default  %+v", o._statusCode, o.Payload)
}

func (o *UpdateArchitectureDefault) String() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/provider/{provider}/architecture/{architecture}][%d] UpdateArchitecture default  %+v", o._statusCode, o.Payload)
}

func (o *UpdateArchitectureDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *UpdateArchitectureDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
