// Code generated by go-swagger; DO NOT EDIT.

package data_source_registration_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-radar/preview/2023-05-01/models"
)

// GetDataSourceByIDReader is a Reader for the GetDataSourceByID structure.
type GetDataSourceByIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetDataSourceByIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetDataSourceByIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetDataSourceByIDDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetDataSourceByIDOK creates a GetDataSourceByIDOK with default headers values
func NewGetDataSourceByIDOK() *GetDataSourceByIDOK {
	return &GetDataSourceByIDOK{}
}

/*
GetDataSourceByIDOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetDataSourceByIDOK struct {
	Payload *models.VaultRadar20230501GetDataSourceByIDResponse
}

// IsSuccess returns true when this get data source by Id o k response has a 2xx status code
func (o *GetDataSourceByIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get data source by Id o k response has a 3xx status code
func (o *GetDataSourceByIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get data source by Id o k response has a 4xx status code
func (o *GetDataSourceByIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get data source by Id o k response has a 5xx status code
func (o *GetDataSourceByIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get data source by Id o k response a status code equal to that given
func (o *GetDataSourceByIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get data source by Id o k response
func (o *GetDataSourceByIDOK) Code() int {
	return 200
}

func (o *GetDataSourceByIDOK) Error() string {
	return fmt.Sprintf("[GET /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/{id}][%d] getDataSourceByIdOK  %+v", 200, o.Payload)
}

func (o *GetDataSourceByIDOK) String() string {
	return fmt.Sprintf("[GET /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/{id}][%d] getDataSourceByIdOK  %+v", 200, o.Payload)
}

func (o *GetDataSourceByIDOK) GetPayload() *models.VaultRadar20230501GetDataSourceByIDResponse {
	return o.Payload
}

func (o *GetDataSourceByIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.VaultRadar20230501GetDataSourceByIDResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetDataSourceByIDDefault creates a GetDataSourceByIDDefault with default headers values
func NewGetDataSourceByIDDefault(code int) *GetDataSourceByIDDefault {
	return &GetDataSourceByIDDefault{
		_statusCode: code,
	}
}

/*
GetDataSourceByIDDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetDataSourceByIDDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this get data source by ID default response has a 2xx status code
func (o *GetDataSourceByIDDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get data source by ID default response has a 3xx status code
func (o *GetDataSourceByIDDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get data source by ID default response has a 4xx status code
func (o *GetDataSourceByIDDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get data source by ID default response has a 5xx status code
func (o *GetDataSourceByIDDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get data source by ID default response a status code equal to that given
func (o *GetDataSourceByIDDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get data source by ID default response
func (o *GetDataSourceByIDDefault) Code() int {
	return o._statusCode
}

func (o *GetDataSourceByIDDefault) Error() string {
	return fmt.Sprintf("[GET /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/{id}][%d] GetDataSourceByID default  %+v", o._statusCode, o.Payload)
}

func (o *GetDataSourceByIDDefault) String() string {
	return fmt.Sprintf("[GET /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/{id}][%d] GetDataSourceByID default  %+v", o._statusCode, o.Payload)
}

func (o *GetDataSourceByIDDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *GetDataSourceByIDDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
