/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// WorkloadReferenceApplyConfiguration represents a declarative configuration of the WorkloadReference type for use
// with apply.
//
// WorkloadReference identifies the Workload object and PodGroup membership
// that a Pod belongs to. The scheduler uses this information to apply
// workload-aware scheduling semantics.
type WorkloadReferenceApplyConfiguration struct {
	// Name defines the name of the Workload object this Pod belongs to.
	// Workload must be in the same namespace as the Pod.
	// If it doesn't match any existing Workload, the Pod will remain unschedulable
	// until a Workload object is created and observed by the kube-scheduler.
	// It must be a DNS subdomain.
	Name *string `json:"name,omitempty"`
	// PodGroup is the name of the PodGroup within the Workload that this Pod
	// belongs to. If it doesn't match any existing PodGroup within the Workload,
	// the Pod will remain unschedulable until the Workload object is recreated
	// and observed by the kube-scheduler. It must be a DNS label.
	PodGroup *string `json:"podGroup,omitempty"`
	// PodGroupReplicaKey specifies the replica key of the PodGroup to which this
	// Pod belongs. It is used to distinguish pods belonging to different replicas
	// of the same pod group. The pod group policy is applied separately to each replica.
	// When set, it must be a DNS label.
	PodGroupReplicaKey *string `json:"podGroupReplicaKey,omitempty"`
}

// WorkloadReferenceApplyConfiguration constructs a declarative configuration of the WorkloadReference type for use with
// apply.
func WorkloadReference() *WorkloadReferenceApplyConfiguration {
	return &WorkloadReferenceApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *WorkloadReferenceApplyConfiguration) WithName(value string) *WorkloadReferenceApplyConfiguration {
	b.Name = &value
	return b
}

// WithPodGroup sets the PodGroup field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodGroup field is set to the value of the last call.
func (b *WorkloadReferenceApplyConfiguration) WithPodGroup(value string) *WorkloadReferenceApplyConfiguration {
	b.PodGroup = &value
	return b
}

// WithPodGroupReplicaKey sets the PodGroupReplicaKey field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PodGroupReplicaKey field is set to the value of the last call.
func (b *WorkloadReferenceApplyConfiguration) WithPodGroupReplicaKey(value string) *WorkloadReferenceApplyConfiguration {
	b.PodGroupReplicaKey = &value
	return b
}
