// generated by diplomat-tool
import type { BidiDirection } from "./BidiDirection"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * Bidi information for a single processed paragraph
 */


export class BidiParagraph {
    get ffiValue(): pointer;


    /**
     * Given a paragraph index `n` within the surrounding text, this sets this
     * object to the paragraph at that index. Returns nothing when out of bounds.
     *
     * This is equivalent to calling `paragraph_at()` on `BidiInfo` but doesn't
     * create a new object
     */
    setParagraphInText(n: number): boolean;

    /**
     * The primary direction of this paragraph
     *
     * See the [Rust documentation for `level_at`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Paragraph.html#method.level_at) for more information.
     */
    get direction(): BidiDirection;

    /**
     * The number of bytes in this paragraph
     *
     * See the [Rust documentation for `len`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.ParagraphInfo.html#method.len) for more information.
     */
    get size(): number;

    /**
     * The start index of this paragraph within the source text
     */
    get rangeStart(): number;

    /**
     * The end index of this paragraph within the source text
     */
    get rangeEnd(): number;

    /**
     * Reorder a line based on display order. The ranges are specified relative to the source text and must be contained
     * within this paragraph's range.
     *
     * See the [Rust documentation for `level_at`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Paragraph.html#method.level_at) for more information.
     */
    reorderLine(rangeStart: number, rangeEnd: number): string | null;

    /**
     * Get the BIDI level at a particular byte index in this paragraph.
     * This integer is conceptually a `unicode_bidi::Level`,
     * and can be further inspected using the static methods on Bidi.
     *
     * Returns 0 (equivalent to `Level::ltr()`) on error
     *
     * See the [Rust documentation for `level_at`](https://docs.rs/unicode_bidi/latest/unicode_bidi/struct.Paragraph.html#method.level_at) for more information.
     */
    levelAt(pos: number): number;
}