/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.donations;

import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.signal.core.util.Base64;
import org.signal.core.util.StringExtensionsKt;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialPresentation;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialRequest;
import org.signal.libsignal.zkgroup.receipts.ReceiptCredentialResponse;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.donations.BoostReceiptCredentialRequestJson;
import org.whispersystems.signalservice.api.donations.PayPalConfirmOneTimePaymentIntentPayload;
import org.whispersystems.signalservice.api.donations.PayPalCreateOneTimePaymentIntentPayload;
import org.whispersystems.signalservice.api.donations.PayPalCreatePaymentMethodPayload;
import org.whispersystems.signalservice.api.donations.ReceiptCredentialRequestJson;
import org.whispersystems.signalservice.api.donations.ReceiptCredentialResponseJson;
import org.whispersystems.signalservice.api.donations.RedeemArchivesReceiptRequest;
import org.whispersystems.signalservice.api.donations.RedeemDonationReceiptRequest;
import org.whispersystems.signalservice.api.donations.StripeOneTimePaymentIntentPayload;
import org.whispersystems.signalservice.api.push.exceptions.MalformedResponseException;
import org.whispersystems.signalservice.api.subscriptions.ActiveSubscription;
import org.whispersystems.signalservice.api.subscriptions.PayPalConfirmPaymentIntentResponse;
import org.whispersystems.signalservice.api.subscriptions.PayPalCreatePaymentIntentResponse;
import org.whispersystems.signalservice.api.subscriptions.PayPalCreatePaymentMethodResponse;
import org.whispersystems.signalservice.api.subscriptions.StripeClientSecret;
import org.whispersystems.signalservice.api.subscriptions.SubscriberId;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.BankMandate;
import org.whispersystems.signalservice.internal.push.DonationProcessor;
import org.whispersystems.signalservice.internal.push.SubscriptionsConfiguration;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\t2\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u0013\u001a\u00020\u0014J,\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010J,\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\t2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020 J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0010J<\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0010J<\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\t2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020 2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0010J,\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0010J\u001c\u0010/\u001a\b\u0012\u0004\u0012\u0002000\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u00101\u001a\u000202J$\u00103\u001a\b\u0012\u0004\u0012\u0002000\t2\u0006\u00104\u001a\u00020\u00102\u0006\u00101\u001a\u0002022\u0006\u00105\u001a\u000206J\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u00108\u001a\u00020\u0010J\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u0010J\u001c\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u00108\u001a\u00020\u0010J\u001c\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010=\u001a\u00020\u0010J$\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020BJ\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\u0006\u0010?\u001a\u00020@J\u0018\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100F*\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/whispersystems/signalservice/api/donations/DonationsApi;", "", "authWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "unauthWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;)V", "getDonationsConfiguration", "Lorg/whispersystems/signalservice/api/NetworkResult;", "Lorg/whispersystems/signalservice/internal/push/SubscriptionsConfiguration;", "locale", "Ljava/util/Locale;", "getBankMandate", "Lorg/whispersystems/signalservice/internal/push/BankMandate;", "bankTransferType", "", "getSubscription", "Lorg/whispersystems/signalservice/api/subscriptions/ActiveSubscription;", "subscriberId", "Lorg/whispersystems/signalservice/api/subscriptions/SubscriberId;", "putSubscription", "", "deleteSubscription", "updateSubscriptionLevel", "level", "currencyCode", "idempotencyKey", "createStripeOneTimePaymentIntent", "Lorg/whispersystems/signalservice/api/subscriptions/StripeClientSecret;", "paymentMethod", "amount", "", "createStripeSubscriptionPaymentMethod", "type", "createPayPalOneTimePaymentIntent", "Lorg/whispersystems/signalservice/api/subscriptions/PayPalCreatePaymentIntentResponse;", "returnUrl", "cancelUrl", "confirmPayPalOneTimePaymentIntent", "Lorg/whispersystems/signalservice/api/subscriptions/PayPalConfirmPaymentIntentResponse;", "currency", "payerId", "paymentId", "paymentToken", "createPayPalPaymentMethod", "Lorg/whispersystems/signalservice/api/subscriptions/PayPalCreatePaymentMethodResponse;", "submitReceiptCredentials", "Lorg/signal/libsignal/zkgroup/receipts/ReceiptCredentialResponse;", "receiptCredentialRequest", "Lorg/signal/libsignal/zkgroup/receipts/ReceiptCredentialRequest;", "submitBoostReceiptCredentials", "paymentIntentId", "processor", "Lorg/whispersystems/signalservice/internal/push/DonationProcessor;", "setDefaultStripeSubscriptionPaymentMethod", "paymentMethodId", "setDefaultIdealSubscriptionPaymentMethod", "setupIntentId", "setDefaultPaypalSubscriptionPaymentMethod", "linkPlayBillingPurchaseToken", "purchaseToken", "redeemDonationReceipt", "receiptCredentialPresentation", "Lorg/signal/libsignal/zkgroup/receipts/ReceiptCredentialPresentation;", "visible", "", "primary", "redeemArchivesReceipt", "toAcceptLanguageHeaders", "", "signal-service-java"})
public final class DonationsApi {
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;
    @NotNull
    private final SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket;

    public DonationsApi(@NotNull SignalWebSocket.AuthenticatedWebSocket authWebSocket, @NotNull SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket) {
        Intrinsics.checkNotNullParameter((Object)authWebSocket, (String)"authWebSocket");
        Intrinsics.checkNotNullParameter((Object)unauthWebSocket, (String)"unauthWebSocket");
        this.authWebSocket = authWebSocket;
        this.unauthWebSocket = unauthWebSocket;
    }

    @NotNull
    public final NetworkResult<SubscriptionsConfiguration> getDonationsConfiguration(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get(WebSocketRequestMessage.Companion, "/v1/subscription/configuration", this.toAcceptLanguageHeaders(locale));
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(SubscriptionsConfiguration.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<BankMandate> getBankMandate(@NotNull Locale locale, @NotNull String bankTransferType) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)bankTransferType, (String)"bankTransferType");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get(WebSocketRequestMessage.Companion, "/v1/subscription/bank_mandate/" + bankTransferType, this.toAcceptLanguageHeaders(locale));
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(BankMandate.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<ActiveSubscription> getSubscription(@NotNull SubscriberId subscriberId) {
        Intrinsics.checkNotNullParameter((Object)subscriberId, (String)"subscriberId");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v1/subscription/" + subscriberId.serialize(), null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(ActiveSubscription.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<Unit> putSubscription(@NotNull SubscriberId subscriberId) {
        Intrinsics.checkNotNullParameter((Object)subscriberId, (String)"subscriberId");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/subscription/" + subscriberId.serialize(), "", null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.unauthWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> deleteSubscription(@NotNull SubscriberId subscriberId) {
        Intrinsics.checkNotNullParameter((Object)subscriberId, (String)"subscriberId");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.delete$default(WebSocketRequestMessage.Companion, "/v1/subscription/" + subscriberId.serialize(), null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.unauthWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> updateSubscriptionLevel(@NotNull SubscriberId subscriberId, @NotNull String level, @NotNull String currencyCode, @NotNull String idempotencyKey) {
        Intrinsics.checkNotNullParameter((Object)subscriberId, (String)"subscriberId");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        Intrinsics.checkNotNullParameter((Object)idempotencyKey, (String)"idempotencyKey");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v1/subscription/" + subscriberId.serialize() + "/level/" + StringExtensionsKt.urlEncode((String)level) + "/" + StringExtensionsKt.urlEncode((String)currencyCode) + "/" + idempotencyKey, "", null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.unauthWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<StripeClientSecret> createStripeOneTimePaymentIntent(@NotNull String currencyCode, @NotNull String paymentMethod, long amount, long level) {
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        StripeOneTimePaymentIntentPayload body = new StripeOneTimePaymentIntentPayload(amount, currencyCode, level, paymentMethod);
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/subscription/boost/create", body, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(StripeClientSecret.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<StripeClientSecret> createStripeSubscriptionPaymentMethod(@NotNull SubscriberId subscriberId, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)subscriberId, (String)"subscriberId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/subscription/" + subscriberId.serialize() + "/create_payment_method?type=" + StringExtensionsKt.urlEncode((String)type), "", null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(StripeClientSecret.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<PayPalCreatePaymentIntentResponse> createPayPalOneTimePaymentIntent(@NotNull Locale locale, @NotNull String currencyCode, long amount, long level, @NotNull String returnUrl, @NotNull String cancelUrl) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
        Intrinsics.checkNotNullParameter((Object)cancelUrl, (String)"cancelUrl");
        PayPalCreateOneTimePaymentIntentPayload body = new PayPalCreateOneTimePaymentIntentPayload(amount, currencyCode, level, returnUrl, cancelUrl);
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post(WebSocketRequestMessage.Companion, "/v1/subscription/boost/paypal/create", body, this.toAcceptLanguageHeaders(locale));
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(PayPalCreatePaymentIntentResponse.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<PayPalConfirmPaymentIntentResponse> confirmPayPalOneTimePaymentIntent(@NotNull String currency, @NotNull String amount, long level, @NotNull String payerId, @NotNull String paymentId, @NotNull String paymentToken) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)payerId, (String)"payerId");
        Intrinsics.checkNotNullParameter((Object)paymentId, (String)"paymentId");
        Intrinsics.checkNotNullParameter((Object)paymentToken, (String)"paymentToken");
        PayPalConfirmOneTimePaymentIntentPayload body = new PayPalConfirmOneTimePaymentIntentPayload(amount, currency, level, payerId, paymentId, paymentToken);
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/subscription/boost/paypal/confirm", body, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(PayPalConfirmPaymentIntentResponse.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<PayPalCreatePaymentMethodResponse> createPayPalPaymentMethod(@NotNull Locale locale, @NotNull SubscriberId subscriberId, @NotNull String returnUrl, @NotNull String cancelUrl) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)subscriberId, (String)"subscriberId");
        Intrinsics.checkNotNullParameter((Object)returnUrl, (String)"returnUrl");
        Intrinsics.checkNotNullParameter((Object)cancelUrl, (String)"cancelUrl");
        PayPalCreatePaymentMethodPayload body = new PayPalCreatePaymentMethodPayload(returnUrl, cancelUrl);
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post(WebSocketRequestMessage.Companion, "/v1/subscription/" + subscriberId.serialize() + "/create_payment_method/paypal", body, this.toAcceptLanguageHeaders(locale));
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.unauthWebSocket, request2, Reflection.getOrCreateKotlinClass(PayPalCreatePaymentMethodResponse.class), 0L, 8, null);
    }

    @NotNull
    public final NetworkResult<ReceiptCredentialResponse> submitReceiptCredentials(@NotNull SubscriberId subscriberId, @NotNull ReceiptCredentialRequest receiptCredentialRequest) {
        Intrinsics.checkNotNullParameter((Object)subscriberId, (String)"subscriberId");
        Intrinsics.checkNotNullParameter((Object)receiptCredentialRequest, (String)"receiptCredentialRequest");
        ReceiptCredentialRequestJson body = new ReceiptCredentialRequestJson(receiptCredentialRequest);
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/subscription/" + subscriberId.serialize() + "/receipt_credentials", body, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-exY8QGI$default(NetworkResult.Companion, this.unauthWebSocket, request2, 0L, new NetworkResult.LongPollingWebSocketConverter(Reflection.getOrCreateKotlinClass(ReceiptCredentialResponseJson.class)), 4, null).map(DonationsApi::submitReceiptCredentials$lambda$0).then(DonationsApi::submitReceiptCredentials$lambda$1);
    }

    @NotNull
    public final NetworkResult<ReceiptCredentialResponse> submitBoostReceiptCredentials(@NotNull String paymentIntentId, @NotNull ReceiptCredentialRequest receiptCredentialRequest, @NotNull DonationProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)paymentIntentId, (String)"paymentIntentId");
        Intrinsics.checkNotNullParameter((Object)receiptCredentialRequest, (String)"receiptCredentialRequest");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        BoostReceiptCredentialRequestJson body = new BoostReceiptCredentialRequestJson(paymentIntentId, receiptCredentialRequest, processor);
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/subscription/boost/receipt_credentials", body, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-exY8QGI$default(NetworkResult.Companion, this.unauthWebSocket, request2, 0L, new NetworkResult.LongPollingWebSocketConverter(Reflection.getOrCreateKotlinClass(ReceiptCredentialResponseJson.class)), 4, null).map(DonationsApi::submitBoostReceiptCredentials$lambda$2).then(DonationsApi::submitBoostReceiptCredentials$lambda$3);
    }

    @NotNull
    public final NetworkResult<Unit> setDefaultStripeSubscriptionPaymentMethod(@NotNull SubscriberId subscriberId, @NotNull String paymentMethodId) {
        Intrinsics.checkNotNullParameter((Object)subscriberId, (String)"subscriberId");
        Intrinsics.checkNotNullParameter((Object)paymentMethodId, (String)"paymentMethodId");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/subscription/" + subscriberId.serialize() + "/default_payment_method/stripe/" + StringExtensionsKt.urlEncode((String)paymentMethodId), "", null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.unauthWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> setDefaultIdealSubscriptionPaymentMethod(@NotNull SubscriberId subscriberId, @NotNull String setupIntentId) {
        Intrinsics.checkNotNullParameter((Object)subscriberId, (String)"subscriberId");
        Intrinsics.checkNotNullParameter((Object)setupIntentId, (String)"setupIntentId");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/subscription/" + subscriberId.serialize() + "/default_payment_method_for_ideal/" + StringExtensionsKt.urlEncode((String)setupIntentId), "", null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.unauthWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> setDefaultPaypalSubscriptionPaymentMethod(@NotNull SubscriberId subscriberId, @NotNull String paymentMethodId) {
        Intrinsics.checkNotNullParameter((Object)subscriberId, (String)"subscriberId");
        Intrinsics.checkNotNullParameter((Object)paymentMethodId, (String)"paymentMethodId");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/subscription/" + subscriberId.serialize() + "/default_payment_method/braintree/" + StringExtensionsKt.urlEncode((String)paymentMethodId), "", null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.unauthWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> linkPlayBillingPurchaseToken(@NotNull SubscriberId subscriberId, @NotNull String purchaseToken) {
        Intrinsics.checkNotNullParameter((Object)subscriberId, (String)"subscriberId");
        Intrinsics.checkNotNullParameter((Object)purchaseToken, (String)"purchaseToken");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/subscription/" + subscriberId.serialize() + "/playbilling/" + StringExtensionsKt.urlEncode((String)purchaseToken), "", null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.unauthWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> redeemDonationReceipt(@NotNull ReceiptCredentialPresentation receiptCredentialPresentation, boolean visible, boolean primary) {
        Intrinsics.checkNotNullParameter((Object)receiptCredentialPresentation, (String)"receiptCredentialPresentation");
        byte[] byArray = receiptCredentialPresentation.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"serialize(...)");
        RedeemDonationReceiptRequest body = new RedeemDonationReceiptRequest(Base64.encodeWithPadding$default((byte[])byArray, (int)0, (int)0, (int)6, null), visible, primary);
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/donation/redeem-receipt", body, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<Unit> redeemArchivesReceipt(@NotNull ReceiptCredentialPresentation receiptCredentialPresentation) {
        Intrinsics.checkNotNullParameter((Object)receiptCredentialPresentation, (String)"receiptCredentialPresentation");
        byte[] byArray = receiptCredentialPresentation.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"serialize(...)");
        RedeemArchivesReceiptRequest body = new RedeemArchivesReceiptRequest(Base64.encodeWithPadding$default((byte[])byArray, (int)0, (int)0, (int)6, null));
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v1/archives/redeem-receipt", body, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    private final Map<String, String> toAcceptLanguageHeaders(Locale $this$toAcceptLanguageHeaders) {
        String string = $this$toAcceptLanguageHeaders.getLanguage();
        String string2 = $this$toAcceptLanguageHeaders.getCountry();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCountry(...)");
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"Accept-Language", (Object)(string + (String)(((CharSequence)string2).length() > 0 ? "-" + $this$toAcceptLanguageHeaders.getCountry() : ""))));
    }

    private static final ReceiptCredentialResponse submitReceiptCredentials$lambda$0(ReceiptCredentialResponseJson it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getReceiptCredentialResponse();
    }

    private static final NetworkResult submitReceiptCredentials$lambda$1(ReceiptCredentialResponse it) {
        return it != null ? (NetworkResult)new NetworkResult.Success<ReceiptCredentialResponse>(it) : (NetworkResult)new NetworkResult.NetworkError(new MalformedResponseException("Unable to parse response"));
    }

    private static final ReceiptCredentialResponse submitBoostReceiptCredentials$lambda$2(ReceiptCredentialResponseJson it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getReceiptCredentialResponse();
    }

    private static final NetworkResult submitBoostReceiptCredentials$lambda$3(ReceiptCredentialResponse it) {
        return it != null ? (NetworkResult)new NetworkResult.Success<ReceiptCredentialResponse>(it) : (NetworkResult)new NetworkResult.NetworkError(new MalformedResponseException("Unable to parse response"));
    }
}

