/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.keys;

import io.reactivex.rxjava3.core.Single;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.LongExtensionsKt;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.kem.KEMPublicKey;
import org.signal.libsignal.protocol.state.KyberPreKeyRecord;
import org.signal.libsignal.protocol.state.PreKeyBundle;
import org.signal.libsignal.protocol.state.PreKeyRecord;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.account.PreKeyUpload;
import org.whispersystems.signalservice.api.crypto.SealedSenderAccess;
import org.whispersystems.signalservice.api.keys.OneTimePreKeyCounts;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.push.SignedPreKeyEntity;
import org.whispersystems.signalservice.api.push.exceptions.UnregisteredUserException;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.WebSocketRequestExtKt;
import org.whispersystems.signalservice.internal.push.CheckRepeatedUsedPreKeysRequest;
import org.whispersystems.signalservice.internal.push.KyberPreKeyEntity;
import org.whispersystems.signalservice.internal.push.PreKeyEntity;
import org.whispersystems.signalservice.internal.push.PreKeyResponse;
import org.whispersystems.signalservice.internal.push.PreKeyResponseItem;
import org.whispersystems.signalservice.internal.push.PreKeyState;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;
import org.whispersystems.signalservice.internal.websocket.WebsocketResponse;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J<\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0019\u001a\u00020\u001aJ,\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\t2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0010J\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0010J.\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\t2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/whispersystems/signalservice/api/keys/KeysApi;", "", "authWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;", "unauthWebSocket", "Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;", "<init>", "(Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$AuthenticatedWebSocket;Lorg/whispersystems/signalservice/api/websocket/SignalWebSocket$UnauthenticatedWebSocket;)V", "checkRepeatedUseKeys", "Lorg/whispersystems/signalservice/api/NetworkResult;", "", "serviceIdType", "Lorg/whispersystems/signalservice/api/push/ServiceIdType;", "identityKey", "Lorg/signal/libsignal/protocol/IdentityKey;", "signedPreKeyId", "", "signedPreKey", "Lorg/signal/libsignal/protocol/ecc/ECPublicKey;", "lastResortKyberKeyId", "lastResortKyberKey", "Lorg/signal/libsignal/protocol/kem/KEMPublicKey;", "getAvailablePreKeyCounts", "Lorg/whispersystems/signalservice/api/keys/OneTimePreKeyCounts;", "setPreKeys", "preKeyUpload", "Lorg/whispersystems/signalservice/api/account/PreKeyUpload;", "getPreKeys", "", "Lorg/signal/libsignal/protocol/state/PreKeyBundle;", "destination", "Lorg/whispersystems/signalservice/api/push/SignalServiceAddress;", "sealedSenderAccess", "Lorg/whispersystems/signalservice/api/crypto/SealedSenderAccess;", "deviceId", "getPreKey", "getPreKeysBySpecifier", "deviceSpecifier", "", "Companion", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nKeysApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeysApi.kt\norg/whispersystems/signalservice/api/keys/KeysApi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 NetworkResult.kt\norg/whispersystems/signalservice/api/NetworkResult$Companion\n*L\n1#1,261:1\n1563#2:262\n1634#2,3:263\n1563#2:266\n1634#2,3:267\n71#3:270\n*S KotlinDebug\n*F\n+ 1 KeysApi.kt\norg/whispersystems/signalservice/api/keys/KeysApi\n*L\n108#1:262\n108#1:263,3\n126#1:266\n126#1:267,3\n192#1:270\n*E\n"})
public final class KeysApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SignalWebSocket.AuthenticatedWebSocket authWebSocket;
    @NotNull
    private final SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket;
    @NotNull
    private static final String TAG = Log.tag((KClass)Reflection.getOrCreateKotlinClass(KeysApi.class));

    public KeysApi(@NotNull SignalWebSocket.AuthenticatedWebSocket authWebSocket, @NotNull SignalWebSocket.UnauthenticatedWebSocket unauthWebSocket) {
        Intrinsics.checkNotNullParameter((Object)authWebSocket, (String)"authWebSocket");
        Intrinsics.checkNotNullParameter((Object)unauthWebSocket, (String)"unauthWebSocket");
        this.authWebSocket = authWebSocket;
        this.unauthWebSocket = unauthWebSocket;
    }

    @NotNull
    public final NetworkResult<Unit> checkRepeatedUseKeys(@NotNull ServiceIdType serviceIdType, @NotNull IdentityKey identityKey, int signedPreKeyId, @NotNull ECPublicKey signedPreKey, int lastResortKyberKeyId, @NotNull KEMPublicKey lastResortKyberKey) {
        MessageDigest messageDigest;
        Intrinsics.checkNotNullParameter((Object)((Object)serviceIdType), (String)"serviceIdType");
        Intrinsics.checkNotNullParameter((Object)identityKey, (String)"identityKey");
        Intrinsics.checkNotNullParameter((Object)signedPreKey, (String)"signedPreKey");
        Intrinsics.checkNotNullParameter((Object)lastResortKyberKey, (String)"lastResortKyberKey");
        MessageDigest $this$checkRepeatedUseKeys_u24lambda_u240 = messageDigest = MessageDigest.getInstance("SHA-256");
        boolean bl = false;
        $this$checkRepeatedUseKeys_u24lambda_u240.update(identityKey.serialize());
        $this$checkRepeatedUseKeys_u24lambda_u240.update(LongExtensionsKt.toByteArray((long)signedPreKeyId));
        $this$checkRepeatedUseKeys_u24lambda_u240.update(signedPreKey.serialize());
        $this$checkRepeatedUseKeys_u24lambda_u240.update(LongExtensionsKt.toByteArray((long)lastResortKyberKeyId));
        $this$checkRepeatedUseKeys_u24lambda_u240.update(lastResortKyberKey.serialize());
        MessageDigest messageDigest2 = messageDigest;
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest2, (String)"apply(...)");
        MessageDigest digest = messageDigest2;
        String string = serviceIdType.toString();
        byte[] byArray = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        CheckRepeatedUsedPreKeysRequest body = new CheckRepeatedUsedPreKeysRequest(string, byArray);
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.post$default(WebSocketRequestMessage.Companion, "/v2/keys/check", body, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<OneTimePreKeyCounts> getAvailablePreKeyCounts(@NotNull ServiceIdType serviceIdType) {
        Intrinsics.checkNotNullParameter((Object)((Object)serviceIdType), (String)"serviceIdType");
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v2/keys?identity=" + serviceIdType.queryParam(), null, 2, null);
        return NetworkResult.Companion.fromWebSocketRequest-Wn2Vu4Y$default(NetworkResult.Companion, this.authWebSocket, request2, Reflection.getOrCreateKotlinClass(OneTimePreKeyCounts.class), 0L, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NetworkResult<Unit> setPreKeys(@NotNull PreKeyUpload preKeyUpload) {
        List list;
        KyberPreKeyEntity lastResortKyberPreKey;
        List list2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        SignedPreKeyEntity signedPreKey;
        Intrinsics.checkNotNullParameter((Object)preKeyUpload, (String)"preKeyUpload");
        SignedPreKeyEntity signedPreKeyEntity = signedPreKey = preKeyUpload.getSignedPreKey() != null ? new SignedPreKeyEntity(preKeyUpload.getSignedPreKey().getId(), preKeyUpload.getSignedPreKey().getKeyPair().getPublicKey(), preKeyUpload.getSignedPreKey().getSignature()) : null;
        if (preKeyUpload.getOneTimeEcPreKeys() != null) {
            void $this$map$iv;
            Iterable iterable = preKeyUpload.getOneTimeEcPreKeys();
            boolean $i$f$map = false;
            void var6_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void oneTimeEcKey;
                PreKeyRecord preKeyRecord = (PreKeyRecord)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PreKeyEntity(oneTimeEcKey.getId(), oneTimeEcKey.getKeyPair().getPublicKey()));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        List oneTimeEcPreKeys = list2;
        KyberPreKeyEntity kyberPreKeyEntity = lastResortKyberPreKey = preKeyUpload.getLastResortKyberPreKey() != null ? new KyberPreKeyEntity(preKeyUpload.getLastResortKyberPreKey().getId(), preKeyUpload.getLastResortKyberPreKey().getKeyPair().getPublicKey(), preKeyUpload.getLastResortKyberPreKey().getSignature()) : null;
        if (preKeyUpload.getOneTimeKyberPreKeys() != null) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            $this$mapTo$iv$iv = preKeyUpload.getOneTimeKyberPreKeys();
            boolean $i$f$map = false;
            void $i$f$mapTo = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void record;
                KyberPreKeyRecord kyberPreKeyRecord = (KyberPreKeyRecord)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new KyberPreKeyEntity(record.getId(), record.getKeyPair().getPublicKey(), record.getSignature()));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List oneTimeKyberPreKeys = list;
        PreKeyState body = new PreKeyState(signedPreKey, oneTimeEcPreKeys, lastResortKyberPreKey, oneTimeKyberPreKeys);
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.put$default(WebSocketRequestMessage.Companion, "/v2/keys?identity=" + preKeyUpload.getServiceIdType().queryParam(), body, null, 4, null);
        return NetworkResult.Companion.fromWebSocketRequest-SxA4cEA$default(NetworkResult.Companion, this.authWebSocket, request2, 0L, 4, null);
    }

    @NotNull
    public final NetworkResult<List<PreKeyBundle>> getPreKeys(@NotNull SignalServiceAddress destination, @Nullable SealedSenderAccess sealedSenderAccess, int deviceId) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return this.getPreKeysBySpecifier(destination, sealedSenderAccess, deviceId == 1 ? "*" : String.valueOf(deviceId));
    }

    @NotNull
    public final NetworkResult<PreKeyBundle> getPreKey(@NotNull SignalServiceAddress destination, int deviceId) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return this.getPreKeysBySpecifier(destination, null, String.valueOf(deviceId)).then(KeysApi::getPreKey$lambda$3);
    }

    /*
     * WARNING - void declaration
     */
    private final NetworkResult<List<PreKeyBundle>> getPreKeysBySpecifier(SignalServiceAddress destination, SealedSenderAccess sealedSenderAccess, String deviceSpecifier) {
        void this_$iv;
        WebSocketRequestMessage request2 = WebSocketRequestExtKt.get$default(WebSocketRequestMessage.Companion, "/v2/keys/" + destination.getIdentifier() + "/" + deviceSpecifier, null, 2, null);
        Log.d((String)TAG, (String)("Fetching prekeys for " + destination.getIdentifier() + "." + deviceSpecifier + ", i.e. GET " + request2.path));
        NetworkResult.Companion companion = NetworkResult.Companion;
        NetworkResult.Fetcher<Single<WebsocketResponse>> fetcher$iv = () -> KeysApi.getPreKeysBySpecifier$lambda$4(sealedSenderAccess, this, request2);
        boolean $i$f$fromWebSocket = false;
        NetworkResult result2 = this_$iv.fromWebSocket(new NetworkResult.DefaultWebSocketConverter(Reflection.getOrCreateKotlinClass(PreKeyResponse.class)), fetcher$iv);
        if (result2 instanceof NetworkResult.StatusCodeError && ((NetworkResult.StatusCodeError)result2).getCode() == 404) {
            return new NetworkResult.NetworkError(new UnregisteredUserException(destination.getIdentifier(), ((NetworkResult.StatusCodeError)result2).getException()));
        }
        return result2.map(KeysApi::getPreKeysBySpecifier$lambda$5);
    }

    private static final NetworkResult getPreKey$lambda$3(List bundles) {
        Intrinsics.checkNotNullParameter((Object)bundles, (String)"bundles");
        return !((Collection)bundles).isEmpty() ? (NetworkResult)new NetworkResult.Success(bundles.get(0)) : (NetworkResult)new NetworkResult.NetworkError(new IOException("No prekeys available!"));
    }

    private static final Single getPreKeysBySpecifier$lambda$4(SealedSenderAccess $sealedSenderAccess, KeysApi this$0, WebSocketRequestMessage $request) {
        return $sealedSenderAccess != null ? this$0.unauthWebSocket.request($request, $sealedSenderAccess) : this$0.authWebSocket.request($request);
    }

    private static final List getPreKeysBySpecifier$lambda$5(PreKeyResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        List bundles = new LinkedList();
        for (PreKeyResponseItem device : response.getDevices()) {
            ECPublicKey preKey = null;
            ECPublicKey signedPreKey = null;
            byte[] signedPreKeySignature = null;
            int preKeyId = -1;
            int signedPreKeyId = -1;
            int kyberPreKeyId = -1;
            KEMPublicKey kyberPreKey = null;
            byte[] kyberPreKeySignature = null;
            if (device.getSignedPreKey() == null) {
                Log.w((String)TAG, (String)("No signed prekey for device " + device.deviceId + "! Skipping."));
                continue;
            }
            signedPreKey = device.getSignedPreKey().getPublicKey();
            signedPreKeyId = device.getSignedPreKey().getKeyId();
            signedPreKeySignature = device.getSignedPreKey().getSignature();
            if (device.getPreKey() != null) {
                preKeyId = device.getPreKey().getKeyId();
                preKey = device.getPreKey().getPublicKey();
            }
            if (device.getKyberPreKey() == null) {
                Log.w((String)TAG, (String)("No kyber prekey for device " + device.deviceId + "! Skipping."));
                continue;
            }
            kyberPreKey = device.getKyberPreKey().getPublicKey();
            kyberPreKeyId = device.getKyberPreKey().getKeyId();
            kyberPreKeySignature = device.getKyberPreKey().getSignature();
            int n = device.getRegistrationId();
            int n2 = device.getDeviceId();
            Object object = signedPreKey;
            Intrinsics.checkNotNull((Object)object);
            ECPublicKey eCPublicKey = object;
            object = signedPreKeySignature;
            Intrinsics.checkNotNull((Object)object);
            Object object2 = object;
            IdentityKey identityKey = response.getIdentityKey();
            Intrinsics.checkNotNullExpressionValue((Object)identityKey, (String)"getIdentityKey(...)");
            object = kyberPreKey;
            Intrinsics.checkNotNull((Object)object);
            Object object3 = object;
            object = kyberPreKeySignature;
            Intrinsics.checkNotNull((Object)object);
            bundles.add(new PreKeyBundle(n, n2, preKeyId, preKey, signedPreKeyId, eCPublicKey, (byte[])object2, identityKey, kyberPreKeyId, (KEMPublicKey)object3, (byte[])object));
        }
        return bundles;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/whispersystems/signalservice/api/keys/KeysApi$Companion;", "", "<init>", "()V", "TAG", "", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

