/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.svr;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.libsignal.attest.AttestationDataException;
import org.signal.libsignal.attest.AttestationFailedException;
import org.signal.libsignal.messagebackup.BackupKey;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.net.NetworkException;
import org.signal.libsignal.net.NetworkProtocolException;
import org.signal.libsignal.net.RetryLaterException;
import org.signal.libsignal.net.SvrBRestoreResponse;
import org.signal.libsignal.net.SvrBStoreResponse;
import org.signal.libsignal.sgxsession.SgxCommunicationFailureException;
import org.signal.libsignal.svr.DataMissingException;
import org.signal.libsignal.svr.InvalidSvrBDataException;
import org.signal.libsignal.svr.RestoreFailedException;
import org.whispersystems.signalservice.api.CancelationException;
import org.whispersystems.signalservice.api.backup.MessageBackupKey;
import org.whispersystems.signalservice.internal.push.AuthCredentials;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi;", "", "network", "Lorg/signal/libsignal/net/Network;", "<init>", "(Lorg/signal/libsignal/net/Network;)V", "createNewBackupChain", "", "auth", "Lorg/whispersystems/signalservice/internal/push/AuthCredentials;", "backupKey", "Lorg/whispersystems/signalservice/api/backup/MessageBackupKey;", "store", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult;", "previousSecretData", "restore", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult;", "forwardSecrecyMetadata", "StoreResult", "RestoreResult", "signal-service-java"})
public final class SvrBApi {
    @NotNull
    private final Network network;

    public SvrBApi(@NotNull Network network) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        this.network = network;
    }

    @NotNull
    public final byte[] createNewBackupChain(@NotNull AuthCredentials auth, @NotNull MessageBackupKey backupKey) {
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        return this.network.svrB(auth.username(), auth.password()).createNewBackupChain(new BackupKey(backupKey.getValue()));
    }

    @NotNull
    public final StoreResult store(@NotNull AuthCredentials auth, @NotNull MessageBackupKey backupKey, @NotNull byte[] previousSecretData) {
        StoreResult storeResult;
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)previousSecretData, (String)"previousSecretData");
        try {
            StoreResult storeResult2;
            Result result2 = (Result)this.network.svrB(auth.username(), auth.password()).store(new BackupKey(backupKey.getValue()), previousSecretData).get();
            Throwable exception = Result.exceptionOrNull-impl((Object)result2.unbox-impl());
            if (exception == null) {
                Intrinsics.checkNotNull((Object)result2);
                var6_9 = result2.unbox-impl();
                ResultKt.throwOnFailure((Object)var6_9);
                storeResult2 = new StoreResult.Success((SvrBStoreResponse)var6_9);
            } else if (exception instanceof InvalidSvrBDataException) {
                storeResult2 = StoreResult.InvalidDataError.INSTANCE;
            } else if (exception instanceof RetryLaterException) {
                IOException iOException = new IOException(exception);
                java.time.Duration duration = ((RetryLaterException)exception).duration;
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"duration");
                var6_9 = duration;
                storeResult2 = new StoreResult.NetworkError(iOException, Duration.box-impl((long)Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)((java.time.Duration)var6_9).getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)((java.time.Duration)var6_9).getNano(), (DurationUnit)DurationUnit.NANOSECONDS))), null);
            } else {
                storeResult2 = exception instanceof NetworkException ? (StoreResult)new StoreResult.NetworkError((IOException)exception, null, 2, null) : (exception instanceof NetworkProtocolException ? (StoreResult)new StoreResult.NetworkError((IOException)exception, null, 2, null) : (exception instanceof AttestationFailedException || exception instanceof AttestationDataException || exception instanceof SgxCommunicationFailureException ? (StoreResult)new StoreResult.SvrError(exception) : (StoreResult)new StoreResult.UnknownError(exception)));
            }
            storeResult = storeResult2;
        }
        catch (CancelationException e) {
            storeResult = new StoreResult.UnknownError(e);
        }
        catch (ExecutionException e) {
            storeResult = new StoreResult.UnknownError(e);
        }
        catch (InterruptedException e) {
            storeResult = new StoreResult.UnknownError(e);
        }
        return storeResult;
    }

    @NotNull
    public final RestoreResult restore(@NotNull AuthCredentials auth, @NotNull MessageBackupKey backupKey, @NotNull byte[] forwardSecrecyMetadata) {
        RestoreResult restoreResult;
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)backupKey, (String)"backupKey");
        Intrinsics.checkNotNullParameter((Object)forwardSecrecyMetadata, (String)"forwardSecrecyMetadata");
        try {
            RestoreResult restoreResult2;
            Result result2 = (Result)this.network.svrB(auth.username(), auth.password()).restore(new BackupKey(backupKey.getValue()), forwardSecrecyMetadata).get();
            Throwable exception = Result.exceptionOrNull-impl((Object)result2.unbox-impl());
            if (exception == null) {
                Intrinsics.checkNotNull((Object)result2);
                var6_9 = result2.unbox-impl();
                ResultKt.throwOnFailure((Object)var6_9);
                restoreResult2 = new RestoreResult.Success((SvrBRestoreResponse)var6_9);
            } else if (exception instanceof InvalidSvrBDataException) {
                restoreResult2 = RestoreResult.InvalidDataError.INSTANCE;
            } else if (exception instanceof RestoreFailedException) {
                restoreResult2 = new RestoreResult.RestoreFailedError(((RestoreFailedException)exception).getTriesRemaining());
            } else if (exception instanceof DataMissingException) {
                restoreResult2 = RestoreResult.DataMissingError.INSTANCE;
            } else if (exception instanceof RetryLaterException) {
                IOException iOException = new IOException(exception);
                java.time.Duration duration = ((RetryLaterException)exception).duration;
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"duration");
                var6_9 = duration;
                restoreResult2 = new RestoreResult.NetworkError(iOException, Duration.box-impl((long)Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)((java.time.Duration)var6_9).getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)((java.time.Duration)var6_9).getNano(), (DurationUnit)DurationUnit.NANOSECONDS))), null);
            } else {
                restoreResult2 = exception instanceof NetworkException ? (RestoreResult)new RestoreResult.NetworkError((IOException)exception, null, 2, null) : (exception instanceof NetworkProtocolException ? (RestoreResult)new RestoreResult.NetworkError((IOException)exception, null, 2, null) : (exception instanceof AttestationFailedException || exception instanceof AttestationDataException || exception instanceof SgxCommunicationFailureException ? (RestoreResult)new RestoreResult.SvrError(exception) : (RestoreResult)new RestoreResult.UnknownError(exception)));
            }
            restoreResult = restoreResult2;
        }
        catch (CancelationException e) {
            restoreResult = new RestoreResult.UnknownError(e);
        }
        catch (ExecutionException e) {
            restoreResult = new RestoreResult.UnknownError(e);
        }
        catch (InterruptedException e) {
            restoreResult = new RestoreResult.UnknownError(e);
        }
        return restoreResult;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0007\u0004\u0005\u0006\u0007\b\t\nB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0007\u000b\f\r\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult;", "", "<init>", "()V", "Success", "NetworkError", "DataMissingError", "InvalidDataError", "RestoreFailedError", "SvrError", "UnknownError", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$DataMissingError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$InvalidDataError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$NetworkError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$RestoreFailedError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$Success;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$SvrError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$UnknownError;", "signal-service-java"})
    public static abstract class RestoreResult {
        private RestoreResult() {
        }

        public /* synthetic */ RestoreResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$DataMissingError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class DataMissingError
        extends RestoreResult {
            @NotNull
            public static final DataMissingError INSTANCE = new DataMissingError();

            private DataMissingError() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "DataMissingError";
            }

            public int hashCode() {
                return -1515706420;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DataMissingError)) {
                    return false;
                }
                DataMissingError cfr_ignored_0 = (DataMissingError)other;
                return true;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$InvalidDataError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class InvalidDataError
        extends RestoreResult {
            @NotNull
            public static final InvalidDataError INSTANCE = new InvalidDataError();

            private InvalidDataError() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "InvalidDataError";
            }

            public int hashCode() {
                return -1155177721;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof InvalidDataError)) {
                    return false;
                }
                InvalidDataError cfr_ignored_0 = (InvalidDataError)other;
                return true;
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\b\u000eJ$\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\b\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$NetworkError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult;", "exception", "Ljava/io/IOException;", "retryAfter", "Lkotlin/time/Duration;", "<init>", "(Ljava/io/IOException;Lkotlin/time/Duration;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getException", "()Ljava/io/IOException;", "getRetryAfter-FghU774", "()Lkotlin/time/Duration;", "component1", "component2", "component2-FghU774", "copy", "copy-6Au4x4Y", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class NetworkError
        extends RestoreResult {
            @NotNull
            private final IOException exception;
            @Nullable
            private final Duration retryAfter;

            private NetworkError(IOException exception, Duration retryAfter) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                super(null);
                this.exception = exception;
                this.retryAfter = retryAfter;
            }

            public /* synthetic */ NetworkError(IOException iOException, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    duration = null;
                }
                this(iOException, duration, null);
            }

            @NotNull
            public final IOException getException() {
                return this.exception;
            }

            @Nullable
            public final Duration getRetryAfter-FghU774() {
                return this.retryAfter;
            }

            @NotNull
            public final IOException component1() {
                return this.exception;
            }

            @Nullable
            public final Duration component2-FghU774() {
                return this.retryAfter;
            }

            @NotNull
            public final NetworkError copy-6Au4x4Y(@NotNull IOException exception, @Nullable Duration retryAfter) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new NetworkError(exception, retryAfter, null);
            }

            public static /* synthetic */ NetworkError copy-6Au4x4Y$default(NetworkError networkError, IOException iOException, Duration duration, int n, Object object) {
                if ((n & 1) != 0) {
                    iOException = networkError.exception;
                }
                if ((n & 2) != 0) {
                    duration = networkError.retryAfter;
                }
                return networkError.copy-6Au4x4Y(iOException, duration);
            }

            @NotNull
            public String toString() {
                return "NetworkError(exception=" + this.exception + ", retryAfter=" + this.retryAfter + ")";
            }

            public int hashCode() {
                int result2 = this.exception.hashCode();
                result2 = result2 * 31 + (this.retryAfter == null ? 0 : Duration.hashCode-impl((long)this.retryAfter.unbox-impl()));
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NetworkError)) {
                    return false;
                }
                NetworkError networkError = (NetworkError)other;
                if (!Intrinsics.areEqual((Object)this.exception, (Object)networkError.exception)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.retryAfter, (Object)networkError.retryAfter);
            }

            public /* synthetic */ NetworkError(IOException exception, Duration retryAfter, DefaultConstructorMarker $constructor_marker) {
                this(exception, retryAfter);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$RestoreFailedError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult;", "triesRemaining", "", "<init>", "(I)V", "getTriesRemaining", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "signal-service-java"})
        public static final class RestoreFailedError
        extends RestoreResult {
            private final int triesRemaining;

            public RestoreFailedError(int triesRemaining) {
                super(null);
                this.triesRemaining = triesRemaining;
            }

            public final int getTriesRemaining() {
                return this.triesRemaining;
            }

            public final int component1() {
                return this.triesRemaining;
            }

            @NotNull
            public final RestoreFailedError copy(int triesRemaining) {
                return new RestoreFailedError(triesRemaining);
            }

            public static /* synthetic */ RestoreFailedError copy$default(RestoreFailedError restoreFailedError, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = restoreFailedError.triesRemaining;
                }
                return restoreFailedError.copy(n);
            }

            @NotNull
            public String toString() {
                return "RestoreFailedError(triesRemaining=" + this.triesRemaining + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.triesRemaining);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RestoreFailedError)) {
                    return false;
                }
                RestoreFailedError restoreFailedError = (RestoreFailedError)other;
                return this.triesRemaining == restoreFailedError.triesRemaining;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$Success;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult;", "data", "Lorg/signal/libsignal/net/SvrBRestoreResponse;", "<init>", "(Lorg/signal/libsignal/net/SvrBRestoreResponse;)V", "getData", "()Lorg/signal/libsignal/net/SvrBRestoreResponse;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class Success
        extends RestoreResult {
            @NotNull
            private final SvrBRestoreResponse data;

            public Success(@NotNull SvrBRestoreResponse data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super(null);
                this.data = data;
            }

            @NotNull
            public final SvrBRestoreResponse getData() {
                return this.data;
            }

            @NotNull
            public final SvrBRestoreResponse component1() {
                return this.data;
            }

            @NotNull
            public final Success copy(@NotNull SvrBRestoreResponse data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return new Success(data);
            }

            public static /* synthetic */ Success copy$default(Success success, SvrBRestoreResponse svrBRestoreResponse, int n, Object object) {
                if ((n & 1) != 0) {
                    svrBRestoreResponse = success.data;
                }
                return success.copy(svrBRestoreResponse);
            }

            @NotNull
            public String toString() {
                return "Success(data=" + this.data + ")";
            }

            public int hashCode() {
                return this.data.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual((Object)this.data, (Object)success.data);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$SvrError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult;", "throwable", "", "<init>", "(Ljava/lang/Throwable;)V", "getThrowable", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class SvrError
        extends RestoreResult {
            @NotNull
            private final Throwable throwable;

            public SvrError(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                super(null);
                this.throwable = throwable;
            }

            @NotNull
            public final Throwable getThrowable() {
                return this.throwable;
            }

            @NotNull
            public final Throwable component1() {
                return this.throwable;
            }

            @NotNull
            public final SvrError copy(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                return new SvrError(throwable);
            }

            public static /* synthetic */ SvrError copy$default(SvrError svrError, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    throwable = svrError.throwable;
                }
                return svrError.copy(throwable);
            }

            @NotNull
            public String toString() {
                return "SvrError(throwable=" + this.throwable + ")";
            }

            public int hashCode() {
                return this.throwable.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SvrError)) {
                    return false;
                }
                SvrError svrError = (SvrError)other;
                return Intrinsics.areEqual((Object)this.throwable, (Object)svrError.throwable);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult$UnknownError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$RestoreResult;", "throwable", "", "<init>", "(Ljava/lang/Throwable;)V", "getThrowable", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class UnknownError
        extends RestoreResult {
            @NotNull
            private final Throwable throwable;

            public UnknownError(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                super(null);
                this.throwable = throwable;
            }

            @NotNull
            public final Throwable getThrowable() {
                return this.throwable;
            }

            @NotNull
            public final Throwable component1() {
                return this.throwable;
            }

            @NotNull
            public final UnknownError copy(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                return new UnknownError(throwable);
            }

            public static /* synthetic */ UnknownError copy$default(UnknownError unknownError, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    throwable = unknownError.throwable;
                }
                return unknownError.copy(throwable);
            }

            @NotNull
            public String toString() {
                return "UnknownError(throwable=" + this.throwable + ")";
            }

            public int hashCode() {
                return this.throwable.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UnknownError)) {
                    return false;
                }
                UnknownError unknownError = (UnknownError)other;
                return Intrinsics.areEqual((Object)this.throwable, (Object)unknownError.throwable);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u0004\u0005\u0006\u0007\bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0005\t\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult;", "", "<init>", "()V", "Success", "InvalidDataError", "NetworkError", "SvrError", "UnknownError", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult$InvalidDataError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult$NetworkError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult$Success;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult$SvrError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult$UnknownError;", "signal-service-java"})
    public static abstract class StoreResult {
        private StoreResult() {
        }

        public /* synthetic */ StoreResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult$InvalidDataError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class InvalidDataError
        extends StoreResult {
            @NotNull
            public static final InvalidDataError INSTANCE = new InvalidDataError();

            private InvalidDataError() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "InvalidDataError";
            }

            public int hashCode() {
                return -1431436652;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof InvalidDataError)) {
                    return false;
                }
                InvalidDataError cfr_ignored_0 = (InvalidDataError)other;
                return true;
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\b\u000eJ$\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\b\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult$NetworkError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult;", "exception", "Ljava/io/IOException;", "retryAfter", "Lkotlin/time/Duration;", "<init>", "(Ljava/io/IOException;Lkotlin/time/Duration;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getException", "()Ljava/io/IOException;", "getRetryAfter-FghU774", "()Lkotlin/time/Duration;", "component1", "component2", "component2-FghU774", "copy", "copy-6Au4x4Y", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class NetworkError
        extends StoreResult {
            @NotNull
            private final IOException exception;
            @Nullable
            private final Duration retryAfter;

            private NetworkError(IOException exception, Duration retryAfter) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                super(null);
                this.exception = exception;
                this.retryAfter = retryAfter;
            }

            public /* synthetic */ NetworkError(IOException iOException, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    duration = null;
                }
                this(iOException, duration, null);
            }

            @NotNull
            public final IOException getException() {
                return this.exception;
            }

            @Nullable
            public final Duration getRetryAfter-FghU774() {
                return this.retryAfter;
            }

            @NotNull
            public final IOException component1() {
                return this.exception;
            }

            @Nullable
            public final Duration component2-FghU774() {
                return this.retryAfter;
            }

            @NotNull
            public final NetworkError copy-6Au4x4Y(@NotNull IOException exception, @Nullable Duration retryAfter) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                return new NetworkError(exception, retryAfter, null);
            }

            public static /* synthetic */ NetworkError copy-6Au4x4Y$default(NetworkError networkError, IOException iOException, Duration duration, int n, Object object) {
                if ((n & 1) != 0) {
                    iOException = networkError.exception;
                }
                if ((n & 2) != 0) {
                    duration = networkError.retryAfter;
                }
                return networkError.copy-6Au4x4Y(iOException, duration);
            }

            @NotNull
            public String toString() {
                return "NetworkError(exception=" + this.exception + ", retryAfter=" + this.retryAfter + ")";
            }

            public int hashCode() {
                int result2 = this.exception.hashCode();
                result2 = result2 * 31 + (this.retryAfter == null ? 0 : Duration.hashCode-impl((long)this.retryAfter.unbox-impl()));
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NetworkError)) {
                    return false;
                }
                NetworkError networkError = (NetworkError)other;
                if (!Intrinsics.areEqual((Object)this.exception, (Object)networkError.exception)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.retryAfter, (Object)networkError.retryAfter);
            }

            public /* synthetic */ NetworkError(IOException exception, Duration retryAfter, DefaultConstructorMarker $constructor_marker) {
                this(exception, retryAfter);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult$Success;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult;", "data", "Lorg/signal/libsignal/net/SvrBStoreResponse;", "<init>", "(Lorg/signal/libsignal/net/SvrBStoreResponse;)V", "getData", "()Lorg/signal/libsignal/net/SvrBStoreResponse;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class Success
        extends StoreResult {
            @NotNull
            private final SvrBStoreResponse data;

            public Success(@NotNull SvrBStoreResponse data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                super(null);
                this.data = data;
            }

            @NotNull
            public final SvrBStoreResponse getData() {
                return this.data;
            }

            @NotNull
            public final SvrBStoreResponse component1() {
                return this.data;
            }

            @NotNull
            public final Success copy(@NotNull SvrBStoreResponse data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return new Success(data);
            }

            public static /* synthetic */ Success copy$default(Success success, SvrBStoreResponse svrBStoreResponse, int n, Object object) {
                if ((n & 1) != 0) {
                    svrBStoreResponse = success.data;
                }
                return success.copy(svrBStoreResponse);
            }

            @NotNull
            public String toString() {
                return "Success(data=" + this.data + ")";
            }

            public int hashCode() {
                return this.data.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual((Object)this.data, (Object)success.data);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult$SvrError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult;", "throwable", "", "<init>", "(Ljava/lang/Throwable;)V", "getThrowable", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class SvrError
        extends StoreResult {
            @NotNull
            private final Throwable throwable;

            public SvrError(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                super(null);
                this.throwable = throwable;
            }

            @NotNull
            public final Throwable getThrowable() {
                return this.throwable;
            }

            @NotNull
            public final Throwable component1() {
                return this.throwable;
            }

            @NotNull
            public final SvrError copy(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                return new SvrError(throwable);
            }

            public static /* synthetic */ SvrError copy$default(SvrError svrError, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    throwable = svrError.throwable;
                }
                return svrError.copy(throwable);
            }

            @NotNull
            public String toString() {
                return "SvrError(throwable=" + this.throwable + ")";
            }

            public int hashCode() {
                return this.throwable.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SvrError)) {
                    return false;
                }
                SvrError svrError = (SvrError)other;
                return Intrinsics.areEqual((Object)this.throwable, (Object)svrError.throwable);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult$UnknownError;", "Lorg/whispersystems/signalservice/api/svr/SvrBApi$StoreResult;", "throwable", "", "<init>", "(Ljava/lang/Throwable;)V", "getThrowable", "()Ljava/lang/Throwable;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "signal-service-java"})
        public static final class UnknownError
        extends StoreResult {
            @NotNull
            private final Throwable throwable;

            public UnknownError(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                super(null);
                this.throwable = throwable;
            }

            @NotNull
            public final Throwable getThrowable() {
                return this.throwable;
            }

            @NotNull
            public final Throwable component1() {
                return this.throwable;
            }

            @NotNull
            public final UnknownError copy(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                return new UnknownError(throwable);
            }

            public static /* synthetic */ UnknownError copy$default(UnknownError unknownError, Throwable throwable, int n, Object object) {
                if ((n & 1) != 0) {
                    throwable = unknownError.throwable;
                }
                return unknownError.copy(throwable);
            }

            @NotNull
            public String toString() {
                return "UnknownError(throwable=" + this.throwable + ")";
            }

            public int hashCode() {
                return this.throwable.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof UnknownError)) {
                    return false;
                }
                UnknownError unknownError = (UnknownError)other;
                return Intrinsics.areEqual((Object)this.throwable, (Object)unknownError.throwable);
            }
        }
    }
}

