require File.expand_path('../../../test_helper', __FILE__)

require 'mocha/parameter_matchers/not'
require 'mocha/inspect'
require 'stub_matcher'
require 'parameter_matchers_test_helper'

class NotTest < Mocha::TestCase
  include Mocha::ParameterMatchers::Methods

  def test_should_match_if_matcher_does_not_match
    matcher = Not(Stub::Matcher.new(false))
    assert matcher.matches?(['any_old_value'])
  end

  def test_should_not_match_if_matcher_does_match
    matcher = Not(Stub::Matcher.new(true))
    assert !matcher.matches?(['any_old_value'])
  end

  def test_should_describe_matcher
    matcher = Not(Stub::Matcher.new(true))
    assert_equal 'Not(matcher(true))', matcher.mocha_inspect
  end

  include ParameterMatchersTestHelper.deprecation_tests_for_matcher_method(:Not, false)
  include ParameterMatchersTestHelper.deprecation_tests_for_matcher_class(:Not)
end
