/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPFieldString;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldArrayString
extends JBBPAbstractArrayField<JBBPFieldString> {
    private static final long serialVersionUID = -220078798710257313L;
    private final String[] array;

    public JBBPFieldArrayString(JBBPNamedFieldInfo name, String[] array) {
        super(name);
        JBBPUtils.assertNotNull(array, "Array must not be null");
        this.array = array;
    }

    public String[] getArray() {
        return (String[])this.array.clone();
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public JBBPFieldString getElementAt(int index) {
        JBBPFieldString result = new JBBPFieldString(this.fieldNameInfo, this.array[index]);
        result.payload = this.payload;
        return result;
    }

    @Override
    public Object getValueArrayAsObject(boolean reverseBits) {
        String[] result = (String[])this.array.clone();
        if (reverseBits) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = JBBPFieldString.reverseBits(result[i]);
            }
        }
        return result;
    }

    @Override
    public String getTypeAsString() {
        return "stringj [" + this.array.length + "]";
    }
}

