/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal.things;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.model.yaml.YamlElement;
import org.openhab.core.model.yaml.YamlElementName;
import org.openhab.core.model.yaml.internal.things.YamlChannelDTO;
import org.openhab.core.model.yaml.internal.util.YamlElementUtils;
import org.openhab.core.thing.ChannelUID;
import org.openhab.core.thing.ThingUID;

@YamlElementName(value="things")
public class YamlThingDTO
implements YamlElement,
Cloneable {
    public String uid;
    public Boolean isBridge;
    public String bridge;
    public String label;
    public String location;
    public Map<@NonNull String, @NonNull Object> config;
    public Map<@NonNull String, @NonNull YamlChannelDTO> channels;

    @Override
    public @NonNull String getId() {
        return this.uid == null ? "" : this.uid;
    }

    @Override
    public void setId(@NonNull String id) {
        this.uid = id;
    }

    @Override
    public YamlElement cloneWithoutId() {
        try {
            YamlThingDTO copy = (YamlThingDTO)super.clone();
            copy.uid = null;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return new YamlThingDTO();
        }
    }

    @Override
    public boolean isValid(@Nullable List<@NonNull String> errors, @Nullable List<@NonNull String> warnings) {
        ThingUID thingUID;
        if (this.uid == null || this.uid.isBlank()) {
            this.addToList(errors, "invalid thing: uid is missing while mandatory");
            return false;
        }
        boolean ok = true;
        try {
            thingUID = new ThingUID(this.uid);
        }
        catch (IllegalArgumentException e) {
            thingUID = new ThingUID("dummy:dummy:dummy");
            this.addToList(errors, "invalid thing \"%s\": %s".formatted(this.uid, e.getMessage()));
            ok = false;
        }
        if (this.bridge != null && !this.bridge.isBlank()) {
            try {
                new ThingUID(this.bridge);
            }
            catch (IllegalArgumentException e) {
                this.addToList(errors, "invalid thing \"%s\": invalid value \"%s\" for \"bridge\" field: %s".formatted(this.uid, this.bridge, e.getMessage()));
                ok = false;
            }
        }
        if (this.config != null) {
            try {
                new Configuration(this.config);
            }
            catch (IllegalArgumentException e) {
                this.addToList(errors, "invalid thing \"%s\": invalid data in \"config\" field: %s".formatted(this.uid, e.getMessage()));
                ok = false;
            }
        }
        if (this.channels != null) {
            for (Map.Entry<String, YamlChannelDTO> entry : this.channels.entrySet()) {
                String channelId = entry.getKey();
                String[] splittedChannelId = channelId.split("#", 2);
                try {
                    if (splittedChannelId.length == 1) {
                        new ChannelUID(thingUID, channelId);
                    } else {
                        new ChannelUID(thingUID, splittedChannelId[0], splittedChannelId[1]);
                    }
                }
                catch (IllegalArgumentException e) {
                    this.addToList(errors, "invalid thing \"%s\": invalid channel id \"%s\": %s".formatted(this.uid, channelId, e.getMessage()));
                    ok = false;
                }
                ArrayList<String> channelErrors = new ArrayList<String>();
                ArrayList<String> channelWarnings = new ArrayList<String>();
                ok &= entry.getValue().isValid(channelErrors, channelWarnings);
                channelErrors.forEach(error -> this.addToList(errors, "invalid thing \"%s\": channel \"%s\": %s".formatted(this.uid, channelId, error)));
                channelWarnings.forEach(warning -> this.addToList(warnings, "thing \"%s\": channel \"%s\": %s".formatted(this.uid, channelId, warning)));
            }
        }
        return ok;
    }

    private void addToList(@Nullable List<@NonNull String> list, String value) {
        if (list != null) {
            list.add(value);
        }
    }

    public boolean isBridge() {
        return this.isBridge == null ? false : this.isBridge;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.isBridge(), this.bridge, this.label, this.location);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        YamlThingDTO other = (YamlThingDTO)obj;
        return Objects.equals(this.uid, other.uid) && this.isBridge() == other.isBridge() && Objects.equals(this.bridge, other.bridge) && Objects.equals(this.label, other.label) && Objects.equals(this.location, other.location) && YamlElementUtils.equalsConfig(this.config, other.config) && this.equalsChannels(this.channels, other.channels);
    }

    private boolean equalsChannels(@Nullable Map<@NonNull String, @NonNull YamlChannelDTO> first, @Nullable Map<@NonNull String, @NonNull YamlChannelDTO> second) {
        if (first != null && second != null) {
            if (first.size() != second.size()) {
                return false;
            }
            return first.entrySet().stream().allMatch(e -> ((YamlChannelDTO)e.getValue()).equals(second.get(e.getKey())));
        }
        return first == null && second == null;
    }
}

