dnl Check for MPFR and dependencies
dnl Copyright (C) 2004, 2005, 2021 Free Software Foundation, Inc.
dnl
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.
dnl
dnl Defines HAVE_MPFR to 1 if a working MPFR/GMP setup is
dnl found, and sets @LIBMPFR@ to the necessary libraries.

AC_DEFUN([GNUPG_CHECK_MPFR],
[
  AC_ARG_WITH([mpfr],
     AS_HELP_STRING([--with-mpfr=DIR],
	[look for the mpfr and gmp libraries in DIR]),
     [_do_mpfr=$withval],[_do_mpfr=yes])

  if test "$_do_mpfr" != "no" ; then
     if test -d "$withval" ; then
        CPPFLAGS="${CPPFLAGS} -I$withval/include"
        LDFLAGS="${LDFLAGS} -L$withval/lib"
     fi

        _mpfr_save_libs=$LIBS
        _combo="-lmpfr -lgmp"
        LIBS="$LIBS $_combo"

        AC_MSG_CHECKING([whether mpfr via "$_combo" is present and usable])

        AC_LINK_IFELSE([
	AC_LANG_PROGRAM([
#include <stdio.h>
#include <mpfr.h>
#include <gmp.h>
],[
mpfr_t p;
mpz_t z;
mpfr_init(p);
mpz_init(z);
mpfr_printf("%Rf%Zd", p, z);
mpfr_clear(p);
mpz_clear(z);
])],_found_mpfr=yes,_found_mpfr=no)

        AC_MSG_RESULT([$_found_mpfr])

        LIBS=$_mpfr_save_libs

        if test $_found_mpfr = yes ; then
           AC_DEFINE(HAVE_MPFR,1,
	      [Define to 1 if you have fully functional mpfr and gmp libraries.])
           AC_SUBST(LIBMPFR,$_combo)
           break
        fi

     unset _mpfr_save_libs
     unset _combo
     unset _found_mpfr
  fi
])dnl
