#ifndef TR_SHADER_H_
#define TR_SHADER_H_

#ifndef GL_MODULATE
#define GL_MODULATE 0x2100
#endif

#ifndef GL_ADD
#define GL_ADD 0x0104
#endif

// any change in the LIGHTMAP_* defines here MUST be reflected in
// R_FindShader() in tr_bsp.c
#define LIGHTMAP_2D -4		  // shader is for 2D rendering
#define LIGHTMAP_BY_VERTEX -3 // pre-lit triangle models
#define LIGHTMAP_WHITEIMAGE -2
#define LIGHTMAP_NONE -1

typedef enum {
	SS_BAD,
	SS_PORTAL,		// mirrors, portals, viewscreens
	SS_ENVIRONMENT, // sky box
	SS_OPAQUE,		// opaque

	SS_DECAL,		// scorch marks, etc.
	SS_SEE_THROUGH, // ladders, grates, grills that may have small blended edges
					// in addition to alpha test
	SS_BANNER,

	SS_FOG,

	SS_UNDERWATER, // for items that should be drawn in front of the water plane

	SS_BLEND0, // regular transparency and filters
	SS_BLEND1, // generally only used for additive type effects
	SS_BLEND2,
	SS_BLEND3,

	SS_BLEND6,
	SS_STENCIL_SHADOW,
	SS_ALMOST_NEAREST, // gun smoke puffs

	SS_NEAREST // blood blobs
} shaderSort_t;

#endif
