import { type ClientOptions, type CustomAttributes, type Identifiers, type OptionsWithDefaults } from '../types';
import { type FrontendClientSdkKeyResponse, type FrontendExperimentsResponse } from './types';
export declare const PROD_BASE_URL = "https://api.atlassian.com/flags";
export declare const STAGING_BASE_URL = "https://api.stg.atlassian.com/flags";
export declare const DEV_BASE_URL = "https://api.dev.atlassian.com/flags";
export declare const FEDM_STAGING_BASE_URL = "https://api.stg.atlassian-us-gov-mod.com/flags";
export declare const FEDM_PROD_BASE_URL = "https://api.atlassian-us-gov-mod.com/flags";
export declare const GATEWAY_BASE_URL = "/gateway/api/flags";
export type FetcherOptions = Pick<OptionsWithDefaults<ClientOptions>, 'apiKey' | 'fetchTimeoutMs' | 'environment' | 'useGatewayURL' | 'targetApp' | 'perimeter'>;
export default class Fetcher {
    static fetchClientSdk(fetcherOptions: FetcherOptions): Promise<FrontendClientSdkKeyResponse>;
    static fetchExperimentValues(fetcherOptions: FetcherOptions, identifiers: Identifiers, customAttributes?: CustomAttributes): Promise<FrontendExperimentsResponse>;
    static handleResponseError(response: Response): Promise<void>;
    static extractResponseBody<T>(response: Response): Promise<T>;
    private static getBaseUrl;
    private static fetchRequest;
}
