/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.LocalDependencyFiles;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;

public class ArtifactCollectingVisitor
implements ArtifactVisitor {
    private final Set<ResolvedArtifact> artifacts;
    private List<Throwable> failures;

    public ArtifactCollectingVisitor() {
        this(new LinkedHashSet<ResolvedArtifact>());
    }

    public ArtifactCollectingVisitor(Set<ResolvedArtifact> artifacts) {
        this.artifacts = artifacts;
    }

    @Override
    public void visitArtifact(DisplayName variantName, ImmutableAttributes variantAttributes, ImmutableCapabilities capabilities, ResolvableArtifact artifact) {
        this.artifacts.add(artifact.toPublicView());
    }

    @Override
    public void visitFailure(Throwable failure) {
        if (this.failures == null) {
            this.failures = new ArrayList<Throwable>();
        }
        this.failures.add(failure);
    }

    @Override
    public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
        if (source instanceof LocalDependencyFiles) {
            return FileCollectionStructureVisitor.VisitType.NoContents;
        }
        return FileCollectionStructureVisitor.VisitType.Visit;
    }

    @Override
    public boolean requireArtifactFiles() {
        return false;
    }

    public Set<ResolvedArtifact> getArtifacts() {
        return this.artifacts;
    }

    public List<Throwable> getFailures() {
        return this.failures != null ? this.failures : Collections.emptyList();
    }
}

