/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.problems;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.cc.impl.problems.ConfigurationCacheProblemsSummaryKt;
import org.gradle.internal.cc.impl.problems.ProblemCause;
import org.gradle.internal.cc.impl.problems.ProblemSeverity;
import org.gradle.internal.cc.impl.problems.Summary;
import org.gradle.internal.configuration.problems.PropertyProblem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0010J\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010$\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u0017j\b\u0012\u0004\u0012\u00020\u0010`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/gradle/internal/cc/impl/problems/ConfigurationCacheProblemsSummary;", "", "maxCollectedProblems", "", "<init>", "(I)V", "overflowed", "", "totalProblemCount", "deferredProblemCount", "suppressedProblemCount", "suppressedSilentlyProblemCount", "incompatibleTasksCount", "problemCauses", "Ljava/util/HashMap;", "Lorg/gradle/internal/cc/impl/problems/ProblemCause;", "Lorg/gradle/internal/cc/impl/problems/ProblemSeverity;", "Lkotlin/collections/HashMap;", "originalProblemExceptions", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "severityComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "get", "Lorg/gradle/internal/cc/impl/problems/Summary;", "onProblem", "problem", "Lorg/gradle/internal/configuration/problems/PropertyProblem;", "severity", "onIncompatibleTask", "", "collectOriginalException", "recordProblemCause", "configuration-cache"})
public final class ConfigurationCacheProblemsSummary {
    private final int maxCollectedProblems;
    private boolean overflowed;
    private int totalProblemCount;
    private int deferredProblemCount;
    private int suppressedProblemCount;
    private int suppressedSilentlyProblemCount;
    private int incompatibleTasksCount;
    @NotNull
    private final HashMap<ProblemCause, ProblemSeverity> problemCauses;
    @NotNull
    private final ArrayList<Throwable> originalProblemExceptions;
    @NotNull
    private final Comparator<ProblemSeverity> severityComparator;
    @NotNull
    private final ReentrantLock lock;

    public ConfigurationCacheProblemsSummary(int maxCollectedProblems) {
        this.maxCollectedProblems = maxCollectedProblems;
        this.problemCauses = new HashMap();
        this.originalProblemExceptions = new ArrayList(5);
        this.severityComparator = ConfigurationCacheProblemsSummaryKt.access$consoleComparatorForSeverity();
        this.lock = new ReentrantLock();
    }

    public /* synthetic */ ConfigurationCacheProblemsSummary(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4096;
        }
        this(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Summary get() {
        Summary summary;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            ImmutableMap immutableMap = ImmutableMap.copyOf((Map)this.problemCauses);
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"copyOf(...)");
            Map map = (Map)immutableMap;
            ImmutableList immutableList = ImmutableList.copyOf((Collection)this.originalProblemExceptions);
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            summary = new Summary(this.totalProblemCount, this.deferredProblemCount, this.suppressedSilentlyProblemCount, map, (List)immutableList, this.overflowed, this.maxCollectedProblems, this.incompatibleTasksCount);
        }
        finally {
            lock.unlock();
        }
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onProblem(@NotNull PropertyProblem problem, @NotNull ProblemSeverity severity) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean isNewCause;
            boolean bl = false;
            ++this.totalProblemCount;
            switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    ++this.deferredProblemCount;
                    break;
                }
                case 2: {
                    ++this.suppressedProblemCount;
                    break;
                }
                case 3: {
                    ++this.suppressedSilentlyProblemCount;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (this.overflowed) {
                boolean bl2 = false;
                return bl2;
            }
            if (this.totalProblemCount > this.maxCollectedProblems) {
                this.overflowed = true;
                boolean bl3 = false;
                return bl3;
            }
            if (severity != ProblemSeverity.SuppressedSilently && (isNewCause = this.recordProblemCause(problem, severity)) && severity != ProblemSeverity.Interrupting) {
                this.collectOriginalException(problem);
            }
            boolean bl4 = true;
            return bl4;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onIncompatibleTask() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            ++this.incompatibleTasksCount;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void collectOriginalException(PropertyProblem problem) {
        block1: {
            if (this.originalProblemExceptions.size() >= 5) break block1;
            Throwable throwable = problem.getException();
            if (throwable != null) {
                Throwable it2 = throwable;
                boolean bl = false;
                this.originalProblemExceptions.add(it2);
            }
        }
    }

    private final boolean recordProblemCause(PropertyProblem problem, ProblemSeverity severity) {
        ProblemCause cause = ProblemCause.Companion.of(problem);
        boolean isNew = !this.problemCauses.containsKey(cause);
        this.problemCauses.merge(cause, severity, new BiFunction(this){
            final /* synthetic */ ConfigurationCacheProblemsSummary this$0;
            {
                this.this$0 = $receiver;
            }

            public final ProblemSeverity apply(ProblemSeverity old, ProblemSeverity problemSeverity) {
                Intrinsics.checkNotNullParameter((Object)old, (String)"old");
                Intrinsics.checkNotNullParameter((Object)problemSeverity, (String)"new");
                return ConfigurationCacheProblemsSummary.access$getSeverityComparator$p(this.this$0).compare(old, problemSeverity) < 0 ? old : problemSeverity;
            }
        });
        return isNew;
    }

    public ConfigurationCacheProblemsSummary() {
        this(0, 1, null);
    }

    public static final /* synthetic */ Comparator access$getSeverityComparator$p(ConfigurationCacheProblemsSummary $this) {
        return $this.severityComparator;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProblemSeverity.values().length];
            try {
                nArray[ProblemSeverity.Deferred.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemSeverity.Suppressed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemSeverity.SuppressedSilently.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemSeverity.Interrupting.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

