/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Objects;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.Repository;
import jdk.jfr.internal.SecuritySupport;

final class RepositoryChunk {
    private static final int MAX_CHUNK_NAMES = 100;
    static final Comparator<RepositoryChunk> END_TIME_COMPARATOR = new Comparator<RepositoryChunk>(){

        @Override
        public int compare(RepositoryChunk repositoryChunk, RepositoryChunk repositoryChunk2) {
            return repositoryChunk.endTime.compareTo(repositoryChunk2.endTime);
        }
    };
    private final SecuritySupport.SafePath repositoryPath;
    private final SecuritySupport.SafePath unFinishedFile;
    private final SecuritySupport.SafePath file;
    private final Instant startTime;
    private final RandomAccessFile unFinishedRAF;
    private Instant endTime = null;
    private int refCount = 0;
    private long size;

    RepositoryChunk(SecuritySupport.SafePath safePath, Instant instant) throws Exception {
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        String string = Repository.REPO_DATE_FORMAT.format(LocalDateTime.ofInstant(instant, zonedDateTime.getZone()));
        this.startTime = instant;
        this.repositoryPath = safePath;
        this.unFinishedFile = RepositoryChunk.findFileName(this.repositoryPath, string, ".part");
        this.file = RepositoryChunk.findFileName(this.repositoryPath, string, ".jfr");
        this.unFinishedRAF = SecuritySupport.createRandomAccessFile(this.unFinishedFile);
        SecuritySupport.touch(this.file);
    }

    private static SecuritySupport.SafePath findFileName(SecuritySupport.SafePath safePath, String string, String string2) throws Exception {
        Path path = safePath.toPath().resolve(string + string2);
        for (int i = 1; i < 100; ++i) {
            SecuritySupport.SafePath safePath2 = new SecuritySupport.SafePath(path);
            if (!SecuritySupport.exists(safePath2)) {
                return safePath2;
            }
            String string3 = String.format("%s_%02d%s", string, i, string2);
            path = safePath.toPath().resolve(string3);
        }
        path = safePath.toPath().resolve(string + "_" + System.currentTimeMillis() + string2);
        return SecuritySupport.toRealPath(new SecuritySupport.SafePath(path));
    }

    public SecuritySupport.SafePath getUnfishedFile() {
        return this.unFinishedFile;
    }

    void finish(Instant instant) {
        try {
            this.finishWithException(instant);
        }
        catch (IOException iOException) {
            Logger.log(LogTag.JFR, LogLevel.ERROR, "Could not finish chunk. " + iOException.getMessage());
        }
    }

    private void finishWithException(Instant instant) throws IOException {
        this.unFinishedRAF.close();
        this.size = RepositoryChunk.finish(this.unFinishedFile, this.file);
        this.endTime = instant;
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.DEBUG, () -> "Chunk finished: " + this.file);
    }

    private static long finish(SecuritySupport.SafePath safePath, SecuritySupport.SafePath safePath2) throws IOException {
        Objects.requireNonNull(safePath);
        Objects.requireNonNull(safePath2);
        SecuritySupport.delete(safePath2);
        SecuritySupport.moveReplace(safePath, safePath2);
        return SecuritySupport.getFileSize(safePath2);
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    private void delete(SecuritySupport.SafePath safePath) {
        block2: {
            try {
                SecuritySupport.delete(safePath);
                Logger.log(LogTag.JFR, LogLevel.DEBUG, () -> "Repository chunk " + safePath + " deleted");
            }
            catch (IOException iOException) {
                Logger.log(LogTag.JFR, LogLevel.ERROR, () -> "Repository chunk " + safePath + " could not be deleted: " + iOException.getMessage());
                if (safePath == null) break block2;
                SecuritySupport.deleteOnExit(safePath);
            }
        }
    }

    private void destroy() {
        if (!this.isFinished()) {
            this.finish(Instant.MIN);
        }
        if (this.file != null) {
            this.delete(this.file);
        }
        try {
            this.unFinishedRAF.close();
        }
        catch (IOException iOException) {
            Logger.log(LogTag.JFR, LogLevel.ERROR, () -> "Could not close random access file: " + this.unFinishedFile.toString() + ". File will not be deleted due to: " + iOException.getMessage());
        }
    }

    public synchronized void use() {
        ++this.refCount;
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.DEBUG, () -> "Use chunk " + this.toString() + " ref count now " + this.refCount);
    }

    public synchronized void release() {
        --this.refCount;
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.DEBUG, () -> "Release chunk " + this.toString() + " ref count now " + this.refCount);
        if (this.refCount == 0) {
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        boolean bl = false;
        RepositoryChunk repositoryChunk = this;
        synchronized (repositoryChunk) {
            if (this.refCount > 0) {
                bl = true;
            }
        }
        if (bl) {
            this.destroy();
        }
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFinished() {
        return this.endTime != null;
    }

    public String toString() {
        if (this.isFinished()) {
            return this.file.toString();
        }
        return this.unFinishedFile.toString();
    }

    ReadableByteChannel newChannel() throws IOException {
        if (!this.isFinished()) {
            throw new IOException("Chunk not finished");
        }
        return SecuritySupport.newFileChannelToRead(this.file);
    }

    public boolean inInterval(Instant instant, Instant instant2) {
        if (instant != null && this.getEndTime().isBefore(instant)) {
            return false;
        }
        return instant2 == null || !this.getStartTime().isAfter(instant2);
    }

    public SecuritySupport.SafePath getFile() {
        return this.file;
    }
}

