import importlib
import subprocess
import sys
from types import ModuleType

import pytest
from typer.testing import CliRunner

runner = CliRunner()


@pytest.fixture(
    name="mod",
    params=[
        pytest.param("tutorial005_py310"),
        pytest.param("tutorial005_an_py310"),
    ],
)
def get_mod(request: pytest.FixtureRequest) -> ModuleType:
    module_name = f"docs_src.options.name.{request.param}"
    mod = importlib.import_module(module_name)
    return mod


def test_option_help(mod: ModuleType):
    result = runner.invoke(mod.app, ["--help"])
    assert result.exit_code == 0
    assert "-n" in result.output
    assert "--name" in result.output
    assert "TEXT" in result.output
    assert "-f" in result.output
    assert "--formal" in result.output


def test_call(mod: ModuleType):
    result = runner.invoke(mod.app, ["-n", "Camila"])
    assert result.exit_code == 0
    assert "Hello Camila" in result.output


def test_call_formal(mod: ModuleType):
    result = runner.invoke(mod.app, ["-n", "Camila", "-f"])
    assert result.exit_code == 0
    assert "Good day Ms. Camila." in result.output


def test_call_formal_condensed(mod: ModuleType):
    result = runner.invoke(mod.app, ["-fn", "Camila"])
    assert result.exit_code == 0
    assert "Good day Ms. Camila." in result.output


def test_call_condensed_wrong_order(mod: ModuleType):
    result = runner.invoke(mod.app, ["-nf", "Camila"])
    assert result.exit_code != 0


def test_script(mod: ModuleType):
    result = subprocess.run(
        [sys.executable, "-m", "coverage", "run", mod.__file__, "--help"],
        capture_output=True,
        encoding="utf-8",
    )
    assert "Usage" in result.stdout
