// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/actions/sdk/v2/event_logs.proto

package sdk

import (
	reflect "reflect"
	sync "sync"

	conversation "google.golang.org/genproto/googleapis/actions/sdk/v2/conversation"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Contains information about execution event which happened during processing
// Actions Builder conversation request. For an overview of the stages involved
// in a conversation request, see
// https://developers.google.com/assistant/conversational/actions.
type ExecutionEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp when the event happened.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// State of the execution during this event.
	ExecutionState *ExecutionState `protobuf:"bytes,2,opt,name=execution_state,json=executionState,proto3" json:"execution_state,omitempty"`
	// Resulting status of particular execution step.
	Status *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	// Detailed information specific to different of events that may be involved
	// in processing a conversation round. The field set here defines the type of
	// this event.
	//
	// Types that are assignable to EventData:
	//
	//	*ExecutionEvent_UserInput
	//	*ExecutionEvent_IntentMatch
	//	*ExecutionEvent_ConditionsEvaluated
	//	*ExecutionEvent_OnSceneEnter
	//	*ExecutionEvent_WebhookRequest
	//	*ExecutionEvent_WebhookResponse
	//	*ExecutionEvent_WebhookInitiatedTransition
	//	*ExecutionEvent_SlotMatch
	//	*ExecutionEvent_SlotRequested
	//	*ExecutionEvent_SlotValidated
	//	*ExecutionEvent_FormFilled
	//	*ExecutionEvent_WaitingUserInput
	//	*ExecutionEvent_EndConversation
	EventData isExecutionEvent_EventData `protobuf_oneof:"EventData"`
	// List of warnings generated during execution of this Event. Warnings are
	// tips for the developer discovered during the conversation request. These
	// are usually non-critical and do not halt the execution of the request. For
	// example, a warnings might be generated when webhook tries to override a
	// custom Type which does not exist. Errors are reported as a failed status
	// code, but warnings can be present even when the status is OK.
	WarningMessages []string `protobuf:"bytes,17,rep,name=warning_messages,json=warningMessages,proto3" json:"warning_messages,omitempty"`
}

func (x *ExecutionEvent) Reset() {
	*x = ExecutionEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionEvent) ProtoMessage() {}

func (x *ExecutionEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionEvent.ProtoReflect.Descriptor instead.
func (*ExecutionEvent) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{0}
}

func (x *ExecutionEvent) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

func (x *ExecutionEvent) GetExecutionState() *ExecutionState {
	if x != nil {
		return x.ExecutionState
	}
	return nil
}

func (x *ExecutionEvent) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (m *ExecutionEvent) GetEventData() isExecutionEvent_EventData {
	if m != nil {
		return m.EventData
	}
	return nil
}

func (x *ExecutionEvent) GetUserInput() *UserConversationInput {
	if x, ok := x.GetEventData().(*ExecutionEvent_UserInput); ok {
		return x.UserInput
	}
	return nil
}

func (x *ExecutionEvent) GetIntentMatch() *IntentMatch {
	if x, ok := x.GetEventData().(*ExecutionEvent_IntentMatch); ok {
		return x.IntentMatch
	}
	return nil
}

func (x *ExecutionEvent) GetConditionsEvaluated() *ConditionsEvaluated {
	if x, ok := x.GetEventData().(*ExecutionEvent_ConditionsEvaluated); ok {
		return x.ConditionsEvaluated
	}
	return nil
}

func (x *ExecutionEvent) GetOnSceneEnter() *OnSceneEnter {
	if x, ok := x.GetEventData().(*ExecutionEvent_OnSceneEnter); ok {
		return x.OnSceneEnter
	}
	return nil
}

func (x *ExecutionEvent) GetWebhookRequest() *WebhookRequest {
	if x, ok := x.GetEventData().(*ExecutionEvent_WebhookRequest); ok {
		return x.WebhookRequest
	}
	return nil
}

func (x *ExecutionEvent) GetWebhookResponse() *WebhookResponse {
	if x, ok := x.GetEventData().(*ExecutionEvent_WebhookResponse); ok {
		return x.WebhookResponse
	}
	return nil
}

func (x *ExecutionEvent) GetWebhookInitiatedTransition() *WebhookInitiatedTransition {
	if x, ok := x.GetEventData().(*ExecutionEvent_WebhookInitiatedTransition); ok {
		return x.WebhookInitiatedTransition
	}
	return nil
}

func (x *ExecutionEvent) GetSlotMatch() *SlotMatch {
	if x, ok := x.GetEventData().(*ExecutionEvent_SlotMatch); ok {
		return x.SlotMatch
	}
	return nil
}

func (x *ExecutionEvent) GetSlotRequested() *SlotRequested {
	if x, ok := x.GetEventData().(*ExecutionEvent_SlotRequested); ok {
		return x.SlotRequested
	}
	return nil
}

func (x *ExecutionEvent) GetSlotValidated() *SlotValidated {
	if x, ok := x.GetEventData().(*ExecutionEvent_SlotValidated); ok {
		return x.SlotValidated
	}
	return nil
}

func (x *ExecutionEvent) GetFormFilled() *FormFilled {
	if x, ok := x.GetEventData().(*ExecutionEvent_FormFilled); ok {
		return x.FormFilled
	}
	return nil
}

func (x *ExecutionEvent) GetWaitingUserInput() *WaitingForUserInput {
	if x, ok := x.GetEventData().(*ExecutionEvent_WaitingUserInput); ok {
		return x.WaitingUserInput
	}
	return nil
}

func (x *ExecutionEvent) GetEndConversation() *EndConversation {
	if x, ok := x.GetEventData().(*ExecutionEvent_EndConversation); ok {
		return x.EndConversation
	}
	return nil
}

func (x *ExecutionEvent) GetWarningMessages() []string {
	if x != nil {
		return x.WarningMessages
	}
	return nil
}

type isExecutionEvent_EventData interface {
	isExecutionEvent_EventData()
}

type ExecutionEvent_UserInput struct {
	// User input handling event.
	UserInput *UserConversationInput `protobuf:"bytes,4,opt,name=user_input,json=userInput,proto3,oneof"`
}

type ExecutionEvent_IntentMatch struct {
	// Intent matching event.
	IntentMatch *IntentMatch `protobuf:"bytes,5,opt,name=intent_match,json=intentMatch,proto3,oneof"`
}

type ExecutionEvent_ConditionsEvaluated struct {
	// Condition evaluation event.
	ConditionsEvaluated *ConditionsEvaluated `protobuf:"bytes,6,opt,name=conditions_evaluated,json=conditionsEvaluated,proto3,oneof"`
}

type ExecutionEvent_OnSceneEnter struct {
	// OnSceneEnter execution event.
	OnSceneEnter *OnSceneEnter `protobuf:"bytes,7,opt,name=on_scene_enter,json=onSceneEnter,proto3,oneof"`
}

type ExecutionEvent_WebhookRequest struct {
	// Webhook request dispatch event.
	WebhookRequest *WebhookRequest `protobuf:"bytes,8,opt,name=webhook_request,json=webhookRequest,proto3,oneof"`
}

type ExecutionEvent_WebhookResponse struct {
	// Webhook response receipt event.
	WebhookResponse *WebhookResponse `protobuf:"bytes,9,opt,name=webhook_response,json=webhookResponse,proto3,oneof"`
}

type ExecutionEvent_WebhookInitiatedTransition struct {
	// Webhook-initiated transition event.
	WebhookInitiatedTransition *WebhookInitiatedTransition `protobuf:"bytes,10,opt,name=webhook_initiated_transition,json=webhookInitiatedTransition,proto3,oneof"`
}

type ExecutionEvent_SlotMatch struct {
	// Slot matching event.
	SlotMatch *SlotMatch `protobuf:"bytes,11,opt,name=slot_match,json=slotMatch,proto3,oneof"`
}

type ExecutionEvent_SlotRequested struct {
	// Slot requesting event.
	SlotRequested *SlotRequested `protobuf:"bytes,12,opt,name=slot_requested,json=slotRequested,proto3,oneof"`
}

type ExecutionEvent_SlotValidated struct {
	// Slot validation event.
	SlotValidated *SlotValidated `protobuf:"bytes,13,opt,name=slot_validated,json=slotValidated,proto3,oneof"`
}

type ExecutionEvent_FormFilled struct {
	// Form filling event.
	FormFilled *FormFilled `protobuf:"bytes,14,opt,name=form_filled,json=formFilled,proto3,oneof"`
}

type ExecutionEvent_WaitingUserInput struct {
	// Waiting-for-user-input event.
	WaitingUserInput *WaitingForUserInput `protobuf:"bytes,15,opt,name=waiting_user_input,json=waitingUserInput,proto3,oneof"`
}

type ExecutionEvent_EndConversation struct {
	// End-of-conversation event.
	EndConversation *EndConversation `protobuf:"bytes,16,opt,name=end_conversation,json=endConversation,proto3,oneof"`
}

func (*ExecutionEvent_UserInput) isExecutionEvent_EventData() {}

func (*ExecutionEvent_IntentMatch) isExecutionEvent_EventData() {}

func (*ExecutionEvent_ConditionsEvaluated) isExecutionEvent_EventData() {}

func (*ExecutionEvent_OnSceneEnter) isExecutionEvent_EventData() {}

func (*ExecutionEvent_WebhookRequest) isExecutionEvent_EventData() {}

func (*ExecutionEvent_WebhookResponse) isExecutionEvent_EventData() {}

func (*ExecutionEvent_WebhookInitiatedTransition) isExecutionEvent_EventData() {}

func (*ExecutionEvent_SlotMatch) isExecutionEvent_EventData() {}

func (*ExecutionEvent_SlotRequested) isExecutionEvent_EventData() {}

func (*ExecutionEvent_SlotValidated) isExecutionEvent_EventData() {}

func (*ExecutionEvent_FormFilled) isExecutionEvent_EventData() {}

func (*ExecutionEvent_WaitingUserInput) isExecutionEvent_EventData() {}

func (*ExecutionEvent_EndConversation) isExecutionEvent_EventData() {}

// Current state of the execution.
type ExecutionState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the scene which is currently  active.
	CurrentSceneId string `protobuf:"bytes,1,opt,name=current_scene_id,json=currentSceneId,proto3" json:"current_scene_id,omitempty"`
	// State of the session storage:
	// https://developers.google.com/assistant/conversational/storage-session
	SessionStorage *structpb.Struct `protobuf:"bytes,2,opt,name=session_storage,json=sessionStorage,proto3" json:"session_storage,omitempty"`
	// State of the slots filling, if applicable:
	// https://developers.google.com/assistant/conversational/scenes#slot_filling
	Slots *Slots `protobuf:"bytes,5,opt,name=slots,proto3" json:"slots,omitempty"`
	// Prompt queue:
	// https://developers.google.com/assistant/conversational/prompts
	PromptQueue []*conversation.Prompt `protobuf:"bytes,7,rep,name=prompt_queue,json=promptQueue,proto3" json:"prompt_queue,omitempty"`
	// State of the user storage:
	// https://developers.google.com/assistant/conversational/storage-user
	UserStorage *structpb.Struct `protobuf:"bytes,6,opt,name=user_storage,json=userStorage,proto3" json:"user_storage,omitempty"`
	// State of the home storage:
	// https://developers.google.com/assistant/conversational/storage-home
	HouseholdStorage *structpb.Struct `protobuf:"bytes,8,opt,name=household_storage,json=householdStorage,proto3" json:"household_storage,omitempty"`
}

func (x *ExecutionState) Reset() {
	*x = ExecutionState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionState) ProtoMessage() {}

func (x *ExecutionState) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionState.ProtoReflect.Descriptor instead.
func (*ExecutionState) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{1}
}

func (x *ExecutionState) GetCurrentSceneId() string {
	if x != nil {
		return x.CurrentSceneId
	}
	return ""
}

func (x *ExecutionState) GetSessionStorage() *structpb.Struct {
	if x != nil {
		return x.SessionStorage
	}
	return nil
}

func (x *ExecutionState) GetSlots() *Slots {
	if x != nil {
		return x.Slots
	}
	return nil
}

func (x *ExecutionState) GetPromptQueue() []*conversation.Prompt {
	if x != nil {
		return x.PromptQueue
	}
	return nil
}

func (x *ExecutionState) GetUserStorage() *structpb.Struct {
	if x != nil {
		return x.UserStorage
	}
	return nil
}

func (x *ExecutionState) GetHouseholdStorage() *structpb.Struct {
	if x != nil {
		return x.HouseholdStorage
	}
	return nil
}

// Represents the current state of a the scene's slots.
type Slots struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current status of slot filling.
	Status conversation.SlotFillingStatus `protobuf:"varint,2,opt,name=status,proto3,enum=google.actions.sdk.v2.conversation.SlotFillingStatus" json:"status,omitempty"`
	// The slots associated with the current scene.
	Slots map[string]*conversation.Slot `protobuf:"bytes,3,rep,name=slots,proto3" json:"slots,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Slots) Reset() {
	*x = Slots{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Slots) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Slots) ProtoMessage() {}

func (x *Slots) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Slots.ProtoReflect.Descriptor instead.
func (*Slots) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{2}
}

func (x *Slots) GetStatus() conversation.SlotFillingStatus {
	if x != nil {
		return x.Status
	}
	return conversation.SlotFillingStatus_UNSPECIFIED
}

func (x *Slots) GetSlots() map[string]*conversation.Slot {
	if x != nil {
		return x.Slots
	}
	return nil
}

// Information related to user input.
type UserConversationInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of user input. E.g. keyboard, voice, touch, etc.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Original text input from the user.
	OriginalQuery string `protobuf:"bytes,2,opt,name=original_query,json=originalQuery,proto3" json:"original_query,omitempty"`
}

func (x *UserConversationInput) Reset() {
	*x = UserConversationInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserConversationInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserConversationInput) ProtoMessage() {}

func (x *UserConversationInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserConversationInput.ProtoReflect.Descriptor instead.
func (*UserConversationInput) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{3}
}

func (x *UserConversationInput) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *UserConversationInput) GetOriginalQuery() string {
	if x != nil {
		return x.OriginalQuery
	}
	return ""
}

// Information about triggered intent match (global or within a scene):
// https://developers.google.com/assistant/conversational/intents
type IntentMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Intent id which triggered this interaction.
	IntentId string `protobuf:"bytes,1,opt,name=intent_id,json=intentId,proto3" json:"intent_id,omitempty"`
	// Parameters of intent which triggered this interaction.
	IntentParameters map[string]*conversation.IntentParameterValue `protobuf:"bytes,5,rep,name=intent_parameters,json=intentParameters,proto3" json:"intent_parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Name of the handler attached to this interaction.
	Handler string `protobuf:"bytes,3,opt,name=handler,proto3" json:"handler,omitempty"`
	// Scene to which this interaction leads to.
	NextSceneId string `protobuf:"bytes,4,opt,name=next_scene_id,json=nextSceneId,proto3" json:"next_scene_id,omitempty"`
}

func (x *IntentMatch) Reset() {
	*x = IntentMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentMatch) ProtoMessage() {}

func (x *IntentMatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentMatch.ProtoReflect.Descriptor instead.
func (*IntentMatch) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{4}
}

func (x *IntentMatch) GetIntentId() string {
	if x != nil {
		return x.IntentId
	}
	return ""
}

func (x *IntentMatch) GetIntentParameters() map[string]*conversation.IntentParameterValue {
	if x != nil {
		return x.IntentParameters
	}
	return nil
}

func (x *IntentMatch) GetHandler() string {
	if x != nil {
		return x.Handler
	}
	return ""
}

func (x *IntentMatch) GetNextSceneId() string {
	if x != nil {
		return x.NextSceneId
	}
	return ""
}

// Results of conditions evaluation:
// https://developers.google.com/assistant/conversational/scenes#conditions
type ConditionsEvaluated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of conditions which were evaluated to 'false'.
	FailedConditions []*Condition `protobuf:"bytes,1,rep,name=failed_conditions,json=failedConditions,proto3" json:"failed_conditions,omitempty"`
	// The first condition which was evaluated to 'true', if any.
	SuccessCondition *Condition `protobuf:"bytes,2,opt,name=success_condition,json=successCondition,proto3" json:"success_condition,omitempty"`
}

func (x *ConditionsEvaluated) Reset() {
	*x = ConditionsEvaluated{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConditionsEvaluated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConditionsEvaluated) ProtoMessage() {}

func (x *ConditionsEvaluated) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConditionsEvaluated.ProtoReflect.Descriptor instead.
func (*ConditionsEvaluated) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{5}
}

func (x *ConditionsEvaluated) GetFailedConditions() []*Condition {
	if x != nil {
		return x.FailedConditions
	}
	return nil
}

func (x *ConditionsEvaluated) GetSuccessCondition() *Condition {
	if x != nil {
		return x.SuccessCondition
	}
	return nil
}

// Evaluated condition.
type Condition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Expression specified in this condition.
	Expression string `protobuf:"bytes,1,opt,name=expression,proto3" json:"expression,omitempty"`
	// Handler name specified in evaluated condition.
	Handler string `protobuf:"bytes,2,opt,name=handler,proto3" json:"handler,omitempty"`
	// Destination scene specified in evaluated condition.
	NextSceneId string `protobuf:"bytes,3,opt,name=next_scene_id,json=nextSceneId,proto3" json:"next_scene_id,omitempty"`
}

func (x *Condition) Reset() {
	*x = Condition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Condition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Condition) ProtoMessage() {}

func (x *Condition) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Condition.ProtoReflect.Descriptor instead.
func (*Condition) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{6}
}

func (x *Condition) GetExpression() string {
	if x != nil {
		return x.Expression
	}
	return ""
}

func (x *Condition) GetHandler() string {
	if x != nil {
		return x.Handler
	}
	return ""
}

func (x *Condition) GetNextSceneId() string {
	if x != nil {
		return x.NextSceneId
	}
	return ""
}

// Information about execution of onSceneEnter stage:
// https://developers.google.com/assistant/conversational/scenes#on_enter
type OnSceneEnter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Handler name specified in onSceneEnter event.
	Handler string `protobuf:"bytes,1,opt,name=handler,proto3" json:"handler,omitempty"`
}

func (x *OnSceneEnter) Reset() {
	*x = OnSceneEnter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OnSceneEnter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OnSceneEnter) ProtoMessage() {}

func (x *OnSceneEnter) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OnSceneEnter.ProtoReflect.Descriptor instead.
func (*OnSceneEnter) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{7}
}

func (x *OnSceneEnter) GetHandler() string {
	if x != nil {
		return x.Handler
	}
	return ""
}

// Event triggered by destination scene returned from webhook:
// https://developers.google.com/assistant/conversational/webhooks#transition_scenes
type WebhookInitiatedTransition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the scene the transition is leading to.
	NextSceneId string `protobuf:"bytes,1,opt,name=next_scene_id,json=nextSceneId,proto3" json:"next_scene_id,omitempty"`
}

func (x *WebhookInitiatedTransition) Reset() {
	*x = WebhookInitiatedTransition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebhookInitiatedTransition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebhookInitiatedTransition) ProtoMessage() {}

func (x *WebhookInitiatedTransition) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebhookInitiatedTransition.ProtoReflect.Descriptor instead.
func (*WebhookInitiatedTransition) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{8}
}

func (x *WebhookInitiatedTransition) GetNextSceneId() string {
	if x != nil {
		return x.NextSceneId
	}
	return ""
}

// Information about a request dispatched to the Action webhook:
// https://developers.google.com/assistant/conversational/webhooks#payloads
type WebhookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Payload of the webhook request.
	RequestJson string `protobuf:"bytes,1,opt,name=request_json,json=requestJson,proto3" json:"request_json,omitempty"`
}

func (x *WebhookRequest) Reset() {
	*x = WebhookRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebhookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebhookRequest) ProtoMessage() {}

func (x *WebhookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebhookRequest.ProtoReflect.Descriptor instead.
func (*WebhookRequest) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{9}
}

func (x *WebhookRequest) GetRequestJson() string {
	if x != nil {
		return x.RequestJson
	}
	return ""
}

// Information about a response received from the Action webhook:
// https://developers.google.com/assistant/conversational/webhooks#payloads
type WebhookResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Payload of the webhook response.
	ResponseJson string `protobuf:"bytes,1,opt,name=response_json,json=responseJson,proto3" json:"response_json,omitempty"`
}

func (x *WebhookResponse) Reset() {
	*x = WebhookResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WebhookResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebhookResponse) ProtoMessage() {}

func (x *WebhookResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebhookResponse.ProtoReflect.Descriptor instead.
func (*WebhookResponse) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{10}
}

func (x *WebhookResponse) GetResponseJson() string {
	if x != nil {
		return x.ResponseJson
	}
	return ""
}

// Information about matched slot(s):
// https://developers.google.com/assistant/conversational/scenes#slot_filling
type SlotMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Parameters extracted by NLU from user input.
	NluParameters map[string]*conversation.IntentParameterValue `protobuf:"bytes,2,rep,name=nlu_parameters,json=nluParameters,proto3" json:"nlu_parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SlotMatch) Reset() {
	*x = SlotMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SlotMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SlotMatch) ProtoMessage() {}

func (x *SlotMatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SlotMatch.ProtoReflect.Descriptor instead.
func (*SlotMatch) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{11}
}

func (x *SlotMatch) GetNluParameters() map[string]*conversation.IntentParameterValue {
	if x != nil {
		return x.NluParameters
	}
	return nil
}

// Information about currently requested slot:
// https://developers.google.com/assistant/conversational/scenes#slot_filling
type SlotRequested struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the requested slot.
	Slot string `protobuf:"bytes,1,opt,name=slot,proto3" json:"slot,omitempty"`
	// Slot prompt.
	Prompt *conversation.Prompt `protobuf:"bytes,3,opt,name=prompt,proto3" json:"prompt,omitempty"`
}

func (x *SlotRequested) Reset() {
	*x = SlotRequested{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SlotRequested) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SlotRequested) ProtoMessage() {}

func (x *SlotRequested) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SlotRequested.ProtoReflect.Descriptor instead.
func (*SlotRequested) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{12}
}

func (x *SlotRequested) GetSlot() string {
	if x != nil {
		return x.Slot
	}
	return ""
}

func (x *SlotRequested) GetPrompt() *conversation.Prompt {
	if x != nil {
		return x.Prompt
	}
	return nil
}

// Event which happens after webhook validation was finished for slot(s):
// https://developers.google.com/assistant/conversational/scenes#slot_filling
type SlotValidated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SlotValidated) Reset() {
	*x = SlotValidated{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SlotValidated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SlotValidated) ProtoMessage() {}

func (x *SlotValidated) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SlotValidated.ProtoReflect.Descriptor instead.
func (*SlotValidated) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{13}
}

// Event which happens when form is fully filled:
// https://developers.google.com/assistant/conversational/scenes#slot_filling
type FormFilled struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *FormFilled) Reset() {
	*x = FormFilled{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FormFilled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FormFilled) ProtoMessage() {}

func (x *FormFilled) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FormFilled.ProtoReflect.Descriptor instead.
func (*FormFilled) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{14}
}

// Event which happens when system needs user input:
// https://developers.google.com/assistant/conversational/scenes#input
type WaitingForUserInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *WaitingForUserInput) Reset() {
	*x = WaitingForUserInput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WaitingForUserInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WaitingForUserInput) ProtoMessage() {}

func (x *WaitingForUserInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WaitingForUserInput.ProtoReflect.Descriptor instead.
func (*WaitingForUserInput) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{15}
}

// Event which informs that conversation with agent was ended.
type EndConversation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *EndConversation) Reset() {
	*x = EndConversation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EndConversation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EndConversation) ProtoMessage() {}

func (x *EndConversation) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_event_logs_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EndConversation.ProtoReflect.Descriptor instead.
func (*EndConversation) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP(), []int{16}
}

var File_google_actions_sdk_v2_event_logs_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_event_logs_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f,
	0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x1a,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x6d,
	0x70, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x73, 0x63, 0x65,
	0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xbb, 0x0a, 0x0a, 0x0e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4e,
	0x0a, 0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0e,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4d, 0x0a, 0x0a, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x09,
	0x75, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x47, 0x0a, 0x0c, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x48, 0x00, 0x52, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x12, 0x5f, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x13,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x65, 0x64, 0x12, 0x4b, 0x0a, 0x0e, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x65, 0x6e, 0x65, 0x5f,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b,
	0x2e, 0x76, 0x32, 0x2e, 0x4f, 0x6e, 0x53, 0x63, 0x65, 0x6e, 0x65, 0x45, 0x6e, 0x74, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x0c, 0x6f, 0x6e, 0x53, 0x63, 0x65, 0x6e, 0x65, 0x45, 0x6e, 0x74, 0x65, 0x72,
	0x12, 0x50, 0x0a, 0x0f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76,
	0x32, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x48, 0x00, 0x52, 0x0e, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x53, 0x0a, 0x10, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64,
	0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x0f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x75, 0x0a, 0x1c, 0x77, 0x65, 0x62, 0x68, 0x6f,
	0x6f, 0x6b, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x49, 0x6e, 0x69,
	0x74, 0x69, 0x61, 0x74, 0x65, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0x00, 0x52, 0x1a, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x49, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x74, 0x65, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41,
	0x0a, 0x0a, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6c, 0x6f, 0x74, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x48, 0x00, 0x52, 0x09, 0x73, 0x6c, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x12, 0x4d, 0x0a, 0x0e, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76,
	0x32, 0x2e, 0x53, 0x6c, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x48,
	0x00, 0x52, 0x0d, 0x73, 0x6c, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x12, 0x4d, 0x0a, 0x0e, 0x73, 0x6c, 0x6f, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x6c, 0x6f, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x48, 0x00,
	0x52, 0x0d, 0x73, 0x6c, 0x6f, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x12,
	0x44, 0x0a, 0x0b, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x66, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x6f, 0x72,
	0x6d, 0x46, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0a, 0x66, 0x6f, 0x72, 0x6d, 0x46,
	0x69, 0x6c, 0x6c, 0x65, 0x64, 0x12, 0x5a, 0x0a, 0x12, 0x77, 0x61, 0x69, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x61, 0x69, 0x74, 0x69, 0x6e,
	0x67, 0x46, 0x6f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52,
	0x10, 0x77, 0x61, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x12, 0x53, 0x0a, 0x10, 0x65, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b,
	0x2e, 0x76, 0x32, 0x2e, 0x45, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f, 0x65, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e,
	0x67, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0f, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x73, 0x42, 0x0b, 0x0a, 0x09, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x22, 0x81,
	0x03, 0x0a, 0x0e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x65,
	0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x65, 0x6e, 0x65, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x0f, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x32, 0x0a,
	0x05, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64,
	0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6c, 0x6f, 0x74, 0x73, 0x52, 0x05, 0x73, 0x6c, 0x6f, 0x74,
	0x73, 0x12, 0x4d, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x75,
	0x65, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x6f,
	0x6d, 0x70, 0x74, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x51, 0x75, 0x65, 0x75, 0x65,
	0x12, 0x3a, 0x0a, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x0b, 0x75, 0x73, 0x65, 0x72, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x44, 0x0a, 0x11,
	0x68, 0x6f, 0x75, 0x73, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x52, 0x10, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x22, 0xf9, 0x01, 0x0a, 0x05, 0x53, 0x6c, 0x6f, 0x74, 0x73, 0x12, 0x4d, 0x0a, 0x06,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64,
	0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x6c, 0x6f, 0x74, 0x46, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x3d, 0x0a, 0x05, 0x73,
	0x6c, 0x6f, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x6c, 0x6f, 0x74, 0x73, 0x2e, 0x53, 0x6c, 0x6f, 0x74, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x05, 0x73, 0x6c, 0x6f, 0x74, 0x73, 0x1a, 0x62, 0x0a, 0x0a, 0x53, 0x6c,
	0x6f, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3e, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76,
	0x32, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53,
	0x6c, 0x6f, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x52,
	0x0a, 0x15, 0x55, 0x73, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x22, 0xce, 0x02, 0x0a, 0x0b, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12,
	0x65, 0x0a, 0x11, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e,
	0x76, 0x32, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72,
	0x12, 0x22, 0x0a, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x63, 0x65, 0x6e, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6e, 0x65, 0x78, 0x74, 0x53, 0x63, 0x65,
	0x6e, 0x65, 0x49, 0x64, 0x1a, 0x7d, 0x0a, 0x15, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x4e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xb3, 0x01, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x12, 0x4d, 0x0a, 0x11, 0x66,
	0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4d, 0x0a, 0x11, 0x73, 0x75,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x69, 0x0a, 0x09, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72,
	0x12, 0x22, 0x0a, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x63, 0x65, 0x6e, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6e, 0x65, 0x78, 0x74, 0x53, 0x63, 0x65,
	0x6e, 0x65, 0x49, 0x64, 0x22, 0x28, 0x0a, 0x0c, 0x4f, 0x6e, 0x53, 0x63, 0x65, 0x6e, 0x65, 0x45,
	0x6e, 0x74, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x22, 0x40,
	0x0a, 0x1a, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x74,
	0x65, 0x64, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x63, 0x65, 0x6e, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x6e, 0x65, 0x78, 0x74, 0x53, 0x63, 0x65, 0x6e, 0x65, 0x49, 0x64,
	0x22, 0x33, 0x0a, 0x0e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6a, 0x73,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x4a, 0x73, 0x6f, 0x6e, 0x22, 0x36, 0x0a, 0x0f, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4a, 0x73, 0x6f, 0x6e, 0x22, 0xe3, 0x01,
	0x0a, 0x09, 0x53, 0x6c, 0x6f, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x5a, 0x0a, 0x0e, 0x6e,
	0x6c, 0x75, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x6c, 0x6f, 0x74,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x4e, 0x6c, 0x75, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x6e, 0x6c, 0x75, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x7a, 0x0a, 0x12, 0x4e, 0x6c, 0x75, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x4e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x67, 0x0a, 0x0d, 0x53, 0x6c, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x6c, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x73, 0x6c, 0x6f, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x72, 0x6f, 0x6d,
	0x70, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32,
	0x2e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x52, 0x06, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x22, 0x0f, 0x0a, 0x0d,
	0x53, 0x6c, 0x6f, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x22, 0x0c, 0x0a,
	0x0a, 0x46, 0x6f, 0x72, 0x6d, 0x46, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x22, 0x15, 0x0a, 0x13, 0x57,
	0x61, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x46, 0x6f, 0x72, 0x55, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x22, 0x11, 0x0a, 0x0f, 0x45, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x67, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e,
	0x76, 0x32, 0x42, 0x0e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4c, 0x6f, 0x67, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x3b, 0x73, 0x64, 0x6b, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_actions_sdk_v2_event_logs_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_event_logs_proto_rawDescData = file_google_actions_sdk_v2_event_logs_proto_rawDesc
)

func file_google_actions_sdk_v2_event_logs_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_event_logs_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_event_logs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_event_logs_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_event_logs_proto_rawDescData
}

var file_google_actions_sdk_v2_event_logs_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_actions_sdk_v2_event_logs_proto_goTypes = []interface{}{
	(*ExecutionEvent)(nil),                    // 0: google.actions.sdk.v2.ExecutionEvent
	(*ExecutionState)(nil),                    // 1: google.actions.sdk.v2.ExecutionState
	(*Slots)(nil),                             // 2: google.actions.sdk.v2.Slots
	(*UserConversationInput)(nil),             // 3: google.actions.sdk.v2.UserConversationInput
	(*IntentMatch)(nil),                       // 4: google.actions.sdk.v2.IntentMatch
	(*ConditionsEvaluated)(nil),               // 5: google.actions.sdk.v2.ConditionsEvaluated
	(*Condition)(nil),                         // 6: google.actions.sdk.v2.Condition
	(*OnSceneEnter)(nil),                      // 7: google.actions.sdk.v2.OnSceneEnter
	(*WebhookInitiatedTransition)(nil),        // 8: google.actions.sdk.v2.WebhookInitiatedTransition
	(*WebhookRequest)(nil),                    // 9: google.actions.sdk.v2.WebhookRequest
	(*WebhookResponse)(nil),                   // 10: google.actions.sdk.v2.WebhookResponse
	(*SlotMatch)(nil),                         // 11: google.actions.sdk.v2.SlotMatch
	(*SlotRequested)(nil),                     // 12: google.actions.sdk.v2.SlotRequested
	(*SlotValidated)(nil),                     // 13: google.actions.sdk.v2.SlotValidated
	(*FormFilled)(nil),                        // 14: google.actions.sdk.v2.FormFilled
	(*WaitingForUserInput)(nil),               // 15: google.actions.sdk.v2.WaitingForUserInput
	(*EndConversation)(nil),                   // 16: google.actions.sdk.v2.EndConversation
	nil,                                       // 17: google.actions.sdk.v2.Slots.SlotsEntry
	nil,                                       // 18: google.actions.sdk.v2.IntentMatch.IntentParametersEntry
	nil,                                       // 19: google.actions.sdk.v2.SlotMatch.NluParametersEntry
	(*timestamppb.Timestamp)(nil),             // 20: google.protobuf.Timestamp
	(*status.Status)(nil),                     // 21: google.rpc.Status
	(*structpb.Struct)(nil),                   // 22: google.protobuf.Struct
	(*conversation.Prompt)(nil),               // 23: google.actions.sdk.v2.conversation.Prompt
	(conversation.SlotFillingStatus)(0),       // 24: google.actions.sdk.v2.conversation.SlotFillingStatus
	(*conversation.Slot)(nil),                 // 25: google.actions.sdk.v2.conversation.Slot
	(*conversation.IntentParameterValue)(nil), // 26: google.actions.sdk.v2.conversation.IntentParameterValue
}
var file_google_actions_sdk_v2_event_logs_proto_depIdxs = []int32{
	20, // 0: google.actions.sdk.v2.ExecutionEvent.event_time:type_name -> google.protobuf.Timestamp
	1,  // 1: google.actions.sdk.v2.ExecutionEvent.execution_state:type_name -> google.actions.sdk.v2.ExecutionState
	21, // 2: google.actions.sdk.v2.ExecutionEvent.status:type_name -> google.rpc.Status
	3,  // 3: google.actions.sdk.v2.ExecutionEvent.user_input:type_name -> google.actions.sdk.v2.UserConversationInput
	4,  // 4: google.actions.sdk.v2.ExecutionEvent.intent_match:type_name -> google.actions.sdk.v2.IntentMatch
	5,  // 5: google.actions.sdk.v2.ExecutionEvent.conditions_evaluated:type_name -> google.actions.sdk.v2.ConditionsEvaluated
	7,  // 6: google.actions.sdk.v2.ExecutionEvent.on_scene_enter:type_name -> google.actions.sdk.v2.OnSceneEnter
	9,  // 7: google.actions.sdk.v2.ExecutionEvent.webhook_request:type_name -> google.actions.sdk.v2.WebhookRequest
	10, // 8: google.actions.sdk.v2.ExecutionEvent.webhook_response:type_name -> google.actions.sdk.v2.WebhookResponse
	8,  // 9: google.actions.sdk.v2.ExecutionEvent.webhook_initiated_transition:type_name -> google.actions.sdk.v2.WebhookInitiatedTransition
	11, // 10: google.actions.sdk.v2.ExecutionEvent.slot_match:type_name -> google.actions.sdk.v2.SlotMatch
	12, // 11: google.actions.sdk.v2.ExecutionEvent.slot_requested:type_name -> google.actions.sdk.v2.SlotRequested
	13, // 12: google.actions.sdk.v2.ExecutionEvent.slot_validated:type_name -> google.actions.sdk.v2.SlotValidated
	14, // 13: google.actions.sdk.v2.ExecutionEvent.form_filled:type_name -> google.actions.sdk.v2.FormFilled
	15, // 14: google.actions.sdk.v2.ExecutionEvent.waiting_user_input:type_name -> google.actions.sdk.v2.WaitingForUserInput
	16, // 15: google.actions.sdk.v2.ExecutionEvent.end_conversation:type_name -> google.actions.sdk.v2.EndConversation
	22, // 16: google.actions.sdk.v2.ExecutionState.session_storage:type_name -> google.protobuf.Struct
	2,  // 17: google.actions.sdk.v2.ExecutionState.slots:type_name -> google.actions.sdk.v2.Slots
	23, // 18: google.actions.sdk.v2.ExecutionState.prompt_queue:type_name -> google.actions.sdk.v2.conversation.Prompt
	22, // 19: google.actions.sdk.v2.ExecutionState.user_storage:type_name -> google.protobuf.Struct
	22, // 20: google.actions.sdk.v2.ExecutionState.household_storage:type_name -> google.protobuf.Struct
	24, // 21: google.actions.sdk.v2.Slots.status:type_name -> google.actions.sdk.v2.conversation.SlotFillingStatus
	17, // 22: google.actions.sdk.v2.Slots.slots:type_name -> google.actions.sdk.v2.Slots.SlotsEntry
	18, // 23: google.actions.sdk.v2.IntentMatch.intent_parameters:type_name -> google.actions.sdk.v2.IntentMatch.IntentParametersEntry
	6,  // 24: google.actions.sdk.v2.ConditionsEvaluated.failed_conditions:type_name -> google.actions.sdk.v2.Condition
	6,  // 25: google.actions.sdk.v2.ConditionsEvaluated.success_condition:type_name -> google.actions.sdk.v2.Condition
	19, // 26: google.actions.sdk.v2.SlotMatch.nlu_parameters:type_name -> google.actions.sdk.v2.SlotMatch.NluParametersEntry
	23, // 27: google.actions.sdk.v2.SlotRequested.prompt:type_name -> google.actions.sdk.v2.conversation.Prompt
	25, // 28: google.actions.sdk.v2.Slots.SlotsEntry.value:type_name -> google.actions.sdk.v2.conversation.Slot
	26, // 29: google.actions.sdk.v2.IntentMatch.IntentParametersEntry.value:type_name -> google.actions.sdk.v2.conversation.IntentParameterValue
	26, // 30: google.actions.sdk.v2.SlotMatch.NluParametersEntry.value:type_name -> google.actions.sdk.v2.conversation.IntentParameterValue
	31, // [31:31] is the sub-list for method output_type
	31, // [31:31] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_google_actions_sdk_v2_event_logs_proto_init() }
func file_google_actions_sdk_v2_event_logs_proto_init() {
	if File_google_actions_sdk_v2_event_logs_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Slots); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserConversationInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntentMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConditionsEvaluated); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Condition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OnSceneEnter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebhookInitiatedTransition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebhookRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WebhookResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SlotMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SlotRequested); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SlotValidated); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FormFilled); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WaitingForUserInput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_event_logs_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EndConversation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_actions_sdk_v2_event_logs_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*ExecutionEvent_UserInput)(nil),
		(*ExecutionEvent_IntentMatch)(nil),
		(*ExecutionEvent_ConditionsEvaluated)(nil),
		(*ExecutionEvent_OnSceneEnter)(nil),
		(*ExecutionEvent_WebhookRequest)(nil),
		(*ExecutionEvent_WebhookResponse)(nil),
		(*ExecutionEvent_WebhookInitiatedTransition)(nil),
		(*ExecutionEvent_SlotMatch)(nil),
		(*ExecutionEvent_SlotRequested)(nil),
		(*ExecutionEvent_SlotValidated)(nil),
		(*ExecutionEvent_FormFilled)(nil),
		(*ExecutionEvent_WaitingUserInput)(nil),
		(*ExecutionEvent_EndConversation)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_event_logs_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_actions_sdk_v2_event_logs_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_event_logs_proto_depIdxs,
		MessageInfos:      file_google_actions_sdk_v2_event_logs_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_event_logs_proto = out.File
	file_google_actions_sdk_v2_event_logs_proto_rawDesc = nil
	file_google_actions_sdk_v2_event_logs_proto_goTypes = nil
	file_google_actions_sdk_v2_event_logs_proto_depIdxs = nil
}
