/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ur extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "\u0641\u062c\u06cc";
        final String metaValue_MD = "\u0645\u0627\u0644\u062f\u0648\u0648\u0627";
        final String metaValue_TR = "\u062a\u0631\u06a9\u06cc";
        final String metaValue_ar = "\u0639\u0631\u0628\u06cc";
        final String metaValue_bo = "\u062a\u0628\u062a\u06cc";
        final String metaValue_el = "\u06cc\u0648\u0646\u0627\u0646\u06cc";
        final String metaValue_gu = "\u06af\u062c\u0631\u0627\u062a\u06cc";
        final String metaValue_he = "\u0639\u0628\u0631\u0627\u0646\u06cc";
        final String metaValue_hy = "\u0622\u0631\u0645\u06cc\u0646\u06cc\u0627\u0626\u06cc";
        final String metaValue_ja = "\u062c\u0627\u067e\u0627\u0646\u06cc";
        final String metaValue_ka = "\u062c\u0627\u0631\u062c\u06cc\u0627\u0626\u06cc";
        final String metaValue_km = "\u062e\u0645\u06cc\u0631";
        final String metaValue_ko = "\u06a9\u0648\u0631\u06cc\u0627\u0626\u06cc";
        final String metaValue_la = "\u0644\u0627\u0637\u06cc\u0646\u06cc";
        final String metaValue_lo = "\u0644\u0627\u0624";
        final String metaValue_or = "\u0627\u0691\u06cc\u06c1";
        final String metaValue_si = "\u0633\u0646\u06c1\u0627\u0644\u0627";
        final String metaValue_ta = "\u062a\u0645\u0644";
        final String metaValue_te = "\u062a\u06cc\u0644\u06af\u0648";
        final String metaValue_th = "\u062a\u06be\u0627\u0626\u06cc";
        final Object[][] data = new Object[][] {
            { "ksh", "\u06a9\u0648\u0644\u0648\u06af\u0646\u06cc\u0627\u0626\u06cc" },
            { "mwl", "\u0645\u06cc\u0631\u0627\u0646\u0688\u06cc\u0632" },
            { "Zsym", "\u0639\u0644\u0627\u0645\u0627\u062a" },
            { "Zsye", "\u0627\u06cc\u0645\u0648\u062c\u06cc" },
            { "ccp", "\u0686\u06a9\u0645\u06c1" },
            { "tem", "\u0679\u0645\u0646\u06d2" },
            { "teo", "\u062a\u06cc\u0633\u0648" },
            { "rap", "\u0631\u067e\u0627\u0646\u0648\u06cc" },
            { "AC", "\u0627\u0633\u06cc\u0646\u0634\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688" },
            { "rar", "\u0631\u0627\u0631\u0648\u062a\u0648\u0646\u06af\u0627\u0646" },
            { "tet", "\u0679\u06cc\u0679\u0645" },
            { "AD", "\u0627\u0646\u0688\u0648\u0631\u0627" },
            { "AE", "\u0645\u062a\u062d\u062f\u06c1 \u0639\u0631\u0628 \u0627\u0645\u0627\u0631\u0627\u062a" },
            { "nl_BE", "\u0641\u0644\u06cc\u0645\u0650\u0634" },
            { "AF", "\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "AG", "\u0627\u0646\u0679\u06cc\u06af\u0648\u0627 \u0627\u0648\u0631 \u0628\u0627\u0631\u0628\u0648\u062f\u0627" },
            { "type.ca.ethiopic", "\u0627\u06cc\u062a\u06be\u0648\u067e\u06cc\u0627\u0626\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "AI", "\u0627\u0646\u06af\u0648\u0626\u06cc\u0644\u0627" },
            { "key.tz", "\u0645\u0646\u0637\u0642\u06c2 \u0648\u0642\u062a" },
            { "AL", "\u0627\u0644\u0628\u0627\u0646\u06cc\u06c1" },
            { "AM", "\u0622\u0631\u0645\u06cc\u0646\u06cc\u0627" },
            { "AO", "\u0627\u0646\u06af\u0648\u0644\u0627" },
            { "AQ", "\u0627\u0646\u0679\u0627\u0631\u06a9\u0679\u06cc\u06a9\u0627" },
            { "AR", "\u0627\u0631\u062c\u0646\u0679\u06cc\u0646\u0627" },
            { "AS", "\u0627\u0645\u0631\u06cc\u06a9\u06cc \u0633\u0627\u0645\u0648\u0622" },
            { "AT", "\u0622\u0633\u0679\u0631\u06cc\u0627" },
            { "AU", "\u0622\u0633\u0679\u0631\u06cc\u0644\u06cc\u0627" },
            { "AW", "\u0627\u0631\u0648\u0628\u0627" },
            { "en_US", "\u0627\u0645\u0631\u06cc\u06a9\u06cc \u0627\u0646\u06af\u0631\u06cc\u0632\u06cc" },
            { "AX", "\u0622\u0644\u06cc\u0646\u0688 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "AZ", "\u0622\u0630\u0631\u0628\u0627\u0626\u06cc\u062c\u0627\u0646" },
            { "BA", "\u0628\u0648\u0633\u0646\u06cc\u0627 \u0627\u0648\u0631 \u06c1\u0631\u0632\u06cc\u06af\u0648\u0648\u06cc\u0646\u0627" },
            { "BB", "\u0628\u0627\u0631\u0628\u0627\u0688\u0648\u0633" },
            { "ceb", "\u0633\u06cc\u0628\u0648\u0622\u0646\u0648" },
            { "BD", "\u0628\u0646\u06af\u0644\u06c1 \u062f\u06cc\u0634" },
            { "kum", "\u06a9\u0648\u0645\u06cc\u06a9" },
            { "BE", "\u0628\u06cc\u0644\u062c\u06cc\u0645" },
            { "BF", "\u0628\u0631\u06a9\u06cc\u0646\u0627 \u0641\u0627\u0633\u0648" },
            { "BG", "\u0628\u0644\u063a\u0627\u0631\u06cc\u06c1" },
            { "BH", "\u0628\u062d\u0631\u06cc\u0646" },
            { "BI", "\u0628\u0631\u0648\u0646\u0688\u06cc" },
            { "BJ", "\u0628\u06cc\u0646\u0646" },
            { "BL", "\u0633\u06cc\u0646\u0679 \u0628\u0631\u062a\u06be\u0644\u06cc\u0645\u06cc" },
            { "BM", "\u0628\u0631\u0645\u0648\u062f\u0627" },
            { "myv", "\u0627\u0631\u0632\u06cc\u0627" },
            { "BN", "\u0628\u0631\u0648\u0646\u0627\u0626\u06cc" },
            { "BO", "\u0628\u0648\u0644\u06cc\u0648\u06cc\u0627" },
            { "BQ", "\u06a9\u0631\u06cc\u0628\u06cc\u0627\u0626\u06cc \u0646\u06cc\u062f\u0631\u0644\u06cc\u0646\u0688\u0632" },
            { "BR", "\u0628\u0631\u0627\u0632\u06cc\u0644" },
            { "BS", "\u0628\u06c1\u0627\u0645\u0627\u0633" },
            { "xog", "\u0633\u0648\u06af\u0627" },
            { "BT", "\u0628\u06be\u0648\u0679\u0627\u0646" },
            { "BV", "\u0628\u0624\u0648\u06cc\u0679 \u0622\u0626\u0644\u06cc\u0646\u0688" },
            { "BW", "\u0628\u0648\u062a\u0633\u0648\u0627\u0646\u0627" },
            { "BY", "\u0628\u06cc\u0644\u0627\u0631\u0648\u0633" },
            { "BZ", "\u0628\u06cc\u0644\u0627\u0626\u0632" },
            { "type.ca.persian", "\u0641\u0627\u0631\u0633\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "type.nu.hebr", "\u0639\u0628\u0631\u0627\u0646\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "CA", "\u06a9\u06cc\u0646\u06cc\u0688\u0627" },
            { "CC", "\u06a9\u0648\u06a9\u0648\u0633 (\u06a9\u06cc\u0644\u0646\u06af) \u062c\u0632\u0627\u0626\u0631" },
            { "mzn", "\u0645\u0632\u0646\u062f\u0631\u0627\u0646\u06cc" },
            { "CD", "\u06a9\u0627\u0646\u06af\u0648 - \u06a9\u0646\u0634\u0627\u0633\u0627" },
            { "CF", "\u0648\u0633\u0637 \u0627\u0641\u0631\u06cc\u0642\u06cc \u062c\u0645\u06c1\u0648\u0631\u06cc\u06c1" },
            { "CG", "\u06a9\u0627\u0646\u06af\u0648 - \u0628\u0631\u0627\u0632\u0627\u0648\u06cc\u0644\u06d2" },
            { "CH", "\u0633\u0648\u0626\u0679\u0632\u0631 \u0644\u06cc\u0646\u0688" },
            { "CI", "\u06a9\u0648\u0679 \u0688\u06cc \u0622\u0626\u06cc\u0648\u0631\u06cc" },
            { "CK", "\u06a9\u06a9 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "CL", "\u0686\u0644\u06cc" },
            { "CM", "\u06a9\u06cc\u0645\u0631\u0648\u0646" },
            { "CN", "\u0686\u06cc\u0646" },
            { "CO", "\u06a9\u0648\u0644\u0645\u0628\u06cc\u0627" },
            { "CP", "\u06a9\u0644\u067e\u0631\u0679\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688" },
            { "CR", "\u06a9\u0648\u0633\u0679\u0627 \u0631\u06cc\u06a9\u0627" },
            { "CU", "\u06a9\u06cc\u0648\u0628\u0627" },
            { "CV", "\u06a9\u06cc\u067e \u0648\u0631\u0688\u06cc" },
            { "CW", "\u06a9\u06cc\u0648\u0631\u0627\u06a9\u0627\u0624" },
            { "CX", "\u062c\u0632\u06cc\u0631\u06c1 \u06a9\u0631\u0633\u0645\u0633" },
            { "CY", "\u0642\u0628\u0631\u0635" },
            { "CZ", "\u0686\u06cc\u06a9\u06cc\u0627" },
            { "eka", "\u0627\u06cc\u06a9\u0627\u062c\u0648\u06cc" },
            { "DE", "\u062c\u0631\u0645\u0646\u06cc" },
            { "ace", "\u0627\u0686\u0627\u0626\u06cc\u0646\u06cc\u0632" },
            { "cgg", "\u0686\u06cc\u06af\u0627" },
            { "DG", "\u0688\u0627\u0626\u062c\u0648 \u06af\u0627\u0631\u0633\u06cc\u0627" },
            { "type.nu.deva", "\u062f\u06cc\u0648\u0646\u0627\u06af\u0631\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "DJ", "\u062c\u0628\u0648\u062a\u06cc" },
            { "DK", "\u0688\u0646\u0645\u0627\u0631\u06a9" },
            { "ach", "\u0627\u06a9\u0648\u0644\u06cc" },
            { "Brai", "\u0628\u0631\u06cc\u0644" },
            { "DM", "\u0688\u0648\u0645\u0646\u06cc\u06a9\u0627" },
            { "type.nu.armnlow", "\u0622\u0631\u0645\u06cc\u0646\u06cc\u0627\u0626\u06cc \u0632\u06cc\u0631\u06cc\u06ba \u0627\u0639\u062f\u0627\u062f" },
            { "DO", "\u062c\u0645\u06c1\u0648\u0631\u06cc\u06c1 \u0688\u0648\u0645\u064a\u0646\u064a\u06a9\u0646" },
            { "gor", "\u06af\u0648\u0631\u0627\u0646\u0679\u0627\u0644\u0648" },
            { "zun", "\u0632\u0648\u0646\u06cc" },
            { "tig", "\u0679\u06af\u0631\u06d2" },
            { "DZ", "\u0627\u0644\u062c\u06cc\u0631\u06cc\u0627" },
            { "pag", "\u067e\u0646\u06af\u0627\u0633\u0646\u0627\u0646" },
            { "type.d0.hwidth", "\u0646\u0635\u0641 \u0639\u0631\u0636" },
            { "EA", "\u0633\u06cc\u0626\u0648\u0679\u0627 \u0627\u0648\u0631 \u0645\u06cc\u0644\u06cc\u0644\u0627" },
            { "pam", "\u067e\u0627\u0645\u067e\u0646\u06af\u0627" },
            { "EC", "\u0627\u06cc\u06a9\u0648\u0627\u0688\u0648\u0631" },
            { "pap", "\u067e\u0627\u067e\u06cc\u0627\u0645\u06cc\u0646\u0679\u0648" },
            { "ada", "\u0627\u062f\u0627\u0646\u06af\u0645\u06d2" },
            { "EE", "\u0627\u0633\u0679\u0648\u0646\u06cc\u0627" },
            { "EG", "\u0645\u0635\u0631" },
            { "EH", "\u0645\u063a\u0631\u0628\u06cc \u0635\u062d\u0627\u0631\u0627" },
            { "pau", "\u067e\u0627\u0644\u0627\u0648\u0646" },
            { "chk", "\u0686\u0648\u06a9\u06cc\u0632" },
            { "chm", "\u0645\u0627\u0631\u06cc" },
            { "cho", "\u0686\u0627\u06a9\u0679\u0627\u0624" },
            { "chr", "\u0686\u06cc\u0631\u0648\u06a9\u06cc" },
            { "ER", "\u0627\u0631\u06cc\u0679\u06cc\u0631\u06cc\u0627" },
            { "ES", "\u06c1\u0633\u067e\u0627\u0646\u06cc\u06c1" },
            { "ET", "\u0627\u06cc\u062a\u06be\u0648\u067e\u06cc\u0627" },
            { "EU", "\u06cc\u0648\u0631\u0648\u067e\u06cc \u06cc\u0648\u0646\u06cc\u0646" },
            { "type.ca.gregorian", "\u062c\u0627\u0631\u062c\u06cc\u0627\u0626\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "EZ", "\u06cc\u0648\u0631\u0648\u0632\u0648\u0646" },
            { "chy", "\u0686\u06cc\u0646\u0651\u06d2" },
            { "type.nu.gujr", "\u06af\u062c\u0631\u0627\u062a\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "ady", "\u0627\u062f\u06cc\u06af\u06be\u06d2" },
            { "FI", "\u0641\u0646 \u0644\u06cc\u0646\u0688" },
            { "FJ", metaValue_FJ },
            { "FK", "\u0641\u0627\u06a9\u0644\u06cc\u0646\u0688 \u062c\u0632\u0627\u0626\u0631" },
            { "FM", "\u0645\u0627\u0626\u06a9\u0631\u0648\u0646\u06cc\u0634\u06cc\u0627" },
            { "key.va", "\u0645\u0642\u0627\u0645 \u06a9\u0627 \u0645\u062a\u063a\u06cc\u0631\u06c1" },
            { "FO", "\u062c\u0632\u0627\u0626\u0631 \u0641\u0627\u0631\u0648" },
            { "Taml", metaValue_ta },
            { "FR", "\u0641\u0631\u0627\u0646\u0633" },
            { "type.ca.indian", "\u06c1\u0646\u062f\u0648\u0633\u062a\u0627\u0646\u06cc \u0642\u0648\u0645\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "GA", "\u06af\u06cc\u0628\u0648\u0646" },
            { "GB", "\u0633\u0644\u0637\u0646\u062a \u0645\u062a\u062d\u062f\u06c1" },
            { "pcm", "\u0646\u0627\u0626\u062c\u06cc\u0631\u06cc\u0627\u0626\u06cc \u067e\u0688\u06af\u0646" },
            { "GD", "\u06af\u0631\u06cc\u0646\u0627\u0688\u0627" },
            { "GE", "\u062c\u0627\u0631\u062c\u06cc\u0627" },
            { "GF", "\u0641\u0631\u06cc\u0646\u0686 \u06af\u06cc\u0627\u0646\u0627" },
            { "GG", "\u06af\u0648\u0626\u0631\u0646\u0633\u06cc" },
            { "GH", "\u06af\u06be\u0627\u0646\u0627" },
            { "GI", "\u062c\u0628\u0644 \u0627\u0644\u0637\u0627\u0631\u0642" },
            { "GL", "\u06af\u0631\u06cc\u0646 \u0644\u06cc\u0646\u0688" },
            { "GM", "\u06af\u06cc\u0645\u0628\u06cc\u0627" },
            { "GN", "\u06af\u0646\u06cc" },
            { "GP", "\u06af\u0648\u0627\u0688\u06cc\u0644\u0648\u067e" },
            { "GQ", "\u0627\u0633\u062a\u0648\u0627\u0626\u06cc \u06af\u06cc\u0627\u0646\u0627" },
            { "GR", "\u06cc\u0648\u0646\u0627\u0646" },
            { "GS", "\u062c\u0646\u0648\u0628\u06cc \u062c\u0627\u0631\u062c\u06cc\u0627 \u0627\u0648\u0631 \u062c\u0646\u0648\u0628\u06cc \u0633\u06cc\u0646\u0688\u0648\u0686 \u062c\u0632\u0627\u0626\u0631" },
            { "GT", "\u06af\u0648\u0627\u0679\u06d2 \u0645\u0627\u0644\u0627" },
            { "GU", "\u06af\u0648\u0627\u0645" },
            { "GW", "\u06af\u0646\u06cc \u0628\u0633\u0627\u0624" },
            { "tlh", "\u06a9\u0644\u0646\u06af\u0646" },
            { "GY", "\u06af\u06cc\u0627\u0646\u0627" },
            { "ckb", "\u0633\u06cc\u0646\u0679\u0631\u0644 \u06a9\u0631\u062f\u0634" },
            { "zxx", "\u06a9\u0648\u0626\u06cc \u0644\u0633\u0627\u0646\u06cc \u0645\u0648\u0627\u062f \u0646\u06c1\u06cc\u06ba" },
            { "de_AT", "\u0622\u0633\u0679\u0631\u06cc\u0627\u0626\u06cc \u062c\u0631\u0645\u0646" },
            { "HK", "\u06c1\u0627\u0646\u06af \u06a9\u0627\u0646\u06af SAR \u0686\u06cc\u0646" },
            { "HM", "\u06c1\u06cc\u0631\u0688 \u062c\u0632\u06cc\u0631\u06c1 \u0648 \u0645\u06cc\u06a9\u0688\u0648\u0644\u06cc\u0646\u0688 \u062c\u0632\u0627\u0626\u0631" },
            { "HN", "\u06c1\u0648\u0646\u0688\u0627\u0631\u0648\u0633" },
            { "HR", "\u06a9\u0631\u0648\u0634\u06cc\u0627" },
            { "agq", "\u0627\u063a\u0645" },
            { "gsw", "\u0633\u0648\u0626\u0633 \u062c\u0631\u0645\u0646" },
            { "type.ca.islamic-umalqura", "\u0627\u0633\u0644\u0627\u0645\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631 (\u0627\u0645 \u0627\u0644\u0642\u0631\u0627\u06c1)" },
            { "HT", "\u06c1\u06cc\u0679\u06cc" },
            { "HU", "\u06c1\u0646\u06af\u0631\u06cc" },
            { "IC", "\u06a9\u06cc\u0646\u0631\u06cc \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "ID", "\u0627\u0646\u0688\u0648\u0646\u06cc\u0634\u06cc\u0627" },
            { "IE", "\u0622\u0626\u0631\u0644\u06cc\u0646\u0688" },
            { "nap", "\u0646\u06cc\u0627\u067e\u0648\u0644\u06cc\u0679\u0646" },
            { "naq", "\u0646\u0627\u0645\u0627" },
            { "zza", "\u0632\u0627\u0632\u0627" },
            { "IL", "\u0627\u0633\u0631\u0627\u0626\u06cc\u0644" },
            { "IM", "\u0622\u0626\u0644 \u0622\u0641 \u0645\u06cc\u0646" },
            { "IN", "\u0628\u06be\u0627\u0631\u062a" },
            { "type.co.eor", "\u06cc\u0648\u0631\u067e\u06cc \u062a\u0631\u062a\u06cc\u0628\u06cc \u0642\u0648\u0627\u0646\u06cc\u0646" },
            { "IO", "\u0628\u0631\u0637\u0627\u0646\u0648\u06cc \u0628\u062d\u0631 \u06c1\u0646\u062f \u06a9\u0627 \u0639\u0644\u0627\u0642\u06c1" },
            { "IQ", "\u0639\u0631\u0627\u0642" },
            { "IR", "\u0627\u06cc\u0631\u0627\u0646" },
            { "IS", "\u0622\u0626\u0633 \u0644\u06cc\u0646\u0688" },
            { "IT", "\u0627\u0679\u0644\u06cc" },
            { "Zmth", "\u0631\u06cc\u0627\u0636\u06cc \u06a9\u06cc \u0639\u0644\u0627\u0645\u062a\u06cc\u06ba" },
            { "type.nu.thai", "\u062a\u06be\u0627\u0626\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "type.nu.beng", "\u0628\u0646\u06af\u0627\u0644\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "JE", "\u062c\u0631\u0633\u06cc" },
            { "type.ca.islamic", "\u0627\u0633\u0644\u0627\u0645\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "JM", "\u062c\u0645\u0627\u0626\u06cc\u06a9\u0627" },
            { "Beng", "\u0628\u0646\u06af\u0627\u0644\u06cc" },
            { "JO", "\u0627\u0631\u062f\u0646" },
            { "JP", "\u062c\u0627\u067e\u0627\u0646" },
            { "ain", "\u0627\u06cc\u0646\u0648" },
            { "guz", "\u06af\u0633\u06cc" },
            { "type.nu.knda", "\u06a9\u0646\u0691 \u06c1\u0646\u062f\u0633\u06d2" },
            { "de_CH", "\u0633\u0648\u0626\u0633 \u06c1\u0627\u0626\u06cc \u062c\u0631\u0645\u0646" },
            { "type.co.phonetic", "\u0635\u0648\u062a\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "type.ca.buddhist", "\u0628\u0648\u062f\u06be \u06a9\u0644\u06cc\u0646\u0688\u0631" },
            { "KE", "\u06a9\u06cc\u0646\u06cc\u0627" },
            { "419", "\u0644\u0627\u0637\u06cc\u0646\u06cc \u0627\u0645\u0631\u06cc\u06a9\u06c1" },
            { "KG", "\u06a9\u0631\u063a\u0632\u0633\u062a\u0627\u0646" },
            { "KH", "\u06a9\u0645\u0628\u0648\u0688\u06cc\u0627" },
            { "KI", "\u06a9\u0631\u06cc\u0628\u0627\u062a\u06cc" },
            { "KM", "\u06a9\u0648\u0645\u0648\u0631\u0648\u0633" },
            { "KN", "\u0633\u06cc\u0646\u0679 \u06a9\u0679\u0633 \u0627\u0648\u0631 \u0646\u06cc\u0648\u06cc\u0633" },
            { "Knda", "\u06a9\u0646\u0691" },
            { "fr_CA", "\u06a9\u06cc\u0646\u06cc\u0688\u06cc\u0646 \u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc" },
            { "KP", "\u0634\u0645\u0627\u0644\u06cc \u06a9\u0648\u0631\u06cc\u0627" },
            { "KR", "\u062c\u0646\u0648\u0628\u06cc \u06a9\u0648\u0631\u06cc\u0627" },
            { "fr_CH", "\u0633\u0648\u0626\u0633 \u0641\u0631\u06cc\u0646\u0686" },
            { "KW", "\u06a9\u0648\u06cc\u062a" },
            { "tpi", "\u0679\u0648\u06a9 \u067e\u0650\u0633\u0650\u0646" },
            { "KY", "\u06a9\u06cc\u0645\u06cc\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "KZ", "\u0642\u0632\u0627\u062e\u0633\u062a\u0627\u0646" },
            { "Cyrl", "\u0633\u06cc\u0631\u06cc\u0644\u06a9" },
            { "LA", "\u0644\u0627\u0624\u0633" },
            { "LB", "\u0644\u0628\u0646\u0627\u0646" },
            { "LC", "\u0633\u06cc\u0646\u0679 \u0644\u0648\u0633\u06cc\u0627" },
            { "gwi", "\u06af\u0648\u0626\u0686 \u0627\u0646" },
            { "nds", "\u0627\u062f\u0646\u06cc \u062c\u0631\u0645\u0646" },
            { "LI", "\u0644\u06cc\u0634\u0679\u0646\u0633\u0679\u0627\u0626\u0646" },
            { "LK", "\u0633\u0631\u06cc \u0644\u0646\u06a9\u0627" },
            { "LR", "\u0644\u0627\u0626\u0628\u06cc\u0631\u06cc\u0627" },
            { "LS", "\u0644\u06cc\u0633\u0648\u062a\u06be\u0648" },
            { "LT", "\u0644\u06cc\u062a\u06be\u0648\u0646\u06cc\u0627" },
            { "LU", "\u0644\u06a9\u0633\u0645\u0628\u0631\u06af" },
            { "LV", "\u0644\u0679\u0648\u06cc\u0627" },
            { "Kana", "\u06a9\u0679\u0627\u06a9\u0627\u0646\u0627" },
            { "LY", "\u0644\u06cc\u0628\u06cc\u0627" },
            { "lad", "\u0644\u06cc\u0688\u06cc\u0646\u0648" },
            { "vun", "\u0648\u0646\u062c\u0648" },
            { "lag", "\u0644\u0627\u0646\u06af\u06cc" },
            { "Thaa", "\u062a\u06be\u0627\u0646\u0627" },
            { "MA", "\u0645\u0631\u0627\u06a9\u0634" },
            { "MC", "\u0645\u0648\u0646\u0627\u06a9\u0648" },
            { "MD", metaValue_MD },
            { "ME", "\u0645\u0648\u0646\u0679\u06d2 \u0646\u06cc\u06af\u0631\u0648" },
            { "MF", "\u0633\u06cc\u0646\u0679 \u0645\u0627\u0631\u0679\u0646" },
            { "MG", "\u0645\u0688\u063a\u0627\u0633\u06a9\u0631" },
            { "Thai", metaValue_th },
            { "MH", "\u0645\u0627\u0631\u0634\u0644 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "ale", "\u0627\u0644\u06cc\u0648\u062a" },
            { "type.nu.vaii", "\u0648\u0627\u0626\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "MK", "\u0634\u0645\u0627\u0644\u06cc \u0645\u0642\u062f\u0648\u0646\u06cc\u06c1" },
            { "ML", "\u0645\u0627\u0644\u06cc" },
            { "MM", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631 (\u0628\u0631\u0645\u0627)" },
            { "MN", "\u0645\u0646\u06af\u0648\u0644\u06cc\u0627" },
            { "new", "\u0646\u06cc\u0648\u0627\u0631\u06cc" },
            { "MO", "\u0645\u06a9\u0627\u0624 SAR \u0686\u06cc\u0646" },
            { "MP", "\u0634\u0645\u0627\u0644\u06cc \u0645\u0627\u0631\u06cc\u0627\u0646\u0627 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "MQ", "\u0645\u0627\u0631\u0679\u06cc\u0646\u06a9" },
            { "MR", "\u0645\u0648\u0631\u06cc\u0637\u0627\u0646\u06cc\u06c1" },
            { "MS", "\u0645\u0648\u0646\u0679\u0633\u06cc\u0631\u0627\u0679" },
            { "MT", "\u0645\u0627\u0644\u0679\u0627" },
            { "type.m0.ungegn", "UN GEGN \u0679\u0631\u0627\u0646\u0633\u0644\u0679\u0631\u06cc\u0634\u0646" },
            { "MU", "\u0645\u0627\u0631\u06cc\u0634\u0633" },
            { "alt", "\u062c\u0646\u0648\u0628\u06cc \u0627\u0644\u0679\u0627\u0626\u06cc" },
            { "MV", "\u0645\u0627\u0644\u062f\u06cc\u067e" },
            { "MW", "\u0645\u0644\u0627\u0648\u06cc" },
            { "MX", "\u0645\u06cc\u06a9\u0633\u06cc\u06a9\u0648" },
            { "type.ca.japanese", "\u062c\u0627\u067e\u0627\u0646\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "MY", "\u0645\u0644\u0627\u0626\u0634\u06cc\u0627" },
            { "MZ", "\u0645\u0648\u0632\u0645\u0628\u06cc\u0642" },
            { "NA", "\u0646\u0627\u0645\u06cc\u0628\u06cc\u0627" },
            { "202", "\u0630\u06cc\u0644\u06cc \u0635\u062d\u0627\u0631\u0646 \u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "type.ca.hebrew", "\u0639\u0628\u0631\u0627\u0646\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "type.co.dictionary", "\u0644\u063a\u062a \u06a9\u06cc \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "NC", "\u0646\u06cc\u0648 \u06a9\u0644\u06cc\u0688\u0648\u0646\u06cc\u0627" },
            { "NE", "\u0646\u0627\u0626\u062c\u0631" },
            { "NF", "\u0646\u0627\u0631\u0641\u0648\u06a9 \u0622\u0626\u0644\u06cc\u0646\u0688" },
            { "NG", "\u0646\u0627\u0626\u062c\u06cc\u0631\u06cc\u0627" },
            { "trv", "\u0679\u0648\u0631\u0648\u06a9\u0648" },
            { "NI", "\u0646\u06a9\u0627\u0631\u0627\u06af\u0648\u0648\u0627" },
            { "NL", "\u0646\u06cc\u062f\u0631 \u0644\u06cc\u0646\u0688\u0632" },
            { "NO", "\u0646\u0627\u0631\u0648\u06d2" },
            { "NP", "\u0646\u06cc\u067e\u0627\u0644" },
            { "NR", "\u0646\u0624\u0631\u0648" },
            { "NU", "\u0646\u06cc\u0626\u0648" },
            { "rof", "\u0631\u0648\u0645\u0628\u0648" },
            { "NZ", "\u0646\u06cc\u0648\u0632\u06cc \u0644\u06cc\u0646\u0688" },
            { "OM", "\u0639\u0645\u0627\u0646" },
            { "anp", "\u0627\u0646\u06af\u06cc\u06a9\u0627" },
            { "crs", "\u0633\u06cc\u0633\u0644\u0648\u0627 \u06a9\u0631\u06cc\u0648\u0644\u06d2 \u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc" },
            { "PA", "\u067e\u0627\u0646\u0627\u0645\u06c1" },
            { "type.ca.islamic-civil", "\u0627\u0633\u0644\u0627\u0645\u06cc \u0634\u06c1\u0631\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "en_GB", "\u0628\u0631\u0637\u0627\u0646\u0648\u06cc \u0627\u0646\u06af\u0631\u06cc\u0632\u06cc" },
            { "PE", "\u067e\u06cc\u0631\u0648" },
            { "PF", "\u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc \u067e\u0648\u0644\u06cc\u0646\u06cc\u0634\u06cc\u0627" },
            { "PG", "\u067e\u0627\u067e\u0648\u0622 \u0646\u06cc\u0648 \u06af\u0646\u06cc" },
            { "PH", "\u0641\u0644\u067e\u0627\u0626\u0646" },
            { "PK", "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646" },
            { "PL", "\u067e\u0648\u0644\u06cc\u0646\u0688" },
            { "ewo", "\u0627\u06cc\u0648\u0627\u0646\u0688\u0648" },
            { "PM", "\u0633\u06cc\u0646\u0679 \u067e\u06cc\u0626\u0631 \u0627\u0648\u0631 \u0645\u06cc\u06a9\u0644\u06cc\u0626\u0648\u0646" },
            { "PN", "\u067e\u0679\u06a9\u0627\u0626\u0631\u0646 \u062c\u0632\u0627\u0626\u0631" },
            { "PR", "\u067e\u06cc\u0648\u0631\u0679\u0648 \u0631\u06cc\u06a9\u0648" },
            { "PS", "\u0641\u0644\u0633\u0637\u06cc\u0646\u06cc \u062e\u0637\u06d2" },
            { "PT", "\u067e\u0631\u062a\u06af\u0627\u0644" },
            { "PW", "\u067e\u0644\u0627\u0624" },
            { "nia", "\u0646\u06cc\u0627\u0633" },
            { "type.nu.greklow", "\u06cc\u0648\u0646\u0627\u0646\u06cc \u0632\u06cc\u0631\u06cc\u06ba \u0627\u0639\u062f\u0627\u062f" },
            { "PY", "\u067e\u06cc\u0631\u0627\u06af\u0648\u0626\u06d2" },
            { "tum", "\u0679\u0645\u0628\u0648\u06a9\u0627" },
            { "Hebr", metaValue_he },
            { "QA", "\u0642\u0637\u0631" },
            { "niu", "\u0646\u06cc\u0648\u06cc\u0627\u0626\u06cc" },
            { "QO", "\u0628\u06cc\u0631\u0648\u0646\u06cc \u0627\u0648\u0634\u06cc\u0627\u0646\u06cc\u0627" },
            { "lez", "\u0644\u06cc\u0632\u06af\u06cc\u0627\u0646" },
            { "tvl", "\u062a\u0648\u0648\u0627\u0644\u0648" },
            { "001", "\u062f\u0646\u06cc\u0627" },
            { "002", "\u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "003", "\u0634\u0645\u0627\u0644\u06cc \u0627\u0645\u0631\u06cc\u06a9\u06c1" },
            { "RE", "\u0631\u06cc \u06cc\u0648\u0646\u06cc\u0646" },
            { "005", "\u062c\u0646\u0648\u0628\u06cc \u0627\u0645\u0631\u06cc\u06a9\u06c1" },
            { "jbo", "\u0644\u0648\u062c\u0628\u0627\u0646" },
            { "009", "\u0627\u0648\u0634\u06cc\u0627\u0646\u06cc\u0627" },
            { "RO", "\u0631\u0648\u0645\u0627\u0646\u06cc\u06c1" },
            { "RS", "\u0633\u0631\u0628\u06cc\u0627" },
            { "RU", "\u0631\u0648\u0633" },
            { "RW", "\u0631\u0648\u0627\u0646\u0688\u0627" },
            { "SA", "\u0633\u0639\u0648\u062f\u06cc \u0639\u0631\u0628" },
            { "SB", "\u0633\u0648\u0644\u0648\u0645\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "twq", "\u062a\u0627\u0633\u0627\u0648\u0627\u0642" },
            { "011", "\u0645\u063a\u0631\u0628\u06cc \u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "SC", "\u0633\u0634\u0644\u06cc\u0632" },
            { "SD", "\u0633\u0648\u0688\u0627\u0646" },
            { "013", "\u0648\u0633\u0637\u06cc \u0627\u0645\u0631\u06cc\u06a9\u06c1" },
            { "SE", "\u0633\u0648\u06cc\u0688\u0646" },
            { "014", "\u0645\u0634\u0631\u0642\u06cc \u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "015", "\u0634\u0645\u0627\u0644\u06cc \u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "SG", "\u0633\u0646\u06af\u0627\u067e\u0648\u0631" },
            { "SH", "\u0633\u06cc\u0646\u0679 \u06c1\u06cc\u0644\u06cc\u0646\u0627" },
            { "type.lb.strict", "\u0633\u062e\u062a \u0644\u0627\u0626\u0646 \u0628\u0631\u06cc\u06a9 \u0627\u0646\u062f\u0627\u0632" },
            { "017", "\u0648\u0633\u0637\u06cc \u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "SI", "\u0633\u0644\u0648\u0648\u06cc\u0646\u06cc\u0627" },
            { "018", "\u062c\u0646\u0648\u0628\u06cc \u0627\u0641\u0631\u06cc\u0642\u06c1 \u06a9\u0627 \u0639\u0644\u0627\u0642\u06c1" },
            { "SJ", "\u0633\u0648\u0627\u0644\u0628\u0631\u0688 \u0627\u0648\u0631 \u062c\u0627\u0646 \u0645\u0627\u06cc\u0646" },
            { "019", "\u0627\u0645\u06cc\u0631\u06cc\u06a9\u0627\u0632" },
            { "SK", "\u0633\u0644\u0648\u0648\u0627\u06a9\u06cc\u06c1" },
            { "SL", "\u0633\u06cc\u0631\u0627\u0644\u06cc\u0648\u0646" },
            { "SM", "\u0633\u0627\u0646 \u0645\u0627\u0631\u06cc\u0646\u0648" },
            { "SN", "\u0633\u06cc\u0646\u06cc\u06af\u0644" },
            { "SO", "\u0635\u0648\u0645\u0627\u0644\u06cc\u06c1" },
            { "arn", "\u0645\u0627\u067e\u0648\u0686\u06d2" },
            { "arp", "\u0627\u0631\u0627\u067e\u0627\u06c1\u0648" },
            { "type.nu.taml", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u062a\u0645\u0644 \u0627\u0639\u062f\u0627\u062f" },
            { "SR", "\u0633\u0648\u0631\u06cc\u0646\u0627\u0645" },
            { "SS", "\u062c\u0646\u0648\u0628\u06cc \u0633\u0648\u0688\u0627\u0646" },
            { "ST", "\u0633\u0627\u0624 \u0679\u0648\u0645\u06d2 \u0627\u0648\u0631 \u067e\u0631\u0646\u0633\u067e\u06d2" },
            { "SV", "\u0627\u0644 \u0633\u0644\u0648\u0627\u0688\u0648\u0631" },
            { "SX", "\u0633\u0646\u0679 \u0645\u0627\u0631\u0679\u0646" },
            { "SY", "\u0634\u0627\u0645" },
            { "SZ", "\u0633\u0648\u0627\u062a\u0646\u06cc" },
            { "TA", "\u0679\u0631\u0633\u0679\u0646 \u0688\u0627 \u06a9\u06cc\u0648\u0646\u06c1\u0627" },
            { "asa", "\u0622\u0633\u0648" },
            { "type.ms.ussystem", "\u067e\u06cc\u0645\u0627\u0626\u0634 \u06a9\u0627 \u0627\u0645\u0631\u06cc\u06a9\u06cc \u0646\u0638\u0627\u0645" },
            { "021", "\u0634\u0645\u0627\u0644\u06cc \u0627\u0645\u0631\u06cc\u06a9\u06c1 \u06a9\u0627 \u0639\u0644\u0627\u0642\u06c1" },
            { "TC", "\u0679\u0631\u06a9\u0633 \u0627\u0648\u0631 \u06a9\u06cc\u06a9\u0648\u0633 \u062c\u0632\u0627\u0626\u0631" },
            { "yav", "\u06cc\u0627\u0646\u06af\u0628\u06cc\u0646" },
            { "TD", "\u0686\u0627\u0688" },
            { "TF", "\u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc \u062c\u0646\u0648\u0628\u06cc \u062e\u0637\u06d2" },
            { "TG", "\u0679\u0648\u06af\u0648" },
            { "TH", "\u062a\u06be\u0627\u0626\u06cc \u0644\u06cc\u0646\u0688" },
            { "TJ", "\u062a\u0627\u062c\u06a9\u0633\u062a\u0627\u0646" },
            { "029", "\u06a9\u0631\u06cc\u0628\u06cc\u0627\u0626\u06cc" },
            { "TK", "\u0679\u0648\u06a9\u06cc\u0644\u0627\u0624" },
            { "TL", "\u062a\u06cc\u0645\u0648\u0631 \u0644\u06cc\u0633\u0679" },
            { "ybb", "\u06cc\u0645\u0628\u0627" },
            { "type.co.searchjl", "Hangul Initial Consonant \u06a9\u06d2 \u0644\u062d\u0627\u0638 \u0633\u06d2 \u062a\u0644\u0627\u0634 \u06a9\u0631\u06cc\u06ba" },
            { "TM", "\u062a\u0631\u06a9\u0645\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "TN", "\u062a\u0648\u0646\u0633" },
            { "TO", "\u0679\u0648\u0646\u06af\u0627" },
            { "TR", metaValue_TR },
            { "TT", "\u062a\u0631\u06cc\u0646\u06cc\u062f\u0627\u062f \u0627\u0648\u0631 \u0679\u0648\u0628\u0627\u06af\u0648" },
            { "TV", "\u0679\u0648\u0648\u0627\u0644\u0648" },
            { "TW", "\u062a\u0627\u0626\u06cc\u0648\u0627\u0646" },
            { "ast", "\u0627\u0633\u0679\u0648\u0631\u06cc\u0627\u0626\u06cc" },
            { "TZ", "\u062a\u0646\u0632\u0627\u0646\u06cc\u06c1" },
            { "nmg", "\u06a9\u0648\u0627\u064a\u0633\u0648" },
            { "Zzzz", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645 \u0631\u0633\u0645 \u0627\u0644\u062e\u0637" },
            { "UA", "\u06cc\u0648\u06a9\u0631\u06cc\u0646" },
            { "rup", "\u0627\u0631\u0648\u0645\u0627\u0646\u06cc" },
            { "030", "\u0645\u0634\u0631\u0642\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "tyv", "\u062a\u0648\u0648\u06cc\u0646\u06cc\u0646" },
            { "sw_CD", "\u06a9\u0627\u0646\u06af\u0648 \u0633\u0648\u0627\u062d\u0644\u06cc" },
            { "034", "\u062c\u0646\u0648\u0628\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "035", "\u062c\u0646\u0648\u0628 \u0645\u0634\u0631\u0642\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "UG", "\u06cc\u0648\u06af\u0646\u0688\u0627" },
            { "type.co.pinyin", "\u067e\u0646 \u06cc\u0646 \u06a9\u06cc \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "039", "\u062c\u0646\u0648\u0628\u06cc \u06cc\u0648\u0631\u067e" },
            { "Sinh", metaValue_si },
            { "UM", "\u0627\u0645\u0631\u06cc\u06a9\u06c1 \u0633\u06d2 \u0628\u0627\u06c1\u0631 \u06a9\u06d2 \u0686\u06be\u0648\u0679\u06d2 \u062c\u0632\u0627\u0626\u0632" },
            { "UN", "\u0627\u0642\u0648\u0627\u0645 \u0645\u062a\u062d\u062f\u06c1" },
            { "US", "\u0631\u06cc\u0627\u0633\u062a \u06c1\u0627\u0626\u06d2 \u0645\u062a\u062d\u062f\u06c1 \u0627\u0645\u0631\u06cc\u06a9\u06c1" },
            { "haw", "\u06c1\u0648\u0627\u0626\u06cc" },
            { "type.co.gb2312han", "\u0622\u0633\u0627\u0646 \u0686\u06cc\u0646\u06cc \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628 - GB2312" },
            { "UY", "\u06cc\u0648\u0631\u0648\u06af\u0648\u0626\u06d2" },
            { "prg", "\u067e\u0627\u0631\u0633\u06cc" },
            { "UZ", "\u0627\u0632\u0628\u06a9\u0633\u062a\u0627\u0646" },
            { "tzm", "\u0633\u06cc\u0646\u0679\u0631\u0644 \u0627\u06cc\u0679\u0644\u0633 \u0679\u0645\u0627\u0632\u0627\u0626\u0679" },
            { "type.co.stroke", "\u0633\u0679\u0631\u0648\u06a9 \u06a9\u06cc \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "nnh", "\u0646\u06af\u06cc\u0645\u0628\u0648\u0646" },
            { "VA", "\u0648\u06cc\u0679\u06cc\u06a9\u0646 \u0633\u0679\u06cc" },
            { "VC", "\u0633\u06cc\u0646\u0679 \u0648\u0646\u0633\u0646\u0679 \u0627\u0648\u0631 \u06af\u0631\u06cc\u0646\u06cc\u0688\u0627\u0626\u0646\u0632" },
            { "VE", "\u0648\u06cc\u0646\u0632\u0648\u0626\u06cc\u0644\u0627" },
            { "VG", "\u0628\u0631\u0679\u0634 \u0648\u0631\u062c\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "VI", "\u0627\u0645\u0631\u06cc\u06a9\u06cc \u0648\u0631\u062c\u0646 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632" },
            { "VN", "\u0648\u06cc\u062a\u0646\u0627\u0645" },
            { "VU", "\u0648\u06cc\u0646\u0648\u0622\u0679\u0648" },
            { "nog", "\u0646\u0648\u06af\u0627\u0626\u06cc" },
            { "rwk", "\u0631\u0648\u0627" },
            { "053", "\u0622\u0633\u0679\u0631\u06cc\u0644\u06cc\u0634\u06cc\u0627" },
            { "054", "\u0645\u0627\u0644\u06cc\u0646\u06cc\u0634\u06cc\u0627" },
            { "WF", "\u0648\u06cc\u0644\u06cc\u0632 \u0627\u0648\u0631 \u0641\u06cc\u0648\u0679\u06cc\u0648\u0646\u0627" },
            { "type.co.traditional", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "057", "\u0645\u0627\u0626\u06a9\u0631\u0648\u0646\u06cc\u0634\u06cc\u0627\u0626\u06cc \u0639\u0644\u0627\u0642\u06c1" },
            { "jgo", "\u0646\u06af\u0648\u0645\u0628\u0627" },
            { "lkt", "\u0644\u0627\u06a9\u0648\u0679\u0627" },
            { "type.nu.finance", "\u0645\u0627\u0644\u06cc\u0627\u062a\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "type.co.compat", "\u0633\u0627\u0628\u0642\u06c1 \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628\u060c \u0645\u0637\u0627\u0628\u0642\u062a \u06a9\u06cc\u0644\u0626\u06d2" },
            { "wae", "\u0648\u0627\u0644\u0633\u0631" },
            { "WS", "\u0633\u0627\u0645\u0648\u0622" },
            { "wal", "\u0648\u0648\u0644\u0627\u06cc\u062a\u0627" },
            { "XA", "\u0628\u0646\u0627\u0648\u0679\u06cc \u0644\u06c1\u062c\u06d2" },
            { "war", "\u0648\u0627\u0631\u06d2" },
            { "XB", "\u0628\u0646\u0627\u0648\u0679\u06cc \u062f\u0648 \u0633\u0645\u062a\u06cc" },
            { "awa", "\u0627\u0648\u0627\u062f\u06be\u06cc" },
            { "061", "\u067e\u0648\u0644\u06cc\u0646\u06cc\u0634\u06cc\u0627" },
            { "XK", "\u06a9\u0648\u0633\u0648\u0648\u0648" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u063a\u06cc\u0631 \u062a\u062d\u0631\u06cc\u0631 \u0634\u062f\u06c1" },
            { "wbp", "\u0648\u0627\u0631\u0644\u067e\u06cc\u0631\u06cc" },
            { "YE", "\u06cc\u0645\u0646" },
            { "nqo", "\u0627\u06cc\u0646\u06a9\u0648" },
            { "type.co.standard", "\u0645\u0639\u06cc\u0627\u0631\u06cc \u0686\u06be\u0627\u0646\u0679\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "YT", "\u0645\u0627\u06cc\u0648\u0679" },
            { "ZA", "\u062c\u0646\u0648\u0628\u06cc \u0627\u0641\u0631\u06cc\u0642\u06c1" },
            { "type.lb.loose", "\u0688\u06be\u06cc\u0644\u0627 \u0644\u0627\u0626\u0646 \u0628\u0631\u06cc\u06a9 \u0627\u0646\u062f\u0627\u0632" },
            { "Deva", "\u062f\u06cc\u0648\u0646\u0627\u06af\u0631\u06cc" },
            { "type.nu.geor", "\u062c\u0627\u0631\u062c\u06cc\u0627\u0626\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "Hira", "\u06c1\u06cc\u0631\u0627\u06af\u06cc\u0646\u0627" },
            { "ZM", "\u0632\u0627\u0645\u0628\u06cc\u0627" },
            { "ZW", "\u0632\u0645\u0628\u0627\u0628\u0648\u06d2" },
            { "ZZ", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645 \u0639\u0644\u0627\u0642\u06c1" },
            { "type.ms.metric", "\u0645\u06cc\u0679\u0631\u06a9 \u0646\u0638\u0627\u0645" },
            { "type.ca.iso8601", "ISO-8601 \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "nso", "\u0634\u0645\u0627\u0644\u06cc \u0633\u0648\u062a\u06be\u0648" },
            { "type.nu.telu", "\u062a\u06cc\u0644\u06af\u0648 \u06c1\u0646\u062f\u0633\u06d2" },
            { "lou", "\u0644\u0648\u0632\u06cc\u0627\u0646\u0627 \u06a9\u0631\u06cc\u0648\u0644" },
            { "loz", "\u0644\u0648\u0632\u06cc" },
            { "jmc", "\u0645\u0627\u0634\u06cc\u0645" },
            { "type.nu.hansfin", "\u0622\u0633\u0627\u0646 \u0686\u06cc\u0646\u06cc \u0645\u0627\u0644\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "hil", "\u06c1\u0627\u0644\u06cc\u06af\u06cc\u0646\u0648\u0646" },
            { "type.nu.arabext", "\u062a\u0648\u0633\u06cc\u0639 \u0634\u062f\u06c1 \u0639\u0631\u0628\u06cc \u06c1\u0646\u062f\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "nus", "\u0646\u0648\u06cc\u0631" },
            { "dak", "\u0688\u0627\u06a9\u0648\u0679\u0627" },
            { "type.nu.fullwide", "\u067e\u0648\u0631\u06d2 \u0639\u0631\u0636 \u0648\u0627\u0644\u06d2 \u06c1\u0646\u062f\u0633\u06d2" },
            { "dar", "\u062f\u0631\u06af\u0648\u0627" },
            { "dav", "\u062a\u0627\u0626\u062a\u0627" },
            { "lrc", "\u0634\u0645\u0627\u0644\u06cc \u0644\u0631\u06cc" },
            { "udm", "\u0627\u062f\u0645\u0648\u0631\u062a" },
            { "Khmr", metaValue_km },
            { "sad", "\u0633\u0646\u0688\u0627\u0648\u06d2" },
            { "type.nu.roman", "\u0631\u0648\u0645\u0646 \u0627\u0639\u062f\u0627\u062f" },
            { "sah", "\u0633\u0627\u06a9\u06be\u0627" },
            { "saq", "\u0633\u0627\u0645\u0628\u0648\u0631\u0648" },
            { "sat", "\u0633\u0646\u062a\u0627\u0644\u06cc" },
            { "type.d0.npinyin", "\u0639\u062f\u062f\u06cc" },
            { "type.nu.native", "\u0627\u0635\u0644 \u06c1\u0646\u062f\u0633\u06d2" },
            { "sba", "\u0646\u06af\u0627\u0645\u0628\u06d2" },
            { "Guru", "\u06af\u0631\u0645\u06a9\u06be\u06cc" },
            { "lua", "\u0644\u06cc\u0648\u0628\u0627 \u0644\u0648\u0644\u0648\u0622" },
            { "type.d0.fwidth", "\u067e\u0648\u0631\u0627 \u0639\u0631\u0636" },
            { "sbp", "\u0633\u0627\u0646\u06af\u0648" },
            { "nyn", "\u0646\u06cc\u0646\u06a9\u0648\u0644" },
            { "lun", "\u0644\u0648\u0646\u0688\u0627" },
            { "luo", "\u0644\u0648" },
            { "fil", "\u0641\u0644\u06cc\u067e\u06cc\u0646\u0648" },
            { "hmn", "\u06c1\u0645\u0627\u0646\u06af" },
            { "lus", "\u0645\u06cc\u0632\u0648" },
            { "ban", "\u0628\u0627\u0644\u06cc\u0646\u06cc\u0632" },
            { "luy", "\u0644\u0648\u06cc\u0627" },
            { "bas", "\u0628\u0627\u0633\u0627" },
            { "es_ES", "\u06cc\u0648\u0631\u067e\u06cc \u06c1\u0633\u067e\u0627\u0646\u0648\u06cc" },
            { "sco", "\u0633\u06a9\u0627\u0679" },
            { "scn", "\u0633\u06cc\u0633\u06cc\u0644\u06cc\u0646" },
            { "aa", "\u0627\u0641\u0627\u0631" },
            { "ab", "\u0627\u0628\u0642\u0627\u0632\u06cc\u0627\u0646" },
            { "Aran", "\u0646\u0633\u062a\u0639\u0644\u06cc\u0642" },
            { "af", "\u0627\u0641\u0631\u06cc\u0642\u06cc" },
            { "ak", "\u0627\u06a9\u0627\u0646" },
            { "am", "\u0627\u0645\u06c1\u0627\u0631\u06cc" },
            { "Arab", metaValue_ar },
            { "an", "\u0627\u0631\u0627\u06af\u0648\u0646\u06cc\u0632" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u062c\u0627\u067e\u0627\u0646\u06cc \u0633\u06cc\u0644\u0627\u0628\u0631\u06cc\u0632" },
            { "as", "\u0622\u0633\u0627\u0645\u06cc" },
            { "av", "\u0627\u0648\u0627\u0631\u06cc" },
            { "sdh", "\u062c\u0646\u0648\u0628\u06cc \u06a9\u0631\u062f" },
            { "ay", "\u0627\u06cc\u0645\u0627\u0631\u0627" },
            { "az", "\u0622\u0630\u0631\u0628\u0627\u0626\u06cc\u062c\u0627\u0646\u06cc" },
            { "ba", "\u0628\u0627\u0634\u06a9\u06cc\u0631" },
            { "type.co.unihan", "\u0627\u0633\u0627\u0633\u06cc-\u0633\u0679\u0631\u0648\u06a9 \u06a9\u06cc \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "be", "\u0628\u06cc\u0644\u0627\u0631\u0648\u0633\u06cc" },
            { "bg", "\u0628\u0644\u063a\u0627\u0631\u06cc" },
            { "bi", "\u0628\u0633\u0644\u0627\u0645\u0627" },
            { "bm", "\u0628\u0645\u0628\u0627\u0631\u0627" },
            { "bn", "\u0628\u0646\u06af\u0644\u06c1" },
            { "bo", metaValue_bo },
            { "dgr", "\u062f\u0648\u06af\u0631\u06cc\u0628" },
            { "br", "\u0628\u0631\u06cc\u0679\u0646" },
            { "bs", "\u0628\u0648\u0633\u0646\u06cc\u0627\u0626\u06cc" },
            { "Mymr", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631" },
            { "type.nu.laoo", "\u0644\u0627\u0624 \u06c1\u0646\u062f\u0633\u06d2" },
            { "seh", "\u0633\u06cc\u0646\u0627" },
            { "ca", "\u06a9\u06cc\u0679\u0627\u0644\u0627\u0646" },
            { "ses", "\u06a9\u0648\u064a\u0631\u0627\u0628\u0648\u0631\u0648 \u0633\u064a\u0646\u06cc" },
            { "ce", "\u0686\u06cc\u0686\u0646" },
            { "ch", "\u0686\u06cc\u0645\u0627\u0631\u0648" },
            { "co", "\u06a9\u0648\u0631\u0627\u0633\u06cc\u06a9\u0646" },
            { "Orya", metaValue_or },
            { "cs", "\u0686\u06cc\u06a9" },
            { "cu", "\u0686\u0631\u0686 \u0633\u0644\u0627\u0648\u06a9" },
            { "cv", "\u0686\u0648\u0648\u0627\u0634" },
            { "cy", "\u0648\u06cc\u0644\u0634" },
            { "type.nu.ethi", "\u0627\u06cc\u062a\u06be\u0648\u067e\u06cc\u0627\u0626\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "da", "\u0688\u06cc\u0646\u0634" },
            { "pt_PT", "\u06cc\u0648\u0631\u067e\u06cc \u067e\u0631\u062a\u06af\u0627\u0644\u06cc" },
            { "de", "\u062c\u0631\u0645\u0646" },
            { "type.cf.standard", "\u0627\u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u06a9\u0631\u0646\u0633\u06cc \u0641\u0627\u0631\u0645\u06cc\u0679" },
            { "bem", "\u0628\u06cc\u0645\u0628\u0627" },
            { "type.nu.mong", "\u0645\u0646\u06af\u0648\u0644\u06cc\u0627\u0626\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "dv", "\u0688\u06cc\u0648\u06cc\u06c1\u06cc" },
            { "es_419", "\u0644\u0627\u0637\u06cc\u0646\u06cc \u0627\u0645\u0631\u06cc\u06a9\u06cc \u06c1\u0633\u067e\u0627\u0646\u0648\u06cc" },
            { "dz", "\u0698\u0648\u0646\u06af\u06a9\u06be\u0627" },
            { "bez", "\u0628\u06cc\u0646\u0627" },
            { "type.ca.chinese", "\u0686\u06cc\u0646\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "dje", "\u0632\u0631\u0645\u0627" },
            { "type.nu.grek", "\u06cc\u0648\u0646\u0627\u0646\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "ee", "\u0627\u06cc\u0648" },
            { "type.lb.normal", "\u0639\u0645\u0648\u0645\u06cc \u0644\u0627\u0626\u0646 \u0628\u0631\u06cc\u06a9 \u0627\u0646\u062f\u0627\u0632" },
            { "ro_MD", metaValue_MD },
            { "el", metaValue_el },
            { "en", "\u0627\u0646\u06af\u0631\u06cc\u0632\u06cc" },
            { "eo", "\u0627\u06cc\u0633\u067e\u0631\u0627\u0646\u0679\u0648" },
            { "type.co.big5han", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u0686\u06cc\u0646\u06cc \u06a9\u06cc \u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628 - Big5" },
            { "es", "\u06c1\u0633\u067e\u0627\u0646\u0648\u06cc" },
            { "et", "\u0627\u0633\u0679\u0648\u0646\u06cc\u0646" },
            { "Hanb", "\u06c1\u06cc\u0646\u0628" },
            { "eu", "\u0628\u0627\u0633\u06a9\u06cc" },
            { "Hang", "\u06c1\u0646\u06af\u0648\u0644" },
            { "shi", "\u062a\u0634\u0644\u062d\u064a\u062a" },
            { "hsb", "\u0627\u067e\u0631 \u0633\u0631\u0628\u06cc\u0627\u0626\u06cc" },
            { "Hani", "\u06c1\u0627\u0646" },
            { "shn", "\u0634\u0627\u0646" },
            { "fa", "\u0641\u0627\u0631\u0633\u06cc" },
            { "Hans", "\u0622\u0633\u0627\u0646" },
            { "type.nu.latn", "\u0645\u063a\u0631\u0628\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "Hant", "\u0631\u0648\u0627\u06cc\u062a\u06cc" },
            { "az_Arab", "\u0622\u0632\u0631\u0628\u0627\u0626\u06cc\u062c\u0627\u0646\u06cc (\u0639\u0631\u0628\u06cc)" },
            { "ff", "\u0641\u0648\u0644\u06c1" },
            { "fi", "\u0641\u06cc\u0646\u06cc\u0634" },
            { "fj", metaValue_FJ },
            { "fon", "\u0641\u0648\u0646" },
            { "bgn", "\u0645\u063a\u0631\u0628\u06cc \u0628\u0644\u0648\u0686\u06cc" },
            { "yue", "\u06a9\u06cc\u0646\u0679\u0648\u0646\u06cc\u0632" },
            { "fo", "\u0641\u06cc\u0631\u0648\u0626\u06cc\u0632" },
            { "type.m0.bgn", "US BGN \u0679\u0631\u0627\u0646\u0633\u0644\u0679\u0631\u06cc\u0634\u0646" },
            { "umb", "\u0627\u0648\u0645\u0628\u0648\u0646\u062f\u0648" },
            { "fr", "\u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc" },
            { "fy", "\u0645\u063a\u0631\u0628\u06cc \u0641\u0631\u06cc\u0633\u06cc\u0626\u0646" },
            { "ga", "\u0622\u0626\u0631\u0634" },
            { "gd", "\u0633\u06a9\u0627\u0679\u0634 \u06af\u06cc\u0644\u06a9" },
            { "gl", "\u06af\u0627\u0644\u06cc\u0634\u06cc\u0627\u0626\u06cc" },
            { "gn", "\u06af\u064f\u0627\u0631\u0627\u0646\u06cc" },
            { "bho", "\u0628\u06be\u0648\u062c\u067e\u0648\u0631\u06cc" },
            { "und", "\u0646\u0627\u0645\u0639\u0644\u0648\u0645 \u0632\u0628\u0627\u0646" },
            { "type.ca.ethiopic-amete-alem", "\u0627\u06cc\u062a\u06be\u0648\u067e\u06a9 \u0627\u0645\u06cc\u0679 \u0627\u0644\u06cc\u0645 \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "gu", metaValue_gu },
            { "gv", "\u0645\u06cc\u0646\u06a9\u0633" },
            { "ha", "\u06c1\u0624\u0633\u0627" },
            { "he", metaValue_he },
            { "hi", "\u06c1\u0646\u062f\u06cc" },
            { "hup", "\u06c1\u06cc\u0648\u067e\u0627" },
            { "bin", "\u0628\u06cc\u0646\u06cc" },
            { "hr", "\u06a9\u0631\u0627\u062a\u06cc" },
            { "ht", "\u06c1\u06cc\u062a\u06cc" },
            { "hu", "\u06c1\u0646\u06af\u06cc\u0631\u06cc\u0646" },
            { "hy", metaValue_hy },
            { "hz", "\u06c1\u0631\u06cc\u0631\u0648" },
            { "frc", "\u06a9\u0627\u062c\u0646 \u0641\u0631\u0627\u0646\u0633\u06cc\u0633\u06cc" },
            { "ia", "\u0628\u06cc\u0646 \u0644\u0633\u0627\u0646\u06cc\u0627\u062a" },
            { "Jamo", "\u062c\u0627\u0645\u0648" },
            { "id", "\u0627\u0646\u0688\u0648\u0646\u06cc\u062b\u06cc\u0627\u0626\u06cc" },
            { "type.nu.tibt", "\u062a\u0628\u062a\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "ig", "\u0627\u0650\u06af\u0628\u0648" },
            { "ii", "\u0633\u0686\u0648\u0627\u0646 \u0627\u06cc" },
            { "io", "\u0627\u06cc\u0688\u0648" },
            { "is", "\u0622\u0626\u0633 \u0644\u06cc\u0646\u0688\u06a9" },
            { "it", "\u0627\u0637\u0627\u0644\u0648\u06cc" },
            { "iu", "\u0627\u06cc\u0646\u064f\u06a9\u0679\u06cc\u0679\u0679" },
            { "ja", metaValue_ja },
            { "Mlym", "\u0645\u0644\u06cc\u0627\u0644\u0645" },
            { "sma", "\u062c\u0646\u0648\u0628\u06cc \u0633\u0627\u0645\u06cc" },
            { "jv", "\u062c\u0627\u0648\u06cc" },
            { "mad", "\u0645\u062f\u0648\u0631\u0633\u06cc" },
            { "smj", "\u0644\u0648\u0644 \u0633\u0627\u0645\u06cc" },
            { "mag", "\u0645\u06af\u0627\u06c1\u06cc" },
            { "mai", "\u0645\u06cc\u062a\u06be\u06cc\u0644\u06cc" },
            { "smn", "\u0627\u0646\u0627\u0631\u06cc \u0633\u0627\u0645\u06cc" },
            { "ka", metaValue_ka },
            { "bla", "\u0633\u06a9\u0633\u06cc\u06a9\u0627" },
            { "mak", "\u0645\u06a9\u0627\u0633\u0631" },
            { "sms", "\u0633\u06a9\u0648\u0644\u0679 \u0633\u0627\u0645\u06cc" },
            { "kg", "\u06a9\u0627\u0646\u06af\u0648" },
            { "ki", "\u06a9\u06cc\u06a9\u0648\u06cc\u0648" },
            { "mas", "\u0645\u0633\u0627\u0626\u06cc" },
            { "kj", "\u06a9\u0648\u0646\u06cc\u0627\u0645\u0627" },
            { "kk", "\u0642\u0632\u0627\u062e" },
            { "kl", "\u06a9\u0627\u0644\u0627\u0644\u064a\u0633\u062a" },
            { "km", metaValue_km },
            { "kn", "\u06a9\u0646\u0651\u0627\u0688\u0627" },
            { "ko", metaValue_ko },
            { "kr", "\u06a9\u0646\u0648\u0631\u06cc" },
            { "ks", "\u06a9\u0634\u0645\u06cc\u0631\u06cc" },
            { "ku", "\u06a9\u0631\u062f\u0634" },
            { "kv", "\u06a9\u0648\u0645\u06cc" },
            { "kw", "\u06a9\u0648\u0631\u0646\u0634" },
            { "ky", "\u06a9\u0631\u063a\u06cc\u0632\u06cc" },
            { "snk", "\u0633\u0648\u0646\u0646\u06a9\u06d2" },
            { "la", metaValue_la },
            { "lb", "\u0644\u06a9\u0633\u0645\u0628\u0631\u06af\u06cc\u0634" },
            { "type.nu.mlym", "\u0645\u0644\u06cc\u0627\u0644\u0645 \u06c1\u0646\u062f\u0633\u06d2" },
            { "lg", "\u06af\u06cc\u0646\u0688\u0627" },
            { "li", "\u0644\u06cc\u0645\u0628\u0631\u06af\u0634" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0644\u0650\u0646\u06af\u064e\u0644\u0627" },
            { "fur", "\u0641\u0631\u06cc\u0648\u0644\u06cc\u0627\u0626\u06cc" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u067e\u06cc\u0645\u0627\u0626\u0634 \u06a9\u0627 \u0627\u0645\u067e\u06cc\u0631\u06cc\u0644 \u0646\u0638\u0627\u0645" },
            { "lt", "\u0644\u06cc\u062a\u06be\u0648\u06cc\u0646\u06cc\u0646" },
            { "lu", "\u0644\u0628\u0627-\u06a9\u0627\u062a\u0627\u0646\u062c\u0627" },
            { "lv", "\u0644\u06cc\u0679\u0648\u06cc\u0646" },
            { "ListCompositionPattern", "{0}\u060c{1}" },
            { "mg", "\u0645\u0644\u0627\u06af\u0627\u0633\u06cc" },
            { "mh", "\u0645\u0627\u0631\u0634\u0644\u06cc\u0632" },
            { "type.co.ducet", "\u0688\u06cc\u0641\u0627\u0644\u0679 \u06cc\u0648\u0646\u06cc \u06a9\u0648\u0688 \u0686\u06be\u0627\u0646\u0679\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "mi", "\u0645\u0627\u0624\u0631\u06cc" },
            { "mk", "\u0645\u0642\u062f\u0648\u0646\u06cc\u0627\u0626\u06cc" },
            { "ml", "\u0645\u0627\u0644\u0627\u06cc\u0627\u0644\u0645" },
            { "mn", "\u0645\u0646\u06af\u0648\u0644\u06cc\u0646" },
            { "mr", "\u0645\u0631\u0627\u0679\u0647\u06cc" },
            { "ms", "\u0645\u0627\u0644\u06d2" },
            { "mt", "\u0645\u0627\u0644\u0679\u06cc" },
            { "my", "\u0628\u0631\u0645\u06cc" },
            { "Armn", metaValue_hy },
            { "mdf", "\u0645\u0648\u06a9\u0634\u0627" },
            { "dsb", "\u0630\u06cc\u0644\u06cc \u0633\u0631\u0628\u06cc\u0627\u0626\u06cc" },
            { "na", "\u0646\u0627\u0624\u0631\u0648" },
            { "type.co.search", "\u0639\u0645\u0648\u0645\u06cc \u062a\u0644\u0627\u0634" },
            { "nb", "\u0646\u0627\u0631\u0648\u06cc\u062c\u06cc\u0646 \u0628\u0648\u06a9\u0645\u0644" },
            { "nd", "\u0634\u0645\u0627\u0644\u06cc \u062f\u0628\u06cc\u0644" },
            { "ne", "\u0646\u06cc\u067e\u0627\u0644\u06cc" },
            { "ng", "\u0646\u0688\u0648\u0646\u06af\u0627" },
            { "nl", "\u0688\u0686" },
            { "nn", "\u0646\u0627\u0631\u0648\u06cc\u062c\u06cc\u0646 \u0646\u06cc\u0646\u0648\u0631\u0633\u06a9" },
            { "no", "\u0646\u0627\u0631\u0648\u06cc\u062c\u06cc\u0646" },
            { "nr", "\u062c\u0646\u0648\u0628\u06cc \u0646\u0688\u06cc\u0628\u06cc\u0644\u06cc" },
            { "nv", "\u0646\u0648\u0627\u062c\u0648" },
            { "ny", "\u0646\u06cc\u0627\u0646\u062c\u0627" },
            { "kac", "\u06a9\u0627\u0686\u0646" },
            { "kab", "\u0642\u0628\u0627\u0626\u0644\u06cc" },
            { "oc", "\u0622\u06a9\u0633\u06cc\u0679\u0627\u0646" },
            { "kaj", "\u062c\u06d2 \u062c\u0648" },
            { "kam", "\u06a9\u0627\u0645\u0628\u0627" },
            { "men", "\u0645\u06cc\u0646\u062f\u06d2" },
            { "mer", "\u0645\u06cc\u0631\u0648" },
            { "type.nu.armn", "\u0622\u0631\u0645\u06cc\u0646\u06cc\u0627\u0626\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "om", "\u0627\u0648\u0631\u0648\u0645\u0648" },
            { "or", metaValue_or },
            { "os", "\u0627\u0648\u0633\u06cc\u0679\u06a9" },
            { "kbd", "\u06a9\u0628\u0627\u0631\u0688\u06cc\u0646" },
            { "mfe", "\u0645\u0648\u0631\u06cc\u0633\u06cc\u06cc\u0646" },
            { "srn", "\u0633\u0631\u0627\u0646\u0646 \u0679\u0648\u0646\u06af\u0648" },
            { "pa", "\u067e\u0646\u062c\u0627\u0628\u06cc" },
            { "dua", "\u062f\u0648\u0627\u0644\u0627" },
            { "pl", "\u067e\u0648\u0644\u0634" },
            { "type.ca.dangi", "\u0688\u0627\u0646\u06af\u06cc \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "ps", "\u067e\u0634\u062a\u0648" },
            { "pt", "\u067e\u064f\u0631\u062a\u06af\u0627\u0644\u06cc" },
            { "key.co", "\u0686\u06be\u0679\u0627\u0626\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "pt_BR", "\u0628\u0631\u0627\u0632\u06cc\u0644\u06cc \u067e\u0631\u062a\u06af\u0627\u0644\u06cc" },
            { "kcg", "\u062a\u06cc\u0627\u067e" },
            { "mgh", "\u0645\u0627\u062e\u0627\u0648\u0627-\u0645\u064a\u062a\u0648" },
            { "key.cf", "\u06a9\u0631\u0646\u0633\u06cc \u0641\u0627\u0631\u0645\u06cc\u0679" },
            { "key.ca", "\u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u0645\u06cc\u0679\u0627" },
            { "type.hc.h23", "24 \u06af\u06be\u0646\u0679\u06d2 \u06a9\u0627 \u0646\u0638\u0627\u0645 (0\u201323)" },
            { "type.hc.h24", "24 \u06af\u06be\u0646\u0679\u06d2 \u06a9\u0627 \u0646\u0638\u0627\u0645 (1\u201324)" },
            { "ssy", "\u0633\u0627\u06c1\u0648" },
            { "type.nu.mymr", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631 \u06a9\u06d2 \u06c1\u0646\u062f\u0633\u06d2" },
            { "qu", "\u06a9\u0648\u06cc\u0686\u0648\u0622" },
            { "brx", "\u0628\u0648\u0688\u0648" },
            { "kde", "\u0645\u0627\u06a9\u0648\u0646\u062f\u0647" },
            { "Ethi", "\u0627\u06cc\u062a\u06be\u0648\u067e\u06cc\u0627\u0626\u06cc" },
            { "type.hc.h12", "12 \u06af\u06be\u0646\u0679\u06d2 \u06a9\u0627 \u0646\u0638\u0627\u0645 (1\u201312)" },
            { "type.hc.h11", "12 \u06af\u06be\u0646\u0679\u06d2 \u06a9\u0627 \u0646\u0638\u0627\u0645 (0\u201311)" },
            { "rm", "\u0631\u0648\u0645\u0627\u0646\u0634" },
            { "rn", "\u0631\u0648\u0646\u0688\u06cc" },
            { "key.cu", "\u06a9\u0631\u0646\u0633\u06cc" },
            { "ro", "\u0631\u0648\u0645\u06cc\u0646\u06cc\u0646" },
            { "type.nu.orya", "\u0627\u0691\u06cc\u06c1 \u06c1\u0646\u062f\u0633\u06d2" },
            { "type.nu.hanidec", "\u0686\u06cc\u0646\u06cc \u0627\u0639\u0634\u0627\u0631\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "ru", "\u0631\u0648\u0633\u06cc" },
            { "rw", "\u06a9\u06cc\u0646\u06cc\u0627\u0631\u0648\u0627\u0646\u0688\u0627" },
            { "kea", "\u06a9\u0627\u0628\u0648\u064a\u0631\u062f\u064a\u0627\u0646\u0648" },
            { "mic", "\u0645\u06a9\u0645\u06cc\u06a9" },
            { "suk", "\u0633\u06a9\u0648\u0645\u0627" },
            { "en_AU", "\u0622\u0633\u0679\u0631\u06cc\u0644\u06cc\u0627\u0626\u06cc \u0627\u0646\u06af\u0631\u06cc\u0632\u06cc" },
            { "sa", "\u0633\u0646\u0633\u06a9\u0631\u062a" },
            { "sc", "\u0633\u0631\u062f\u06cc\u0646\u06cc\u0646" },
            { "sd", "\u0633\u0646\u062f\u06be\u06cc" },
            { "se", "\u0634\u0645\u0627\u0644\u06cc \u0633\u0627\u0645\u06cc" },
            { "min", "\u0645\u0646\u0627\u0646\u06af\u06a9\u0628\u0627\u0624" },
            { "sg", "\u0633\u0627\u06ba\u063a\u0648" },
            { "sh", "\u0633\u0631\u0628\u0648-\u06a9\u0631\u0648\u0626\u06cc\u0634\u06cc\u0646" },
            { "si", metaValue_si },
            { "sk", "\u0633\u0644\u0648\u0648\u0627\u06a9" },
            { "sl", "\u0633\u0644\u0648\u0648\u06cc\u0646\u06cc\u0627\u0626\u06cc" },
            { "sm", "\u0633\u0627\u0645\u0648\u0622\u0646" },
            { "sn", "\u0634\u0648\u0646\u0627" },
            { "so", "\u0635\u0648\u0645\u0627\u0644\u06cc" },
            { "type.nu.arab", "\u0639\u0631\u0628\u06cc \u06c1\u0646\u062f\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "sq", "\u0627\u0644\u0628\u0627\u0646\u06cc" },
            { "sr", "\u0633\u0631\u0628\u06cc\u0646" },
            { "ss", "\u0633\u0648\u0627\u062a\u06cc" },
            { "type.cf.account", "\u0627\u06a9\u0627\u0624\u0646\u0679\u0646\u06af \u06a9\u0631\u0646\u0633\u06cc \u0641\u0627\u0631\u0645\u06cc\u0679" },
            { "st", "\u062c\u0646\u0648\u0628\u06cc \u0633\u0648\u062a\u06be\u0648" },
            { "su", "\u0633\u0646\u0688\u0627\u0646\u06cc\u0632" },
            { "sv", "\u0633\u0648\u06cc\u0688\u0634" },
            { "sw", "\u0633\u0648\u0627\u062d\u0644\u06cc" },
            { "type.nu.hantfin", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u0686\u06cc\u0646\u06cc \u0645\u0627\u0644\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "ibb", "\u0627\u0628\u06cc \u0628\u06cc\u0648" },
            { "iba", "\u0627\u06cc\u0628\u0627\u0646" },
            { "ta", metaValue_ta },
            { "142", "\u0627\u06cc\u0634\u06cc\u0627" },
            { "143", "\u0648\u0633\u0637\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "te", metaValue_te },
            { "145", "\u0645\u063a\u0631\u0628\u06cc \u0627\u06cc\u0634\u06cc\u0627" },
            { "tg", "\u062a\u0627\u062c\u06a9" },
            { "th", metaValue_th },
            { "ti", "\u0679\u06af\u0631\u06cc\u0646\u06cc\u0627" },
            { "bug", "\u0628\u06af\u06cc\u0646\u06cc\u0632" },
            { "kfo", "\u06a9\u0648\u0631\u0648" },
            { "en_CA", "\u06a9\u06cc\u0646\u06cc\u0688\u06cc\u0646 \u0627\u0646\u06af\u0631\u06cc\u0632\u06cc" },
            { "tk", "\u062a\u0631\u06a9\u0645\u0627\u0646" },
            { "tl", "\u0679\u06cc\u06af\u0627 \u0644\u0648\u06af" },
            { "tn", "\u0633\u0648\u0627\u0646\u0627" },
            { "to", "\u0679\u0648\u0646\u06af\u0646" },
            { "dyo", "\u062c\u0648\u0644\u0627 \u0641\u0648\u0646\u064a\u0627" },
            { "type.nu.jpan", "\u062c\u0627\u067e\u0627\u0646\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "tr", metaValue_TR },
            { "ts", "\u0632\u0648\u0646\u06af\u0627" },
            { "swb", "\u06a9\u0648\u0645\u0648\u0631\u06cc\u0627\u0626\u06cc" },
            { "tt", "\u062a\u0627\u062a\u0627\u0631" },
            { "tw", "\u062a\u0648\u06cc" },
            { "ty", "\u062a\u0627\u06c1\u06cc\u062a\u06cc" },
            { "150", "\u06cc\u0648\u0631\u067e" },
            { "151", "\u0645\u0634\u0631\u0642\u06cc \u06cc\u0648\u0631\u067e" },
            { "154", "\u0634\u0645\u0627\u0644\u06cc \u06cc\u0648\u0631\u067e" },
            { "dzg", "\u062f\u0632\u0627\u06af\u0627" },
            { "155", "\u0645\u063a\u0631\u0628\u06cc \u06cc\u0648\u0631\u067e" },
            { "ug", "\u06cc\u0648\u0626\u06af\u06c1\u0631" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u0639\u0627\u0645" },
            { "uk", "\u06cc\u0648\u06a9\u0631\u06cc\u0646\u06cc\u0627\u0626\u06cc" },
            { "type.ca.coptic", "\u06a9\u0627\u067e\u0679\u06a9 \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "ur", "\u0627\u0631\u062f\u0648" },
            { "xal", "\u06a9\u0627\u0644\u0645\u06cc\u06a9" },
            { "uz", "\u0627\u0632\u0628\u06cc\u06a9" },
            { "kha", "\u06a9\u06be\u0627\u0633\u06cc" },
            { "nds_NL", "\u0627\u062f\u0646\u06cc \u0633\u06cc\u06a9\u0633\u0646" },
            { "ve", "\u0648\u06cc\u0646\u0688\u0627" },
            { "type.ca.roc", "\u0645\u0646\u06af\u0648\u0648 \u06a9\u06cc\u0644\u0646\u0688\u0631" },
            { "vi", "\u0648\u06cc\u062a\u0646\u0627\u0645\u06cc" },
            { "khq", "\u06a9\u0648\u064a\u0631\u0627 \u0634\u064a\u0646\u064a" },
            { "key.hc", "\u06af\u06be\u0646\u0679\u06c1 \u0633\u0627\u0626\u06cc\u06a9\u0644 (12 \u0628\u0646\u0627\u0645 24)" },
            { "vo", "\u0648\u0648\u0644\u0627\u067e\u0648\u06a9" },
            { "quc", "\u06a9\u064a\u0634\u06cc" },
            { "gaa", "\u06af\u0627" },
            { "wa", "\u0648\u0627\u0644\u0648\u0646" },
            { "gag", "\u063a\u0627\u063a\u0627\u0648\u0632" },
            { "syr", "\u0633\u0631\u06cc\u0627\u0646\u06cc" },
            { "Grek", metaValue_el },
            { "gan", "gan" },
            { "wo", "\u0648\u0648\u0644\u0648\u0641" },
            { "zgh", "\u0627\u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0645\u0631\u0627\u0642\u0634\u06cc \u062a\u0645\u0627\u0632\u06cc\u0642\u06cc" },
            { "ar_001", "\u0645\u0627\u0688\u0631\u0646 \u0627\u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0639\u0631\u0628\u06cc" },
            { "Mong", "\u0645\u0646\u06af\u0648\u0644\u06cc\u0627\u0626\u06cc" },
            { "mni", "\u0645\u0646\u06cc \u067e\u0648\u0631\u06cc" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "\u0622\u0633\u0627\u0646 \u0686\u06cc\u0646\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.hant", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u0686\u06cc\u0646\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "xh", "\u0698\u0648\u0633\u0627" },
            { "type.nu.romanlow", "\u0631\u0648\u0645\u0646 \u0632\u06cc\u0631\u06cc\u06ba \u0627\u0639\u062f\u0627\u062f" },
            { "byn", "\u0628\u0644\u06cc\u0646" },
            { "moh", "\u0645\u0648\u06c1\u0627\u06a9" },
            { "kkj", "\u06a9\u0627\u06a9\u0648" },
            { "yi", "\u06cc\u062f\u0634" },
            { "mos", "\u0645\u0648\u0633\u06cc" },
            { "yo", "\u06cc\u0648\u0631\u0648\u0628\u0627" },
            { "type.nu.traditional", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "es_MX", "\u0645\u06cc\u06a9\u0633\u06cc\u06a9\u0646 \u06c1\u0633\u067e\u0627\u0646\u0648\u06cc" },
            { "vai", "\u0648\u0627\u0626\u06cc" },
            { "kln", "\u06a9\u0627\u0644\u064a\u0646\u062c\u064a\u0646" },
            { "zh", "\u0686\u06cc\u0646\u06cc" },
            { "Bopo", "\u0628\u0648\u067e\u0648\u0645\u0648\u0641\u0648" },
            { "key.lb", "\u0644\u0627\u0626\u0646 \u0628\u0631\u06cc\u06a9 \u0627\u0646\u062f\u0627\u0632" },
            { "zu", "\u0632\u0648\u0644\u0648" },
            { "type.co.phonebook", "\u0641\u0648\u0646 \u0628\u06a9 \u06a9\u06cc \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "Geor", metaValue_ka },
            { "kmb", "\u06a9\u06cc\u0645\u0628\u0648\u0646\u0688\u0648" },
            { "type.nu.jpanfin", "\u062c\u0627\u067e\u0627\u0646\u06cc \u0645\u0627\u0644\u06cc \u0627\u0639\u062f\u0627\u062f" },
            { "gez", "\u06af\u06cc\u0632" },
            { "type.co.reformed", "\u062f\u0648\u0628\u0627\u0631\u06c1 \u062a\u0634\u06a9\u06cc\u0644 \u0634\u062f\u06c1 \u0686\u06be\u0679\u0646\u06cc \u06a9\u06cc \u062a\u0631\u062a\u06cc\u0628" },
            { "ebu", "\u0627\u0645\u0628\u0648" },
            { "zh_Hans", "\u0686\u06cc\u0646\u06cc (\u0622\u0633\u0627\u0646 \u06a9\u0631\u062f\u06c1)" },
            { "koi", "\u06a9\u0648\u0645\u06cc \u067e\u0631\u0645\u06cc\u0627\u06a9" },
            { "kok", "\u06a9\u0648\u0646\u06a9\u0646\u06cc" },
            { "zh_Hant", "\u0631\u0648\u0627\u06cc\u062a\u06cc \u0686\u06cc\u0646\u06cc" },
            { "kpe", "\u06a9\u06cc\u067e\u06cc\u0644\u0651\u06d2" },
            { "type.nu.khmr", "\u062e\u0645\u06cc\u0631 \u06c1\u0646\u062f\u0633\u06d2" },
            { "ilo", "\u0627\u06cc\u0644\u0648\u06a9\u0648" },
            { "mua", "\u0645\u0646\u0688\u0627\u0646\u06af" },
            { "type.nu.guru", "\u06af\u0631\u0645\u06a9\u06be\u06cc \u06c1\u0646\u062f\u0633\u06d2" },
            { "mul", "\u0645\u062a\u0639\u062f\u062f \u0632\u0628\u0627\u0646\u06cc\u06ba" },
            { "key.ms", "\u067e\u06cc\u0645\u0627\u0626\u0634 \u06a9\u0627 \u0646\u0638\u0627\u0645" },
            { "mus", "\u06a9\u0631\u06cc\u06a9" },
            { "gil", "\u06af\u0644\u0628\u0631\u062a\u06cc\u0632" },
            { "type.nu.tamldec", "\u062a\u0645\u0644 \u0627\u0639\u062f\u0627\u062f" },
            { "krc", "\u06a9\u0631\u0627\u0686\u06d2 \u0628\u0627\u0644\u06a9\u0631" },
            { "inh", "\u0627\u0646\u06af\u0648\u0634" },
            { "fa_AF", "\u062f\u0631\u06cc" },
            { "krl", "\u06a9\u06cc\u0631\u0644\u06cc\u0646" },
            { "efi", "\u0627\u06cc\u0641\u0650\u06a9" },
            { "key.nu", "\u0627\u0639\u062f\u0627\u062f" },
            { "kru", "\u06a9\u0648\u0631\u0648\u06a9\u06be" },
            { "ksb", "\u0634\u0627\u0645\u0628\u0627\u0644\u0627" },
            { "Telu", metaValue_te },
            { "ksf", "\u0628\u0627\u0641\u064a\u0627" },
        };
        return data;
    }
}
