/**
 *    Copyright (C) 2020-present MongoDB, Inc.
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the Server Side Public License, version 1,
 *    as published by MongoDB, Inc.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    Server Side Public License for more details.
 *
 *    You should have received a copy of the Server Side Public License
 *    along with this program. If not, see
 *    <http://www.mongodb.com/licensing/server-side-public-license>.
 *
 *    As a special exception, the copyright holders give permission to link the
 *    code of portions of this program with the OpenSSL library under certain
 *    conditions as described in each individual source file and distribute
 *    linked combinations including the program with the OpenSSL library. You
 *    must comply with the Server Side Public License in all respects for
 *    all of the code used other than as permitted herein. If you modify file(s)
 *    with this exception, you may extend this exception to your version of the
 *    file(s), but you are not obligated to do so. If you do not wish to do so,
 *    delete this exception statement from your version. If you delete this
 *    exception statement from all source files in the program, then also delete
 *    it in the license file.
 */
#pragma once

#include <string>
#include <string_view>

#include "mongo/platform/visibility.h"

#ifdef MONGO_API_visibility_test_lib1
#define MONGO_VISIBILITY_TEST_LIB1_API MONGO_API_EXPORT
#else
#define MONGO_VISIBILITY_TEST_LIB1_API MONGO_API_IMPORT
#endif

namespace mongo {
namespace visibility_test_lib1 {
class MONGO_VISIBILITY_TEST_LIB1_API Base {
public:
    explicit Base(const std::string& name);
    std::string_view name() const;

private:
    MONGO_PRIVATE static void _validate(std::string_view);

    std::string _name;
};

}  // namespace visibility_test_lib1
}  // namespace mongo
