/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Job;
import org.dita.dost.util.TopicIdParser;
import org.dita.dost.util.URLUtils;

public final class MergeUtils {
    private static final String PREFIX = "unique_";
    private final Map<URI, String> idMap = new ConcurrentHashMap<URI, String>();
    private int index = 0;
    private final Set<URI> visitSet = Collections.synchronizedSet(new HashSet(256));
    private DITAOTLogger logger;
    private Job job;

    public void setJob(Job job) {
        this.job = job;
    }

    public void setLogger(DITAOTLogger logger) {
        this.logger = logger;
    }

    public void reset() {
        this.idMap.clear();
        this.visitSet.clear();
        this.index = 0;
    }

    public boolean findId(URI id) {
        return id != null && this.idMap.containsKey(id.normalize());
    }

    public String addId(URI id) {
        if (id == null) {
            return null;
        }
        URI localId = id.normalize();
        ++this.index;
        String newId = PREFIX + Integer.toString(this.index);
        this.idMap.put(localId, newId);
        return newId;
    }

    public void addId(URI id, String value) {
        if (id != null && value != null) {
            URI localId = id.normalize();
            String localValue = value.trim();
            this.idMap.put(localId, localValue);
        }
    }

    public String getIdValue(URI id) {
        if (id == null) {
            return null;
        }
        URI localId = id.normalize();
        return this.idMap.get(localId);
    }

    public boolean isVisited(URI path) {
        URI localPath = URLUtils.stripFragment(path).normalize();
        return this.visitSet.contains(localPath);
    }

    public void visit(URI path) {
        URI localPath = URLUtils.stripFragment(path).normalize();
        this.visitSet.add(localPath);
    }

    public String getFirstTopicId(URI file, boolean useCatalog) {
        assert (file.isAbsolute());
        if (!this.job.getStore().exists(file)) {
            return null;
        }
        StringBuilder firstTopicId = new StringBuilder();
        TopicIdParser parser = new TopicIdParser(firstTopicId);
        try {
            this.job.getStore().transform(file, parser);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
        return firstTopicId.toString();
    }
}

