/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.carbons;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.SimpleIQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.ExceptionCallback;
import org.jivesoftware.smack.util.SuccessCallback;
import org.jivesoftware.smackx.carbons.CarbonCopyReceivedListener;
import org.jivesoftware.smackx.carbons.packet.Carbon;
import org.jivesoftware.smackx.carbons.packet.CarbonExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.forward.packet.Forwarded;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityFullJid;

public final class CarbonManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(CarbonManager.class.getName());
    private static Map<XMPPConnection, CarbonManager> INSTANCES = new WeakHashMap<XMPPConnection, CarbonManager>();
    private static boolean ENABLED_BY_DEFAULT = false;
    private static final StanzaFilter CARBON_EXTENSION_FILTER;
    private final Set<CarbonCopyReceivedListener> listeners = new CopyOnWriteArraySet<CarbonCopyReceivedListener>();
    private volatile boolean enabled_state = false;
    private volatile boolean enabledByDefault = ENABLED_BY_DEFAULT;
    private final StanzaListener carbonsListener;
    private final AsyncButOrdered<BareJid> carbonsListenerAsyncButOrdered = new AsyncButOrdered();

    public static void setEnabledByDefault(boolean enabledByDefault) {
        ENABLED_BY_DEFAULT = enabledByDefault;
    }

    private CarbonManager(XMPPConnection connection) {
        super(connection);
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        sdm.addFeature("urn:xmpp:carbons:2");
        this.carbonsListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza stanza) {
                final Message wrappingMessage = (Message)stanza;
                CarbonExtension carbonExtension = CarbonExtension.from(wrappingMessage);
                final CarbonExtension.Direction direction = carbonExtension.getDirection();
                Forwarded<Message> forwarded = carbonExtension.getForwarded();
                final Message carbonCopy = forwarded.getForwardedStanza();
                BareJid from = carbonCopy.getFrom().asBareJid();
                CarbonManager.this.carbonsListenerAsyncButOrdered.performAsyncButOrdered(from, new Runnable(){

                    @Override
                    public void run() {
                        for (CarbonCopyReceivedListener listener : CarbonManager.this.listeners) {
                            listener.onCarbonCopyReceived(direction, carbonCopy, wrappingMessage);
                        }
                    }
                });
            }
        };
        connection.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionClosed() {
                CarbonManager.this.enabled_state = false;
                CarbonManager.this.connection().removeSyncStanzaListener(CarbonManager.this.carbonsListener);
            }

            @Override
            public void authenticated(XMPPConnection connection, boolean resumed) {
                if (!resumed) {
                    CarbonManager.this.enabled_state = false;
                    try {
                        if (CarbonManager.this.shouldCarbonsBeEnabled() && CarbonManager.this.isSupportedByServer()) {
                            CarbonManager.this.setCarbonsEnabled(true);
                        }
                    }
                    catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                        LOGGER.log(Level.WARNING, "Cannot check for Carbon support and / or enable carbons.", e);
                    }
                }
                CarbonManager.this.addCarbonsListener(connection);
            }
        });
        this.addCarbonsListener(connection);
    }

    private void addCarbonsListener(XMPPConnection connection) {
        EntityFullJid localAddress = connection.getUser();
        if (localAddress == null) {
            return;
        }
        connection.addSyncStanzaListener(this.carbonsListener, new AndFilter(CARBON_EXTENSION_FILTER, FromMatchesFilter.createBare(localAddress)));
    }

    public static synchronized CarbonManager getInstanceFor(XMPPConnection connection) {
        CarbonManager carbonManager = INSTANCES.get(connection);
        if (carbonManager == null) {
            carbonManager = new CarbonManager(connection);
            INSTANCES.put(connection, carbonManager);
        }
        return carbonManager;
    }

    private static IQ carbonsEnabledIQ(boolean new_state) {
        SimpleIQ request = new_state ? new Carbon.Enable() : new Carbon.Disable();
        return request;
    }

    public boolean addCarbonCopyReceivedListener(CarbonCopyReceivedListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeCarbonCopyReceivedListener(CarbonCopyReceivedListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean isSupportedByServer() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).serverSupportsFeature("urn:xmpp:carbons:2");
    }

    @Deprecated
    public void sendCarbonsEnabled(boolean new_state) {
        this.sendUseCarbons(new_state, null);
    }

    public void enableCarbonsAsync(ExceptionCallback<Exception> exceptionCallback) {
        this.sendUseCarbons(true, exceptionCallback);
    }

    public void disableCarbonsAsync(ExceptionCallback<Exception> exceptionCallback) {
        this.sendUseCarbons(false, exceptionCallback);
    }

    private void sendUseCarbons(final boolean use2, ExceptionCallback<Exception> exceptionCallback) {
        this.enabledByDefault = use2;
        IQ setIQ = CarbonManager.carbonsEnabledIQ(use2);
        SmackFuture<IQ, Exception> future = this.connection().sendIqRequestAsync(setIQ);
        future.onSuccess(new SuccessCallback<IQ>(){

            @Override
            public void onSuccess(IQ result) {
                CarbonManager.this.enabled_state = use2;
            }
        }).onError(exceptionCallback);
    }

    public synchronized void setCarbonsEnabled(boolean new_state) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.enabledByDefault = new_state;
        if (this.enabled_state == new_state) {
            return;
        }
        IQ setIQ = CarbonManager.carbonsEnabledIQ(new_state);
        this.connection().sendIqRequestAndWaitForResponse(setIQ);
        this.enabled_state = new_state;
    }

    public void enableCarbons() throws XMPPException, SmackException, InterruptedException {
        this.setCarbonsEnabled(true);
    }

    public void disableCarbons() throws XMPPException, SmackException, InterruptedException {
        this.setCarbonsEnabled(false);
    }

    public boolean getCarbonsEnabled() {
        return this.enabled_state;
    }

    private boolean shouldCarbonsBeEnabled() {
        return this.enabledByDefault;
    }

    @Deprecated
    public static void disableCarbons(Message msg) {
        msg.addExtension(CarbonExtension.Private.INSTANCE);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                CarbonManager.getInstanceFor(connection);
            }
        });
        CARBON_EXTENSION_FILTER = new AndFilter(new OrFilter(new StanzaExtensionFilter(CarbonExtension.Direction.sent.name(), "urn:xmpp:carbons:2"), new StanzaExtensionFilter(CarbonExtension.Direction.received.name(), "urn:xmpp:carbons:2")), StanzaTypeFilter.MESSAGE);
    }
}

