/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.httpfileupload;

import java.io.IOException;
import java.net.URL;
import org.jivesoftware.smackx.httpfileupload.element.Slot;

public abstract class AbstractHttpUploadException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final long fileSize;
    private final Slot slot;

    protected AbstractHttpUploadException(long fileSize, Slot slot, String message) {
        this(fileSize, slot, message, null);
    }

    protected AbstractHttpUploadException(long fileSize, Slot slot, String message, Throwable wrappedThrowable) {
        super(message, wrappedThrowable);
        this.fileSize = fileSize;
        this.slot = slot;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public URL getPutUrl() {
        return this.slot.getPutUrl();
    }

    public Slot getSlot() {
        return this.slot;
    }

    public static class HttpUploadIOException
    extends AbstractHttpUploadException {
        private static final long serialVersionUID = 5940866318073349451L;
        private final IOException wrappedIOException;

        public HttpUploadIOException(long fileSize, Slot slot, IOException cause) {
            super(fileSize, slot, "Unexpected error occurred during file upload, file size: " + fileSize + ", put Url: " + String.valueOf(slot.getPutUrl()), cause);
            this.wrappedIOException = cause;
        }

        public IOException getCausingIOException() {
            return this.wrappedIOException;
        }
    }

    public static class HttpUploadErrorException
    extends AbstractHttpUploadException {
        private static final long serialVersionUID = 8494356028399474995L;
        private final int httpStatus;
        private final String responseMsg;

        public HttpUploadErrorException(int httpStatus, String responseMsg, long fileSize, Slot slot) {
            super(fileSize, slot, "Error response " + httpStatus + " from server during file upload: " + responseMsg + ", file size: " + fileSize + ", put URL: " + String.valueOf(slot.getPutUrl()));
            this.httpStatus = httpStatus;
            this.responseMsg = responseMsg;
        }

        public int getHttpStatus() {
            return this.httpStatus;
        }

        public String getResponseMsg() {
            return this.responseMsg;
        }
    }
}

