/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.transports.jingle_s5b.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.jingle.provider.JingleContentTransportProvider;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransport;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportCandidate;
import org.jivesoftware.smackx.jingle.transports.jingle_s5b.elements.JingleS5BTransportInfo;
import org.jxmpp.JxmppContext;

public class JingleS5BTransportProvider
extends JingleContentTransportProvider<JingleS5BTransport> {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public JingleS5BTransport parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        JingleS5BTransport.Builder builder = JingleS5BTransport.getBuilder();
        String streamId = parser.getAttributeValue(null, "sid");
        builder.setStreamId(streamId);
        String dstAddr = parser.getAttributeValue(null, "dstaddr");
        builder.setDestinationAddress(dstAddr);
        String mode = parser.getAttributeValue(null, "mode");
        if (mode != null) {
            builder.setMode(mode.equals(Bytestream.Mode.udp.toString()) ? Bytestream.Mode.udp : Bytestream.Mode.tcp);
        }
        while (true) {
            XmlPullParser.TagEvent tag = parser.nextTag();
            block0 : switch (tag) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "candidate": {
                            String typeString;
                            JingleS5BTransportCandidate.Builder cb = JingleS5BTransportCandidate.getBuilder();
                            cb.setCandidateId(parser.getAttributeValue(null, "cid"));
                            cb.setHost(ParserUtils.getInternetAddressIngoringZoneIdAttribute(parser, "host"));
                            cb.setJid(parser.getAttributeValue(null, "jid"));
                            cb.setPriority(Integer.parseInt(parser.getAttributeValue(null, "priority")));
                            String portString = parser.getAttributeValue(null, "port");
                            if (portString != null) {
                                cb.setPort(Integer.parseInt(portString));
                            }
                            if ((typeString = parser.getAttributeValue(null, "type")) != null) {
                                cb.setType(JingleS5BTransportCandidate.Type.fromString(typeString));
                            }
                            builder.addTransportCandidate(cb.build());
                            break block0;
                        }
                        case "activated": {
                            builder.setTransportInfo(new JingleS5BTransportInfo.CandidateActivated(parser.getAttributeValue(null, "cid")));
                            break block0;
                        }
                        case "candidate-used": {
                            builder.setTransportInfo(new JingleS5BTransportInfo.CandidateUsed(parser.getAttributeValue(null, "cid")));
                            break block0;
                        }
                        case "candidate-error": {
                            builder.setTransportInfo(JingleS5BTransportInfo.CandidateError.INSTANCE);
                            break block0;
                        }
                        case "proxy-error": {
                            builder.setTransportInfo(JingleS5BTransportInfo.ProxyError.INSTANCE);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return builder.build();
                }
            }
        }
    }
}

