/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.element;

import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;

public class OmemoKeyElement
implements XmlElement {
    public static final String ELEMENT = "key";
    public static final String NAMESPACE = "eu.siacs.conversations.axolotl";
    public static final String ATTR_RID = "rid";
    public static final String ATTR_PREKEY = "prekey";
    private final byte[] data;
    private final int id;
    private final boolean preKey;

    public OmemoKeyElement(byte[] data, int id) {
        this(data, id, false);
    }

    public OmemoKeyElement(byte[] data, int id, boolean preKey) {
        this.data = data;
        this.id = id;
        this.preKey = preKey;
    }

    public int getId() {
        return this.id;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isPreKey() {
        return this.preKey;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingXmlEnvironment) {
        XmlStringBuilder sb = new XmlStringBuilder(this, enclosingXmlEnvironment);
        if (this.isPreKey()) {
            sb.attribute(ATTR_PREKEY, true);
        }
        sb.attribute(ATTR_RID, this.getId());
        sb.rightAngleBracket();
        sb.append(Base64.encodeToString(this.getData()));
        sb.closeElement(this);
        return sb;
    }
}

