/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smackx.omemo.element.OmemoBundleElement;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.trust.OmemoFingerprint;

public abstract class OmemoKeyUtil<T_IdKeyPair, T_IdKey, T_PreKey, T_SigPreKey, T_Sess, T_ECPub, T_Bundle> {
    private static final Logger LOGGER = Logger.getLogger(OmemoKeyUtil.class.getName());
    public final Bundle BUNDLE = new Bundle();

    public abstract T_IdKeyPair identityKeyPairFromBytes(byte[] var1) throws CorruptedOmemoKeyException;

    public abstract T_IdKey identityKeyFromBytes(byte[] var1) throws CorruptedOmemoKeyException;

    public abstract byte[] identityKeyToBytes(T_IdKey var1);

    public abstract T_ECPub ellipticCurvePublicKeyFromBytes(byte[] var1) throws CorruptedOmemoKeyException;

    public T_ECPub preKeyPublicFromBytes(byte[] data) throws CorruptedOmemoKeyException {
        return this.ellipticCurvePublicKeyFromBytes(data);
    }

    public abstract byte[] preKeyToBytes(T_PreKey var1);

    public abstract T_PreKey preKeyFromBytes(byte[] var1) throws IOException;

    public abstract TreeMap<Integer, T_PreKey> generateOmemoPreKeys(int var1, int var2);

    public abstract T_SigPreKey generateOmemoSignedPreKey(T_IdKeyPair var1, int var2) throws CorruptedOmemoKeyException;

    public T_ECPub signedPreKeyPublicFromBytes(byte[] data) throws CorruptedOmemoKeyException {
        return this.ellipticCurvePublicKeyFromBytes(data);
    }

    public abstract T_SigPreKey signedPreKeyFromBytes(byte[] var1) throws IOException;

    public abstract byte[] signedPreKeyToBytes(T_SigPreKey var1);

    public abstract T_Bundle bundleFromOmemoBundle(OmemoBundleElement var1, OmemoDevice var2, int var3) throws CorruptedOmemoKeyException;

    public abstract byte[] signedPreKeySignatureFromKey(T_SigPreKey var1);

    public abstract T_IdKeyPair generateOmemoIdentityKeyPair();

    public abstract int signedPreKeyIdFromKey(T_SigPreKey var1);

    public abstract byte[] identityKeyPairToBytes(T_IdKeyPair var1);

    public abstract T_IdKey identityKeyFromPair(T_IdKeyPair var1);

    public abstract byte[] identityKeyForBundle(T_IdKey var1);

    public abstract byte[] preKeyPublicKeyForBundle(T_ECPub var1);

    public abstract byte[] preKeyForBundle(T_PreKey var1);

    public Map<Integer, byte[]> preKeyPublicKeysForBundle(Map<Integer, T_PreKey> preKeyHashMap) {
        HashMap<Integer, byte[]> out = new HashMap<Integer, byte[]>();
        for (Map.Entry<Integer, T_PreKey> e : preKeyHashMap.entrySet()) {
            out.put(e.getKey(), this.preKeyForBundle(e.getValue()));
        }
        return out;
    }

    public abstract byte[] signedPreKeyPublicForBundle(T_SigPreKey var1);

    public abstract OmemoFingerprint getFingerprintOfIdentityKey(T_IdKey var1);

    public abstract OmemoFingerprint getFingerprintOfIdentityKeyPair(T_IdKeyPair var1);

    public abstract T_Sess rawSessionFromBytes(byte[] var1) throws IOException;

    public abstract byte[] rawSessionToBytes(T_Sess var1);

    public static int addInBounds(int value, int added) {
        int avail = Integer.MAX_VALUE - value;
        if (avail < added) {
            return added - avail;
        }
        return value + added;
    }

    public class Bundle {
        public T_IdKey identityKey(OmemoBundleElement bundle) throws CorruptedOmemoKeyException {
            return OmemoKeyUtil.this.identityKeyFromBytes(bundle.getIdentityKey());
        }

        public T_ECPub signedPreKeyPublic(OmemoBundleElement bundle) throws CorruptedOmemoKeyException {
            return OmemoKeyUtil.this.signedPreKeyPublicFromBytes(bundle.getSignedPreKey());
        }

        public int signedPreKeyId(OmemoBundleElement bundle) {
            return bundle.getSignedPreKeyId();
        }

        public byte[] signedPreKeySignature(OmemoBundleElement bundle) {
            return bundle.getSignedPreKeySignature();
        }

        public T_ECPub preKeyPublic(OmemoBundleElement bundle, int keyId) throws CorruptedOmemoKeyException {
            return OmemoKeyUtil.this.preKeyPublicFromBytes(bundle.getPreKey(keyId));
        }

        public Map<Integer, T_Bundle> bundles(OmemoBundleElement bundle, OmemoDevice contact) throws CorruptedOmemoKeyException {
            HashMap bundles = new HashMap();
            for (int deviceId : bundle.getPreKeys().keySet()) {
                try {
                    bundles.put(deviceId, OmemoKeyUtil.this.bundleFromOmemoBundle(bundle, contact, deviceId));
                }
                catch (CorruptedOmemoKeyException e) {
                    LOGGER.log(Level.INFO, "Cannot parse PreKeyBundle: " + e.getMessage());
                }
            }
            if (bundles.size() == 0) {
                throw new CorruptedOmemoKeyException("Bundle contained no valid preKeys.");
            }
            return bundles;
        }
    }
}

